/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.services.search;

import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNameViewModel;
import com.intellij.ide.util.gotoByName.ChooseByNameWeightedItemProvider;
import com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel;
import com.intellij.ml.llm.matterhorn.services.search.AbstractProjectSearcher;
import com.intellij.ml.llm.matterhorn.services.search.BackgroundChooseByNameViewModel;
import com.intellij.ml.llm.matterhorn.services.search.SearchQuery;
import com.intellij.ml.llm.matterhorn.services.search.SearchResultContent;
import com.intellij.ml.llm.matterhorn.services.search.SearchResultItem;
import com.intellij.ml.llm.matterhorn.services.search.SearchResultsFilter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.DocumentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0094@\u00a2\u0006\u0002\u0010\u0016J6\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J8\u0010 \u001a\u00020\u00132\b\u0010!\u001a\u0004\u0018\u00010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180$2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&H\u0002R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006("}, d2={"Lcom/intellij/ml/llm/matterhorn/services/search/AbstractSymbolProjectSearcher;", "Lcom/intellij/ml/llm/matterhorn/services/search/AbstractProjectSearcher;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getContributorsBasedGotoByModel", "Lcom/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel;", "disposable", "Lcom/intellij/openapi/Disposable;", "prefixToReplace", "", "", "getPrefixToReplace", "()Ljava/util/List;", "enhanceSearchQuery", "Lcom/intellij/ml/llm/matterhorn/services/search/SearchQuery;", "query", "detectSearchQuery", "", "searchProject", "Lcom/intellij/ml/llm/matterhorn/services/search/SearchResultItem;", "(Lcom/intellij/ml/llm/matterhorn/services/search/SearchQuery;Lcom/intellij/openapi/Disposable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findClassOrPsiElement", "Lcom/intellij/ml/llm/matterhorn/services/search/AbstractSymbolProjectSearcher$FoundPsiItemWithWeight;", "gotoModel", "itemProvider", "Lcom/intellij/ide/util/gotoByName/ChooseByNameItemProvider;", "viewModel", "Lcom/intellij/ide/util/gotoByName/ChooseByNameViewModel;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "addClassOrPsiElement", "item", "", "result", "", "weight", "", "FoundPsiItemWithWeight", "ej-core"})
@SourceDebugExtension(value={"SMAP\nAbstractSymbolProjectSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSymbolProjectSearcher.kt\ncom/intellij/ml/llm/matterhorn/services/search/AbstractSymbolProjectSearcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1863#2,2:103\n1755#2,3:105\n1557#2:109\n1628#2,3:110\n1#3:108\n*S KotlinDebug\n*F\n+ 1 AbstractSymbolProjectSearcher.kt\ncom/intellij/ml/llm/matterhorn/services/search/AbstractSymbolProjectSearcher\n*L\n24#1:103,2\n37#1:105,3\n49#1:109\n49#1:110,3\n*E\n"})
public abstract class AbstractSymbolProjectSearcher
extends AbstractProjectSearcher {
    public AbstractSymbolProjectSearcher(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    public abstract ContributorsBasedGotoByModel getContributorsBasedGotoByModel(@NotNull Disposable var1);

    @NotNull
    public abstract List<String> getPrefixToReplace();

    @Override
    @NotNull
    protected SearchQuery enhanceSearchQuery(@NotNull SearchQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        String queryEnhanced = null;
        queryEnhanced = query.getQuery();
        Iterable $this$forEach$iv = this.getPrefixToReplace();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)queryEnhanced, (String)it, (boolean)false, (int)2, null)) continue;
            queryEnhanced = StringsKt.removePrefix((String)queryEnhanced, (CharSequence)it);
        }
        String string = queryEnhanced;
        SearchResultsFilter searchResultsFilter = query.getFilter();
        int n = query.getQueryLimit();
        return new SearchQuery(string, n, searchResultsFilter);
    }

    @Override
    public boolean detectSearchQuery(@NotNull SearchQuery query) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Iterable $this$any$iv = this.getPrefixToReplace();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(StringsKt.startsWith$default((String)query.getQuery(), (String)it, (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)query.getQuery(), (Object)it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    protected Object searchProject(@NotNull SearchQuery query, @NotNull Disposable disposable, @NotNull Continuation<? super List<SearchResultItem>> $completion) {
        return AbstractSymbolProjectSearcher.searchProject$suspendImpl(this, query, disposable, $completion);
    }

    static /* synthetic */ Object searchProject$suspendImpl(AbstractSymbolProjectSearcher $this, SearchQuery query, Disposable disposable, Continuation<? super List<SearchResultItem>> $completion) {
        ContributorsBasedGotoByModel gotoModel = $this.getContributorsBasedGotoByModel(disposable);
        BackgroundChooseByNameViewModel viewModel = new BackgroundChooseByNameViewModel($this.getProject(), (ChooseByNameModel)gotoModel, query.getQueryLimit());
        ChooseByNameItemProvider chooseByNameItemProvider = gotoModel.getItemProvider(null);
        Intrinsics.checkNotNullExpressionValue((Object)chooseByNameItemProvider, (String)"getItemProvider(...)");
        ChooseByNameItemProvider itemProvider = chooseByNameItemProvider;
        EmptyProgressIndicator progressIndicator = new EmptyProgressIndicator();
        return CoroutinesKt.smartReadAction((Project)$this.getProject(), () -> AbstractSymbolProjectSearcher.searchProject$lambda$6($this, query, gotoModel, itemProvider, viewModel, progressIndicator), $completion);
    }

    private final List<FoundPsiItemWithWeight> findClassOrPsiElement(SearchQuery query, ContributorsBasedGotoByModel gotoModel, ChooseByNameItemProvider itemProvider, ChooseByNameViewModel viewModel, ProgressIndicator progressIndicator) {
        List result = new ArrayList();
        boolean bl = itemProvider instanceof ChooseByNameWeightedItemProvider ? ((ChooseByNameWeightedItemProvider)itemProvider).filterElementsWithWeights(viewModel, query.getQuery(), false, progressIndicator, arg_0 -> AbstractSymbolProjectSearcher.findClassOrPsiElement$lambda$8(arg_0 -> AbstractSymbolProjectSearcher.findClassOrPsiElement$lambda$7(this, result, gotoModel, query, arg_0), arg_0)) : itemProvider.filterElements(viewModel, query.getQuery(), false, progressIndicator, arg_0 -> AbstractSymbolProjectSearcher.findClassOrPsiElement$lambda$9(this, result, gotoModel, query, arg_0));
        return result;
    }

    private final boolean addClassOrPsiElement(Object item, List<FoundPsiItemWithWeight> result, ContributorsBasedGotoByModel gotoModel, SearchQuery query, int weight) {
        if (item instanceof PsiElement && !(item instanceof PsiFile)) {
            SearchResultsFilter searchResultsFilter = query.getFilter();
            PsiFile psiFile = ((PsiElement)item).getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            if (this.checkFile(searchResultsFilter, psiFile)) {
                PsiElement it = (PsiElement)item;
                boolean bl = false;
                String string = gotoModel.getFullName(item);
                String string2 = string;
                if (string == null) {
                    string2 = query.getQuery();
                }
                String name = string2;
                result.add(new FoundPsiItemWithWeight((PsiElement)item, name, weight));
            }
        }
        return result.size() < query.getQueryLimit();
    }

    private static final Comparable searchProject$lambda$6$lambda$2(FoundPsiItemWithWeight it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(-it.getWeight());
    }

    private static final Comparable searchProject$lambda$6$lambda$3(FoundPsiItemWithWeight it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getName());
    }

    /*
     * WARNING - void declaration
     */
    private static final List searchProject$lambda$6(AbstractSymbolProjectSearcher this$0, SearchQuery $query, ContributorsBasedGotoByModel $gotoModel, ChooseByNameItemProvider $itemProvider, BackgroundChooseByNameViewModel $viewModel, EmptyProgressIndicator $progressIndicator) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = new Function1[]{AbstractSymbolProjectSearcher::searchProject$lambda$6$lambda$2, AbstractSymbolProjectSearcher::searchProject$lambda$6$lambda$3};
        object = CollectionsKt.sortedWith((Iterable)this$0.findClassOrPsiElement($query, $gotoModel, $itemProvider, $viewModel, (ProgressIndicator)$progressIndicator), (Comparator)ComparisonsKt.compareBy((Function1[])object));
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            VirtualFile virtualFile;
            void it;
            SearchResultContent searchResultContent;
            Document document;
            void item;
            FoundPsiItemWithWeight foundPsiItemWithWeight = (FoundPsiItemWithWeight)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)item.getPsiElement().getContainingFile().getFileDocument(), (String)"getFileDocument(...)");
            int startLine = document.getLineNumber(item.getPsiElement().getTextOffset());
            String string = document.getText(DocumentUtil.getLineTextRange((Document)document, (int)startLine));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String lineText = ((Object)StringsKt.trim((CharSequence)string)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)item.getPsiElement().getContainingFile().getVirtualFile(), (String)"getVirtualFile(...)");
            SearchResultContent searchResultContent2 = searchResultContent = new SearchResultContent(startLine);
            boolean bl2 = false;
            it.setLineText(lineText);
            it.setWeight(item.getWeight());
            SmartPsiElementPointer smartPsiElementPointer = SmartPointersKt.createSmartPointer((PsiElement)item.getPsiElement());
            SearchResultContent searchResultContent3 = searchResultContent;
            VirtualFile virtualFile2 = virtualFile;
            collection.add(new SearchResultItem(virtualFile2, searchResultContent3, (SmartPsiElementPointer<? extends PsiElement>)smartPsiElementPointer));
        }
        return (List)destination$iv$iv;
    }

    private static final boolean findClassOrPsiElement$lambda$7(AbstractSymbolProjectSearcher this$0, List $result, ContributorsBasedGotoByModel $gotoModel, SearchQuery $query, FoundItemDescriptor it) {
        return this$0.addClassOrPsiElement(it.getItem(), $result, $gotoModel, $query, it.getWeight());
    }

    private static final boolean findClassOrPsiElement$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean findClassOrPsiElement$lambda$9(AbstractSymbolProjectSearcher this$0, List $result, ContributorsBasedGotoByModel $gotoModel, SearchQuery $query, Object it) {
        return this$0.addClassOrPsiElement(it, $result, $gotoModel, $query, 1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/matterhorn/services/search/AbstractSymbolProjectSearcher$FoundPsiItemWithWeight;", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "name", "", "weight", "", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;I)V", "getPsiElement", "()Lcom/intellij/psi/PsiElement;", "getName", "()Ljava/lang/String;", "getWeight", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "ej-core"})
    private static final class FoundPsiItemWithWeight {
        @NotNull
        private final PsiElement psiElement;
        @NotNull
        private final String name;
        private final int weight;

        public FoundPsiItemWithWeight(@NotNull PsiElement psiElement, @NotNull String name, int weight) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.psiElement = psiElement;
            this.name = name;
            this.weight = weight;
        }

        @NotNull
        public final PsiElement getPsiElement() {
            return this.psiElement;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getWeight() {
            return this.weight;
        }

        @NotNull
        public final PsiElement component1() {
            return this.psiElement;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        public final int component3() {
            return this.weight;
        }

        @NotNull
        public final FoundPsiItemWithWeight copy(@NotNull PsiElement psiElement, @NotNull String name, int weight) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new FoundPsiItemWithWeight(psiElement, name, weight);
        }

        public static /* synthetic */ FoundPsiItemWithWeight copy$default(FoundPsiItemWithWeight foundPsiItemWithWeight, PsiElement psiElement, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                psiElement = foundPsiItemWithWeight.psiElement;
            }
            if ((n2 & 2) != 0) {
                string = foundPsiItemWithWeight.name;
            }
            if ((n2 & 4) != 0) {
                n = foundPsiItemWithWeight.weight;
            }
            return foundPsiItemWithWeight.copy(psiElement, string, n);
        }

        @NotNull
        public String toString() {
            return "FoundPsiItemWithWeight(psiElement=" + this.psiElement + ", name=" + this.name + ", weight=" + this.weight + ")";
        }

        public int hashCode() {
            int result = this.psiElement.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + Integer.hashCode(this.weight);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FoundPsiItemWithWeight)) {
                return false;
            }
            FoundPsiItemWithWeight foundPsiItemWithWeight = (FoundPsiItemWithWeight)other;
            if (!Intrinsics.areEqual((Object)this.psiElement, (Object)foundPsiItemWithWeight.psiElement)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)foundPsiItemWithWeight.name)) {
                return false;
            }
            return this.weight == foundPsiItemWithWeight.weight;
        }
    }
}

