/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.statistics;

import com.intellij.internal.statistic.IdeActivityDefinition;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.ml.llm.matterhorn.ArtifactId;
import com.intellij.ml.llm.matterhorn.ArtifactStatistic;
import com.intellij.ml.llm.matterhorn.statistics.AbstractEJEventLogger;
import com.intellij.ml.llm.matterhorn.statistics.EJResultStatus;
import com.intellij.ml.llm.matterhorn.statistics.RequestPrivateData;
import com.intellij.ml.llm.matterhorn.statistics.StatsUtilsKt;
import com.intellij.ml.llm.matterhorn.statistics.processors.EJActivityProcessor;
import com.intellij.ml.llm.matterhorn.tasks.persistence.TaskChainId;
import com.intellij.ml.llm.matterhorn.tasks.persistence.TaskId;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J*\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012Jn\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\u0006\u0010!\u001a\u00020\u0012H\u0016J<\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J8\u0010(\u001a\u00020\u00172\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u00192\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016JF\u0010*\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010+\u001a\u0004\u0018\u00010\u00122\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/ml/llm/matterhorn/statistics/AbstractEJPrivateEventLogger;", "Lcom/intellij/ml/llm/matterhorn/statistics/processors/EJActivityProcessor;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "TRAJECTORY_ENTRY", "Lcom/intellij/ml/llm/matterhorn/statistics/RequestPrivateData;", "EJ_TRAJECTORY", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "logTrajectoryEntry", "", "project", "Lcom/intellij/openapi/project/Project;", "chainId", "Lcom/intellij/ml/llm/matterhorn/tasks/persistence/TaskChainId;", "taskId", "Lcom/intellij/ml/llm/matterhorn/tasks/persistence/TaskId;", "trajectoryEntry", "", "GENERATION_ACTIVITY", "Lcom/intellij/internal/statistic/IdeActivityDefinition;", "GENERATION_STEP_ACTIVITY", "logGenerationStarted", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "artifactId", "Lcom/intellij/ml/llm/matterhorn/ArtifactId;", "taskDescription", "vcsStateId", "Ljava/util/UUID;", "recentFilesAddedToContext", "", "openFilesAddedToContext", "explicitlySelectedUserPaths", "ejVersion", "logGenerationFinished", "activity", "status", "Lcom/intellij/ml/llm/matterhorn/statistics/EJResultStatus;", "modelStats", "Lcom/intellij/ml/llm/matterhorn/ArtifactStatistic;", "logGenerationStepStarted", "parentArtifactId", "logGenerationStepFinished", "agentAction", "Companion", "ej-core"})
public abstract class AbstractEJPrivateEventLogger
extends CounterUsagesCollector
implements EJActivityProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RequestPrivateData TRAJECTORY_ENTRY = new RequestPrivateData("artifact_id");
    @NotNull
    private final VarargEventId EJ_TRAJECTORY;
    @NotNull
    private final IdeActivityDefinition GENERATION_ACTIVITY;
    @NotNull
    private final IdeActivityDefinition GENERATION_STEP_ACTIVITY;
    @NotNull
    private static final RequestPrivateData ARTIFACT_ID = new RequestPrivateData("artifact_id");
    @NotNull
    private static final RequestPrivateData PARENT_ARTIFACT_ID = new RequestPrivateData("parent_artifact_id");
    @NotNull
    private static final RequestPrivateData CHAIN_ID = new RequestPrivateData("chain_id");
    @NotNull
    private static final RequestPrivateData ISSUE_ID = new RequestPrivateData("issue_id");
    @NotNull
    private static final RequestPrivateData TASK_DESCRIPTION = new RequestPrivateData("task_description");
    @NotNull
    private static final LongEventField START_TIME_MS = EventFields.Long$default((String)"start_time_ms", null, (int)2, null);
    @NotNull
    private static final LongEventField DURATION_MS = EventFields.Long$default((String)"duration_ms", null, (int)2, null);
    @NotNull
    private static final RequestPrivateData RECENT_FILES_ADDED_TO_CONTEXT = new RequestPrivateData("recent_files_added_to_context");
    @NotNull
    private static final RequestPrivateData OPEN_FILES_ADDED_TO_CONTEXT = new RequestPrivateData("open_files_added_to_context");
    @NotNull
    private static final RequestPrivateData EXPLICITLY_SELECTED_USER_PATHS = new RequestPrivateData("explicitly_selected_user_paths");
    @NotNull
    private static final StringEventField STEP_TYPE = EventFields.String((String)"step_type", (List)CollectionsKt.toList((Iterable)AbstractEJEventLogger.Companion.getSTEP_TYPES()));
    @NotNull
    private static final RequestPrivateData EJ_VERSION = new RequestPrivateData("ej_version");

    public AbstractEJPrivateEventLogger() {
        EventField[] eventFieldArray = new EventField[]{CHAIN_ID, ISSUE_ID, this.TRAJECTORY_ENTRY};
        this.EJ_TRAJECTORY = this.getGroup().registerVarargEvent("ej_trajectory", eventFieldArray);
        eventFieldArray = new EventField[]{ARTIFACT_ID, CHAIN_ID, ISSUE_ID, TASK_DESCRIPTION, START_TIME_MS, RECENT_FILES_ADDED_TO_CONTEXT, OPEN_FILES_ADDED_TO_CONTEXT, EXPLICITLY_SELECTED_USER_PATHS, EJ_VERSION};
        EventField[] eventFieldArray2 = eventFieldArray;
        eventFieldArray = new EventField[]{ARTIFACT_ID, CHAIN_ID, ISSUE_ID, DURATION_MS, AbstractEJEventLogger.Companion.getEXIT_STATUS(), AbstractEJEventLogger.Companion.getARTIFACT_STATS_TIME_MS(), AbstractEJEventLogger.Companion.getMODEL_STATS_TIME_MS(), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHED_TIME_MS(), AbstractEJEventLogger.Companion.getMODEL_STATS_REQUESTS(), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHED_REQUESTS(), AbstractEJEventLogger.Companion.getMODEL_STATS_INPUT_TOKENS(), AbstractEJEventLogger.Companion.getMODEL_STATS_OUTPUT_TOKENS(), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHE_INPUT_TOKENS(), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHE_CREATE_INPUT_TOKENS(), AbstractEJEventLogger.Companion.getMODEL_STATS_COST(), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHED_COST()};
        this.GENERATION_ACTIVITY = EventLogGroup.registerIdeActivity$default((EventLogGroup)this.getGroup(), (String)"ej_generation", (EventField[])eventFieldArray2, (EventField[])eventFieldArray, null, (boolean)false, (int)24, null);
        eventFieldArray = new EventField[]{PARENT_ARTIFACT_ID, ARTIFACT_ID, CHAIN_ID, ISSUE_ID, START_TIME_MS};
        EventField[] eventFieldArray3 = eventFieldArray;
        eventFieldArray = new EventField[]{PARENT_ARTIFACT_ID, ARTIFACT_ID, CHAIN_ID, ISSUE_ID, STEP_TYPE, AbstractEJEventLogger.Companion.getSTEP_RESULT(), DURATION_MS, AbstractEJEventLogger.Companion.getARTIFACT_STATS_TIME_MS(), AbstractEJEventLogger.Companion.getMODEL_STATS_TIME_MS(), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHED_TIME_MS(), AbstractEJEventLogger.Companion.getMODEL_STATS_REQUESTS(), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHED_REQUESTS(), AbstractEJEventLogger.Companion.getMODEL_STATS_INPUT_TOKENS(), AbstractEJEventLogger.Companion.getMODEL_STATS_OUTPUT_TOKENS(), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHE_INPUT_TOKENS(), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHE_CREATE_INPUT_TOKENS(), AbstractEJEventLogger.Companion.getMODEL_STATS_COST(), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHED_COST()};
        this.GENERATION_STEP_ACTIVITY = EventLogGroup.registerIdeActivity$default((EventLogGroup)this.getGroup(), (String)"ej_generation_step", (EventField[])eventFieldArray3, (EventField[])eventFieldArray, null, (boolean)false, (int)24, null);
    }

    public final void logTrajectoryEntry(@NotNull Project project, @Nullable TaskChainId chainId, @Nullable TaskId taskId, @NotNull String trajectoryEntry) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)trajectoryEntry, (String)"trajectoryEntry");
        if (!this.getEnabled()) {
            return;
        }
        EventPair[] eventPairArray = new EventPair[3];
        Object object = chainId;
        if (object == null || (object = ((TaskChainId)object).toString()) == null) {
            object = "unknown";
        }
        eventPairArray[0] = CHAIN_ID.with(object);
        Object object2 = taskId;
        if (object2 == null || (object2 = ((TaskId)object2).toString()) == null) {
            object2 = "unknown";
        }
        eventPairArray[1] = ISSUE_ID.with(object2);
        eventPairArray[2] = this.TRAJECTORY_ENTRY.with(trajectoryEntry);
        this.EJ_TRAJECTORY.log(project, eventPairArray);
    }

    @Override
    @NotNull
    public StructuredIdeActivity logGenerationStarted(@NotNull ArtifactId<?> artifactId, @NotNull Project project, @NotNull TaskChainId chainId, @NotNull TaskId taskId, @NotNull String taskDescription, @NotNull UUID vcsStateId, @NotNull Collection<String> recentFilesAddedToContext, @NotNull Collection<String> openFilesAddedToContext, @NotNull Collection<String> explicitlySelectedUserPaths, @NotNull String ejVersion) {
        Intrinsics.checkNotNullParameter(artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)chainId, (String)"chainId");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)taskDescription, (String)"taskDescription");
        Intrinsics.checkNotNullParameter((Object)vcsStateId, (String)"vcsStateId");
        Intrinsics.checkNotNullParameter(recentFilesAddedToContext, (String)"recentFilesAddedToContext");
        Intrinsics.checkNotNullParameter(openFilesAddedToContext, (String)"openFilesAddedToContext");
        Intrinsics.checkNotNullParameter(explicitlySelectedUserPaths, (String)"explicitlySelectedUserPaths");
        Intrinsics.checkNotNullParameter((Object)ejVersion, (String)"ejVersion");
        long startedTimestamp = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        Function0 dataSupplier = () -> AbstractEJPrivateEventLogger.logGenerationStarted$lambda$0(artifactId, chainId, taskId, taskDescription, startedTimestamp, recentFilesAddedToContext, openFilesAddedToContext, explicitlySelectedUserPaths, ejVersion);
        return this.GENERATION_ACTIVITY.started(project, dataSupplier);
    }

    @Override
    public void logGenerationFinished(@NotNull StructuredIdeActivity activity, @NotNull ArtifactId<?> artifactId, @NotNull TaskChainId chainId, @NotNull TaskId taskId, @NotNull EJResultStatus status, @NotNull ArtifactStatistic modelStats) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter(artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)chainId, (String)"chainId");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter((Object)modelStats, (String)"modelStats");
        long durationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - activity.getStartedTimestamp());
        activity.finished(() -> AbstractEJPrivateEventLogger.logGenerationFinished$lambda$1(artifactId, chainId, taskId, durationMs, status, modelStats));
    }

    @Override
    @NotNull
    public StructuredIdeActivity logGenerationStepStarted(@NotNull ArtifactId<?> parentArtifactId, @NotNull ArtifactId<?> artifactId, @NotNull Project project, @NotNull TaskChainId chainId, @NotNull TaskId taskId) {
        Intrinsics.checkNotNullParameter(parentArtifactId, (String)"parentArtifactId");
        Intrinsics.checkNotNullParameter(artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)chainId, (String)"chainId");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        long startedTimestamp = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        Function0 dataSupplier = () -> AbstractEJPrivateEventLogger.logGenerationStepStarted$lambda$2(parentArtifactId, artifactId, chainId, taskId, startedTimestamp);
        return this.GENERATION_STEP_ACTIVITY.started(project, dataSupplier);
    }

    @Override
    public void logGenerationStepFinished(@NotNull StructuredIdeActivity activity, @NotNull ArtifactId<?> artifactId, @NotNull TaskChainId chainId, @NotNull TaskId taskId, @Nullable String agentAction, @NotNull EJResultStatus status, @NotNull ArtifactStatistic modelStats) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter(artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)chainId, (String)"chainId");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter((Object)modelStats, (String)"modelStats");
        long durationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - activity.getStartedTimestamp());
        activity.finished(() -> AbstractEJPrivateEventLogger.logGenerationStepFinished$lambda$3(artifactId, chainId, taskId, agentAction, status, durationMs, modelStats));
    }

    private static final List logGenerationStarted$lambda$0(ArtifactId $artifactId, TaskChainId $chainId, TaskId $taskId, String $taskDescription, long $startedTimestamp, Collection $recentFilesAddedToContext, Collection $openFilesAddedToContext, Collection $explicitlySelectedUserPaths, String $ejVersion) {
        Object[] objectArray = new EventPair[]{ARTIFACT_ID.with($artifactId.toString()), CHAIN_ID.with($chainId.toString()), ISSUE_ID.with($taskId.toString()), TASK_DESCRIPTION.with($taskDescription), START_TIME_MS.with((Object)$startedTimestamp), RECENT_FILES_ADDED_TO_CONTEXT.with(CollectionsKt.joinToString$default((Iterable)$recentFilesAddedToContext, null, null, null, (int)0, null, null, (int)63, null)), OPEN_FILES_ADDED_TO_CONTEXT.with(CollectionsKt.joinToString$default((Iterable)$openFilesAddedToContext, null, null, null, (int)0, null, null, (int)63, null)), EXPLICITLY_SELECTED_USER_PATHS.with(CollectionsKt.joinToString$default((Iterable)$explicitlySelectedUserPaths, null, null, null, (int)0, null, null, (int)63, null)), EJ_VERSION.with($ejVersion)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final List logGenerationFinished$lambda$1(ArtifactId $artifactId, TaskChainId $chainId, TaskId $taskId, long $durationMs, EJResultStatus $status, ArtifactStatistic $modelStats) {
        Object[] objectArray = new EventPair[]{ARTIFACT_ID.with($artifactId.toString()), CHAIN_ID.with($chainId.toString()), ISSUE_ID.with($taskId.toString()), DURATION_MS.with((Object)$durationMs), AbstractEJEventLogger.Companion.getEXIT_STATUS().with((Object)$status), AbstractEJEventLogger.Companion.getARTIFACT_STATS_TIME_MS().with((Object)$modelStats.getArtifactTime()), AbstractEJEventLogger.Companion.getMODEL_STATS_TIME_MS().with((Object)$modelStats.getModelTime()), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHED_TIME_MS().with((Object)$modelStats.getModelCachedTime()), AbstractEJEventLogger.Companion.getMODEL_STATS_REQUESTS().with((Object)$modelStats.getRequests()), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHED_REQUESTS().with((Object)$modelStats.getCachedRequests()), AbstractEJEventLogger.Companion.getMODEL_STATS_INPUT_TOKENS().with((Object)$modelStats.getInputTokens()), AbstractEJEventLogger.Companion.getMODEL_STATS_OUTPUT_TOKENS().with((Object)$modelStats.getOutputTokens()), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHE_INPUT_TOKENS().with((Object)$modelStats.getCacheInputTokens()), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHE_CREATE_INPUT_TOKENS().with((Object)$modelStats.getCacheCreateInputTokens()), AbstractEJEventLogger.Companion.getMODEL_STATS_COST().with((Object)$modelStats.getCost()), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHED_COST().with((Object)$modelStats.getCachedCost())};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final List logGenerationStepStarted$lambda$2(ArtifactId $parentArtifactId, ArtifactId $artifactId, TaskChainId $chainId, TaskId $taskId, long $startedTimestamp) {
        Object[] objectArray = new EventPair[]{PARENT_ARTIFACT_ID.with($parentArtifactId.toString()), ARTIFACT_ID.with($artifactId.toString()), CHAIN_ID.with($chainId.toString()), ISSUE_ID.with($taskId.toString()), START_TIME_MS.with((Object)$startedTimestamp)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final List logGenerationStepFinished$lambda$3(ArtifactId $artifactId, TaskChainId $chainId, TaskId $taskId, String $agentAction, EJResultStatus $status, long $durationMs, ArtifactStatistic $modelStats) {
        Object[] objectArray = new EventPair[]{ARTIFACT_ID.with($artifactId.toString()), CHAIN_ID.with($chainId.toString()), ISSUE_ID.with($taskId.toString()), STEP_TYPE.with((Object)StatsUtilsKt.getCommand($agentAction)), AbstractEJEventLogger.Companion.getSTEP_RESULT().with((Object)$status), DURATION_MS.with((Object)$durationMs), AbstractEJEventLogger.Companion.getARTIFACT_STATS_TIME_MS().with((Object)$modelStats.getArtifactTime()), AbstractEJEventLogger.Companion.getMODEL_STATS_TIME_MS().with((Object)$modelStats.getModelTime()), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHED_TIME_MS().with((Object)$modelStats.getModelCachedTime()), AbstractEJEventLogger.Companion.getMODEL_STATS_REQUESTS().with((Object)$modelStats.getRequests()), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHED_REQUESTS().with((Object)$modelStats.getCachedRequests()), AbstractEJEventLogger.Companion.getMODEL_STATS_INPUT_TOKENS().with((Object)$modelStats.getInputTokens()), AbstractEJEventLogger.Companion.getMODEL_STATS_OUTPUT_TOKENS().with((Object)$modelStats.getOutputTokens()), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHE_INPUT_TOKENS().with((Object)$modelStats.getCacheInputTokens()), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHE_CREATE_INPUT_TOKENS().with((Object)$modelStats.getCacheCreateInputTokens()), AbstractEJEventLogger.Companion.getMODEL_STATS_COST().with((Object)$modelStats.getCost()), AbstractEJEventLogger.Companion.getMODEL_STATS_CACHED_COST().with((Object)$modelStats.getCachedCost())};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0007\u00a8\u0006\""}, d2={"Lcom/intellij/ml/llm/matterhorn/statistics/AbstractEJPrivateEventLogger$Companion;", "", "<init>", "()V", "ARTIFACT_ID", "Lcom/intellij/ml/llm/matterhorn/statistics/RequestPrivateData;", "getARTIFACT_ID", "()Lcom/intellij/ml/llm/matterhorn/statistics/RequestPrivateData;", "PARENT_ARTIFACT_ID", "getPARENT_ARTIFACT_ID", "CHAIN_ID", "getCHAIN_ID", "ISSUE_ID", "getISSUE_ID", "TASK_DESCRIPTION", "getTASK_DESCRIPTION", "START_TIME_MS", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "getSTART_TIME_MS", "()Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "DURATION_MS", "getDURATION_MS", "RECENT_FILES_ADDED_TO_CONTEXT", "getRECENT_FILES_ADDED_TO_CONTEXT", "OPEN_FILES_ADDED_TO_CONTEXT", "getOPEN_FILES_ADDED_TO_CONTEXT", "EXPLICITLY_SELECTED_USER_PATHS", "getEXPLICITLY_SELECTED_USER_PATHS", "STEP_TYPE", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getSTEP_TYPE", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "EJ_VERSION", "getEJ_VERSION", "ej-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RequestPrivateData getARTIFACT_ID() {
            return ARTIFACT_ID;
        }

        @NotNull
        public final RequestPrivateData getPARENT_ARTIFACT_ID() {
            return PARENT_ARTIFACT_ID;
        }

        @NotNull
        public final RequestPrivateData getCHAIN_ID() {
            return CHAIN_ID;
        }

        @NotNull
        public final RequestPrivateData getISSUE_ID() {
            return ISSUE_ID;
        }

        @NotNull
        public final RequestPrivateData getTASK_DESCRIPTION() {
            return TASK_DESCRIPTION;
        }

        @NotNull
        public final LongEventField getSTART_TIME_MS() {
            return START_TIME_MS;
        }

        @NotNull
        public final LongEventField getDURATION_MS() {
            return DURATION_MS;
        }

        @NotNull
        public final RequestPrivateData getRECENT_FILES_ADDED_TO_CONTEXT() {
            return RECENT_FILES_ADDED_TO_CONTEXT;
        }

        @NotNull
        public final RequestPrivateData getOPEN_FILES_ADDED_TO_CONTEXT() {
            return OPEN_FILES_ADDED_TO_CONTEXT;
        }

        @NotNull
        public final RequestPrivateData getEXPLICITLY_SELECTED_USER_PATHS() {
            return EXPLICITLY_SELECTED_USER_PATHS;
        }

        @NotNull
        public final StringEventField getSTEP_TYPE() {
            return STEP_TYPE;
        }

        @NotNull
        public final RequestPrivateData getEJ_VERSION() {
            return EJ_VERSION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

