/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.miniAiChat.uiUtils;

import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JButton;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001\"B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u0019X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0012\u0010\u001e\u001a\u00020\u001fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006#"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/uiUtils/RoundedButton2D;", "Ljavax/swing/JButton;", "desiredSize", "", "horizontalTextMargin", "gapBetweenIconAndText", "arc", "<init>", "(FFFF)V", "getDesiredSize", "()F", "getHorizontalTextMargin", "getGapBetweenIconAndText", "getArc", "floatSize", "Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/uiUtils/RoundedButton2D$FloatSize;", "getFloatSize", "()Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/uiUtils/RoundedButton2D$FloatSize;", "getPreferredSize", "Ljava/awt/Dimension;", "paint", "", "g", "Ljava/awt/Graphics;", "backgroundBorderPaint", "Ljava/awt/Paint;", "getBackgroundBorderPaint", "()Ljava/awt/Paint;", "backgroundPaint", "getBackgroundPaint", "buttonForeground", "Ljava/awt/Color;", "getButtonForeground", "()Ljava/awt/Color;", "FloatSize", "intellij.ml.llm.minichat"})
public abstract class RoundedButton2D
extends JButton {
    private final float desiredSize;
    private final float horizontalTextMargin;
    private final float gapBetweenIconAndText;
    private final float arc;

    public RoundedButton2D(float desiredSize, float horizontalTextMargin, float gapBetweenIconAndText, float arc) {
        this.desiredSize = desiredSize;
        this.horizontalTextMargin = horizontalTextMargin;
        this.gapBetweenIconAndText = gapBetweenIconAndText;
        this.arc = arc;
        this.setOpaque(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public /* synthetic */ RoundedButton2D(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f3 = JBUIScale.scale((float)4.0f);
        }
        if ((n & 8) != 0) {
            f4 = JBUIScale.scale((float)7.0f);
        }
        this(f, f2, f3, f4);
    }

    public final float getDesiredSize() {
        return this.desiredSize;
    }

    public final float getHorizontalTextMargin() {
        return this.horizontalTextMargin;
    }

    public final float getGapBetweenIconAndText() {
        return this.gapBetweenIconAndText;
    }

    public final float getArc() {
        return this.arc;
    }

    private final FloatSize getFloatSize() {
        Icon icon;
        Icon icon2 = icon = this.getIcon();
        int iconSize = icon2 != null ? icon2.getIconWidth() : 0;
        String text = this.getText();
        if (text != null && !(((CharSequence)text).length() == 0)) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            int textWidth = metrics.stringWidth(text);
            float width = this.horizontalTextMargin + (icon == null ? 0.0f : (float)iconSize + this.gapBetweenIconAndText) + (float)textWidth + this.horizontalTextMargin;
            return new FloatSize(width, this.desiredSize);
        }
        return new FloatSize(this.desiredSize, this.desiredSize);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        FloatSize size = this.getFloatSize();
        return new Dimension(MathKt.roundToInt((float)size.getWidth()), MathKt.roundToInt((float)size.getHeight()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(@Nullable Graphics g) {
        Icon icon;
        Icon icon2 = icon = this.getIcon();
        int iconSize = icon2 != null ? icon2.getIconWidth() : 0;
        FloatSize floatSize = this.getFloatSize();
        Graphics graphics = g;
        if (graphics == null) {
            return;
        }
        Graphics2D graphics2D = IdeBackgroundUtil.getOriginalGraphics((Graphics)graphics);
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"getOriginalGraphics(...)");
        Graphics2D g2 = graphics2D;
        Graphics graphics2 = g2.create();
        Intrinsics.checkNotNull((Object)graphics2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g22 = (Graphics2D)graphics2;
        try {
            g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g22.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            float w = floatSize.getWidth();
            float h = floatSize.getHeight();
            float borderArc = this.arc;
            float border = JBUIScale.scale((float)1.0f);
            float buttonArc = borderArc - border;
            String text = this.getText();
            if (text != null && !(((CharSequence)text).length() == 0)) {
                g22.setPaint(this.getBackgroundBorderPaint());
                Area shape = new Area(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, this.arc, this.arc));
                g22.fill(shape);
                g22.setPaint(this.getBackgroundPaint());
                Area shape2 = new Area(new RoundRectangle2D.Float(border, border, w - (float)2 * border, h - (float)2 * border, buttonArc, buttonArc));
                g22.fill(shape2);
                g22.setColor(this.getButtonForeground());
                float textX = this.horizontalTextMargin + (icon == null ? 0.0f : (float)iconSize + this.gapBetweenIconAndText);
                g22.drawString(text, textX, (float)this.getBaseline(MathKt.roundToInt((float)w), MathKt.roundToInt((float)h)));
                Icon icon3 = icon;
                if (icon3 != null) {
                    icon3.paintIcon(this, g22, MathKt.roundToInt((float)this.horizontalTextMargin), MathKt.roundToInt((float)((h - (float)icon.getIconHeight()) / (float)2)));
                }
            } else {
                g22.setPaint(this.getBackgroundBorderPaint());
                Area shape = new Area(new Ellipse2D.Float(0.0f, 0.0f, w, h));
                g22.fill(shape);
                g22.setPaint(this.getBackgroundPaint());
                Area shape2 = new Area(new Ellipse2D.Float(border, border, w - (float)2 * border, h - (float)2 * border));
                g22.fill(shape2);
                Icon icon4 = icon;
                if (icon4 != null) {
                    icon4.paintIcon(this, g22, MathKt.roundToInt((float)((w - (float)iconSize) / (float)2)), MathKt.roundToInt((float)((h - (float)icon.getIconHeight()) / (float)2)));
                }
            }
        }
        finally {
            g22.dispose();
        }
    }

    @NotNull
    protected abstract Paint getBackgroundBorderPaint();

    @NotNull
    protected abstract Paint getBackgroundPaint();

    @NotNull
    protected abstract Color getButtonForeground();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/miniAiChat/uiUtils/RoundedButton2D$FloatSize;", "", "width", "", "height", "<init>", "(FF)V", "getWidth", "()F", "getHeight", "intellij.ml.llm.minichat"})
    private static final class FloatSize {
        private final float width;
        private final float height;

        public FloatSize(float width, float height) {
            this.width = width;
            this.height = height;
        }

        public final float getWidth() {
            return this.width;
        }

        public final float getHeight() {
            return this.height;
        }
    }
}

