/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.net.WWWFormCodec;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.apache.hc.core5.util.CharArrayBuffer;

public final class EntityUtils {
    private static final int DEFAULT_ENTITY_RETURN_MAX_LENGTH = Integer.MAX_VALUE;
    private static final Charset DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
    private static final int DEFAULT_CHAR_BUFFER_SIZE = 1024;
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 4096;
    private static final Map<String, ContentType> CONTENT_TYPE_MAP;

    private EntityUtils() {
    }

    public static void consumeQuietly(HttpEntity entity2) {
        try {
            EntityUtils.consume(entity2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void consume(HttpEntity entity2) throws IOException {
        if (entity2 == null) {
            return;
        }
        if (entity2.isStreaming()) {
            Closer.close(entity2.getContent());
        }
    }

    private static int toContentLength(int contentLength) {
        return contentLength < 0 ? 4096 : contentLength;
    }

    static long checkContentLength(EntityDetails entityDetails) {
        return Args.checkRange(entityDetails.getContentLength(), -1L, Integer.MAX_VALUE, "HTTP entity too large to be buffered in memory)");
    }

    public static byte[] toByteArray(HttpEntity entity2) throws IOException {
        Args.notNull(entity2, "HttpEntity");
        int contentLength = EntityUtils.toContentLength((int)EntityUtils.checkContentLength(entity2));
        try (InputStream inStream = entity2.getContent();){
            int l;
            if (inStream == null) {
                byte[] byArray = null;
                return byArray;
            }
            ByteArrayBuffer buffer = new ByteArrayBuffer(contentLength);
            byte[] tmp = new byte[4096];
            while ((l = inStream.read(tmp)) != -1) {
                buffer.append(tmp, 0, l);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    public static byte[] toByteArray(HttpEntity entity2, int maxResultLength) throws IOException {
        Args.notNull(entity2, "HttpEntity");
        int contentLength = EntityUtils.toContentLength((int)EntityUtils.checkContentLength(entity2));
        try (InputStream inStream = entity2.getContent();){
            int l;
            if (inStream == null) {
                byte[] byArray = null;
                return byArray;
            }
            ByteArrayBuffer buffer = new ByteArrayBuffer(Math.min(maxResultLength, contentLength));
            byte[] tmp = new byte[4096];
            while ((l = inStream.read(tmp)) != -1 && buffer.length() < maxResultLength) {
                buffer.append(tmp, 0, l);
            }
            buffer.setLength(Math.min(buffer.length(), maxResultLength));
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    private static CharArrayBuffer toCharArrayBuffer(InputStream inStream, int contentLength, Charset charset, int maxResultLength) throws IOException {
        int chReadCount;
        Args.notNull(inStream, "InputStream");
        Args.positive(maxResultLength, "maxResultLength");
        Charset actualCharset = charset == null ? DEFAULT_CHARSET : charset;
        CharArrayBuffer buf = new CharArrayBuffer(Math.min(maxResultLength, contentLength > 0 ? contentLength : 1024));
        InputStreamReader reader = new InputStreamReader(inStream, actualCharset);
        char[] tmp = new char[1024];
        while ((chReadCount = reader.read(tmp)) != -1 && buf.length() < maxResultLength) {
            buf.append(tmp, 0, chReadCount);
        }
        buf.setLength(Math.min(buf.length(), maxResultLength));
        return buf;
    }

    private static String toString(HttpEntity entity2, ContentType contentType, int maxResultLength) throws IOException {
        Args.notNull(entity2, "HttpEntity");
        int contentLength = EntityUtils.toContentLength((int)EntityUtils.checkContentLength(entity2));
        try (InputStream inStream = entity2.getContent();){
            if (inStream == null) {
                String string = null;
                return string;
            }
            Charset charset = null;
            if (contentType != null && (charset = contentType.getCharset()) == null) {
                ContentType defaultContentType = CONTENT_TYPE_MAP.get(contentType.getMimeType());
                charset = defaultContentType != null ? defaultContentType.getCharset() : null;
            }
            String string = EntityUtils.toCharArrayBuffer(inStream, contentLength, charset, maxResultLength).toString();
            return string;
        }
    }

    public static String toString(HttpEntity entity2, Charset defaultCharset) throws IOException, ParseException {
        return EntityUtils.toString(entity2, defaultCharset, Integer.MAX_VALUE);
    }

    public static String toString(HttpEntity entity2, Charset defaultCharset, int maxResultLength) throws IOException, ParseException {
        ContentType contentType;
        block5: {
            Args.notNull(entity2, "HttpEntity");
            contentType = null;
            try {
                contentType = ContentType.parse(entity2.getContentType());
            }
            catch (UnsupportedCharsetException ex) {
                if (defaultCharset != null) break block5;
                throw new UnsupportedEncodingException(ex.getMessage());
            }
        }
        if (contentType != null) {
            if (contentType.getCharset() == null) {
                contentType = contentType.withCharset(defaultCharset);
            }
        } else {
            contentType = ContentType.DEFAULT_TEXT.withCharset(defaultCharset);
        }
        return EntityUtils.toString(entity2, contentType, maxResultLength);
    }

    public static String toString(HttpEntity entity2, String defaultCharset) throws IOException, ParseException {
        return EntityUtils.toString(entity2, defaultCharset, Integer.MAX_VALUE);
    }

    public static String toString(HttpEntity entity2, String defaultCharset, int maxResultLength) throws IOException, ParseException {
        return EntityUtils.toString(entity2, defaultCharset != null ? Charset.forName(defaultCharset) : null, maxResultLength);
    }

    public static String toString(HttpEntity entity2) throws IOException, ParseException {
        return EntityUtils.toString(entity2, Integer.MAX_VALUE);
    }

    public static String toString(HttpEntity entity2, int maxResultLength) throws IOException, ParseException {
        Args.notNull(entity2, "HttpEntity");
        return EntityUtils.toString(entity2, ContentType.parse(entity2.getContentType()), maxResultLength);
    }

    public static List<NameValuePair> parse(HttpEntity entity2) throws IOException {
        return EntityUtils.parse(entity2, Integer.MAX_VALUE);
    }

    public static List<NameValuePair> parse(HttpEntity entity2, int maxStreamLength) throws IOException {
        CharArrayBuffer buf;
        Args.notNull(entity2, "HttpEntity");
        int contentLength = EntityUtils.toContentLength((int)EntityUtils.checkContentLength(entity2));
        ContentType contentType = ContentType.parse(entity2.getContentType());
        if (!ContentType.APPLICATION_FORM_URLENCODED.isSameMimeType(contentType)) {
            return Collections.emptyList();
        }
        Charset charset = contentType.getCharset(DEFAULT_CHARSET);
        try (InputStream inStream = entity2.getContent();){
            if (inStream == null) {
                List<NameValuePair> list2 = Collections.emptyList();
                return list2;
            }
            buf = EntityUtils.toCharArrayBuffer(inStream, contentLength, charset, maxStreamLength);
        }
        if (buf.isEmpty()) {
            return Collections.emptyList();
        }
        return WWWFormCodec.parse(buf, charset);
    }

    static {
        ContentType[] contentTypes = new ContentType[]{ContentType.APPLICATION_ATOM_XML, ContentType.APPLICATION_FORM_URLENCODED, ContentType.APPLICATION_JSON, ContentType.APPLICATION_SVG_XML, ContentType.APPLICATION_XHTML_XML, ContentType.APPLICATION_XML, ContentType.MULTIPART_FORM_DATA, ContentType.TEXT_HTML, ContentType.TEXT_PLAIN, ContentType.TEXT_XML};
        HashMap<String, ContentType> map2 = new HashMap<String, ContentType>();
        for (ContentType contentType : contentTypes) {
            map2.put(contentType.getMimeType(), contentType);
        }
        CONTENT_TYPE_MAP = Collections.unmodifiableMap(map2);
    }
}

