/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.terminal.TerminalLLMBundle;
import com.intellij.ml.llm.terminal.TerminalTextToCommandModeManager;
import com.intellij.ml.llm.terminal.TerminalTextToCommandSession;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPromoter;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModel;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalTextToCommandAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/ActionPromoter;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "updatePresentation", "state", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandAction$TextToCommandModeState;", "getCurrentState", "promptModel", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "suppress", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "actions", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "TextToCommandModeState", "intellij.ml.llm.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalTextToCommandAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalTextToCommandAction.kt\ncom/intellij/ml/llm/terminal/TerminalTextToCommandAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n774#2:114\n865#2,2:115\n*S KotlinDebug\n*F\n+ 1 TerminalTextToCommandAction.kt\ncom/intellij/ml/llm/terminal/TerminalTextToCommandAction\n*L\n110#1:114\n110#1:115,2\n*E\n"})
public final class TerminalTextToCommandAction
extends DumbAwareAction
implements ActionPromoter {
    public TerminalTextToCommandAction() {
        Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        super(TerminalLLMBundle.INSTANCE.messagePointer("action.Terminal.GenerateCommandFromText.brandedText", objectArray));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = TerminalDataContextUtils.INSTANCE.getEditor(e);
        if (editor == null || (editor = TerminalDataContextUtils.INSTANCE.getTerminalPromptModel(editor)) == null) {
            throw new IllegalStateException("No prompt model in the terminal prompt editor".toString());
        }
        Editor promptModel = editor;
        Object object = TerminalDataContextUtils.INSTANCE.getEditor(e);
        if (object == null || (object = TerminalTextToCommandModeManager.Companion.getTextToCommandModeManager((Editor)object)) == null) {
            throw new IllegalStateException("No TextToCommandModeManager in the terminal prompt editor".toString());
        }
        Object textToCommandModeManager = object;
        TextToCommandModeState state = this.getCurrentState((TerminalPromptModel)promptModel);
        TextToCommandModeState newState = switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1 -> {
                TerminalTextToCommandModeManager.AiModeEnablingReason reason = e.isFromContextMenu() ? TerminalTextToCommandModeManager.AiModeEnablingReason.AI_CONTEXT_MENU_OPTION_CLICKED : (e.getInputEvent() instanceof KeyEvent ? TerminalTextToCommandModeManager.AiModeEnablingReason.AI_SHORTCUT_PRESSED : TerminalTextToCommandModeManager.AiModeEnablingReason.AI_ICON_CLICKED);
                ((TerminalTextToCommandModeManager)textToCommandModeManager).activateTextToCommandMode(reason);
                yield TextToCommandModeState.ENABLED;
            }
            case 2 -> {
                TerminalTextToCommandModeManager.AiModeDisablingReason v3;
                InputEvent var7_6 = e.getInputEvent();
                KeyEvent keyEvent = var7_6 instanceof KeyEvent ? (KeyEvent)var7_6 : null;
                if (e.isFromContextMenu()) {
                    v3 = TerminalTextToCommandModeManager.AiModeDisablingReason.AI_CONTEXT_MENU_OPTION_CLICKED;
                } else {
                    KeyEvent v4 = keyEvent;
                    v3 = (v4 != null ? v4.getKeyCode() == 27 : false) ? TerminalTextToCommandModeManager.AiModeDisablingReason.ESCAPE_PRESSED : (keyEvent != null ? TerminalTextToCommandModeManager.AiModeDisablingReason.AI_SHORTCUT_PRESSED : TerminalTextToCommandModeManager.AiModeDisablingReason.AI_ICON_CLICKED);
                }
                TerminalTextToCommandModeManager.AiModeDisablingReason reason = v3;
                ((TerminalTextToCommandModeManager)textToCommandModeManager).deactivateTextToCommandMode(reason);
                yield TextToCommandModeState.DISABLED;
            }
            case 3 -> {
                TerminalTextToCommandSession v5 = TerminalTextToCommandSession.Companion.get((TerminalPromptModel)promptModel);
                Intrinsics.checkNotNull((Object)v5);
                v5.interruptCommandGeneration();
                yield TextToCommandModeState.ENABLED;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        this.updatePresentation(e, newState);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = TerminalDataContextUtils.INSTANCE.getEditor(e);
        TerminalPromptModel promptModel = editor != null ? TerminalDataContextUtils.INSTANCE.getTerminalPromptModel(editor) : null;
        Project project = e.getProject();
        e.getPresentation().setVisible(project != null && promptModel != null && TerminalTextToCommandModeManager.Companion.getTextToCommandModeManager((Editor)promptModel.getEditor()) != null && TerminalDataContextUtils.INSTANCE.getTerminalOutputModel(e) != null && AIAssistantUIUtil.INSTANCE.isAuthedAndAllowed(project));
        e.getPresentation().setEnabled(e.getPresentation().isVisible() && AIAssistantUIUtil.INSTANCE.isAssistantActive(e.getProject()));
        if (promptModel != null) {
            TextToCommandModeState state = this.getCurrentState(promptModel);
            this.updatePresentation(e, state);
        }
    }

    private final void updatePresentation(AnActionEvent e, TextToCommandModeState state) {
        Toggleable.setSelected((Presentation)e.getPresentation(), (state == TextToCommandModeState.ENABLED ? 1 : 0) != 0);
        if (!e.isFromActionToolbar()) {
            String string;
            Presentation presentation = e.getPresentation();
            if (state == TextToCommandModeState.DISABLED) {
                Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
                string = TerminalLLMBundle.INSTANCE.message("action.Terminal.GenerateCommandFromText.brandedText", objectArray);
            } else {
                string = TerminalLLMBundle.INSTANCE.message("action.Terminal.GenerateCommandFromText.disableText", new Object[0]);
            }
            presentation.setText(string);
        }
        e.getPresentation().setIcon(state == TextToCommandModeState.GENERATING_COMMAND ? AllIcons.Actions.Suspend : AIAssistantBranding.Logo16Colored);
    }

    private final TextToCommandModeState getCurrentState(TerminalPromptModel promptModel) {
        TerminalTextToCommandSession session = TerminalTextToCommandSession.Companion.get(promptModel);
        return session != null && session.isCommandGenerationInProgress() ? TextToCommandModeState.GENERATING_COMMAND : (session != null ? TextToCommandModeState.ENABLED : TextToCommandModeState.DISABLED);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AnAction> suppress(@NotNull List<? extends AnAction> actions, @NotNull DataContext context) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (LookupManager.getActiveLookup((Editor)TerminalDataContextUtils.INSTANCE.getEditor(context)) != null) {
            return CollectionsKt.listOf((Object)((Object)this));
        }
        ActionManager actionManager = ActionManager.getInstance();
        Iterable $this$filter$iv = actions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AnAction it = (AnAction)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)actionManager.getId(it), (Object)"Terminal.Escape")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalTextToCommandAction$TextToCommandModeState;", "", "<init>", "(Ljava/lang/String;I)V", "DISABLED", "ENABLED", "GENERATING_COMMAND", "intellij.ml.llm.terminal"})
    private static final class TextToCommandModeState
    extends Enum<TextToCommandModeState> {
        public static final /* enum */ TextToCommandModeState DISABLED = new TextToCommandModeState();
        public static final /* enum */ TextToCommandModeState ENABLED = new TextToCommandModeState();
        public static final /* enum */ TextToCommandModeState GENERATING_COMMAND = new TextToCommandModeState();
        private static final /* synthetic */ TextToCommandModeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TextToCommandModeState[] values() {
            return (TextToCommandModeState[])$VALUES.clone();
        }

        public static TextToCommandModeState valueOf(String value) {
            return Enum.valueOf(TextToCommandModeState.class, value);
        }

        @NotNull
        public static EnumEntries<TextToCommandModeState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = textToCommandModeStateArray = new TextToCommandModeState[]{TextToCommandModeState.DISABLED, TextToCommandModeState.ENABLED, TextToCommandModeState.GENERATING_COMMAND};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextToCommandModeState.values().length];
            try {
                nArray[TextToCommandModeState.DISABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextToCommandModeState.ENABLED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextToCommandModeState.GENERATING_COMMAND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

