/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Name;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

@BugPattern(summary="Class.newInstance() bypasses exception checking; prefer getDeclaredConstructor().newInstance()", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class ClassNewInstance
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> NEW_INSTANCE = MethodMatchers.instanceMethod().onExactClass(Class.class.getName()).named("newInstance");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!NEW_INSTANCE.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix.replace(state.getEndPosition((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)), state.getEndPosition((Tree)tree), ".getDeclaredConstructor().newInstance()");
        boolean fixedExceptions = ClassNewInstance.fixExceptions(state, fix);
        if (!fixedExceptions) {
            ClassNewInstance.fixThrows(state, fix);
        }
        return this.describeMatch(tree, (Fix)fix.build());
    }

    private static boolean fixExceptions(final VisitorState state, SuggestedFix.Builder fix) {
        TryTree tryTree = null;
        for (TreePath path = state.getPath(); path != null; path = path.getParentPath()) {
            if (path.getLeaf() instanceof CatchTree) {
                return false;
            }
            if (!(path.getLeaf() instanceof TryTree) || ((TryTree)path.getLeaf()).getCatches().isEmpty()) continue;
            tryTree = (TryTree)path.getLeaf();
            break;
        }
        if (tryTree == null) {
            return false;
        }
        ImmutableMap.Builder catches = ImmutableMap.builder();
        for (CatchTree catchTree : tryTree.getCatches()) {
            catches.put((Object)ASTHelpers.getType((Tree)catchTree.getParameter().getType()), (Object)catchTree);
        }
        UnhandledResult result = ClassNewInstance.unhandled(catches.buildOrThrow(), state);
        if (result.unhandled.isEmpty()) {
            return true;
        }
        CatchTree catchTree = (CatchTree)Iterables.getLast(tryTree.getCatches());
        Tree lastType = catchTree.getParameter().getType();
        if (lastType.getKind() == Tree.Kind.UNION_TYPE) {
            Type roe = state.getTypeFromString(ReflectiveOperationException.class.getName());
            LinkedHashSet<String> exceptions = new LinkedHashSet<String>();
            boolean foundReflective = false;
            for (Tree tree : ((UnionTypeTree)lastType).getTypeAlternatives()) {
                if (ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)tree), (Type)roe, (VisitorState)state)) {
                    foundReflective = true;
                    exceptions.add("ReflectiveOperationException");
                    continue;
                }
                exceptions.add(state.getSourceForNode(tree));
            }
            if (foundReflective) {
                fix.replace(lastType, Joiner.on((String)" | ").join(exceptions));
                return true;
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (CatchTree ct : result.handles.values()) {
            hashSet.add(state.getSourceForNode((Tree)ct.getBlock()));
        }
        if (hashSet.size() != 1) {
            CatchTree last2 = (CatchTree)Iterables.getLast(tryTree.getCatches());
            String name = last2.getParameter().getName().toString();
            fix.postfixWith((Tree)last2, String.format("catch (ReflectiveOperationException %s) { throw new LinkageError(%s.getMessage(), %s); }", name, name, name));
            return true;
        }
        final AtomicBoolean newInstanceInCatch = new AtomicBoolean(false);
        ((JCTree)result.handles.values().iterator().next()).accept(new TreeScanner(){

            @Override
            public void visitApply(JCTree.JCMethodInvocation tree) {
                if (NEW_INSTANCE.matches((Tree)tree, state)) {
                    newInstanceInCatch.set(true);
                }
            }
        });
        if (newInstanceInCatch.get()) {
            fix.replace(((CatchTree)Iterables.getLast((Iterable)result.handles.values())).getParameter().getType(), "ReflectiveOperationException");
            return true;
        }
        boolean first = true;
        for (CatchTree ct : result.handles.values()) {
            if (first) {
                fix.replace(ct.getParameter().getType(), "ReflectiveOperationException");
                first = false;
                continue;
            }
            fix.delete((Tree)ct);
        }
        return true;
    }

    private static void fixThrows(VisitorState state, SuggestedFix.Builder fix) {
        MethodTree methodTree = (MethodTree)state.findEnclosing(new Class[]{MethodTree.class});
        if (methodTree == null || methodTree.getThrows().isEmpty()) {
            return;
        }
        ImmutableMap.Builder thrown = ImmutableMap.builder();
        for (ExpressionTree expressionTree : methodTree.getThrows()) {
            thrown.put((Object)ASTHelpers.getType((Tree)expressionTree), (Object)expressionTree);
        }
        UnhandledResult result = ClassNewInstance.unhandled(thrown.buildOrThrow(), state);
        if (result.unhandled.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Type handle : result.unhandled) {
            arrayList.add(((Name)handle.tsym.getSimpleName()).toString());
        }
        Collections.sort(arrayList);
        fix.postfixWith((Tree)Iterables.getLast(methodTree.getThrows()), ", " + Joiner.on((String)", ").join(arrayList));
        fix.addImport("java.lang.reflect.InvocationTargetException");
    }

    private static <T> UnhandledResult<T> unhandled(ImmutableMap<Type, T> handles, VisitorState state) {
        LinkedHashSet<Type> toHandle = new LinkedHashSet<Type>();
        for (Class e : Arrays.asList(InstantiationException.class, IllegalAccessException.class, InvocationTargetException.class, NoSuchMethodException.class)) {
            Type type = state.getTypeFromString(e.getName());
            if (type == null) continue;
            toHandle.add(type);
        }
        Type roe = state.getTypeFromString(ReflectiveOperationException.class.getName());
        ImmutableMap.Builder newHandles = ImmutableMap.builder();
        for (Map.Entry entry : handles.entrySet()) {
            Type type = (Type)entry.getKey();
            if (ASTHelpers.isSubtype((Type)type, (Type)roe, (VisitorState)state)) {
                newHandles.put((Object)type, entry.getValue());
            }
            for (Type precise : type.isUnion() ? ((Type.UnionClassType)type).getAlternativeTypes() : Collections.singleton(type)) {
                toHandle.removeIf(elem -> ASTHelpers.isSubtype((Type)elem, (Type)precise, (VisitorState)state));
            }
        }
        return new UnhandledResult((ImmutableSet<Type>)ImmutableSet.copyOf(toHandle), newHandles.buildOrThrow());
    }

    static class UnhandledResult<T> {
        final ImmutableSet<Type> unhandled;
        final ImmutableMap<Type, T> handles;

        UnhandledResult(ImmutableSet<Type> unhandled, ImmutableMap<Type, T> handles) {
            this.unhandled = unhandled;
            this.handles = handles;
        }
    }
}

