/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.util.Context;
import java.util.List;
import java.util.stream.Collectors;

@BugPattern(summary="Both branches contain identical code", severity=BugPattern.SeverityLevel.ERROR)
public class DuplicateBranches
extends BugChecker
implements BugChecker.IfTreeMatcher,
BugChecker.ConditionalExpressionTreeMatcher {
    private static final int MAX_LENGTH_TO_COMPARE = 750;

    public Description matchConditionalExpression(ConditionalExpressionTree tree, VisitorState state) {
        return this.match(tree, tree.getTrueExpression(), tree.getFalseExpression(), state);
    }

    public Description matchIf(IfTree tree, VisitorState state) {
        if (tree.getElseStatement() == null) {
            return Description.NO_MATCH;
        }
        return this.match(tree, tree.getThenStatement(), tree.getElseStatement(), state);
    }

    private Description match(Tree tree, Tree thenTree, Tree elseTree, VisitorState state) {
        Object comments;
        if (state.getSourceForNode(thenTree).length() > 750 || state.getSourceForNode(elseTree).length() > 750) {
            return Description.NO_MATCH;
        }
        if (!thenTree.toString().equals(elseTree.toString())) {
            return Description.NO_MATCH;
        }
        int start = ASTHelpers.getStartPosition((Tree)elseTree);
        int end = state.getEndPosition(elseTree);
        boolean needsBraces = false;
        if (elseTree instanceof BlockTree) {
            needsBraces = !state.getPath().getParentPath().getLeaf().getKind().equals((Object)Tree.Kind.BLOCK);
            List<? extends StatementTree> statements = ((BlockTree)elseTree).getStatements();
            if (statements.isEmpty()) {
                start = end;
            } else {
                start = ASTHelpers.getStartPosition((Tree)statements.get(0));
                end = state.getEndPosition((Tree)Iterables.getLast(statements));
            }
        }
        if (!((String)(comments = ErrorProneTokens.getTokens((String)state.getSourceCode().subSequence(ASTHelpers.getStartPosition((Tree)tree), start).toString(), (int)ASTHelpers.getStartPosition((Tree)tree), (Context)state.context).stream().flatMap(errorProneToken -> errorProneToken.comments().stream()).map(c -> c.getText()).collect(Collectors.joining("\n")))).isEmpty()) {
            comments = (String)comments + "\n";
        }
        String replacement = (String)comments + String.valueOf(state.getSourceCode().subSequence(start, end));
        if (needsBraces) {
            replacement = "{\n" + replacement + "}";
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)replacement));
    }
}

