/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ClosingFuture;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

@BugPattern(summary="Use transform instead of transformAsync when all returns are an immediate future.", severity=BugPattern.SeverityLevel.WARNING)
public final class FutureTransformAsync
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableSet<String> CLASSES_WITH_STATIC_METHOD = ImmutableSet.of((Object)Futures.class.getName());
    private static final ImmutableSet<String> CLASSES_WITH_INSTANCE_METHOD = ImmutableSet.of((Object)ClosingFuture.class.getName(), (Object)FluentFuture.class.getName());
    private static final Matcher<ExpressionTree> TRANSFORM_ASYNC_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClassAny(CLASSES_WITH_STATIC_METHOD).named("transformAsync"), MethodMatchers.instanceMethod().onExactClassAny(CLASSES_WITH_INSTANCE_METHOD).named("transformAsync")});
    private static final Matcher<ExpressionTree> IMMEDIATE_FUTURE = MethodMatchers.staticMethod().onClassAny((Iterable)Sets.union(CLASSES_WITH_STATIC_METHOD, CLASSES_WITH_INSTANCE_METHOD)).named("immediateFuture");
    private static final Matcher<ExpressionTree> IMMEDIATE_VOID_FUTURE = MethodMatchers.staticMethod().onClassAny((Iterable)Sets.union(CLASSES_WITH_STATIC_METHOD, CLASSES_WITH_INSTANCE_METHOD)).named("immediateVoidFuture");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!TRANSFORM_ASYNC_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Optional<LambdaExpressionTree> lambda = tree.getArguments().stream().filter(LambdaExpressionTree.class::isInstance).map(arg -> (LambdaExpressionTree)arg).filter(lambdaTree -> !FutureTransformAsync.throwsCheckedException(lambdaTree, state)).findFirst();
        return lambda.map(lambdaTree -> this.handleTransformAsync(tree, (LambdaExpressionTree)lambdaTree, state)).orElse(Description.NO_MATCH);
    }

    private Description handleTransformAsync(MethodInvocationTree tree, LambdaExpressionTree lambda, VisitorState state) {
        final HashSet<ExpressionTree> returnExpressions = new HashSet<ExpressionTree>();
        if (lambda.getBody() instanceof ExpressionTree) {
            returnExpressions.add((ExpressionTree)lambda.getBody());
        } else if (lambda.getBody() instanceof BlockTree) {
            new TreePathScanner<Void, Void>(this){
                final /* synthetic */ FutureTransformAsync this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                    return null;
                }

                @Override
                public Void visitClass(ClassTree node, Void unused) {
                    return null;
                }

                @Override
                public Void visitReturn(ReturnTree tree, Void unused) {
                    returnExpressions.add(tree.getExpression());
                    return null;
                }
            }.scan(TreePath.getPath(state.getPath().getCompilationUnit(), lambda.getBody()), (Void)null);
        } else {
            return Description.NO_MATCH;
        }
        boolean areAllImmediateFutures = returnExpressions.stream().allMatch(expression -> expression instanceof MethodInvocationTree && (IMMEDIATE_FUTURE.matches((Tree)expression, state) || IMMEDIATE_VOID_FUTURE.matches((Tree)expression, state)));
        if (areAllImmediateFutures) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            FutureTransformAsync.suggestFixTransformAsyncToTransform(tree, state, fix);
            for (ExpressionTree expression2 : returnExpressions) {
                FutureTransformAsync.suggestFixRemoveImmediateFuture((MethodInvocationTree)expression2, state, fix);
            }
            state.reportMatch(this.describeMatch(tree, (Fix)fix.build()));
        }
        return Description.NO_MATCH;
    }

    private static boolean throwsCheckedException(LambdaExpressionTree lambda, VisitorState state) {
        return ASTHelpers.getThrownExceptions((Tree)lambda.getBody(), (VisitorState)state).stream().anyMatch(type -> ASTHelpers.isCheckedExceptionType((Type)type, (VisitorState)state));
    }

    private static void suggestFixTransformAsyncToTransform(MethodInvocationTree tree, VisitorState state, SuggestedFix.Builder fix) {
        ExpressionTree methodSelect = tree.getMethodSelect();
        if (state.getSourceForNode((Tree)methodSelect).equals("transformAsync")) {
            Symbol symbol = ASTHelpers.getSymbol((Tree)methodSelect);
            String className = ASTHelpers.enclosingClass((Symbol)symbol).getQualifiedName().toString();
            fix.addStaticImport(className + ".transform");
        }
        fix.merge(SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"transform", (VisitorState)state));
    }

    private static void suggestFixRemoveImmediateFuture(MethodInvocationTree tree, VisitorState state, SuggestedFix.Builder fix) {
        String typeArgument = "";
        String argument = "";
        if (IMMEDIATE_FUTURE.matches((Tree)tree, state)) {
            List<? extends Tree> typeArguments = tree.getTypeArguments();
            if (typeArguments.size() == 1) {
                typeArgument = state.getSourceForNode(typeArguments.get(0));
            }
            argument = state.getSourceForNode((Tree)tree.getArguments().get(0));
        } else if (IMMEDIATE_VOID_FUTURE.matches((Tree)tree, state)) {
            typeArgument = "Void";
            argument = "null";
        }
        String fixString = typeArgument.isEmpty() ? argument : String.format("(%s) %s", typeArgument, argument);
        fix.replace((Tree)tree, fixString);
    }
}

