/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.argumentselectiondefects.NamedParameterComment;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="Methods and non-static variables should be named in lowerCamelCase", altNames={"MemberName"}, linkType=BugPattern.LinkType.CUSTOM, link="https://google.github.io/styleguide/javaguide.html#s5.2-specific-identifier-names")
public final class IdentifierName
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Supplier<ImmutableSet<Name>> EXEMPTED_CLASS_ANNOTATIONS = VisitorState.memoize((Supplier & Serializable)s -> (ImmutableSet)Stream.of("org.robolectric.annotation.Implements").map(arg_0 -> ((VisitorState)s).getName(arg_0)).collect(ImmutableSet.toImmutableSet()));
    private static final Supplier<ImmutableSet<Name>> EXEMPTED_METHOD_ANNOTATIONS = VisitorState.memoize((Supplier & Serializable)s -> (ImmutableSet)Stream.of("com.pholser.junit.quickcheck.Property", "com.google.caliper.Benchmark", "com.google.caliper.api.Macrobenchmark", "com.google.caliper.api.Footprint").map(arg_0 -> ((VisitorState)s).getName(arg_0)).collect(ImmutableSet.toImmutableSet()));
    private static final String STATIC_VARIABLE_FINDING = "Static variables should be named in UPPER_SNAKE_CASE if deeply immutable or lowerCamelCase if not";
    private static final String INITIALISM_DETAIL = ", with acronyms treated as words (https://google.github.io/styleguide/javaguide.html#s5.3-camel-case)";
    private final boolean allowInitialismsInTypeName;
    private static final ImmutableSet<String> EXEMPTED_VARIABLE_NAMES = ImmutableSet.of((Object)"serialVersionUID");
    private static final ImmutableSet<ElementKind> LOCAL_VARIABLE_KINDS = ImmutableSet.of((Object)((Object)ElementKind.LOCAL_VARIABLE), (Object)((Object)ElementKind.RESOURCE_VARIABLE), (Object)((Object)ElementKind.EXCEPTION_PARAMETER));
    private static final Pattern LOWER_UNDERSCORE_PATTERN = Pattern.compile("[a-z0-9_]+");
    private static final Pattern UPPER_UNDERSCORE_PATTERN = Pattern.compile("[A-Z0-9_]+");
    private static final Pattern PROBABLE_INITIALISM = Pattern.compile("([A-Z]{2,})([A-Z][^A-Z]|$)");
    private static final Splitter UNDERSCORE_SPLITTER = Splitter.on((char)'_');

    @Inject
    IdentifierName(ErrorProneFlags flags) {
        this.allowInitialismsInTypeName = flags.getBoolean("IdentifierName:AllowInitialismsInTypeName").orElse(false);
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        Symbol.ClassSymbol symbol = ASTHelpers.getSymbol((ClassTree)tree);
        String name = tree.getSimpleName().toString();
        if (name.isEmpty() || this.isConformantTypeName(name)) {
            return Description.NO_MATCH;
        }
        String renamed = IdentifierName.suggestedClassRename(name);
        String suggested = this.allowInitialismsInTypeName ? renamed : IdentifierName.fixInitialisms(renamed);
        boolean fixable = !suggested.equals(name) && ASTHelpers.canBeRemoved((Symbol.ClassSymbol)symbol);
        String diagnostic = "Classes should be named in UpperCamelCase" + (suggested.equals(renamed) ? "" : INITIALISM_DETAIL);
        return this.buildDescription(tree).setMessage(fixable ? diagnostic : diagnostic + String.format("; did you mean '%s'?", suggested)).addFix((Fix)SuggestedFix.emptyFix()).build();
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (!ASTHelpers.annotationsAmong((Symbol)symbol.owner, (Set)((Set)EXEMPTED_CLASS_ANNOTATIONS.get(state)), (VisitorState)state).isEmpty()) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.annotationsAmong((Symbol)symbol, (Set)((Set)EXEMPTED_METHOD_ANNOTATIONS.get(state)), (VisitorState)state).isEmpty()) {
            return Description.NO_MATCH;
        }
        if (IdentifierName.hasTestAnnotation(symbol)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Symbol)symbol, (String)"org.junit.Ignore", (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.findSuperMethods((Symbol.MethodSymbol)symbol, (Types)state.getTypes()).isEmpty()) {
            return Description.NO_MATCH;
        }
        if (tree.getModifiers().getFlags().contains((Object)Modifier.NATIVE)) {
            return Description.NO_MATCH;
        }
        if (((Name)symbol.getSimpleName()).toString().startsWith("parametersFor")) {
            return Description.NO_MATCH;
        }
        if (JUnitMatchers.TEST_CASE.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        String name = tree.getName().toString();
        if (IdentifierName.isConformant(symbol, name)) {
            return Description.NO_MATCH;
        }
        String renamed = IdentifierName.suggestedRename(symbol, name);
        String suggested = IdentifierName.fixInitialisms(renamed);
        boolean fixable = !suggested.equals(name) && ASTHelpers.canBeRemoved((Symbol)symbol, (VisitorState)state);
        String diagnostic = "Methods and non-static variables should be named in lowerCamelCase" + (suggested.equals(renamed) ? "" : INITIALISM_DETAIL) + ", but " + String.valueOf(symbol.getSimpleName()) + " is not";
        return this.buildDescription(tree).setMessage(fixable ? diagnostic : diagnostic + String.format("; did you mean '%s'?", suggested)).addFix((Fix)(fixable ? SuggestedFixes.renameMethodWithInvocations((MethodTree)tree, (String)suggested, (VisitorState)state) : SuggestedFix.emptyFix())).build();
    }

    private static boolean hasTestAnnotation(Symbol.MethodSymbol symbol) {
        return symbol.getRawAttributes().stream().anyMatch(c -> ((Name)c.type.tsym.getSimpleName()).toString().contains("Test"));
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        String name = tree.getName().toString();
        if (symbol.owner instanceof Symbol.MethodSymbol && symbol.getKind() == ElementKind.PARAMETER && state.getPath().getParentPath().getLeaf().getKind() != Tree.Kind.LAMBDA_EXPRESSION) {
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol.owner;
            int index = ((List)methodSymbol.getParameters()).indexOf(symbol);
            Optional maybeSuper = ASTHelpers.streamSuperMethods((Symbol.MethodSymbol)methodSymbol, (Types)state.getTypes()).findFirst();
            if (maybeSuper.isPresent()) {
                Symbol.MethodSymbol superMethod = (Symbol.MethodSymbol)maybeSuper.get();
                if (NamedParameterComment.containsSyntheticParameterName(superMethod)) {
                    return Description.NO_MATCH;
                }
                if (index < ((List)superMethod.getParameters()).size() && ((Name)((Symbol.VarSymbol)((List)superMethod.getParameters()).get(index)).getSimpleName()).contentEquals(name)) {
                    return Description.NO_MATCH;
                }
            }
        }
        if (IdentifierName.isConformantStaticVariableName(name) && !symbol.isStatic()) {
            return Description.NO_MATCH;
        }
        if (IdentifierName.isConformant(symbol, name)) {
            return Description.NO_MATCH;
        }
        if (EXEMPTED_VARIABLE_NAMES.contains((Object)name)) {
            return Description.NO_MATCH;
        }
        String renamed = IdentifierName.suggestedRename(symbol, name);
        String suggested = IdentifierName.fixInitialisms(renamed);
        boolean fixable = !suggested.equals(name) && IdentifierName.canBeRenamed(symbol);
        String diagnostic = (IdentifierName.isStaticVariable(symbol) ? STATIC_VARIABLE_FINDING : this.message()) + (suggested.equals(renamed) ? "" : INITIALISM_DETAIL) + ", but " + String.valueOf(symbol.getSimpleName()) + " is not";
        return this.buildDescription(tree).setMessage(fixable ? diagnostic : diagnostic + String.format("; did you mean '%s'?", suggested)).addFix((Fix)(fixable ? SuggestedFixes.renameVariable((VariableTree)tree, (String)suggested, (VisitorState)state) : SuggestedFix.emptyFix())).build();
    }

    private static String suggestedRename(Symbol symbol, String name) {
        if (!IdentifierName.isStaticVariable(symbol) && IdentifierName.isConformantStaticVariableName(name)) {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
        }
        if (LOWER_UNDERSCORE_PATTERN.matcher(name).matches()) {
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
        }
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, UNDERSCORE_SPLITTER.splitToStream((CharSequence)name).map(c -> CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, c)).collect(Collectors.joining("")));
    }

    private static String suggestedClassRename(String name) {
        if (LOWER_UNDERSCORE_PATTERN.matcher(name).matches()) {
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, name);
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, UNDERSCORE_SPLITTER.splitToStream((CharSequence)name).map(c -> CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_CAMEL, c)).collect(Collectors.joining("")));
    }

    private static boolean canBeRenamed(Symbol symbol) {
        return symbol.isPrivate() || LOCAL_VARIABLE_KINDS.contains((Object)symbol.getKind());
    }

    private static boolean isConformant(Symbol symbol, String name) {
        if (IdentifierName.isStaticVariable(symbol) && IdentifierName.isConformantStaticVariableName(name)) {
            return true;
        }
        return IdentifierName.isConformantLowerCamelName(name);
    }

    private static boolean isConformantStaticVariableName(String name) {
        return UPPER_UNDERSCORE_PATTERN.matcher(name).matches();
    }

    private static boolean isConformantLowerCamelName(String name) {
        return !name.contains("_") && !Ascii.isUpperCase((char)name.charAt(0)) && !PROBABLE_INITIALISM.matcher(name).find();
    }

    private boolean isConformantTypeName(String name) {
        return !name.contains("_") && Ascii.isUpperCase((char)name.charAt(0)) && (this.allowInitialismsInTypeName || !PROBABLE_INITIALISM.matcher(name).find());
    }

    private static boolean isStaticVariable(Symbol symbol) {
        return symbol instanceof Symbol.VarSymbol && ASTHelpers.isStatic((Symbol)symbol);
    }

    private static String fixInitialisms(String input) {
        return PROBABLE_INITIALISM.matcher(input).replaceAll(r -> IdentifierName.titleCase(r.group(1)) + r.group(2));
    }

    private static String titleCase(String input) {
        String lower = Ascii.toLowerCase((String)input);
        return Ascii.toUpperCase((char)lower.charAt(0)) + lower.substring(1);
    }
}

