/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import java.util.List;

@BugPattern(summary="toCharArray allocates a new array, using charAt is more efficient", severity=BugPattern.SeverityLevel.WARNING)
public class LoopOverCharArray
extends BugChecker
implements BugChecker.EnhancedForLoopTreeMatcher {
    private static final Matcher<ExpressionTree> TO_CHAR_ARRAY = MethodMatchers.instanceMethod().onExactClass("java.lang.String").named("toCharArray");

    public Description matchEnhancedForLoop(EnhancedForLoopTree tree, VisitorState state) {
        if (!TO_CHAR_ARRAY.matches((Tree)tree.getExpression(), state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree.getExpression());
        if (!(receiver instanceof IdentifierTree)) {
            return Description.NO_MATCH;
        }
        StatementTree body = tree.getStatement();
        if (!(body instanceof BlockTree)) {
            return Description.NO_MATCH;
        }
        List<? extends StatementTree> statements = ((BlockTree)body).getStatements();
        if (statements.isEmpty()) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        if (!LoopOverCharArray.alreadyDefinesIdentifier(tree)) {
            description.addFix((Fix)SuggestedFix.replace((int)ASTHelpers.getStartPosition((Tree)tree), (int)ASTHelpers.getStartPosition((Tree)statements.get(0)), (String)String.format("for (int i = 0; i < %s.length(); i++) { char %s = %s.charAt(i);", state.getSourceForNode((Tree)receiver), tree.getVariable().getName(), state.getSourceForNode((Tree)receiver))));
        }
        return description.build();
    }

    private static boolean alreadyDefinesIdentifier(Tree tree) {
        final boolean[] result = new boolean[]{false};
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree node, Void unused) {
                if (node.getName().contentEquals("i")) {
                    result[0] = true;
                }
                return (Void)super.visitIdentifier(node, null);
            }
        }.scan(tree, null);
        return result[0];
    }
}

