/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneTokens;
import com.google.errorprone.util.SourceVersion;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Context;
import java.util.stream.Collectors;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="This test data will be more readable if correctly formatted.")
public final class MisformattedTestData
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> ADD_SOURCE_CALL = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onExactClass("com.google.errorprone.CompilationTestHelper").named("addSourceLines"), MethodMatchers.instanceMethod().onExactClass("com.google.errorprone.BugCheckerRefactoringTestHelper").named("addInputLines"), MethodMatchers.instanceMethod().onExactClass("com.google.errorprone.BugCheckerRefactoringTestHelper").named("addOutputLines")});
    private static final Splitter LINE_SPLITTER = Splitter.on((char)'\n');
    private static final Escaper ESCAPER = Escapers.builder().addEscape('\\', "\\\\").build();

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        String formattedSource;
        if (!SourceVersion.supportsTextBlocks((Context)state.context)) {
            return Description.NO_MATCH;
        }
        if (!ADD_SOURCE_CALL.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (tree.getArguments().size() != 2) {
            return Description.NO_MATCH;
        }
        ExpressionTree sourceTree = tree.getArguments().get(1);
        if (!(sourceTree instanceof LiteralTree)) {
            return Description.NO_MATCH;
        }
        Object sourceValue = ((LiteralTree)sourceTree).getValue();
        if (!(sourceValue instanceof String)) {
            return Description.NO_MATCH;
        }
        Formatter formatter = new Formatter();
        try {
            formattedSource = formatter.formatSource((String)sourceValue);
        }
        catch (FormatterException exception) {
            return Description.NO_MATCH;
        }
        if (formattedSource.trim().equals(((String)sourceValue).trim())) {
            return Description.NO_MATCH;
        }
        int startPos = state.getEndPosition((Tree)tree.getArguments().get(0));
        int endPos = ASTHelpers.getStartPosition((Tree)tree.getArguments().get(1));
        ImmutableList tokens = ErrorProneTokens.getTokens((String)state.getSourceCode().subSequence(startPos, endPos).toString(), (int)startPos, (Context)state.context);
        int afterCommaPos = tokens.reverse().stream().filter(t -> t.kind().equals(Tokens.TokenKind.COMMA)).findFirst().orElseThrow().endPos();
        String spaces = state.getSourceCode().subSequence(afterCommaPos, endPos).toString().replace("\n", "");
        return this.describeMatch(sourceTree, (Fix)SuggestedFix.replace((Tree)sourceTree, (String)("\"\"\"\n" + LINE_SPLITTER.splitToStream((CharSequence)MisformattedTestData.escape(formattedSource)).map(line -> line.isEmpty() ? "" : spaces + line).collect(Collectors.joining("\n")) + spaces + "\"\"\"")));
    }

    private static String escape(String line) {
        return ESCAPER.escape(line).replace("\"\"\"", "\\\"\"\"");
    }
}

