/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Switches on enum types should either handle all values, or have a default case.", severity=BugPattern.SeverityLevel.WARNING)
public class MissingCasesInEnumSwitch
extends BugChecker
implements BugChecker.SwitchTreeMatcher {
    public static final int MAX_CASES_TO_PRINT = 5;

    public Description matchSwitch(SwitchTree tree, VisitorState state) {
        ExpressionTree expression = tree.getExpression();
        List<? extends CaseTree> cases = tree.getCases();
        Type switchType = ASTHelpers.getType((Tree)expression);
        if (switchType.asElement().getKind() != ElementKind.ENUM) {
            return Description.NO_MATCH;
        }
        if (cases.stream().anyMatch(c -> ASTHelpers.isSwitchDefault((CaseTree)c))) {
            return Description.NO_MATCH;
        }
        ImmutableSet handled = (ImmutableSet)cases.stream().flatMap(c -> c.getExpressions().stream()).map(e -> ASTHelpers.getSymbol((Tree)e).getSimpleName().toString()).collect(ImmutableSet.toImmutableSet());
        Sets.SetView unhandled = Sets.difference((Set)ASTHelpers.enumValues((Symbol.TypeSymbol)switchType.asElement()), (Set)handled);
        if (unhandled.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(expression).setMessage(MissingCasesInEnumSwitch.buildMessage((Set<String>)unhandled)).build();
    }

    private static String buildMessage(Set<String> unhandled) {
        StringBuilder message = new StringBuilder("Non-exhaustive switch; either add a default or handle the remaining cases: ");
        int numberToShow = unhandled.size() > 5 ? 3 : unhandled.size();
        message.append(unhandled.stream().limit(numberToShow).collect(Collectors.joining(", ")));
        if (numberToShow < unhandled.size()) {
            message.append(String.format(", and %d others", unhandled.size() - numberToShow));
        }
        return message.toString();
    }
}

