/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.RestrictedApi;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.model.AnnotationProxyMaker;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import javax.lang.model.type.TypeMirror;
import org.jspecify.annotations.Nullable;

@BugPattern(name="RestrictedApi", summary="Check for non-allowlisted callers to RestrictedApiChecker.", severity=BugPattern.SeverityLevel.ERROR)
public class RestrictedApiChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher,
BugChecker.AnnotationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private static final ImmutableSet<String> ALLOWLIST_ANNOTATION_NAMES = ImmutableSet.of((Object)"allowlistAnnotations", (Object)"allowlistWithWarningAnnotations");

    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        if (!ASTHelpers.getSymbol((Tree)tree).getQualifiedName().contentEquals(RestrictedApi.class.getName())) {
            return Description.NO_MATCH;
        }
        Attribute.Compound restrictedApi = (Attribute.Compound)ASTHelpers.getAnnotationMirror((AnnotationTree)tree);
        if (restrictedApi == null) {
            return Description.NO_MATCH;
        }
        return Description.NO_MATCH;
    }

    private static Tree getAnnotationArgumentTree(AnnotationTree tree, String name) {
        return tree.getArguments().stream().filter(arg -> arg.getKind().equals((Object)Tree.Kind.ASSIGNMENT)).map(arg -> (AssignmentTree)arg).filter(arg -> RestrictedApiChecker.isVariableTreeWithName(arg, name)).map(AssignmentTree::getExpression).findFirst().orElse(tree);
    }

    private static boolean isVariableTreeWithName(AssignmentTree tree, String name) {
        ExpressionTree variable = tree.getVariable();
        return variable instanceof IdentifierTree && ((IdentifierTree)variable).getName().contentEquals(name);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.checkMethodUse(ASTHelpers.getSymbol((MethodInvocationTree)tree), tree, state);
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        return this.checkMethodUse(ASTHelpers.getSymbol((MemberReferenceTree)tree), tree, state);
    }

    private static Type dropImplicitEnclosingInstanceParameter(NewClassTree tree, VisitorState state, Symbol.MethodSymbol anonymousClassConstructor) {
        TypeMirror type = anonymousClassConstructor.asType();
        if (!RestrictedApiChecker.hasEnclosingExpression(tree)) {
            return type;
        }
        List params = ((Type)type).getParameterTypes();
        params = (List)MoreObjects.firstNonNull(params.tail, List.nil());
        return state.getTypes().createMethodTypeWithParameters((Type)type, params);
    }

    private static boolean hasEnclosingExpression(NewClassTree tree) {
        if (tree.getEnclosingExpression() != null) {
            return true;
        }
        java.util.List<? extends ExpressionTree> arguments = tree.getArguments();
        return !arguments.isEmpty() && ((JCTree)((Object)arguments.get(0))).hasTag(JCTree.Tag.NULLCHK);
    }

    private static Symbol.MethodSymbol superclassConstructorSymbol(NewClassTree tree, VisitorState state) {
        Symbol.MethodSymbol constructor = ASTHelpers.getSymbol((NewClassTree)tree);
        Types types = state.getTypes();
        Symbol.TypeSymbol superclass = types.supertype((Type)constructor.enclClass().asType()).asElement();
        TypeMirror anonymousClassType = constructor.enclClass().asType();
        Type matchingConstructorType = RestrictedApiChecker.dropImplicitEnclosingInstanceParameter(tree, state, constructor);
        return (Symbol.MethodSymbol)Iterables.getOnlyElement((Iterable)ASTHelpers.scope((Scope)superclass.members()).getSymbols(arg_0 -> RestrictedApiChecker.lambda$superclassConstructorSymbol$0(types, (Type)anonymousClassType, matchingConstructorType, arg_0)));
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (tree.getClassBody() != null) {
            return this.checkMethodUse(RestrictedApiChecker.superclassConstructorSymbol(tree, state), tree, state);
        }
        return this.checkRestriction(RestrictedApiChecker.getRestrictedApiAnnotation(ASTHelpers.getSymbol((NewClassTree)tree), state), tree, state);
    }

    private Description checkMethodUse(Symbol.MethodSymbol method, ExpressionTree where, VisitorState state) {
        Attribute.Compound annotation = RestrictedApiChecker.getRestrictedApiAnnotation(method, state);
        if (annotation != null) {
            return this.checkRestriction(annotation, where, state);
        }
        return ASTHelpers.streamSuperMethods((Symbol.MethodSymbol)method, (Types)state.getTypes()).filter(t -> ASTHelpers.hasAnnotation((Symbol)t, RestrictedApi.class, (VisitorState)state)).findFirst().map(superWithRestrictedApi -> this.checkRestriction(RestrictedApiChecker.getRestrictedApiAnnotation(superWithRestrictedApi, state), where, state)).orElse(Description.NO_MATCH);
    }

    private static  @Nullable Attribute.Compound getRestrictedApiAnnotation(Symbol sym, VisitorState state) {
        if (sym == null) {
            return null;
        }
        return sym.attribute(state.getSymbolFromString(RestrictedApi.class.getName()));
    }

    private Description checkRestriction( @Nullable Attribute.Compound attribute, Tree where, VisitorState state) {
        if (attribute == null) {
            return Description.NO_MATCH;
        }
        RestrictedApi restriction = AnnotationProxyMaker.generateAnnotation(attribute, RestrictedApi.class);
        if (restriction == null) {
            return Description.NO_MATCH;
        }
        if (!restriction.allowedOnPath().isEmpty()) {
            JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)state.getPath().getCompilationUnit();
            String path = compilationUnit.getSourceFile().toUri().toString();
            try {
                if (Pattern.matches(restriction.allowedOnPath(), path)) {
                    return Description.NO_MATCH;
                }
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException(String.format("Invalid regex for RestrictedApi annotation of %s", state.getSourceForNode(where)), e);
            }
        }
        boolean warn = Matchers.enclosingNode(RestrictedApiChecker.shouldAllowWithWarning(attribute)).matches(where, state);
        boolean allow = Matchers.enclosingNode(RestrictedApiChecker.shouldAllow(attribute)).matches(where, state);
        if (warn && allow) {
            Description.Builder descriptionBuilder = this.buildDescription(where).setMessage("The Restricted API (" + restriction.explanation() + ") call here is both allowlisted-as-warning and silently allowlisted. Please remove one of the conflicting suppression annotations.");
            if (!restriction.link().isEmpty()) {
                descriptionBuilder.setLinkUrl(restriction.link());
            }
            return descriptionBuilder.build();
        }
        if (allow) {
            return Description.NO_MATCH;
        }
        BugPattern.SeverityLevel level = warn ? BugPattern.SeverityLevel.WARNING : BugPattern.SeverityLevel.ERROR;
        Description.Builder description = this.buildDescription(where).setMessage(restriction.explanation()).overrideSeverity(level);
        return description.build();
    }

    private static Matcher<Tree> shouldAllow(Attribute.Compound api) {
        Optional allowlistAnnotations = MoreAnnotations.getValue((Attribute.Compound)api, (String)"allowlistAnnotations");
        if (!allowlistAnnotations.isPresent()) {
            allowlistAnnotations = MoreAnnotations.getValue((Attribute.Compound)api, (String)"whitelistAnnotations");
        }
        return Matchers.hasAnyAnnotation((java.util.List)((java.util.List)allowlistAnnotations.map(MoreAnnotations::asTypes).orElse(Stream.empty()).collect(ImmutableList.toImmutableList())));
    }

    private static Matcher<Tree> shouldAllowWithWarning(Attribute.Compound api) {
        Optional allowlistWithWarningAnnotations = MoreAnnotations.getValue((Attribute.Compound)api, (String)"allowlistWithWarningAnnotations");
        if (!allowlistWithWarningAnnotations.isPresent()) {
            allowlistWithWarningAnnotations = MoreAnnotations.getValue((Attribute.Compound)api, (String)"whitelistWithWarningAnnotations");
        }
        return Matchers.hasAnyAnnotation((java.util.List)((java.util.List)allowlistWithWarningAnnotations.map(MoreAnnotations::asTypes).orElse(Stream.empty()).collect(ImmutableList.toImmutableList())));
    }

    private static /* synthetic */ boolean lambda$superclassConstructorSymbol$0(Types types, Type anonymousClassType, Type matchingConstructorType, Symbol member) {
        return member.isConstructor() && types.hasSameArgs(member.asMemberOf(anonymousClassType, types).asType(), matchingConstructorType);
    }
}

