/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_StatementSwitchToExpressionSwitch_AnalysisResult;
import com.google.errorprone.bugpatterns.AutoValue_StatementSwitchToExpressionSwitch_AssignmentSwitchAnalysisResult;
import com.google.errorprone.bugpatterns.AutoValue_StatementSwitchToExpressionSwitch_AssignmentSwitchAnalysisState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneComment;
import com.google.errorprone.util.Reachability;
import com.google.errorprone.util.SourceVersion;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.util.Context;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="This statement switch can be converted to an equivalent expression switch")
public final class StatementSwitchToExpressionSwitch
extends BugChecker
implements BugChecker.SwitchTreeMatcher {
    private static final ImmutableSet<Tree.Kind> KINDS_CONVERTIBLE_WITHOUT_BRACES = ImmutableSet.of((Object)((Object)Tree.Kind.THROW), (Object)((Object)Tree.Kind.EXPRESSION_STATEMENT));
    private static final ImmutableSet<Tree.Kind> KINDS_RETURN_OR_THROW = ImmutableSet.of((Object)((Object)Tree.Kind.THROW), (Object)((Object)Tree.Kind.RETURN));
    private static final Pattern FALL_THROUGH_PATTERN = Pattern.compile("\\bfalls?.?(through|out)\\b", 2);
    private static final AssignmentSwitchAnalysisResult DEFAULT_ASSIGNMENT_SWITCH_ANALYSIS_RESULT = AssignmentSwitchAnalysisResult.of(false, Optional.empty(), Optional.empty(), Optional.empty());
    private static final AnalysisResult DEFAULT_ANALYSIS_RESULT = AnalysisResult.of(false, false, DEFAULT_ASSIGNMENT_SWITCH_ANALYSIS_RESULT, (ImmutableList<Boolean>)ImmutableList.of());
    private static final String EQUALS_STRING = "=";
    private final boolean enableDirectConversion;
    private final boolean enableReturnSwitchConversion;
    private final boolean enableAssignmentSwitchConversion;

    @Inject
    StatementSwitchToExpressionSwitch(ErrorProneFlags flags) {
        this.enableDirectConversion = flags.getBoolean("StatementSwitchToExpressionSwitch:EnableDirectConversion").orElse(false);
        this.enableReturnSwitchConversion = flags.getBoolean("StatementSwitchToExpressionSwitch:EnableReturnSwitchConversion").orElse(false);
        this.enableAssignmentSwitchConversion = flags.getBoolean("StatementSwitchToExpressionSwitch:EnableAssignmentSwitchConversion").orElse(false);
    }

    public Description matchSwitch(SwitchTree switchTree, VisitorState state) {
        if (!SourceVersion.supportsSwitchExpressions((Context)state.context)) {
            return Description.NO_MATCH;
        }
        AnalysisResult analysisResult = StatementSwitchToExpressionSwitch.analyzeSwitchTree(switchTree, state);
        ArrayList<SuggestedFix> suggestedFixes = new ArrayList<SuggestedFix>();
        if (this.enableReturnSwitchConversion && analysisResult.canConvertToReturnSwitch()) {
            suggestedFixes.add(StatementSwitchToExpressionSwitch.convertToReturnSwitch(switchTree, state, analysisResult));
        }
        if (this.enableAssignmentSwitchConversion && analysisResult.assignmentSwitchAnalysisResult().canConvertToAssignmentSwitch()) {
            suggestedFixes.add(StatementSwitchToExpressionSwitch.convertToAssignmentSwitch(switchTree, state, analysisResult));
        }
        if (this.enableDirectConversion && analysisResult.canConvertDirectlyToExpressionSwitch()) {
            suggestedFixes.add(StatementSwitchToExpressionSwitch.convertDirectlyToExpressionSwitch(switchTree, state, analysisResult));
        }
        return suggestedFixes.isEmpty() ? Description.NO_MATCH : this.buildDescription(switchTree).addAllFixes(suggestedFixes).build();
    }

    private static AnalysisResult analyzeSwitchTree(SwitchTree switchTree, VisitorState state) {
        if (ASTHelpers.findEnclosingNode((TreePath)state.getPath(), SwitchTree.class) != null) {
            return DEFAULT_ANALYSIS_RESULT;
        }
        List<? extends CaseTree> cases = switchTree.getCases();
        boolean allCasesHaveDefiniteControlFlow = true;
        ArrayList<Boolean> groupedWithNextCase = new ArrayList<Boolean>(Collections.nCopies(cases.size(), false));
        HashSet<String> handledEnumValues = new HashSet<String>();
        CaseQualifications returnSwitchCaseQualifications = CaseQualifications.NO_CASES_ASSESSED;
        AssignmentSwitchAnalysisState assignmentSwitchAnalysisState = AssignmentSwitchAnalysisState.of(CaseQualifications.NO_CASES_ASSESSED, Optional.empty(), Optional.empty(), Optional.empty());
        boolean hasDefaultCase = false;
        for (int caseIndex = 0; caseIndex < cases.size(); ++caseIndex) {
            CaseTree caseTree = cases.get(caseIndex);
            boolean isDefaultCase = caseTree.getExpressions().isEmpty();
            hasDefaultCase |= isDefaultCase;
            handledEnumValues.addAll((Collection)caseTree.getExpressions().stream().filter(IdentifierTree.class::isInstance).map(expressionTree -> ((IdentifierTree)expressionTree).getName().toString()).collect(ImmutableSet.toImmutableSet()));
            boolean isLastCaseInSwitch = caseIndex == cases.size() - 1;
            List<? extends StatementTree> statements = StatementSwitchToExpressionSwitch.getStatements(caseTree);
            CaseFallThru caseFallThru = CaseFallThru.MAYBE_FALLS_THRU;
            if (statements == null) {
                return DEFAULT_ANALYSIS_RESULT;
            }
            if (statements.isEmpty()) {
                caseFallThru = CaseFallThru.DEFINITELY_DOES_FALL_THRU;
                groupedWithNextCase.set(caseIndex, !isLastCaseInSwitch);
            } else {
                groupedWithNextCase.set(caseIndex, false);
                if (StatementSwitchToExpressionSwitch.areStatementsConvertibleToExpressionSwitch(statements, isLastCaseInSwitch)) {
                    caseFallThru = CaseFallThru.DEFINITELY_DOES_NOT_FALL_THRU;
                }
            }
            if (isDefaultCase) {
                boolean fallsIntoDefaultCase;
                boolean bl = fallsIntoDefaultCase = caseIndex > 0 && (Boolean)groupedWithNextCase.get(caseIndex - 1) != false;
                allCasesHaveDefiniteControlFlow = isLastCaseInSwitch ? (allCasesHaveDefiniteControlFlow &= !fallsIntoDefaultCase) : (allCasesHaveDefiniteControlFlow &= !fallsIntoDefaultCase && caseFallThru.equals((Object)CaseFallThru.DEFINITELY_DOES_NOT_FALL_THRU));
            } else {
                allCasesHaveDefiniteControlFlow &= !caseFallThru.equals((Object)CaseFallThru.MAYBE_FALLS_THRU);
            }
            returnSwitchCaseQualifications = StatementSwitchToExpressionSwitch.analyzeCaseForReturnSwitch(returnSwitchCaseQualifications, statements, isLastCaseInSwitch);
            assignmentSwitchAnalysisState = StatementSwitchToExpressionSwitch.analyzeCaseForAssignmentSwitch(assignmentSwitchAnalysisState, statements, isLastCaseInSwitch);
        }
        boolean exhaustive = StatementSwitchToExpressionSwitch.isSwitchExhaustive(hasDefaultCase, handledEnumValues, ASTHelpers.getType((Tree)switchTree.getExpression()));
        boolean canConvertToReturnSwitch = allCasesHaveDefiniteControlFlow && returnSwitchCaseQualifications.equals((Object)CaseQualifications.ALL_CASES_QUALIFY) && exhaustive;
        boolean canConvertToAssignmentSwitch = allCasesHaveDefiniteControlFlow && assignmentSwitchAnalysisState.assignmentSwitchCaseQualifications().equals((Object)CaseQualifications.ALL_CASES_QUALIFY) && exhaustive;
        return AnalysisResult.of(allCasesHaveDefiniteControlFlow, canConvertToReturnSwitch, AssignmentSwitchAnalysisResult.of(canConvertToAssignmentSwitch, assignmentSwitchAnalysisState.assignmentTargetOptional(), assignmentSwitchAnalysisState.assignmentExpressionKindOptional(), assignmentSwitchAnalysisState.assignmentTreeOptional().map(StatementSwitchToExpressionSwitch::renderJavaSourceOfAssignment)), (ImmutableList<Boolean>)ImmutableList.copyOf(groupedWithNextCase));
    }

    private static String renderJavaSourceOfAssignment(ExpressionTree tree) {
        if (tree instanceof JCTree.JCAssign) {
            return EQUALS_STRING;
        }
        JCTree.JCAssignOp jcAssignOp = (JCTree.JCAssignOp)tree;
        Pretty pretty = new Pretty(new StringWriter(), true);
        return pretty.operatorName(jcAssignOp.getTag().noAssignOp()) + EQUALS_STRING;
    }

    private static CaseQualifications analyzeCaseForReturnSwitch(CaseQualifications previousCaseQualifications, List<? extends StatementTree> statements, boolean isLastCaseInSwitch) {
        if (statements.isEmpty() && !isLastCaseInSwitch) {
            return previousCaseQualifications;
        }
        if (statements.isEmpty()) {
            return CaseQualifications.SOME_OR_ALL_CASES_DONT_QUALIFY;
        }
        StatementTree lastStatement = (StatementTree)Iterables.getLast(statements);
        if (!statements.subList(0, statements.size() - 1).stream().allMatch(statement -> statement.getKind().equals((Object)Tree.Kind.EXPRESSION_STATEMENT)) || !KINDS_RETURN_OR_THROW.contains((Object)lastStatement.getKind())) {
            return CaseQualifications.SOME_OR_ALL_CASES_DONT_QUALIFY;
        }
        if (!lastStatement.getKind().equals((Object)Tree.Kind.RETURN)) {
            return previousCaseQualifications;
        }
        if (!previousCaseQualifications.equals((Object)CaseQualifications.NO_CASES_ASSESSED)) {
            return previousCaseQualifications;
        }
        Type returnType = ASTHelpers.getType((Tree)((ReturnTree)lastStatement).getExpression());
        return returnType == null ? CaseQualifications.SOME_OR_ALL_CASES_DONT_QUALIFY : CaseQualifications.ALL_CASES_QUALIFY;
    }

    private static AssignmentSwitchAnalysisState analyzeCaseForAssignmentSwitch(AssignmentSwitchAnalysisState previousAssignmentSwitchAnalysisState, List<? extends StatementTree> statements, boolean isLastCaseInSwitch) {
        boolean compatibleReference;
        boolean expressionOrExpressionBreak;
        CaseQualifications caseQualifications = previousAssignmentSwitchAnalysisState.assignmentSwitchCaseQualifications();
        Optional<Tree.Kind> assignmentExpressionKindOptional = previousAssignmentSwitchAnalysisState.assignmentExpressionKindOptional();
        Optional<ExpressionTree> assignmentTargetOptional = previousAssignmentSwitchAnalysisState.assignmentTargetOptional();
        Optional<ExpressionTree> assignmentTreeOptional = previousAssignmentSwitchAnalysisState.assignmentTreeOptional();
        if (statements.isEmpty()) {
            return isLastCaseInSwitch ? AssignmentSwitchAnalysisState.of(CaseQualifications.SOME_OR_ALL_CASES_DONT_QUALIFY, assignmentTargetOptional, assignmentExpressionKindOptional, assignmentTreeOptional) : previousAssignmentSwitchAnalysisState;
        }
        StatementTree firstStatement = statements.get(0);
        Tree.Kind firstStatementKind = firstStatement.getKind();
        boolean bl = expressionOrExpressionBreak = statements.size() == 1 && KINDS_CONVERTIBLE_WITHOUT_BRACES.contains((Object)firstStatementKind) || KINDS_CONVERTIBLE_WITHOUT_BRACES.contains((Object)firstStatementKind) && statements.get(1).getKind().equals((Object)Tree.Kind.BREAK) && ((BreakTree)statements.get(1)).getLabel() == null;
        if (!expressionOrExpressionBreak) {
            return AssignmentSwitchAnalysisState.of(CaseQualifications.SOME_OR_ALL_CASES_DONT_QUALIFY, assignmentTargetOptional, assignmentExpressionKindOptional, assignmentTreeOptional);
        }
        if (!firstStatement.getKind().equals((Object)Tree.Kind.EXPRESSION_STATEMENT)) {
            return previousAssignmentSwitchAnalysisState;
        }
        ExpressionTree expression = ((ExpressionStatementTree)firstStatement).getExpression();
        Optional<Object> caseAssignmentTargetOptional = Optional.empty();
        Optional<Object> caseAssignmentKindOptional = Optional.empty();
        Optional<Object> caseAssignmentTreeOptional = Optional.empty();
        if (expression instanceof CompoundAssignmentTree) {
            CompoundAssignmentTree compoundAssignmentTree = (CompoundAssignmentTree)expression;
            caseAssignmentTargetOptional = Optional.of(compoundAssignmentTree.getVariable());
            caseAssignmentKindOptional = Optional.of(compoundAssignmentTree.getKind());
            caseAssignmentTreeOptional = Optional.of(expression);
        } else if (expression instanceof AssignmentTree) {
            caseAssignmentTargetOptional = Optional.of(((AssignmentTree)expression).getVariable());
            caseAssignmentKindOptional = Optional.of(Tree.Kind.ASSIGNMENT);
            caseAssignmentTreeOptional = Optional.of(expression);
        }
        boolean compatibleOperator = assignmentExpressionKindOptional.isEmpty() && caseAssignmentKindOptional.isPresent() || assignmentExpressionKindOptional.isPresent() && caseAssignmentKindOptional.isPresent() && assignmentExpressionKindOptional.get().equals(caseAssignmentKindOptional.get());
        boolean bl2 = compatibleReference = assignmentTargetOptional.isEmpty() && caseAssignmentTargetOptional.isPresent() || StatementSwitchToExpressionSwitch.isCompatibleWithFirstAssignment(assignmentTargetOptional, caseAssignmentTargetOptional);
        caseQualifications = compatibleOperator && compatibleReference ? (caseQualifications.equals((Object)CaseQualifications.NO_CASES_ASSESSED) ? CaseQualifications.ALL_CASES_QUALIFY : caseQualifications) : CaseQualifications.SOME_OR_ALL_CASES_DONT_QUALIFY;
        return AssignmentSwitchAnalysisState.of(caseQualifications, assignmentTargetOptional.isEmpty() ? caseAssignmentTargetOptional : assignmentTargetOptional, assignmentExpressionKindOptional.isEmpty() ? caseAssignmentKindOptional : assignmentExpressionKindOptional, assignmentTreeOptional.isEmpty() ? caseAssignmentTreeOptional : assignmentTreeOptional);
    }

    private static boolean isCompatibleWithFirstAssignment(Optional<ExpressionTree> assignmentTargetOptional, Optional<ExpressionTree> caseAssignmentTargetOptional) {
        if (assignmentTargetOptional.isEmpty() || caseAssignmentTargetOptional.isEmpty()) {
            return false;
        }
        Symbol assignmentTargetSymbol = ASTHelpers.getSymbol((Tree)assignmentTargetOptional.get());
        if (assignmentTargetSymbol == null) {
            return false;
        }
        Symbol caseAssignmentTargetSymbol = ASTHelpers.getSymbol((Tree)caseAssignmentTargetOptional.get());
        return Objects.equals(assignmentTargetSymbol, caseAssignmentTargetSymbol);
    }

    private static boolean areStatementsConvertibleToExpressionSwitch(List<? extends StatementTree> statements, boolean isLastCaseInSwitch) {
        if (isLastCaseInSwitch) {
            return true;
        }
        if (statements.isEmpty()) {
            return true;
        }
        return !Reachability.canCompleteNormally((StatementTree)((StatementTree)Iterables.getLast(statements)));
    }

    private static SuggestedFix convertDirectlyToExpressionSwitch(SwitchTree switchTree, VisitorState state, AnalysisResult analysisResult) {
        List<? extends CaseTree> cases = switchTree.getCases();
        ImmutableList allSwitchComments = (ImmutableList)state.getTokensForNode((Tree)switchTree).stream().flatMap(errorProneToken -> errorProneToken.comments().stream()).collect(ImmutableList.toImmutableList());
        StringBuilder replacementCodeBuilder = new StringBuilder();
        replacementCodeBuilder.append("switch ").append(state.getSourceForNode((Tree)switchTree.getExpression())).append(" {");
        StringBuilder groupedCaseCommentsAccumulator = null;
        boolean firstCaseInGroup = true;
        for (int caseIndex = 0; caseIndex < cases.size(); ++caseIndex) {
            CaseTree caseTree = cases.get(caseIndex);
            boolean isDefaultCase = ASTHelpers.isSwitchDefault((CaseTree)caseTree);
            ImmutableList<StatementTree> filteredStatements = StatementSwitchToExpressionSwitch.filterOutRedundantBreak(caseTree);
            String transformedBlockSource = StatementSwitchToExpressionSwitch.transformBlock(caseTree, state, filteredStatements);
            if (firstCaseInGroup) {
                groupedCaseCommentsAccumulator = new StringBuilder(caseIndex == 0 ? StatementSwitchToExpressionSwitch.extractCommentsBeforeFirstCase(switchTree, (ImmutableList<ErrorProneComment>)allSwitchComments).orElse("") : "");
                replacementCodeBuilder.append("\n  ");
                if (!isDefaultCase) {
                    replacementCodeBuilder.append("case ");
                }
            }
            replacementCodeBuilder.append(isDefaultCase ? "default" : StatementSwitchToExpressionSwitch.printCaseExpressions(caseTree, state));
            Optional<String> commentsAfterCaseOptional = StatementSwitchToExpressionSwitch.extractCommentsAfterCase(switchTree, (ImmutableList<ErrorProneComment>)allSwitchComments, state, caseIndex);
            if (((Boolean)analysisResult.groupedWithNextCase().get(caseIndex)).booleanValue()) {
                firstCaseInGroup = false;
                replacementCodeBuilder.append(", ");
                if (!transformedBlockSource.trim().isEmpty()) {
                    String commentsToAppend = StatementSwitchToExpressionSwitch.removeFallThruLines(transformedBlockSource);
                    if (groupedCaseCommentsAccumulator.length() > 0) {
                        groupedCaseCommentsAccumulator.append("\n");
                    }
                    groupedCaseCommentsAccumulator.append(commentsToAppend);
                }
                if (!commentsAfterCaseOptional.isPresent()) continue;
                if (groupedCaseCommentsAccumulator.length() > 0) {
                    groupedCaseCommentsAccumulator.append("\n");
                }
                groupedCaseCommentsAccumulator.append(commentsAfterCaseOptional.get());
                continue;
            }
            Optional<String> commentsBeforeRemovedBreak = StatementSwitchToExpressionSwitch.extractCommentsBeforeRemovedBreak(caseTree, state, filteredStatements);
            transformedBlockSource = Joiner.on((String)"\n").skipNulls().join((Object)(groupedCaseCommentsAccumulator.length() == 0 ? null : groupedCaseCommentsAccumulator.toString()), (Object)(transformedBlockSource.isEmpty() ? null : transformedBlockSource.trim()), new Object[]{commentsBeforeRemovedBreak.orElse(null), commentsAfterCaseOptional.orElse(null)});
            replacementCodeBuilder.append(" -> ");
            if (filteredStatements.isEmpty()) {
                String trimmedTransformedBlockSource = transformedBlockSource.trim();
                if (trimmedTransformedBlockSource.isEmpty() || trimmedTransformedBlockSource.equals("break;")) {
                    replacementCodeBuilder.append("{}");
                } else {
                    replacementCodeBuilder.append("{\n").append(transformedBlockSource).append("\n}");
                }
            } else if (StatementSwitchToExpressionSwitch.shouldTransformCaseWithoutBraces(filteredStatements)) {
                replacementCodeBuilder.append("\n").append(transformedBlockSource);
            } else {
                replacementCodeBuilder.append("{\n").append(transformedBlockSource).append("\n}");
            }
            firstCaseInGroup = true;
        }
        replacementCodeBuilder.append("\n}");
        return SuggestedFix.builder().replace((Tree)switchTree, replacementCodeBuilder.toString()).build();
    }

    private static SuggestedFix convertToReturnSwitch(SwitchTree switchTree, VisitorState state, AnalysisResult analysisResult) {
        ArrayList<StatementTree> statementsToDelete = new ArrayList<StatementTree>();
        List<? extends CaseTree> cases = switchTree.getCases();
        ImmutableList allSwitchComments = (ImmutableList)state.getTokensForNode((Tree)switchTree).stream().flatMap(errorProneToken -> errorProneToken.comments().stream()).collect(ImmutableList.toImmutableList());
        StringBuilder replacementCodeBuilder = new StringBuilder();
        replacementCodeBuilder.append("return switch ").append(state.getSourceForNode((Tree)switchTree.getExpression())).append(" {");
        StringBuilder groupedCaseCommentsAccumulator = null;
        boolean firstCaseInGroup = true;
        for (int caseIndex = 0; caseIndex < cases.size(); ++caseIndex) {
            CaseTree caseTree = cases.get(caseIndex);
            boolean isDefaultCase = ASTHelpers.isSwitchDefault((CaseTree)caseTree);
            String transformedBlockSource = StatementSwitchToExpressionSwitch.transformReturnOrThrowBlock(caseTree, state, StatementSwitchToExpressionSwitch.getStatements(caseTree));
            if (firstCaseInGroup) {
                groupedCaseCommentsAccumulator = new StringBuilder(caseIndex == 0 ? StatementSwitchToExpressionSwitch.extractCommentsBeforeFirstCase(switchTree, (ImmutableList<ErrorProneComment>)allSwitchComments).orElse("") : "");
                replacementCodeBuilder.append("\n  ");
                if (!isDefaultCase) {
                    replacementCodeBuilder.append("case ");
                }
            }
            replacementCodeBuilder.append(isDefaultCase ? "default" : StatementSwitchToExpressionSwitch.printCaseExpressions(caseTree, state));
            Optional<String> commentsAfterCaseOptional = StatementSwitchToExpressionSwitch.extractCommentsAfterCase(switchTree, (ImmutableList<ErrorProneComment>)allSwitchComments, state, caseIndex);
            if (((Boolean)analysisResult.groupedWithNextCase().get(caseIndex)).booleanValue()) {
                firstCaseInGroup = false;
                replacementCodeBuilder.append(", ");
                if (!transformedBlockSource.trim().isEmpty()) {
                    String commentsToAppend = StatementSwitchToExpressionSwitch.removeFallThruLines(transformedBlockSource);
                    if (groupedCaseCommentsAccumulator.length() > 0) {
                        groupedCaseCommentsAccumulator.append("\n");
                    }
                    groupedCaseCommentsAccumulator.append(commentsToAppend);
                }
                if (!commentsAfterCaseOptional.isPresent()) continue;
                if (groupedCaseCommentsAccumulator.length() > 0) {
                    groupedCaseCommentsAccumulator.append("\n");
                }
                groupedCaseCommentsAccumulator.append(commentsAfterCaseOptional.get());
                continue;
            }
            transformedBlockSource = Joiner.on((String)"\n").skipNulls().join((Object)(groupedCaseCommentsAccumulator.length() == 0 ? null : groupedCaseCommentsAccumulator.toString()), (Object)(transformedBlockSource.isEmpty() ? null : transformedBlockSource), new Object[]{commentsAfterCaseOptional.orElse(null)});
            replacementCodeBuilder.append(" -> ");
            replacementCodeBuilder.append("\n").append(transformedBlockSource);
            firstCaseInGroup = true;
        }
        replacementCodeBuilder.append("\n};");
        statementsToDelete.addAll(StatementSwitchToExpressionSwitch.followingStatementsInBlock(switchTree, state));
        SuggestedFix.Builder suggestedFixBuilder = SuggestedFix.builder().replace((Tree)switchTree, replacementCodeBuilder.toString());
        statementsToDelete.forEach(deleteMe -> suggestedFixBuilder.replace((Tree)deleteMe, ""));
        return suggestedFixBuilder.build();
    }

    private static List<StatementTree> followingStatementsInBlock(SwitchTree switchTree, VisitorState state) {
        Tree enclosing;
        ArrayList<StatementTree> followingStatements = new ArrayList<StatementTree>();
        if (!Matchers.nextStatement((Matcher)Matchers.anything()).matches((Tree)switchTree, state)) {
            return followingStatements;
        }
        TreePath pathToEnclosing = state.findPathToEnclosing(new Class[]{BlockTree.class});
        if (pathToEnclosing != null && (enclosing = pathToEnclosing.getLeaf()) instanceof BlockTree) {
            BlockTree blockTree = (BlockTree)enclosing;
            TreePath rootToSwitchPath = TreePath.getPath(pathToEnclosing, (Tree)switchTree);
            for (int i = StatementSwitchToExpressionSwitch.findBlockStatementIndex(rootToSwitchPath, blockTree) + 1; i >= 0 && i < blockTree.getStatements().size(); ++i) {
                followingStatements.add(blockTree.getStatements().get(i));
            }
        }
        return followingStatements;
    }

    private static int findBlockStatementIndex(TreePath treePath, BlockTree blockTree) {
        for (int i = 0; i < blockTree.getStatements().size(); ++i) {
            StatementTree thisStatement = blockTree.getStatements().get(i);
            TreePath pathFromRootToThisStatement = TreePath.getPath(treePath, (Tree)thisStatement);
            if (pathFromRootToThisStatement == null) continue;
            return i;
        }
        return -1;
    }

    private static SuggestedFix convertToAssignmentSwitch(SwitchTree switchTree, VisitorState state, AnalysisResult analysisResult) {
        List<? extends CaseTree> cases = switchTree.getCases();
        ImmutableList allSwitchComments = (ImmutableList)state.getTokensForNode((Tree)switchTree).stream().flatMap(errorProneToken -> errorProneToken.comments().stream()).collect(ImmutableList.toImmutableList());
        StringBuilder replacementCodeBuilder = new StringBuilder(state.getSourceForNode((Tree)analysisResult.assignmentSwitchAnalysisResult().assignmentTargetOptional().get())).append(" ").append(analysisResult.assignmentSwitchAnalysisResult().assignmentSourceCodeOptional().get()).append(" ").append("switch ").append(state.getSourceForNode((Tree)switchTree.getExpression())).append(" {");
        StringBuilder groupedCaseCommentsAccumulator = null;
        boolean firstCaseInGroup = true;
        for (int caseIndex = 0; caseIndex < cases.size(); ++caseIndex) {
            CaseTree caseTree = cases.get(caseIndex);
            boolean isDefaultCase = ASTHelpers.isSwitchDefault((CaseTree)caseTree);
            ImmutableList<StatementTree> filteredStatements = StatementSwitchToExpressionSwitch.filterOutRedundantBreak(caseTree);
            String transformedBlockSource = StatementSwitchToExpressionSwitch.transformAssignOrThrowBlock(caseTree, state, filteredStatements);
            if (firstCaseInGroup) {
                groupedCaseCommentsAccumulator = new StringBuilder(caseIndex == 0 ? StatementSwitchToExpressionSwitch.extractCommentsBeforeFirstCase(switchTree, (ImmutableList<ErrorProneComment>)allSwitchComments).orElse("") : "");
                replacementCodeBuilder.append("\n  ");
                if (!isDefaultCase) {
                    replacementCodeBuilder.append("case ");
                }
            }
            replacementCodeBuilder.append(isDefaultCase ? "default" : StatementSwitchToExpressionSwitch.printCaseExpressions(caseTree, state));
            Optional<String> commentsAfterCaseOptional = StatementSwitchToExpressionSwitch.extractCommentsAfterCase(switchTree, (ImmutableList<ErrorProneComment>)allSwitchComments, state, caseIndex);
            if (((Boolean)analysisResult.groupedWithNextCase().get(caseIndex)).booleanValue()) {
                firstCaseInGroup = false;
                replacementCodeBuilder.append(", ");
                if (!transformedBlockSource.trim().isEmpty()) {
                    String commentsToAppend = StatementSwitchToExpressionSwitch.removeFallThruLines(transformedBlockSource);
                    if (groupedCaseCommentsAccumulator.length() > 0) {
                        groupedCaseCommentsAccumulator.append("\n");
                    }
                    groupedCaseCommentsAccumulator.append(commentsToAppend);
                }
                if (!commentsAfterCaseOptional.isPresent()) continue;
                if (groupedCaseCommentsAccumulator.length() > 0) {
                    groupedCaseCommentsAccumulator.append("\n");
                }
                groupedCaseCommentsAccumulator.append(commentsAfterCaseOptional.get());
                continue;
            }
            Optional<String> commentsBeforeRemovedBreak = StatementSwitchToExpressionSwitch.extractCommentsBeforeRemovedBreak(caseTree, state, filteredStatements);
            transformedBlockSource = Joiner.on((String)"\n").skipNulls().join((Object)(groupedCaseCommentsAccumulator.length() == 0 ? null : groupedCaseCommentsAccumulator.toString()), (Object)(transformedBlockSource.isEmpty() ? null : transformedBlockSource), new Object[]{commentsBeforeRemovedBreak.orElse(null), commentsAfterCaseOptional.orElse(null)});
            replacementCodeBuilder.append(" -> ");
            replacementCodeBuilder.append("\n").append(transformedBlockSource);
            firstCaseInGroup = true;
        }
        replacementCodeBuilder.append("\n};");
        return SuggestedFix.builder().replace((Tree)switchTree, replacementCodeBuilder.toString()).build();
    }

    private static Optional<String> extractCommentsBeforeRemovedBreak(CaseTree caseTree, VisitorState state, ImmutableList<StatementTree> filteredStatements) {
        String commentsAfterNewLastStatement;
        if (!filteredStatements.isEmpty() && StatementSwitchToExpressionSwitch.getStatements(caseTree).size() > filteredStatements.size() && !(commentsAfterNewLastStatement = state.getSourceCode().subSequence(state.getEndPosition((Tree)Iterables.getLast(filteredStatements)), ASTHelpers.getStartPosition((Tree)StatementSwitchToExpressionSwitch.getStatements(caseTree).get(StatementSwitchToExpressionSwitch.getStatements(caseTree).size() - 1))).toString().trim()).isEmpty()) {
            return Optional.of(commentsAfterNewLastStatement);
        }
        return Optional.empty();
    }

    private static ImmutableList<StatementTree> filterOutRedundantBreak(CaseTree caseTree) {
        boolean caseEndsWithUnlabelledBreak = Streams.findLast(StatementSwitchToExpressionSwitch.getStatements(caseTree).stream()).filter(statement -> statement.getKind().equals((Object)Tree.Kind.BREAK)).filter(breakTree -> ((BreakTree)breakTree).getLabel() == null).isPresent();
        return caseEndsWithUnlabelledBreak ? (ImmutableList)StatementSwitchToExpressionSwitch.getStatements(caseTree).stream().limit(StatementSwitchToExpressionSwitch.getStatements(caseTree).size() - 1).collect(ImmutableList.toImmutableList()) : ImmutableList.copyOf(StatementSwitchToExpressionSwitch.getStatements(caseTree));
    }

    private static List<? extends StatementTree> getStatements(CaseTree caseTree) {
        List<? extends StatementTree> statements = caseTree.getStatements();
        if (statements == null || statements.size() != 1) {
            return statements;
        }
        StatementTree onlyStatement = (StatementTree)Iterables.getOnlyElement(statements);
        if (!onlyStatement.getKind().equals((Object)Tree.Kind.BLOCK)) {
            return statements;
        }
        return ((BlockTree)onlyStatement).getStatements();
    }

    private static String transformBlock(CaseTree caseTree, VisitorState state, ImmutableList<StatementTree> filteredStatements) {
        StringBuilder transformedBlockBuilder = new StringBuilder();
        int codeBlockStart = StatementSwitchToExpressionSwitch.extractLhsComments(caseTree, state, transformedBlockBuilder);
        if (!filteredStatements.isEmpty()) {
            int codeBlockEnd = state.getEndPosition((Tree)Iterables.getLast(filteredStatements));
            transformedBlockBuilder.append(state.getSourceCode(), codeBlockStart, codeBlockEnd);
        }
        return transformedBlockBuilder.toString();
    }

    private static int extractLhsComments(CaseTree caseTree, VisitorState state, StringBuilder stringBuilder) {
        int lhsStart = ASTHelpers.getStartPosition((Tree)caseTree);
        int lhsEnd = StatementSwitchToExpressionSwitch.getStatements(caseTree).isEmpty() ? state.getEndPosition((Tree)caseTree) : ASTHelpers.getStartPosition((Tree)StatementSwitchToExpressionSwitch.getStatements(caseTree).get(0));
        state.getOffsetTokens(lhsStart, lhsEnd).stream().flatMap(errorProneToken -> errorProneToken.comments().stream()).forEach(comment -> stringBuilder.append(comment.getText()).append("\n"));
        return lhsEnd;
    }

    private static Optional<String> extractCommentsBeforeFirstCase(SwitchTree switchTree, ImmutableList<ErrorProneComment> allSwitchComments) {
        int switchStart = ASTHelpers.getStartPosition((Tree)switchTree);
        int firstCaseStartIndex = ASTHelpers.getStartPosition((Tree)switchTree.getCases().get(0)) - switchStart;
        return StatementSwitchToExpressionSwitch.filterAndRenderComments(allSwitchComments, comment -> comment.getPos() < firstCaseStartIndex);
    }

    private static Optional<String> extractCommentsAfterCase(SwitchTree switchTree, ImmutableList<ErrorProneComment> allSwitchComments, VisitorState state, int caseIndex) {
        int switchStart = ASTHelpers.getStartPosition((Tree)switchTree);
        int caseEndIndex = state.getEndPosition((Tree)switchTree.getCases().get(caseIndex)) - switchStart;
        int nextCaseStartIndex = caseIndex == switchTree.getCases().size() - 1 ? state.getEndPosition((Tree)switchTree) - switchStart : ASTHelpers.getStartPosition((Tree)switchTree.getCases().get(caseIndex + 1)) - switchStart;
        return StatementSwitchToExpressionSwitch.filterAndRenderComments(allSwitchComments, comment -> comment.getPos() >= caseEndIndex && comment.getPos() < nextCaseStartIndex);
    }

    private static Optional<String> filterAndRenderComments(ImmutableList<ErrorProneComment> comments, Predicate<ErrorProneComment> commentFilter) {
        String rendered = comments.stream().filter(commentFilter).map(ErrorProneComment::getText).map(commentText -> StatementSwitchToExpressionSwitch.removeFallThruLines(commentText)).filter(commentText -> !commentText.isEmpty()).collect(Collectors.joining("\n"));
        return rendered.isEmpty() ? Optional.empty() : Optional.of(rendered);
    }

    private static int getBlockEnd(VisitorState state, CaseTree caseTree) {
        List<? extends StatementTree> statements = caseTree.getStatements();
        if (statements == null || statements.size() != 1) {
            return state.getEndPosition((Tree)caseTree);
        }
        StatementTree onlyStatement = (StatementTree)Iterables.getOnlyElement(statements);
        if (!onlyStatement.getKind().equals((Object)Tree.Kind.BLOCK)) {
            return state.getEndPosition((Tree)caseTree);
        }
        List<? extends StatementTree> blockStatements = ((BlockTree)onlyStatement).getStatements();
        return blockStatements.isEmpty() ? state.getEndPosition((Tree)caseTree) : state.getEndPosition((Tree)blockStatements.get(blockStatements.size() - 1));
    }

    private static boolean shouldTransformCaseWithoutBraces(ImmutableList<StatementTree> statementTrees) {
        if (statementTrees.isEmpty()) {
            return false;
        }
        if (statementTrees.size() > 1) {
            return false;
        }
        StatementTree onlyStatementTree = (StatementTree)statementTrees.get(0);
        return KINDS_CONVERTIBLE_WITHOUT_BRACES.contains((Object)onlyStatementTree.getKind());
    }

    private static String removeFallThruLines(String comments) {
        String string;
        StringBuilder output = new StringBuilder();
        BufferedReader br = new BufferedReader(new CharArrayReader(comments.toCharArray()));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (FALL_THROUGH_PATTERN.matcher(line).find()) continue;
                output.append(line).append("\n");
            }
            string = output.length() > 0 ? output.substring(0, output.length() - 1) : "";
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return comments;
            }
        }
        br.close();
        return string;
    }

    private static String printCaseExpressions(CaseTree caseTree, VisitorState state) {
        return caseTree.getExpressions().stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(Collectors.joining(", "));
    }

    private static boolean isSwitchExhaustive(boolean hasDefaultCase, Set<String> handledEnumValues, Type switchType) {
        if (hasDefaultCase) {
            return true;
        }
        if (switchType.asElement().getKind() != ElementKind.ENUM) {
            return false;
        }
        return handledEnumValues.containsAll(ASTHelpers.enumValues((Symbol.TypeSymbol)switchType.asElement()));
    }

    private static String transformReturnOrThrowBlock(CaseTree caseTree, VisitorState state, List<? extends StatementTree> statements) {
        StringBuilder transformedBlockBuilder = new StringBuilder();
        int codeBlockEnd = state.getEndPosition((Tree)caseTree);
        if (statements.size() > 1) {
            transformedBlockBuilder.append("{\n");
            int codeBlockStart = StatementSwitchToExpressionSwitch.extractLhsComments(caseTree, state, transformedBlockBuilder);
            int offset = transformedBlockBuilder.length();
            transformedBlockBuilder.append(state.getSourceCode(), codeBlockStart, codeBlockEnd);
            transformedBlockBuilder.append("\n}");
            ReturnTree returnTree = (ReturnTree)Iterables.getLast(statements);
            int start = ASTHelpers.getStartPosition((Tree)returnTree);
            transformedBlockBuilder.replace(offset + start - codeBlockStart, offset + start - codeBlockStart + "return".length(), "yield");
        } else if (statements.size() == 1 && statements.get(0).getKind().equals((Object)Tree.Kind.RETURN)) {
            int unused = StatementSwitchToExpressionSwitch.extractLhsComments(caseTree, state, transformedBlockBuilder);
            ReturnTree returnTree = (ReturnTree)statements.get(0);
            int codeBlockStart = ASTHelpers.getStartPosition((Tree)returnTree.getExpression());
            codeBlockEnd = state.getEndPosition((Tree)Streams.findLast(statements.stream()).get());
            transformedBlockBuilder.append(state.getSourceCode(), codeBlockStart, codeBlockEnd);
        } else {
            int codeBlockStart = StatementSwitchToExpressionSwitch.extractLhsComments(caseTree, state, transformedBlockBuilder);
            transformedBlockBuilder.append(state.getSourceCode(), codeBlockStart, codeBlockEnd);
        }
        return transformedBlockBuilder.toString();
    }

    private static String transformAssignOrThrowBlock(CaseTree caseTree, VisitorState state, List<? extends StatementTree> statements) {
        int codeBlockStart;
        int codeBlockEnd;
        StringBuilder transformedBlockBuilder = new StringBuilder();
        int n = codeBlockEnd = statements.isEmpty() ? StatementSwitchToExpressionSwitch.getBlockEnd(state, caseTree) : state.getEndPosition((Tree)Streams.findLast(statements.stream()).get());
        if (!statements.isEmpty() && statements.get(0).getKind().equals((Object)Tree.Kind.EXPRESSION_STATEMENT)) {
            int unused = StatementSwitchToExpressionSwitch.extractLhsComments(caseTree, state, transformedBlockBuilder);
            ExpressionTree expression = ((ExpressionStatementTree)statements.get(0)).getExpression();
            Optional<Object> rhs = Optional.empty();
            if (expression instanceof CompoundAssignmentTree) {
                rhs = Optional.of(((CompoundAssignmentTree)expression).getExpression());
            } else if (expression instanceof AssignmentTree) {
                rhs = Optional.of(((AssignmentTree)expression).getExpression());
            }
            codeBlockStart = ASTHelpers.getStartPosition((Tree)((Tree)rhs.get()));
        } else {
            codeBlockStart = StatementSwitchToExpressionSwitch.extractLhsComments(caseTree, state, transformedBlockBuilder);
        }
        transformedBlockBuilder.append(state.getSourceCode(), codeBlockStart, codeBlockEnd);
        return transformedBlockBuilder.toString();
    }

    @AutoValue
    static abstract class AnalysisResult {
        AnalysisResult() {
        }

        abstract boolean canConvertDirectlyToExpressionSwitch();

        abstract boolean canConvertToReturnSwitch();

        abstract AssignmentSwitchAnalysisResult assignmentSwitchAnalysisResult();

        abstract ImmutableList<Boolean> groupedWithNextCase();

        static AnalysisResult of(boolean canConvertDirectlyToExpressionSwitch, boolean canConvertToReturnSwitch, AssignmentSwitchAnalysisResult assignmentSwitchAnalysisResult, ImmutableList<Boolean> groupedWithNextCase) {
            return new AutoValue_StatementSwitchToExpressionSwitch_AnalysisResult(canConvertDirectlyToExpressionSwitch, canConvertToReturnSwitch, assignmentSwitchAnalysisResult, groupedWithNextCase);
        }
    }

    @AutoValue
    static abstract class AssignmentSwitchAnalysisResult {
        AssignmentSwitchAnalysisResult() {
        }

        abstract boolean canConvertToAssignmentSwitch();

        abstract Optional<ExpressionTree> assignmentTargetOptional();

        abstract Optional<Tree.Kind> assignmentKindOptional();

        abstract Optional<String> assignmentSourceCodeOptional();

        static AssignmentSwitchAnalysisResult of(boolean canConvertToAssignmentSwitch, Optional<ExpressionTree> assignmentTargetOptional, Optional<Tree.Kind> assignmentKindOptional, Optional<String> assignmentSourceCodeOptional) {
            return new AutoValue_StatementSwitchToExpressionSwitch_AssignmentSwitchAnalysisResult(canConvertToAssignmentSwitch, assignmentTargetOptional, assignmentKindOptional, assignmentSourceCodeOptional);
        }
    }

    static enum CaseQualifications {
        NO_CASES_ASSESSED,
        ALL_CASES_QUALIFY,
        SOME_OR_ALL_CASES_DONT_QUALIFY;

    }

    @AutoValue
    static abstract class AssignmentSwitchAnalysisState {
        AssignmentSwitchAnalysisState() {
        }

        abstract CaseQualifications assignmentSwitchCaseQualifications();

        abstract Optional<ExpressionTree> assignmentTargetOptional();

        abstract Optional<Tree.Kind> assignmentExpressionKindOptional();

        abstract Optional<ExpressionTree> assignmentTreeOptional();

        static AssignmentSwitchAnalysisState of(CaseQualifications assignmentSwitchCaseQualifications, Optional<ExpressionTree> assignmentTargetOptional, Optional<Tree.Kind> assignmentKindOptional, Optional<ExpressionTree> assignmentTreeOptional) {
            return new AutoValue_StatementSwitchToExpressionSwitch_AssignmentSwitchAnalysisState(assignmentSwitchCaseQualifications, assignmentTargetOptional, assignmentKindOptional, assignmentTreeOptional);
        }
    }

    private static enum CaseFallThru {
        DEFINITELY_DOES_NOT_FALL_THRU,
        MAYBE_FALLS_THRU,
        DEFINITELY_DOES_FALL_THRU;

    }
}

