/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import javax.lang.model.type.UnionType;

@BugPattern(summary="`throwIfUnchecked(knownUnchecked)` is equivalent to `throw knownUnchecked`.", severity=BugPattern.SeverityLevel.WARNING)
public class ThrowIfUncheckedKnownUnchecked
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> IS_THROW_IF_UNCHECKED = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.base.Throwables").named("throwIfUnchecked"), MethodMatchers.staticMethod().onClass("com.google.common.base.Throwables").named("propagateIfPossible")}), Matchers.argumentCount((int)1)});
    private static final Matcher<ExpressionTree> IS_KNOWN_UNCHECKED = new Matcher<ExpressionTree>(){

        public boolean matches(ExpressionTree tree, VisitorState state) {
            Type type = ASTHelpers.getType((Tree)tree);
            if (type.isUnion()) {
                return ((UnionType)((Object)type)).getAlternatives().stream().allMatch(t -> this.isKnownUnchecked(state, (Type)t));
            }
            return this.isKnownUnchecked(state, type);
        }

        boolean isKnownUnchecked(VisitorState state, Type type) {
            Types types = state.getTypes();
            Symtab symtab = state.getSymtab();
            return types.isSubtype(type = types.erasure(type), symtab.errorType) || types.isSubtype(type, symtab.runtimeExceptionType);
        }
    };

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (IS_THROW_IF_UNCHECKED.matches((Tree)tree, state) && Matchers.argument((int)0, IS_KNOWN_UNCHECKED).matches((Tree)tree, state)) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            fix.replace((Tree)tree, "throw " + state.getSourceForNode((Tree)tree.getArguments().get(0)));
            Tree parent = state.getPath().getParentPath().getLeaf();
            Tree grandparent = state.getPath().getParentPath().getParentPath().getLeaf();
            if (parent.getKind() == Tree.Kind.EXPRESSION_STATEMENT && grandparent.getKind() == Tree.Kind.BLOCK) {
                ((BlockTree)grandparent).getStatements().stream().dropWhile(t -> t != parent).skip(1L).forEach(arg_0 -> ((SuggestedFix.Builder)fix).delete(arg_0));
            }
            return this.describeMatch(tree, (Fix)fix.build());
        }
        return Description.NO_MATCH;
    }
}

