/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import javax.inject.Inject;

@BugPattern(summary="A large number of parameters on public APIs should be avoided.", severity=BugPattern.SeverityLevel.WARNING)
public class TooManyParameters
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final int DEFAULT_LIMIT = 9;
    static final String TOO_MANY_PARAMETERS_FLAG_NAME = "TooManyParameters:ParameterLimit";
    private static final ImmutableSet<String> METHOD_ANNOTATIONS_TO_IGNORE = ImmutableSet.of((Object)"java.lang.Deprecated", (Object)"java.lang.Override", (Object)"javax.inject.Inject", (Object)"com.google.inject.Inject", (Object)"com.google.inject.Provides", (Object)"org.junit.Test", (Object[])new String[]{"dagger.Provides", "dagger.producers.Produces"});
    private static final ImmutableSet<String> CLASS_ANNOTATIONS_TO_IGNORE = ImmutableSet.of((Object)"com.google.auto.factory.AutoFactory");
    private final int limit;

    @Inject
    TooManyParameters(ErrorProneFlags flags) {
        this.limit = flags.getInteger(TOO_MANY_PARAMETERS_FLAG_NAME).orElse(9);
        Preconditions.checkArgument((this.limit > 0 ? 1 : 0) != 0, (String)"%s (%s) must be > 0", (Object)TOO_MANY_PARAMETERS_FLAG_NAME, (int)this.limit);
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        int paramCount = tree.getParameters().size();
        if (paramCount <= this.limit) {
            return Description.NO_MATCH;
        }
        if (!TooManyParameters.shouldApplyApiChecks(tree, state)) {
            return Description.NO_MATCH;
        }
        String name = ASTHelpers.getSymbol((MethodTree)tree).isConstructor() ? "constructor" : "method";
        String message = String.format("Consider using a builder pattern instead of a %s with %s parameters. Data shows that defining %s with > 5 parameters often leads to bugs. See also Effective Java, Item 2.", name, paramCount, name);
        return this.buildDescription(tree).setMessage(message).build();
    }

    private static boolean shouldApplyApiChecks(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (symbol.owner instanceof Symbol.ClassSymbol && CLASS_ANNOTATIONS_TO_IGNORE.stream().anyMatch(a -> ASTHelpers.hasAnnotation((Symbol)symbol.owner, (String)a, (VisitorState)state))) {
            return false;
        }
        if (ASTHelpers.isRecord((Symbol)symbol)) {
            return false;
        }
        return METHOD_ANNOTATIONS_TO_IGNORE.stream().noneMatch(a -> ASTHelpers.hasAnnotation((Tree)tree, (String)a, (VisitorState)state)) && ASTHelpers.methodIsPublicAndNotAnOverride((Symbol.MethodSymbol)symbol, (VisitorState)state);
    }
}

