/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Var;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.SourceVersion;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(name="Var", summary="Non-constant variable missing @Var annotation", severity=BugPattern.SeverityLevel.WARNING)
public class VarChecker
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final String UNNECESSARY_FINAL = "Unnecessary 'final' modifier.";

    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        if (ASTHelpers.hasAnnotation((Symbol)sym, Var.class, (VisitorState)state)) {
            if ((sym.flags() & 0x20000000000L) != 0L) {
                return this.buildDescription(tree).setMessage("@Var variable is never modified").addFix((Fix)SuggestedFix.delete((Tree)ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), (String)"Var"))).build();
            }
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.getGeneratedBy((VisitorState)state).isEmpty()) {
            return Description.NO_MATCH;
        }
        if (TreeInfo.isReceiverParam((JCTree)((Object)tree))) {
            return Description.NO_MATCH;
        }
        if (this.forLoopVariable(tree, state.getPath())) {
            return Description.NO_MATCH;
        }
        return switch (((Symbol)sym).getKind()) {
            case ElementKind.PARAMETER, ElementKind.LOCAL_VARIABLE, ElementKind.EXCEPTION_PARAMETER, ElementKind.RESOURCE_VARIABLE -> this.handleLocalOrParam(tree, state, sym);
            default -> Description.NO_MATCH;
        };
    }

    boolean forLoopVariable(VariableTree tree, TreePath path) {
        Tree parent = path.getParentPath().getLeaf();
        if (!(parent instanceof ForLoopTree)) {
            return false;
        }
        ForLoopTree forLoop = (ForLoopTree)parent;
        return forLoop.getInitializer().contains(tree);
    }

    private Description handleLocalOrParam(VariableTree tree, VisitorState state, Symbol sym) {
        if (sym.getModifiers().contains((Object)Modifier.FINAL)) {
            Optional fix;
            if (SourceVersion.supportsEffectivelyFinal((Context)state.context) && (fix = SuggestedFixes.removeModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL})).isPresent()) {
                return this.buildDescription(tree).setMessage(UNNECESSARY_FINAL).addFix((Fix)fix.get()).build();
            }
            return Description.NO_MATCH;
        }
        if (!Collections.disjoint(sym.owner.getModifiers(), EnumSet.of(Modifier.ABSTRACT, Modifier.NATIVE))) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isConsideredFinal((Symbol)sym)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, VarChecker.addVarAnnotation(tree));
    }

    private static Fix addVarAnnotation(VariableTree tree) {
        return SuggestedFix.builder().prefixWith((Tree)tree, "@Var ").addImport(Var.class.getName()).build();
    }
}

