/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.argumentselectiondefects.AutoValue_Parameter;
import com.google.errorprone.names.NamingConventions;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Name;
import java.util.List;
import java.util.Optional;

@AutoValue
abstract class Parameter {
    private static final ImmutableSet<String> METHODNAME_PREFIXES_TO_REMOVE = ImmutableSet.of((Object)"get", (Object)"set", (Object)"is");
    @VisibleForTesting
    static final String NAME_NULL = "*NULL*";
    @VisibleForTesting
    static final String NAME_NOT_PRESENT = "*NOT_PRESENT*";

    Parameter() {
    }

    abstract String name();

    abstract Type type();

    abstract int index();

    abstract String text();

    abstract Tree.Kind kind();

    abstract boolean constant();

    static ImmutableList<Parameter> createListFromVarSymbols(List<Symbol.VarSymbol> varSymbols) {
        return (ImmutableList)Streams.mapWithIndex(varSymbols.stream(), (s, i) -> new AutoValue_Parameter(((Name)s.getSimpleName()).toString(), (Type)s.asType(), (int)i, ((Name)s.getSimpleName()).toString(), Tree.Kind.IDENTIFIER, false)).collect(ImmutableList.toImmutableList());
    }

    static ImmutableList<Parameter> createListFromExpressionTrees(List<? extends Tree> trees) {
        return (ImmutableList)Streams.mapWithIndex(trees.stream(), (t, i) -> new AutoValue_Parameter(Parameter.getArgumentName(t), Optional.ofNullable(t instanceof ExpressionTree ? ASTHelpers.getResultType((ExpressionTree)((ExpressionTree)t)) : ASTHelpers.getType((Tree)t)).orElse(Type.noType), (int)i, t.toString(), t.getKind(), ASTHelpers.constValue((Tree)t) != null)).collect(ImmutableList.toImmutableList());
    }

    static ImmutableList<Parameter> createListFromVariableTrees(List<? extends VariableTree> trees) {
        return Parameter.createListFromVarSymbols((List)trees.stream().map(ASTHelpers::getSymbol).collect(ImmutableList.toImmutableList()));
    }

    boolean isAssignableTo(Parameter target, VisitorState state) {
        if (state.getTypes().isSameType(this.type(), Type.noType) || state.getTypes().isSameType(target.type(), Type.noType)) {
            return false;
        }
        try {
            return state.getTypes().isAssignable(this.type(), target.type());
        }
        catch (Symbol.CompletionFailure e) {
            Check.instance(state.context).completionError((JCDiagnostic.DiagnosticPosition)((Object)state.getPath().getLeaf()), e);
            return false;
        }
    }

    boolean isNullLiteral() {
        return this.name().equals(NAME_NULL);
    }

    boolean isUnknownName() {
        return this.name().equals(NAME_NOT_PRESENT);
    }

    private static String getClassName(Symbol.ClassSymbol s) {
        if (s.isAnonymous()) {
            return ((Name)s.getSuperclass().tsym.getSimpleName()).toString();
        }
        return s.getSimpleName().toString();
    }

    @VisibleForTesting
    static String getArgumentName(Tree tree) {
        return switch (tree.getKind()) {
            case Tree.Kind.VARIABLE -> ((VariableTree)tree).getName().toString();
            case Tree.Kind.MEMBER_SELECT -> ((MemberSelectTree)tree).getIdentifier().toString();
            case Tree.Kind.NULL_LITERAL -> NAME_NULL;
            case Tree.Kind.IDENTIFIER -> {
                IdentifierTree idTree = (IdentifierTree)tree;
                if (idTree.getName().contentEquals("this")) {
                    Symbol sym = ASTHelpers.getSymbol((Tree)idTree);
                    if (sym != null) {
                        yield Parameter.getClassName(ASTHelpers.enclosingClass((Symbol)sym));
                    }
                    yield NAME_NOT_PRESENT;
                }
                yield idTree.getName().toString();
            }
            case Tree.Kind.METHOD_INVOCATION -> {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
                Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationTree);
                String name = ((Name)methodSym.getSimpleName()).toString();
                ImmutableList terms = NamingConventions.splitToLowercaseTerms((String)name);
                String firstTerm = (String)Iterables.getFirst((Iterable)terms, null);
                if (METHODNAME_PREFIXES_TO_REMOVE.contains((Object)firstTerm)) {
                    if (terms.size() == 1) {
                        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)methodInvocationTree);
                        if (receiver == null) {
                            yield Parameter.getClassName(ASTHelpers.enclosingClass((Symbol)methodSym));
                        }
                        yield Parameter.getArgumentName(receiver);
                    }
                    yield name.substring(firstTerm.length());
                }
                yield name;
            }
            case Tree.Kind.NEW_CLASS -> {
                Symbol.MethodSymbol constructorSym = ASTHelpers.getSymbol((NewClassTree)((NewClassTree)tree));
                if (constructorSym.owner != null) {
                    yield Parameter.getClassName((Symbol.ClassSymbol)constructorSym.owner);
                }
                yield NAME_NOT_PRESENT;
            }
            default -> NAME_NOT_PRESENT;
        };
    }
}

