/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.formatstring;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.formatstring.AutoValue_FormatStringValidation_ValidationResult;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.DuplicateFormatFlagsException;
import java.util.FormatFlagsConversionMismatchException;
import java.util.GregorianCalendar;
import java.util.IllegalFormatCodePointException;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatException;
import java.util.IllegalFormatFlagsException;
import java.util.IllegalFormatPrecisionException;
import java.util.IllegalFormatWidthException;
import java.util.List;
import java.util.MissingFormatArgumentException;
import java.util.MissingFormatWidthException;
import java.util.UnknownFormatConversionException;
import java.util.UnknownFormatFlagsException;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.lang.model.type.TypeKind;
import org.jspecify.annotations.Nullable;

public final class FormatStringValidation {
    private static final Supplier<Type> COM_GOOGLE_COMMON_FLOGGER_LAZYARG = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("com.google.common.flogger.LazyArg"));

    static Stream<String> constValues(Tree tree) {
        final ArrayList flat = new ArrayList();
        new SimpleTreeVisitor<Void, Void>(){

            @Override
            public Void visitConditionalExpression(ConditionalExpressionTree tree, Void unused) {
                this.visit(tree.getTrueExpression(), null);
                this.visit(tree.getFalseExpression(), null);
                return null;
            }

            @Override
            protected Void defaultAction(Tree tree, Void unused) {
                flat.add(tree);
                return null;
            }
        }.visit(tree, null);
        return flat.stream().map(t -> (String)ASTHelpers.constValue((Tree)t, String.class)).filter(x -> x != null);
    }

    public static @Nullable ValidationResult validate( @Nullable Symbol.MethodSymbol formatMethodSymbol, Collection<? extends ExpressionTree> arguments, VisitorState state) {
        Type type;
        Preconditions.checkArgument((!arguments.isEmpty() ? 1 : 0) != 0, (String)"A format method should have one or more arguments, but method (%s) has zero arguments.", (Object)formatMethodSymbol);
        ArrayDeque<? extends ExpressionTree> args = new ArrayDeque<ExpressionTree>(arguments);
        Stream<String> formatStrings = FormatStringValidation.constValues((Tree)args.removeFirst());
        if (formatStrings == null) {
            return null;
        }
        if (args.size() == 1 && (formatMethodSymbol == null || formatMethodSymbol.isVarArgs()) && (type = ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(args)))) instanceof Type.ArrayType && ASTHelpers.isSameType((Type)((Type.ArrayType)type).elemtype, (Type)state.getSymtab().objectType, (VisitorState)state)) {
            return null;
        }
        Object[] instances = args.stream().map(input -> {
            try {
                return FormatStringValidation.getInstance(input, state);
            }
            catch (RuntimeException t) {
                return null;
            }
        }).toArray();
        return formatStrings.map(formatString -> FormatStringValidation.validate(formatString, instances)).filter(x -> x != null).findFirst().orElse(null);
    }

    private static @Nullable Object getInstance(Tree tree, VisitorState state) {
        Object value = ASTHelpers.constValue((Tree)tree);
        if (value != null) {
            return value;
        }
        Type type = ASTHelpers.getType((Tree)tree);
        return FormatStringValidation.getInstance(type, state);
    }

    private static @Nullable Object getInstance(Type type, VisitorState state) {
        Type asLazyArg;
        Types types = state.getTypes();
        if (type.getKind() == TypeKind.NULL) {
            return null;
        }
        Type unboxedType = types.unboxedTypeOrType(types.erasure(type));
        if (unboxedType.isPrimitive()) {
            type = unboxedType;
            return switch (type.getKind()) {
                case TypeKind.BOOLEAN -> false;
                case TypeKind.BYTE -> Byte.valueOf((byte)1);
                case TypeKind.SHORT -> Short.valueOf((short)2);
                case TypeKind.INT -> Integer.valueOf(3);
                case TypeKind.LONG -> Long.valueOf(4L);
                case TypeKind.CHAR -> Character.valueOf('c');
                case TypeKind.FLOAT -> Float.valueOf(5.0f);
                case TypeKind.DOUBLE -> Double.valueOf(6.0);
                case TypeKind.VOID, TypeKind.NONE, TypeKind.NULL, TypeKind.ERROR -> null;
                case TypeKind.ARRAY -> new Object[]{};
                default -> throw new AssertionError((Object)type.getKind());
            };
        }
        if (FormatStringValidation.isSubtype(types, type, state.getSymtab().stringType)) {
            return "string";
        }
        if (FormatStringValidation.isSubtype(types, type, state.getTypeFromString(BigDecimal.class.getName()))) {
            return BigDecimal.valueOf(42.0);
        }
        if (FormatStringValidation.isSubtype(types, type, state.getTypeFromString(BigInteger.class.getName()))) {
            return BigInteger.valueOf(43L);
        }
        if (ASTHelpers.isSameType((Type)type, (Type)state.getTypeFromString(Number.class.getName()), (VisitorState)state)) {
            return 0;
        }
        if (FormatStringValidation.isSubtype(types, type, state.getTypeFromString(Date.class.getName()))) {
            return new Date();
        }
        if (FormatStringValidation.isSubtype(types, type, state.getTypeFromString(Calendar.class.getName()))) {
            return new GregorianCalendar();
        }
        if (FormatStringValidation.isSubtype(types, type, state.getTypeFromString(Instant.class.getName()))) {
            return Instant.now();
        }
        if (FormatStringValidation.isSubtype(types, type, state.getTypeFromString(TemporalAccessor.class.getName()))) {
            return Instant.now().atZone(ZoneId.systemDefault());
        }
        Type lazyArg = (Type)COM_GOOGLE_COMMON_FLOGGER_LAZYARG.get(state);
        if (lazyArg != null && (asLazyArg = types.asSuper(type, lazyArg.tsym)) != null && !asLazyArg.getTypeArguments().isEmpty()) {
            return FormatStringValidation.getInstance((Type)Iterables.getOnlyElement(asLazyArg.getTypeArguments()), state);
        }
        return new Object();
    }

    private static boolean isSubtype(Types types, Type t, Type s) {
        return s != null && types.isSubtype(t, s);
    }

    private static ValidationResult validate(String formatString, Object[] arguments) {
        try {
            String string = String.format(formatString, arguments);
        }
        catch (DuplicateFormatFlagsException e) {
            return ValidationResult.create(String.format("duplicate format flags: %s", e.getFlags()));
        }
        catch (FormatFlagsConversionMismatchException e) {
            return ValidationResult.create(String.format("format specifier '%%%s' is not compatible with the given flag(s): %s", Character.valueOf(e.getConversion()), e.getFlags()));
        }
        catch (IllegalFormatCodePointException e) {
            return ValidationResult.create(String.format("invalid Unicode code point: %x", e.getCodePoint()));
        }
        catch (IllegalFormatConversionException e) {
            return ValidationResult.create(String.format("illegal format conversion: '%s' cannot be formatted using '%%%s'", e.getArgumentClass().getName(), Character.valueOf(e.getConversion())));
        }
        catch (IllegalFormatFlagsException e) {
            return ValidationResult.create(String.format("illegal format flags: %s", e.getFlags()));
        }
        catch (IllegalFormatPrecisionException e) {
            return ValidationResult.create(String.format("illegal format precision: %d", e.getPrecision()));
        }
        catch (IllegalFormatWidthException e) {
            return ValidationResult.create(String.format("illegal format width: %s", e.getWidth()));
        }
        catch (MissingFormatArgumentException e) {
            return ValidationResult.create(String.format("missing argument for format specifier '%s'", e.getFormatSpecifier()));
        }
        catch (MissingFormatWidthException e) {
            return ValidationResult.create(String.format("missing format width: %s", e.getFormatSpecifier()));
        }
        catch (UnknownFormatConversionException e) {
            return ValidationResult.create(FormatStringValidation.unknownFormatConversion(e.getConversion()));
        }
        catch (UnknownFormatFlagsException e) {
            return ValidationResult.create(String.format("unknown format flag(s): %s", e.getFlags()));
        }
        catch (IllegalFormatException e) {
            return ValidationResult.create(e.getMessage());
        }
        return FormatStringValidation.extraFormatArguments(formatString, Arrays.asList(arguments));
    }

    private static @Nullable ValidationResult extraFormatArguments(String formatString, List<Object> arguments) {
        int used = IntStream.rangeClosed(0, arguments.size()).filter(i -> FormatStringValidation.doesItFormat(formatString, arguments.subList(0, i))).findFirst().orElse(0);
        if (used == arguments.size()) {
            return null;
        }
        return ValidationResult.create(String.format("extra format arguments: used %d, provided %d", used, arguments.size()));
    }

    private static boolean doesItFormat(String formatString, List<Object> arguments) {
        try {
            String unused = String.format(formatString, arguments.toArray());
            return true;
        }
        catch (IllegalFormatException e) {
            return false;
        }
    }

    private static String unknownFormatConversion(String conversion) {
        if (conversion.equals("l")) {
            return "%l is not a valid format specifier; use %d to format integral types as a decimal integer, and %f, %g or %e to format floating point types (depending on your formatting needs)";
        }
        return String.format("unknown format conversion: '%s'", conversion);
    }

    private FormatStringValidation() {
    }

    @AutoValue
    public static abstract class ValidationResult {
        public abstract String message();

        public static ValidationResult create(String message) {
            return new AutoValue_FormatStringValidation_ValidationResult(message);
        }
    }
}

