/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.JavadocTag;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneComment;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.util.Context;
import java.util.HashMap;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="This comment contains Javadoc or HTML tags, but isn't started with a double asterisk (/**); is it meant to be Javadoc?", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"}, documentSuppression=false)
public final class AlmostJavadoc
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Pattern HAS_TAG = Pattern.compile(String.format("</(em|b|a|strong|i|pre|code)>|@(%s)", Streams.concat((Stream[])new Stream[]{JavadocTag.VALID_CLASS_TAGS.stream(), JavadocTag.VALID_METHOD_TAGS.stream(), JavadocTag.VALID_VARIABLE_TAGS.stream()}).map(JavadocTag::name).map(Pattern::quote).distinct().collect(Collectors.joining("|"))));

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        ImmutableMap<Integer, Tree> javadocableTrees = this.getJavadocableTrees(tree, state);
        for (ErrorProneToken token : ErrorProneTokens.getTokens((String)state.getSourceCode().toString(), (Context)state.context)) {
            for (ErrorProneComment comment : token.comments()) {
                if (!javadocableTrees.containsKey((Object)token.pos())) continue;
                AlmostJavadoc.generateFix(comment).ifPresent(fix -> state.reportMatch(this.describeMatch(Utils.getDiagnosticPosition(comment.getSourcePos(0), (Tree)javadocableTrees.get((Object)token.pos())), (Fix)fix)));
            }
        }
        return Description.NO_MATCH;
    }

    private static Optional<SuggestedFix> generateFix(ErrorProneComment comment) {
        String text = comment.getText();
        if (text.startsWith("/*") && !text.startsWith("/**") && HAS_TAG.matcher(text).find()) {
            int pos = comment.getSourcePos(1);
            return Optional.of(SuggestedFix.replace((int)pos, (int)pos, (String)"*"));
        }
        if (text.startsWith("//") && text.endsWith("*/") && HAS_TAG.matcher(text).find()) {
            int endReplacement;
            if (text.startsWith("// /**")) {
                return Optional.of(SuggestedFix.replace((int)comment.getSourcePos(0), (int)comment.getSourcePos(2), (String)""));
            }
            for (endReplacement = 2; endReplacement < text.length(); ++endReplacement) {
                char c = text.charAt(endReplacement);
                if (c == '/') {
                    return Optional.empty();
                }
                if (c != '*' && c != ' ') break;
            }
            return Optional.of(SuggestedFix.replace((int)comment.getSourcePos(1), (int)comment.getSourcePos(endReplacement), (String)"**"));
        }
        return Optional.empty();
    }

    private ImmutableMap<Integer, Tree> getJavadocableTrees(CompilationUnitTree tree, VisitorState state) {
        final HashMap javadoccablePositions = new HashMap();
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, state){
            final /* synthetic */ AlmostJavadoc this$0;
            {
                this.this$0 = this$0;
                super((BugChecker)this$0, state);
            }

            public Void visitClass(ClassTree classTree, Void unused) {
                if (!this.shouldMatch()) {
                    return null;
                }
                javadoccablePositions.put(this.startPos(classTree), classTree);
                return (Void)super.visitClass(classTree, null);
            }

            public Void visitMethod(MethodTree methodTree, Void unused) {
                if (!this.shouldMatch()) {
                    return null;
                }
                if (!ASTHelpers.isGeneratedConstructor((MethodTree)methodTree)) {
                    javadoccablePositions.put(this.startPos(methodTree), methodTree);
                }
                return (Void)super.visitMethod(methodTree, null);
            }

            public Void visitVariable(VariableTree variableTree, Void unused) {
                if (!this.shouldMatch()) {
                    return null;
                }
                ElementKind kind = ASTHelpers.getSymbol((VariableTree)variableTree).getKind();
                if (kind == ElementKind.FIELD) {
                    javadoccablePositions.put(this.startPos(variableTree), variableTree);
                }
                if (kind == ElementKind.ENUM_CONSTANT) {
                    javadoccablePositions.put(this.startPos(variableTree), variableTree);
                    if (variableTree.getInitializer() instanceof NewClassTree) {
                        ClassTree classBody = ((NewClassTree)variableTree.getInitializer()).getClassBody();
                        if (classBody != null) {
                            this.scan(classBody.getMembers(), null);
                        }
                        return null;
                    }
                }
                return (Void)super.visitVariable(variableTree, null);
            }

            private boolean shouldMatch() {
                return Utils.getDocTreePath(this.state.withPath(this.getCurrentPath())) == null;
            }

            private int startPos(Tree tree) {
                return ASTHelpers.getStartPosition((Tree)tree);
            }
        }.scan((Tree)tree, null);
        return ImmutableMap.copyOf(javadoccablePositions);
    }
}

