/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.time.AutoValue_TimeUnitMismatch_TreeAndTimeUnit;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.names.NamingConventions;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="An value that appears to be represented in one unit is used where another appears to be required (e.g., seconds where nanos are needed)", severity=BugPattern.SeverityLevel.WARNING)
public final class TimeUnitMismatch
extends BugChecker
implements BugChecker.AssignmentTreeMatcher,
BugChecker.BinaryTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher,
BugChecker.VariableTreeMatcher {
    private final boolean improvements;
    private static final ImmutableBiMap<TimeUnit, String> TIME_UNIT_TO_UNIT_METHODS = new ImmutableBiMap.Builder().put((Object)TimeUnit.NANOSECONDS, (Object)"toNanos").put((Object)TimeUnit.MICROSECONDS, (Object)"toMicros").put((Object)TimeUnit.MILLISECONDS, (Object)"toMillis").put((Object)TimeUnit.SECONDS, (Object)"toSeconds").put((Object)TimeUnit.MINUTES, (Object)"toMinutes").put((Object)TimeUnit.HOURS, (Object)"toHours").put((Object)TimeUnit.DAYS, (Object)"toDays").buildOrThrow();
    private static final Matcher<Tree> NUMERIC_TIME_TYPE = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isSameType((Supplier)Suppliers.INT_TYPE), Matchers.isSameType((Supplier)Suppliers.LONG_TYPE), Matchers.isSameType((Supplier)Suppliers.DOUBLE_TYPE), Matchers.isSameType((String)"java.lang.Integer"), Matchers.isSameType((String)"java.lang.Long"), Matchers.isSameType((String)"java.lang.Double")});
    private static final ImmutableSet<String> NUMBER_WORDS = ImmutableSet.of((Object)"one", (Object)"two", (Object)"three", (Object)"four", (Object)"five", (Object)"six", (Object[])new String[]{"seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "twenty", "thirty", "forty", "fifty", "sixty"});
    private static final ImmutableMap<String, TimeUnit> UNIT_FOR_SUFFIX = ImmutableMap.copyOf((Iterable)new ImmutableSetMultimap.Builder().putAll((Object)TimeUnit.SECONDS, (Object[])new String[]{"sec", "secs", "second", "seconds"}).putAll((Object)TimeUnit.MILLISECONDS, (Object[])new String[]{"milli", "millis", "mills", "ms", "msec", "msecs", "millisec", "millisecs", "millisecond", "milliseconds"}).putAll((Object)TimeUnit.MICROSECONDS, (Object[])new String[]{"micro", "micros", "us", "usec", "usecs", "microsec", "microsecs", "microsecond", "microseconds"}).putAll((Object)TimeUnit.NANOSECONDS, (Object[])new String[]{"nano", "nanos", "ns", "nsec", "nsecs", "nanosec", "nanosecs", "nanosecond", "nanoseconds"}).build().inverse().entries());
    private static final Description ANY_MATCHES_WERE_ALREADY_REPORTED = Description.NO_MATCH;
    private static final Supplier<Type> JAVA_UTIL_CONCURRENT_TIMEUNIT = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.util.concurrent.TimeUnit"));

    @Inject
    TimeUnitMismatch(ErrorProneFlags flags) {
        this.improvements = flags.getBoolean("TimeUnitMismatch:improvements").orElse(true);
    }

    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        String formalName = TimeUnitMismatch.extractArgumentName(tree.getVariable());
        if (formalName != null) {
            this.check(formalName, tree.getExpression(), state);
        }
        return ANY_MATCHES_WERE_ALREADY_REPORTED;
    }

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (!(this.improvements && NUMERIC_TIME_TYPE.matches((Tree)tree.getLeftOperand(), state) && NUMERIC_TIME_TYPE.matches((Tree)tree.getRightOperand(), state))) {
            return Description.NO_MATCH;
        }
        switch (tree.getKind()) {
            case PLUS: 
            case MINUS: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_EQUAL: 
            case GREATER_THAN_EQUAL: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: {
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        TreeAndTimeUnit lhs = this.unitSuggestedByTree(tree.getLeftOperand());
        TreeAndTimeUnit rhs = this.unitSuggestedByTree(tree.getRightOperand());
        if (lhs == null || rhs == null) {
            return Description.NO_MATCH;
        }
        if (lhs.outermostUnit().equals((Object)rhs.outermostUnit())) {
            return Description.NO_MATCH;
        }
        StringBuilder message = new StringBuilder(String.format("This operation seems to mix up time units: %s and %s. The generated fix uses the smaller unit to preserve precision.", new Object[]{lhs.outermostUnit(), rhs.outermostUnit()}));
        if (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree), (Type)state.getSymtab().booleanType, (VisitorState)state)) {
            message.append(" We picked the smaller unit (so larger result) to avoid truncation errors, but this may result in overflow.");
        } else {
            message.append(" We picked the smaller unit to preserve truncation, but this may not be the right unit for the result. Please review carefully!");
        }
        if (lhs.outermostUnit().convert(1L, rhs.outermostUnit()) != 0L) {
            return this.buildDescription(tree).setMessage(message.toString()).addFix((Fix)TimeUnitMismatch.convertTree(tree.getRightOperand(), rhs.innermostTree(), lhs.outermostUnit(), rhs.innermostUnit(), state)).build();
        }
        return this.buildDescription(tree).setMessage(message.toString()).addFix((Fix)TimeUnitMismatch.convertTree(tree.getLeftOperand(), lhs.innermostTree(), rhs.outermostUnit(), lhs.innermostUnit(), state)).build();
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (tree.getInitializer() != null) {
            this.check(tree.getName().toString(), tree.getInitializer(), state);
        }
        return ANY_MATCHES_WERE_ALREADY_REPORTED;
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((NewClassTree)tree);
        this.checkAll(symbol.getParameters(), tree.getArguments(), state);
        return ANY_MATCHES_WERE_ALREADY_REPORTED;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        this.checkTimeUnitToUnit(tree, symbol, state);
        boolean setterMethodReported = this.checkSetterStyleMethod(tree, symbol, state);
        if (!setterMethodReported) {
            this.checkAll(symbol.getParameters(), tree.getArguments(), state);
        }
        return ANY_MATCHES_WERE_ALREADY_REPORTED;
    }

    private boolean checkSetterStyleMethod(MethodInvocationTree tree, Symbol.MethodSymbol symbol, VisitorState state) {
        if (symbol.params().length() == 1 && ASTHelpers.isVoidType((Type)symbol.getReturnType(), (VisitorState)state) && tree.getArguments().size() == 1) {
            return this.check(symbol.name.toString(), tree.getArguments().get(0), state);
        }
        return false;
    }

    @CanIgnoreReturnValue
    private boolean checkTimeUnitToUnit(MethodInvocationTree tree, Symbol.MethodSymbol methodSymbol, VisitorState state) {
        if (tree.getMethodSelect().getKind() != Tree.Kind.MEMBER_SELECT) {
            return false;
        }
        MemberSelectTree memberSelect = (MemberSelectTree)tree.getMethodSelect();
        Symbol receiverSymbol = ASTHelpers.getSymbol((Tree)memberSelect.getExpression());
        if (receiverSymbol == null) {
            return false;
        }
        if (TimeUnitMismatch.isTimeUnit(receiverSymbol, state) && receiverSymbol.isEnum() && TIME_UNIT_TO_UNIT_METHODS.containsValue((Object)((Name)methodSymbol.getSimpleName()).toString()) && tree.getArguments().size() == 1) {
            return this.check(receiverSymbol.getSimpleName().toString(), (ExpressionTree)Iterables.getOnlyElement(tree.getArguments()), state);
        }
        return false;
    }

    private static boolean isTimeUnit(Symbol receiverSymbol, VisitorState state) {
        return ASTHelpers.isSameType((Type)((Type)JAVA_UTIL_CONCURRENT_TIMEUNIT.get(state)), (Type)receiverSymbol.type, (VisitorState)state);
    }

    @CanIgnoreReturnValue
    private boolean checkAll(List<Symbol.VarSymbol> formals, List<? extends ExpressionTree> actuals, VisitorState state) {
        if (formals.size() != actuals.size()) {
            return false;
        }
        boolean hasFinding = false;
        for (int i = 0; i < formals.size(); ++i) {
            hasFinding |= this.check(((Name)formals.get(i).getSimpleName()).toString(), actuals.get(i), state);
        }
        return hasFinding;
    }

    @CanIgnoreReturnValue
    private boolean check(String formalName, ExpressionTree actualTree, VisitorState state) {
        if (!NUMERIC_TIME_TYPE.matches((Tree)actualTree, state)) {
            return false;
        }
        TimeUnit targetUnit = TimeUnitMismatch.unitSuggestedByName(formalName);
        TreeAndTimeUnit provided = this.unitSuggestedByTree(actualTree);
        if (targetUnit == null || provided == null || targetUnit.equals((Object)provided.outermostUnit())) {
            return false;
        }
        TimeUnit providedUnit = provided.outermostUnit();
        Object message = String.format("Possible unit mismatch: expected %s but was %s. Before accepting this change, make sure that there is a true unit mismatch and not just an identifier whose name contains the wrong unit. (If there is, correct that instead!)", targetUnit.toString().toLowerCase(Locale.ROOT), providedUnit.toString().toLowerCase(Locale.ROOT));
        if (!(providedUnit != TimeUnit.MICROSECONDS && providedUnit != TimeUnit.MILLISECONDS || targetUnit != TimeUnit.MICROSECONDS && targetUnit != TimeUnit.MILLISECONDS)) {
            message = (String)message + " WARNING: This checker considers \"ms\" and \"msec\" to always refer to *milli*seconds. Occasionally, code uses them for *micro*seconds. If this error involves identifiers with those terms, be sure to check that it does mean milliseconds before accepting this fix. If it instead means microseconds, consider renaming to \"us\" or \"usec\" (or just \"micros\").";
        } else if (targetUnit == TimeUnit.SECONDS && providedUnit != TimeUnit.HOURS && providedUnit != TimeUnit.DAYS) {
            message = (String)message + " WARNING: The suggested replacement truncates fractional seconds, so a value like 999ms becomes 0.";
            message = (String)message + "Consider performing a floating-point division instead.";
        }
        SuggestedFix fix = TimeUnitMismatch.convertTree(actualTree, provided.innermostTree(), targetUnit, provided.innermostUnit(), state);
        state.reportMatch(this.buildDescription(actualTree).setMessage((String)message).addFix((Fix)fix).build());
        return true;
    }

    private static SuggestedFix convertTree(ExpressionTree actualTree, ExpressionTree innerTree, TimeUnit to, TimeUnit from, VisitorState state) {
        if (to.equals((Object)from)) {
            return SuggestedFix.replace((Tree)actualTree, (String)state.getSourceForNode((Tree)innerTree));
        }
        return SuggestedFix.builder().addStaticImport(TimeUnit.class.getName() + "." + String.valueOf((Object)from)).replace((Tree)actualTree, String.format("%s.%s(%s)", new Object[]{from, TIME_UNIT_TO_UNIT_METHODS.get((Object)to), state.getSourceForNode((Tree)innerTree)})).build();
    }

    private static @Nullable String extractArgumentName(ExpressionTree expr) {
        switch (expr.getKind()) {
            case TYPE_CAST: {
                return TimeUnitMismatch.extractArgumentName(((TypeCastTree)expr).getExpression());
            }
            case MEMBER_SELECT: {
                MemberSelectTree memberSelect = (MemberSelectTree)expr;
                String member = memberSelect.getIdentifier().toString();
                return member.equals("get") ? TimeUnitMismatch.extractArgumentName(memberSelect.getExpression()) : member;
            }
            case METHOD_INVOCATION: {
                Symbol sym = ASTHelpers.getSymbol((Tree)expr);
                if (sym == null) {
                    return null;
                }
                String methodName = sym.getSimpleName().toString();
                return methodName.equals("get") ? TimeUnitMismatch.extractArgumentName(((MethodInvocationTree)expr).getMethodSelect()) : methodName;
            }
            case IDENTIFIER: {
                IdentifierTree idTree = (IdentifierTree)expr;
                if (idTree.getName().contentEquals("this")) {
                    Symbol sym = ASTHelpers.getSymbol((Tree)idTree);
                    return sym == null ? null : ASTHelpers.enclosingClass((Symbol)sym).getSimpleName().toString();
                }
                return ((IdentifierTree)expr).getName().toString();
            }
        }
        return null;
    }

    private @Nullable TreeAndTimeUnit unitSuggestedByTree(ExpressionTree tree) {
        String name;
        ExpressionTree rhs;
        ExpressionTree lhs;
        if (this.improvements && tree.getKind().equals((Object)Tree.Kind.MULTIPLY)) {
            lhs = ((BinaryTree)tree).getLeftOperand();
            rhs = ((BinaryTree)tree).getRightOperand();
            Long lhsConversion = TimeUnitMismatch.conversionFactor(lhs);
            Long rhsConversion = TimeUnitMismatch.conversionFactor(rhs);
            if (lhsConversion != null) {
                return this.unitSuggestedWithConversion(lhsConversion, rhs);
            }
            if (rhsConversion != null) {
                return this.unitSuggestedWithConversion(rhsConversion, lhs);
            }
        }
        if (this.improvements && tree.getKind().equals((Object)Tree.Kind.DIVIDE)) {
            lhs = ((BinaryTree)tree).getLeftOperand();
            rhs = ((BinaryTree)tree).getRightOperand();
            Long rhsConversion = TimeUnitMismatch.conversionFactor(rhs);
            if (rhsConversion != null) {
                return this.unitSuggestedWithReciprocalConversion(rhsConversion, lhs);
            }
        }
        if ((name = TimeUnitMismatch.extractArgumentName(tree)) == null) {
            return null;
        }
        TimeUnit unit = TimeUnitMismatch.unitSuggestedByName(name);
        return unit == null ? null : TreeAndTimeUnit.of(tree, unit, unit);
    }

    private @Nullable TreeAndTimeUnit unitSuggestedWithConversion(long conversionFactor, ExpressionTree tree) {
        TreeAndTimeUnit underlying = this.unitSuggestedByTree(tree);
        if (underlying == null) {
            return null;
        }
        return EnumSet.allOf(TimeUnit.class).stream().filter(unit -> unit.convert(1L, underlying.outermostUnit()) == conversionFactor).findFirst().map(u -> TreeAndTimeUnit.of(underlying.innermostTree(), u, underlying.innermostUnit())).orElse(null);
    }

    private @Nullable TreeAndTimeUnit unitSuggestedWithReciprocalConversion(long conversionFactor, ExpressionTree tree) {
        TreeAndTimeUnit underlying = this.unitSuggestedByTree(tree);
        if (underlying == null) {
            return null;
        }
        return EnumSet.allOf(TimeUnit.class).stream().filter(unit -> underlying.outermostUnit().convert(1L, (TimeUnit)((Object)unit)) == conversionFactor).findFirst().map(u -> TreeAndTimeUnit.of(underlying.innermostTree(), u, underlying.innermostUnit())).orElse(null);
    }

    private static @Nullable Long conversionFactor(ExpressionTree tree) {
        Object constValue = ASTHelpers.constValue((Tree)tree);
        if (constValue instanceof Long) {
            return (Long)constValue == 0L ? null : (Long)constValue;
        }
        if (constValue instanceof Integer) {
            return (Integer)constValue == 0 ? null : Long.valueOf(((Integer)constValue).longValue());
        }
        return null;
    }

    @VisibleForTesting
    static @Nullable TimeUnit unitSuggestedByName(String name) {
        if (name.equals("second") || name.equals("getSecond")) {
            return null;
        }
        if (name.equals("secondsPart")) {
            return TimeUnit.NANOSECONDS;
        }
        if (name.equals("msToS")) {
            return TimeUnit.SECONDS;
        }
        ImmutableList<String> words = TimeUnitMismatch.fixUnitCamelCase((List<String>)NamingConventions.splitToLowercaseTerms((String)name));
        if (((String)words.get(0)).equals("second")) {
            return null;
        }
        if (TimeUnitMismatch.hasNameOfFromUnits(words)) {
            return null;
        }
        if (TimeUnitMismatch.isNamedForNumberOfUnits(words)) {
            return null;
        }
        ImmutableSet<TimeUnit> units = TimeUnitMismatch.timeUnits(words);
        return units.size() == 1 ? (TimeUnit)((Object)Iterables.getOnlyElement(units)) : null;
    }

    private static boolean hasNameOfFromUnits(List<String> words) {
        return words.size() == 2 && words.get(0).equals("from") && UNIT_FOR_SUFFIX.containsKey((Object)words.get(1));
    }

    private static boolean isNamedForNumberOfUnits(List<String> words) {
        return words.size() == 2 && NUMBER_WORDS.contains((Object)words.get(0)) && UNIT_FOR_SUFFIX.containsKey((Object)words.get(1));
    }

    private static ImmutableList<String> fixUnitCamelCase(List<String> words) {
        ImmutableList.Builder out = ImmutableList.builderWithExpectedSize((int)words.size());
        int i = 0;
        for (i = 0; i < words.size() - 1; ++i) {
            String next;
            String current = words.get(i);
            String together = current + (next = words.get(i + 1));
            if (UNIT_FOR_SUFFIX.containsKey((Object)together)) {
                out.add((Object)together);
                ++i;
                continue;
            }
            out.add((Object)current);
        }
        if (i == words.size() - 1) {
            out.add((Object)words.get(i));
        }
        return out.build();
    }

    private static ImmutableSet<TimeUnit> timeUnits(List<String> wordsLists) {
        return (ImmutableSet)wordsLists.stream().map(arg_0 -> UNIT_FOR_SUFFIX.get(arg_0)).filter(x -> x != null).collect(ImmutableSet.toImmutableSet());
    }

    @AutoValue
    static abstract class TreeAndTimeUnit {
        TreeAndTimeUnit() {
        }

        public static TreeAndTimeUnit of(ExpressionTree tree, TimeUnit timeUnit, TimeUnit underlyingUnit) {
            return new AutoValue_TimeUnitMismatch_TreeAndTimeUnit(tree, timeUnit, underlyingUnit);
        }

        abstract ExpressionTree innermostTree();

        abstract TimeUnit outermostUnit();

        abstract TimeUnit innermostUnit();
    }
}

