/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.KeepMarker;
import proguard.optimize.info.FieldOptimizationInfo;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.ProgramFieldOptimizationInfo;
import proguard.optimize.info.ProgramMethodOptimizationInfo;

public class StoringInvocationUnit
extends BasicInvocationUnit {
    private boolean storeFieldValues;
    private boolean storeMethodParameterValues;
    private boolean storeMethodReturnValues;

    public StoringInvocationUnit(ValueFactory valueFactory) {
        this(valueFactory, true, true, true);
    }

    public StoringInvocationUnit(ValueFactory valueFactory, boolean storeFieldValues, boolean storeMethodParameterValues, boolean storeMethodReturnValues) {
        super(valueFactory);
        this.storeFieldValues = storeFieldValues;
        this.storeMethodParameterValues = storeMethodParameterValues;
        this.storeMethodReturnValues = storeMethodReturnValues;
    }

    public void setFieldClassValue(Clazz clazz, FieldrefConstant refConstant, ReferenceValue value) {
        Field referencedMember;
        if (this.storeFieldValues && (referencedMember = refConstant.referencedField) != null) {
            StoringInvocationUnit.generalizeFieldClassValue(referencedMember, value);
        }
    }

    public void setFieldValue(Clazz clazz, FieldrefConstant refConstant, Value value) {
        Field referencedMember;
        if (this.storeFieldValues && (referencedMember = refConstant.referencedField) != null) {
            StoringInvocationUnit.generalizeFieldValue(referencedMember, value);
        }
    }

    public void setMethodParameterValue(Clazz clazz, AnyMethodrefConstant refConstant, int parameterIndex, Value value) {
        Method referencedMember;
        if (this.storeMethodParameterValues && (referencedMember = refConstant.referencedMethod) != null) {
            StoringInvocationUnit.generalizeMethodParameterValue(referencedMember, parameterIndex, value);
        }
    }

    public void setMethodReturnValue(Clazz clazz, Method method, Value value) {
        if (this.storeMethodReturnValues) {
            StoringInvocationUnit.generalizeMethodReturnValue(method, value);
        }
    }

    private static void generalizeFieldClassValue(Field field, ReferenceValue value) {
        if (!KeepMarker.isKept(field)) {
            ProgramFieldOptimizationInfo.getProgramFieldOptimizationInfo(field).generalizeReferencedClass(value);
        }
    }

    public static ReferenceValue getFieldClassValue(Field field) {
        return FieldOptimizationInfo.getFieldOptimizationInfo(field).getReferencedClass();
    }

    private static void generalizeFieldValue(Field field, Value value) {
        if (!KeepMarker.isKept(field)) {
            ProgramFieldOptimizationInfo.getProgramFieldOptimizationInfo(field).generalizeValue(value);
        }
    }

    public static Value getFieldValue(Field field) {
        return FieldOptimizationInfo.getFieldOptimizationInfo(field).getValue();
    }

    private static void generalizeMethodParameterValue(Method method, int parameterIndex, Value value) {
        if (!KeepMarker.isKept(method)) {
            ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(method).generalizeParameterValue(parameterIndex, value);
        }
    }

    public static Value getMethodParameterValue(Method method, int parameterIndex) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).getParameterValue(parameterIndex);
    }

    private static void generalizeMethodReturnValue(Method method, Value value) {
        if (!KeepMarker.isKept(method)) {
            ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(method).generalizeReturnValue(value);
        }
    }

    public static Value getMethodReturnValue(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).getReturnValue();
    }
}

