/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.testing.junit.testparameterinjector.TestInfo;
import com.google.testing.junit.testparameterinjector.TestMethodProcessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Test;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.Fail;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

abstract class PluggableTestRunner
extends BlockJUnit4ClassRunner {
    private static final ThreadLocal<TestInfo> currentTestInfo = new ThreadLocal();
    private ImmutableList<TestRule> testRules;
    private List<TestMethodProcessor> testMethodProcessors;

    protected PluggableTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected abstract List<TestMethodProcessor> createTestMethodProcessorList();

    protected void finalizeCreatedTestInstance(Object testInstance) {
    }

    protected boolean shouldSortTestMethodsDeterministically() {
        return false;
    }

    protected List<TestRule> getInnerTestRules() {
        return ImmutableList.of();
    }

    protected List<TestRule> getOuterTestRules() {
        return ImmutableList.of();
    }

    protected List<MethodRule> getInnerMethodRules() {
        return ImmutableList.of();
    }

    protected List<MethodRule> getOuterMethodRules() {
        return ImmutableList.of();
    }

    @VisibleForTesting
    public static ImmutableList<Failure> run(PluggableTestRunner testRunner) throws Exception {
        final ImmutableList.Builder failures = ImmutableList.builder();
        RunNotifier notifier = new RunNotifier();
        notifier.addFirstListener(new RunListener(){

            public void testFailure(Failure failure) throws Exception {
                failures.add((Object)failure);
            }
        });
        testRunner.run(notifier);
        return failures.build();
    }

    protected final ImmutableList<FrameworkMethod> computeTestMethods() {
        Stream<Object> processedMethods = super.computeTestMethods().stream().flatMap(method -> this.processMethod((FrameworkMethod)method).stream());
        if (this.shouldSortTestMethodsDeterministically()) {
            processedMethods = processedMethods.sorted(Comparator.comparing(method -> method.getName().hashCode()).thenComparing(FrameworkMethod::getName));
        }
        return processedMethods.collect(PluggableTestRunner.toImmutableList());
    }

    private ImmutableList<FrameworkMethod> processMethod(FrameworkMethod initialMethod) {
        ImmutableList methods = ImmutableList.of((Object)initialMethod);
        for (TestMethodProcessor testMethodProcessor : this.getTestMethodProcessors()) {
            methods = methods.stream().flatMap(method -> {
                TestInfo originalTest = TestInfo.create(method.getMethod(), method.getName(), (List<Annotation>)ImmutableList.copyOf((Object[])method.getAnnotations()));
                List<TestInfo> processedTests = testMethodProcessor.processTest(this.getTestClass().getJavaClass(), originalTest);
                return processedTests.stream().map(processedTest -> new OverriddenFrameworkMethod(method.getMethod(), (TestInfo)processedTest));
            }).collect(PluggableTestRunner.toImmutableList());
        }
        return methods;
    }

    protected final Statement methodBlock(final FrameworkMethod method) {
        Object testObject;
        try {
            testObject = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return PluggableTestRunner.this.createTestForMethod(method);
                }
            }.run();
        }
        catch (Throwable e) {
            return new Fail(e);
        }
        Statement statement = this.methodInvoker(method, testObject);
        statement = this.possiblyExpectingExceptions(method, testObject, statement);
        statement = this.withPotentialTimeout(method, testObject, statement);
        statement = this.withBefores(method, testObject, statement);
        statement = this.withAfters(method, testObject, statement);
        statement = this.withRules(method, testObject, statement);
        return statement;
    }

    protected final Statement methodInvoker(FrameworkMethod frameworkMethod, Object testObject) {
        Optional<Statement> statement = Optional.absent();
        for (TestMethodProcessor testMethodProcessor : this.getTestMethodProcessors()) {
            statement = testMethodProcessor.createStatement(this.getTestClass(), frameworkMethod, testObject, statement);
        }
        if (statement.isPresent()) {
            return (Statement)statement.get();
        }
        return super.methodInvoker(frameworkMethod, testObject);
    }

    private Statement withRules(FrameworkMethod method, Object target, Statement statement) {
        ImmutableList testRules = Stream.of(this.getTestRulesForProcessors().stream(), this.getInnerTestRules().stream(), this.getTestRules(target).stream(), this.getOuterTestRules().stream()).flatMap(x -> x).collect(PluggableTestRunner.toImmutableList());
        Iterable methodRules = Iterables.concat((Iterable)Lists.reverse(this.getInnerMethodRules()), (Iterable)this.rules(target), (Iterable)Lists.reverse(this.getOuterMethodRules()));
        for (MethodRule methodRule : methodRules) {
            if (testRules.contains((Object)methodRule)) continue;
            statement = methodRule.apply(statement, method, target);
        }
        Description testDescription = this.describeChild(method);
        for (TestRule testRule : testRules) {
            statement = testRule.apply(statement, testDescription);
        }
        return new ContextMethodRule().apply(statement, method, target);
    }

    private Object createTestForMethod(FrameworkMethod method) throws Exception {
        Optional<Object> maybeTestInstance = Optional.absent();
        for (TestMethodProcessor testMethodProcessor : this.getTestMethodProcessors()) {
            maybeTestInstance = testMethodProcessor.createTest(this.getTestClass(), method, maybeTestInstance);
        }
        Object testInstance = maybeTestInstance.isPresent() ? maybeTestInstance.get() : super.createTest();
        this.finalizeCreatedTestInstance(testInstance);
        return testInstance;
    }

    protected final void validateZeroArgConstructor(List<Throwable> errorsReturned) {
        for (TestMethodProcessor testMethodProcessor : this.getTestMethodProcessors()) {
            if (testMethodProcessor.validateConstructor(this.getTestClass(), errorsReturned) != TestMethodProcessor.ValidationResult.HANDLED) continue;
            return;
        }
        super.validateZeroArgConstructor(errorsReturned);
    }

    protected final void validateTestMethods(List<Throwable> list) {
        List testMethods = this.getTestClass().getAnnotatedMethods(Test.class);
        for (FrameworkMethod testMethod : testMethods) {
            boolean isHandled = false;
            for (TestMethodProcessor testMethodProcessor : this.getTestMethodProcessors()) {
                if (testMethodProcessor.validateTestMethod(this.getTestClass(), testMethod, list) != TestMethodProcessor.ValidationResult.HANDLED) continue;
                isHandled = true;
                break;
            }
            if (isHandled) continue;
            testMethod.validatePublicVoidNoArg(false, list);
        }
    }

    protected final void collectInitializationErrors(List<Throwable> errors) {
        super.collectInitializationErrors(errors);
        if (!errors.isEmpty()) {
            throw new RuntimeException(String.format("Found %s issues while initializing the test runner:\n\n  - %s\n\n\n", errors.size(), errors.stream().map(Throwables::getStackTraceAsString).collect(Collectors.joining("\n\n\n  - "))));
        }
    }

    protected final Object createTest() throws Exception {
        return super.createTest();
    }

    protected final void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        super.validatePublicVoidNoArgMethods(annotation, isStatic, errors);
    }

    private synchronized List<TestMethodProcessor> getTestMethodProcessors() {
        if (this.testMethodProcessors == null) {
            this.testMethodProcessors = this.createTestMethodProcessorList();
        }
        return this.testMethodProcessors;
    }

    private synchronized ImmutableList<TestRule> getTestRulesForProcessors() {
        if (this.testRules == null) {
            this.testRules = this.testMethodProcessors.stream().map(testMethodProcessor -> testMethodProcessor::processStatement).collect(PluggableTestRunner.toImmutableList());
        }
        return this.testRules;
    }

    private static <E> Collector<E, ?, ImmutableList<E>> toImmutableList() {
        return Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf);
    }

    private static class ContextMethodRule
    implements MethodRule {
        private ContextMethodRule() {
        }

        public Statement apply(final Statement statement, final FrameworkMethod method, Object o) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    currentTestInfo.set(((OverriddenFrameworkMethod)method).getTestInfo());
                    try {
                        statement.evaluate();
                    }
                    finally {
                        currentTestInfo.set(null);
                    }
                }
            };
        }
    }

    private static class OverriddenFrameworkMethod
    extends FrameworkMethod {
        private final TestInfo testInfo;

        public OverriddenFrameworkMethod(Method method, TestInfo testInfo) {
            super(method);
            this.testInfo = testInfo;
        }

        public TestInfo getTestInfo() {
            return this.testInfo;
        }

        public String getName() {
            return this.testInfo.getName();
        }

        public Annotation[] getAnnotations() {
            ImmutableList<Annotation> annotations = this.testInfo.getAnnotations();
            return annotations.toArray((Annotation[])new Annotation[0]);
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.testInfo.getAnnotation(annotationClass);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OverriddenFrameworkMethod)) {
                return false;
            }
            OverriddenFrameworkMethod other = (OverriddenFrameworkMethod)((Object)obj);
            return super.equals((Object)other) && other.testInfo.equals(this.testInfo);
        }

        public int hashCode() {
            return super.hashCode() * 37 + this.testInfo.hashCode();
        }
    }
}

