/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import com.google.protobuf.MessageLite;
import com.google.testing.junit.testparameterinjector.ParameterValueParsing;
import com.google.testing.junit.testparameterinjector.TestParameterAnnotation;
import com.google.testing.junit.testparameterinjector.TestParameterValueProvider;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.PARAMETER})
@TestParameterAnnotation(valueProvider=InternalImplementationOfThisParameter.class)
public @interface TestParameter {
    public String[] value() default {};

    public Class<? extends TestParameterValuesProvider> valuesProvider() default DefaultTestParameterValuesProvider.class;

    public static final class InternalImplementationOfThisParameter
    implements TestParameterValueProvider {
        @Override
        public List<Object> provideValues(Annotation uncastAnnotation, Optional<Class<?>> maybeParameterClass) {
            TestParameter annotation = (TestParameter)uncastAnnotation;
            Class<?> parameterClass = this.getValueType(annotation.annotationType(), maybeParameterClass);
            boolean valueIsSet = annotation.value().length > 0;
            boolean valuesProviderIsSet = !annotation.valuesProvider().equals(DefaultTestParameterValuesProvider.class);
            Preconditions.checkState((!valueIsSet || !valuesProviderIsSet ? 1 : 0) != 0, (String)"It is not allowed to specify both value and valuesProvider on annotation %s", (Object)annotation);
            if (valueIsSet) {
                return Arrays.stream(annotation.value()).map(v -> InternalImplementationOfThisParameter.parseStringValue(v, parameterClass)).collect(Collectors.toList());
            }
            if (valuesProviderIsSet) {
                return InternalImplementationOfThisParameter.getValuesFromProvider(annotation.valuesProvider());
            }
            if (Enum.class.isAssignableFrom(parameterClass)) {
                return ImmutableList.copyOf((Object[])parameterClass.asSubclass(Enum.class).getEnumConstants());
            }
            if (Primitives.wrap(parameterClass).equals(Boolean.class)) {
                return ImmutableList.of((Object)false, (Object)true);
            }
            throw new IllegalStateException(String.format("A @TestParameter without values can only be placed at an enum or a boolean, but was placed by a %s", parameterClass));
        }

        @Override
        public Class<?> getValueType(Class<? extends Annotation> annotationType, Optional<Class<?>> parameterClass) {
            return parameterClass.orElseThrow(() -> new AssertionError((Object)String.format("An empty parameter class should not be possible since @TestParameter can only target FIELD or PARAMETER, both of which are supported for annotation %s.", annotationType)));
        }

        private static Object parseStringValue(String value, Class<?> parameterClass) {
            if (parameterClass.equals(String.class)) {
                return value;
            }
            if (Enum.class.isAssignableFrom(parameterClass)) {
                return ParameterValueParsing.parseEnum(value, parameterClass);
            }
            if (MessageLite.class.isAssignableFrom(parameterClass)) {
                if (ParameterValueParsing.isValidYamlString(value)) {
                    return ParameterValueParsing.parseYamlStringToJavaType(value, parameterClass);
                }
                return ParameterValueParsing.parseTextprotoMessage(value, parameterClass);
            }
            return ParameterValueParsing.parseYamlStringToJavaType(value, parameterClass);
        }

        private static List<Object> getValuesFromProvider(Class<? extends TestParameterValuesProvider> valuesProvider) {
            try {
                Constructor<? extends TestParameterValuesProvider> constructor = valuesProvider.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return new ArrayList<Object>(constructor.newInstance(new Object[0]).provideValues());
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static class DefaultTestParameterValuesProvider
    implements TestParameterValuesProvider {
        public List<Object> provideValues() {
            return ImmutableList.of();
        }
    }

    public static interface TestParameterValuesProvider {
        public List<?> provideValues();
    }
}

