/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import com.google.testing.junit.testparameterinjector.AutoAnnotation_TestParametersMethodProcessor_TestIndexHolderFactory_create;
import com.google.testing.junit.testparameterinjector.ParameterValueParsing;
import com.google.testing.junit.testparameterinjector.TestInfo;
import com.google.testing.junit.testparameterinjector.TestMethodProcessor;
import com.google.testing.junit.testparameterinjector.TestParameters;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

class TestParametersMethodProcessor
implements TestMethodProcessor {
    private final TestClass testClass;
    private final LoadingCache<Object, ImmutableList<TestParameters.TestParametersValues>> parameterValuesByConstructorOrMethodCache = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(methodOrConstructor -> methodOrConstructor instanceof Constructor ? TestParametersMethodProcessor.toParameterValuesList(methodOrConstructor, ((Constructor)methodOrConstructor).getAnnotation(TestParameters.class), ((Constructor)methodOrConstructor).getParameters()) : TestParametersMethodProcessor.toParameterValuesList(methodOrConstructor, ((Method)methodOrConstructor).getAnnotation(TestParameters.class), ((Method)methodOrConstructor).getParameters())));

    public TestParametersMethodProcessor(TestClass testClass) {
        this.testClass = testClass;
    }

    @Override
    public TestMethodProcessor.ValidationResult validateConstructor(TestClass testClass, List<Throwable> exceptions) {
        if (testClass.getOnlyConstructor().isAnnotationPresent(TestParameters.class)) {
            try {
                this.getConstructorParameters();
            }
            catch (Throwable t) {
                exceptions.add(t);
            }
            return TestMethodProcessor.ValidationResult.HANDLED;
        }
        return TestMethodProcessor.ValidationResult.NOT_HANDLED;
    }

    @Override
    public TestMethodProcessor.ValidationResult validateTestMethod(TestClass testClass, FrameworkMethod testMethod, List<Throwable> exceptions) {
        if (testMethod.getMethod().isAnnotationPresent(TestParameters.class)) {
            try {
                this.getMethodParameters(testMethod.getMethod());
            }
            catch (Throwable t) {
                exceptions.add(t);
            }
            return TestMethodProcessor.ValidationResult.HANDLED;
        }
        return TestMethodProcessor.ValidationResult.NOT_HANDLED;
    }

    @Override
    public List<TestInfo> processTest(Class<?> clazz, TestInfo originalTest) {
        boolean constructorIsParameterized = this.testClass.getOnlyConstructor().isAnnotationPresent(TestParameters.class);
        boolean methodIsParameterized = originalTest.getMethod().isAnnotationPresent(TestParameters.class);
        if (!constructorIsParameterized && !methodIsParameterized) {
            return ImmutableList.of((Object)originalTest);
        }
        ImmutableList.Builder testInfos = ImmutableList.builder();
        ImmutableList<Optional<TestParameters.TestParametersValues>> constructorParametersList = this.getConstructorParametersOrSingleAbsentElement();
        ImmutableList<Optional<TestParameters.TestParametersValues>> methodParametersList = this.getMethodParametersOrSingleAbsentElement(originalTest.getMethod());
        for (int constructorParametersIndex = 0; constructorParametersIndex < constructorParametersList.size(); ++constructorParametersIndex) {
            Optional constructorParameters = (Optional)constructorParametersList.get(constructorParametersIndex);
            for (int methodParametersIndex = 0; methodParametersIndex < methodParametersList.size(); ++methodParametersIndex) {
                Optional methodParameters = (Optional)methodParametersList.get(methodParametersIndex);
                testInfos.add((Object)TestInfo.create(originalTest.getMethod(), TestParametersMethodProcessor.getTestName(originalTest, (Optional<TestParameters.TestParametersValues>)constructorParameters, (Optional<TestParameters.TestParametersValues>)methodParameters), (List<Annotation>)new ImmutableList.Builder().addAll(originalTest.getAnnotations()).add((Object)TestIndexHolderFactory.create(constructorParametersIndex, methodParametersIndex)).build()));
            }
        }
        return TestInfo.shortenNamesIfNecessary((List<TestInfo>)testInfos.build(), testInfo -> {
            TestIndexHolder annotation = testInfo.getAnnotation(TestIndexHolder.class);
            return TestParametersMethodProcessor.maybeAppendToTestName(TestParametersMethodProcessor.maybeAppendToTestName(originalTest.getName(), TestParametersMethodProcessor.maybeParameterIndexString(annotation.constructorParametersIndex(), constructorParametersList)), TestParametersMethodProcessor.maybeParameterIndexString(annotation.methodParametersIndex(), methodParametersList));
        });
    }

    private static Optional<String> maybeParameterIndexString(int index, ImmutableList<Optional<TestParameters.TestParametersValues>> parameterList) {
        return ((Optional)parameterList.get(index)).transform(p -> String.valueOf(index + 1));
    }

    private ImmutableList<Optional<TestParameters.TestParametersValues>> getConstructorParametersOrSingleAbsentElement() {
        return this.testClass.getOnlyConstructor().isAnnotationPresent(TestParameters.class) ? this.getConstructorParameters().stream().map(Optional::of).collect(TestParametersMethodProcessor.toImmutableList()) : ImmutableList.of((Object)Optional.absent());
    }

    private ImmutableList<Optional<TestParameters.TestParametersValues>> getMethodParametersOrSingleAbsentElement(Method method) {
        return method.isAnnotationPresent(TestParameters.class) ? this.getMethodParameters(method).stream().map(Optional::of).collect(TestParametersMethodProcessor.toImmutableList()) : ImmutableList.of((Object)Optional.absent());
    }

    private static String getTestName(TestInfo originalTest, Optional<TestParameters.TestParametersValues> constructorParameters, Optional<TestParameters.TestParametersValues> methodParameters) {
        return TestParametersMethodProcessor.maybeAppendParametersToTestName(TestParametersMethodProcessor.maybeAppendParametersToTestName(originalTest.getName(), constructorParameters), methodParameters);
    }

    private static String maybeAppendParametersToTestName(String originalTestName, Optional<TestParameters.TestParametersValues> parameters) {
        return TestParametersMethodProcessor.maybeAppendToTestName(originalTestName, (Optional<String>)parameters.transform(p -> p.name().replaceAll("\\s+", " ")));
    }

    private static String maybeAppendToTestName(String originalTestName, Optional<String> maybeSuffix) {
        if (!maybeSuffix.isPresent()) {
            return originalTestName;
        }
        String suffixName = (String)maybeSuffix.get();
        if (originalTestName.endsWith("]")) {
            return String.format("%s,%s]", originalTestName.substring(0, originalTestName.length() - 1), suffixName);
        }
        return String.format("%s[%s]", originalTestName, suffixName);
    }

    @Override
    public Statement processStatement(Statement originalStatement, Description finalTestDescription) {
        return originalStatement;
    }

    @Override
    public Optional<Object> createTest(TestClass testClass, FrameworkMethod method, Optional<Object> test) {
        if (testClass.getOnlyConstructor().isAnnotationPresent(TestParameters.class)) {
            ImmutableList<TestParameters.TestParametersValues> parameterValuesList = this.getConstructorParameters();
            TestParameters.TestParametersValues parametersValues = (TestParameters.TestParametersValues)parameterValuesList.get(((TestIndexHolder)method.getAnnotation(TestIndexHolder.class)).constructorParametersIndex());
            try {
                Constructor constructor = testClass.getOnlyConstructor();
                return Optional.of(constructor.newInstance(TestParametersMethodProcessor.toParameterArray(parametersValues, testClass.getOnlyConstructor().getParameters())));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return test;
    }

    @Override
    public Optional<Statement> createStatement(TestClass testClass, final FrameworkMethod method, final Object testObject, Optional<Statement> statement) {
        if (method.getMethod().isAnnotationPresent(TestParameters.class)) {
            ImmutableList<TestParameters.TestParametersValues> parameterValuesList = this.getMethodParameters(method.getMethod());
            final TestParameters.TestParametersValues parametersValues = (TestParameters.TestParametersValues)parameterValuesList.get(((TestIndexHolder)method.getAnnotation(TestIndexHolder.class)).methodParametersIndex());
            return Optional.of((Object)new Statement(){

                public void evaluate() throws Throwable {
                    method.invokeExplosively(testObject, TestParametersMethodProcessor.toParameterArray(parametersValues, method.getMethod().getParameters()));
                }
            });
        }
        return statement;
    }

    private ImmutableList<TestParameters.TestParametersValues> getConstructorParameters() {
        return (ImmutableList)this.parameterValuesByConstructorOrMethodCache.getUnchecked((Object)this.testClass.getOnlyConstructor());
    }

    private ImmutableList<TestParameters.TestParametersValues> getMethodParameters(Method method) {
        return (ImmutableList)this.parameterValuesByConstructorOrMethodCache.getUnchecked((Object)method);
    }

    private static ImmutableList<TestParameters.TestParametersValues> toParameterValuesList(Object methodOrConstructor, TestParameters annotation, Parameter[] invokableParameters) {
        boolean valueIsSet = annotation.value().length > 0;
        boolean valuesProviderIsSet = !annotation.valuesProvider().equals(TestParameters.DefaultTestParametersValuesProvider.class);
        Preconditions.checkState((!valueIsSet || !valuesProviderIsSet ? 1 : 0) != 0, (String)"It is not allowed to specify both value and valuesProvider on annotation %s", (Object)annotation);
        Preconditions.checkState((valueIsSet || valuesProviderIsSet ? 1 : 0) != 0, (String)"Either value or valuesProvider must be set on annotation %s", (Object)annotation);
        ImmutableList parametersList = ImmutableList.copyOf((Object[])invokableParameters);
        Preconditions.checkState((boolean)parametersList.stream().allMatch(Parameter::isNamePresent), (String)"Parameter name is not present for method or constructor: %s.  Please ensure that this test was built with the -parameters compiler option.\n\nIn Maven, you do this by adding <parameters>true</parameters> to the maven-compiler-plugin's configuration. For example:\n\n<plugin>\n  <artifactId>maven-compiler-plugin</artifactId>\n  <version>3.8.1</version>\n  <configuration>\n    <parameters>true</parameters>\n  </configuration>\n</plugin>", (Object)methodOrConstructor);
        if (valueIsSet) {
            return Arrays.stream(annotation.value()).map(yamlMap -> TestParametersMethodProcessor.toParameterValues(yamlMap, (List<Parameter>)parametersList)).collect(TestParametersMethodProcessor.toImmutableList());
        }
        return TestParametersMethodProcessor.toParameterValuesList(annotation.valuesProvider(), (List<Parameter>)parametersList);
    }

    private static ImmutableList<TestParameters.TestParametersValues> toParameterValuesList(Class<? extends TestParameters.TestParametersValuesProvider> valuesProvider, List<Parameter> parameters) {
        try {
            Constructor<? extends TestParameters.TestParametersValuesProvider> constructor = valuesProvider.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]).provideValues().stream().peek(values -> TestParametersMethodProcessor.validateThatValuesMatchParameters(values, parameters)).collect(TestParametersMethodProcessor.toImmutableList());
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void validateThatValuesMatchParameters(TestParameters.TestParametersValues testParametersValues, List<Parameter> parameters) {
        ImmutableMap parametersByName = Maps.uniqueIndex(parameters, Parameter::getName);
        Preconditions.checkState((boolean)testParametersValues.parametersMap().keySet().equals(parametersByName.keySet()), (String)"Cannot map the given TestParametersValues to parameters %s (Given TestParametersValues are %s)", (Object)parametersByName.keySet(), (Object)testParametersValues);
        testParametersValues.parametersMap().forEach((paramName, paramValue) -> {
            Class expectedClass = Primitives.wrap(((Parameter)parametersByName.get(paramName)).getType());
            if (paramValue != null) {
                Preconditions.checkState((boolean)expectedClass.isInstance(paramValue), (String)"Cannot map value '%s' (class = %s) to parameter %s (class = %s) (for TestParametersValues %s)", (Object[])new Object[]{paramValue, paramValue.getClass(), paramName, expectedClass, testParametersValues});
            }
        });
    }

    private static TestParameters.TestParametersValues toParameterValues(String yamlString, List<Parameter> parameters) {
        Object yamlMapObject = ParameterValueParsing.parseYamlStringToObject(yamlString);
        Preconditions.checkState((boolean)(yamlMapObject instanceof Map), (String)"Cannot map YAML string '%s' to parameters because it is not a mapping", (Object)yamlString);
        Map yamlMap = (Map)yamlMapObject;
        ImmutableMap parametersByName = Maps.uniqueIndex(parameters, Parameter::getName);
        Preconditions.checkState((boolean)yamlMap.keySet().equals(parametersByName.keySet()), (String)"Cannot map YAML string '%s' to parameters %s", (Object)yamlString, (Object)parametersByName.keySet());
        return TestParameters.TestParametersValues.builder().name(yamlString).addParameters(Maps.transformEntries((Map)yamlMap, (parameterName, parsedYaml) -> ParameterValueParsing.parseYamlObjectToJavaType(parsedYaml, TypeToken.of((Type)((Parameter)parametersByName.get(parameterName)).getParameterizedType())))).build();
    }

    private static Object[] toParameterArray(TestParameters.TestParametersValues parametersValues, Parameter[] parameters) {
        return Arrays.stream(parameters).map(parameter -> parametersValues.parametersMap().get(parameter.getName())).toArray();
    }

    private static <E> Collector<E, ?, ImmutableList<E>> toImmutableList() {
        return Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf);
    }

    static class TestIndexHolderFactory {
        static TestIndexHolder create(int constructorParametersIndex, int methodParametersIndex) {
            return new AutoAnnotation_TestParametersMethodProcessor_TestIndexHolderFactory_create(constructorParametersIndex, methodParametersIndex);
        }

        private TestIndexHolderFactory() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface TestIndexHolder {
        public int constructorParametersIndex();

        public int methodParametersIndex();
    }
}

