/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.bound.SourceBoundClass;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.tree.Tree;
import com.google.turbine.tree.TurbineModifier;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class CompUnitPreprocessor {
    public static ImmutableList<PreprocessedCompUnit> preprocess(List<Tree.CompUnit> units) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Tree.CompUnit unit : units) {
            result.add((Object)CompUnitPreprocessor.preprocess(unit));
        }
        return result.build();
    }

    public static PreprocessedCompUnit preprocess(Tree.CompUnit unit) {
        String packageName;
        Object decls = unit.decls();
        if (unit.pkg().isPresent()) {
            packageName = Joiner.on((char)'/').join(unit.pkg().get().name());
            if (CompUnitPreprocessor.isPackageInfo(unit)) {
                decls = Iterables.concat(decls, (Iterable)ImmutableList.of((Object)CompUnitPreprocessor.packageInfoTree(unit.pkg().get())));
            }
        } else {
            packageName = "";
        }
        ImmutableList.Builder types = ImmutableList.builder();
        for (Tree.TyDecl decl : decls) {
            ClassSymbol sym = new ClassSymbol((!packageName.isEmpty() ? packageName + "/" : "") + decl.name());
            int access = CompUnitPreprocessor.access(decl.mods(), decl.tykind());
            ImmutableMap<String, ClassSymbol> children = CompUnitPreprocessor.preprocessChildren(unit.source(), (ImmutableList.Builder<SourceBoundClass>)types, sym, decl.members(), access);
            types.add((Object)new SourceBoundClass(sym, null, children, access, decl));
        }
        return new PreprocessedCompUnit(unit.imports(), (ImmutableList<SourceBoundClass>)types.build(), unit.mod(), unit.source(), packageName);
    }

    private static boolean isPackageInfo(Tree.CompUnit unit) {
        String path = unit.source().path();
        if (path == null) {
            return false;
        }
        Path fileName = Paths.get(path, new String[0]).getFileName();
        if (fileName == null) {
            return false;
        }
        return fileName.toString().equals("package-info.java");
    }

    private static ImmutableMap<String, ClassSymbol> preprocessChildren(SourceFile source, ImmutableList.Builder<SourceBoundClass> types, ClassSymbol owner, ImmutableList<Tree> members, int enclosing) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        HashSet<String> seen = new HashSet<String>();
        for (Tree member : members) {
            if (member.kind() != Tree.Kind.TY_DECL) continue;
            Tree.TyDecl decl = (Tree.TyDecl)member;
            ClassSymbol sym = new ClassSymbol(owner.binaryName() + '$' + decl.name());
            if (!seen.add(decl.name().value())) {
                throw TurbineError.format(source, member.position(), TurbineError.ErrorKind.DUPLICATE_DECLARATION, sym);
            }
            result.put((Object)decl.name().value(), (Object)sym);
            int access = CompUnitPreprocessor.innerClassAccess(enclosing, decl);
            ImmutableMap<String, ClassSymbol> children = CompUnitPreprocessor.preprocessChildren(source, types, sym, decl.members(), access);
            types.add((Object)new SourceBoundClass(sym, owner, children, access, decl));
        }
        return result.buildOrThrow();
    }

    public static int access(ImmutableSet<TurbineModifier> mods, TurbineTyKind tykind) {
        int access = 0;
        for (TurbineModifier m : mods) {
            access |= m.flag();
        }
        switch (tykind) {
            case CLASS: {
                access |= 0x20;
                break;
            }
            case INTERFACE: {
                access |= 0x600;
                break;
            }
            case ENUM: {
                access |= 0x4030;
                break;
            }
            case ANNOTATION: {
                access |= 0x2600;
                break;
            }
            case RECORD: {
                access |= 0x30;
            }
        }
        return access;
    }

    private static int innerClassAccess(int enclosing, Tree.TyDecl decl) {
        int access = CompUnitPreprocessor.access(decl.mods(), decl.tykind());
        if ((enclosing & 0x2200) != 0) {
            access &= 0xFFFFFFF9;
            access |= 1;
        }
        switch (decl.tykind()) {
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION: 
            case RECORD: {
                access |= 8;
                break;
            }
            case CLASS: {
                if ((enclosing & 0x2200) == 0) break;
                access |= 8;
            }
        }
        return access |= enclosing & 0x800;
    }

    private static Tree.TyDecl packageInfoTree(Tree.PkgDecl pkgDecl) {
        return new Tree.TyDecl(pkgDecl.position(), (Set<TurbineModifier>)ImmutableSet.of((Object)((Object)TurbineModifier.ACC_SYNTHETIC)), pkgDecl.annos(), new Tree.Ident(pkgDecl.position(), "package-info"), (ImmutableList<Tree.TyParam>)ImmutableList.of(), Optional.empty(), (ImmutableList<Tree.ClassTy>)ImmutableList.of(), (ImmutableList<Tree.ClassTy>)ImmutableList.of(), (ImmutableList<Tree>)ImmutableList.of(), (ImmutableList<Tree.VarDecl>)ImmutableList.of(), TurbineTyKind.INTERFACE, null);
    }

    private CompUnitPreprocessor() {
    }

    public static class PreprocessedCompUnit {
        private final ImmutableList<Tree.ImportDecl> imports;
        private final ImmutableList<SourceBoundClass> types;
        private final Optional<Tree.ModDecl> module;
        private final SourceFile source;
        private final String packageName;

        public PreprocessedCompUnit(ImmutableList<Tree.ImportDecl> imports, ImmutableList<SourceBoundClass> types, Optional<Tree.ModDecl> module, SourceFile source, String packageName) {
            this.imports = imports;
            this.types = types;
            this.module = module;
            this.source = source;
            this.packageName = packageName;
        }

        public ImmutableList<Tree.ImportDecl> imports() {
            return this.imports;
        }

        public ImmutableList<SourceBoundClass> types() {
            return this.types;
        }

        Optional<Tree.ModDecl> module() {
            return this.module;
        }

        public SourceFile source() {
            return this.source;
        }

        public String packageName() {
            return this.packageName;
        }
    }
}

