/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.env;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.sym.Symbol;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public class LazyEnv<S extends Symbol, T, V extends T>
implements Env<S, V> {
    private final LinkedHashSet<S> seen = new LinkedHashSet();
    private final ImmutableMap<S, Completer<S, T, V>> completers;
    private final Map<S, @Nullable V> cache = new LinkedHashMap<S, V>();
    private final Env<S, T> rec;

    public LazyEnv(ImmutableMap<S, Completer<S, T, V>> completers, Env<S, ? extends T> base) {
        this.completers = completers;
        this.rec = CompoundEnv.of(base).append(this);
    }

    @Override
    public @Nullable V get(S sym) {
        V v = this.cache.get(sym);
        if (v != null) {
            return v;
        }
        Completer completer = (Completer)this.completers.get(sym);
        if (completer != null) {
            if (!this.seen.add(sym)) {
                throw new LazyBindingError(Joiner.on((String)" -> ").join(this.seen) + " -> " + sym);
            }
            v = completer.complete(this.rec, sym);
            this.seen.remove(sym);
            this.cache.put(sym, v);
            return v;
        }
        return null;
    }

    public static class LazyBindingError
    extends Error {
        public LazyBindingError(String message) {
            super(message);
        }
    }

    public static interface Completer<S extends Symbol, T, V extends T> {
        public @Nullable V complete(Env<S, T> var1, S var2);
    }
}

