/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.lookup;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.lookup.PackageScope;
import com.google.turbine.binder.lookup.Scope;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class SimpleTopLevelIndex
implements TopLevelIndex {
    final Node root;
    final Scope scope = new Scope(){

        @Override
        public @Nullable LookupResult lookup(LookupKey lookupKey) {
            Node curr = SimpleTopLevelIndex.this.root;
            while ((curr = curr.lookup(lookupKey.first().value())) != null) {
                if (curr.sym != null) {
                    return new LookupResult(curr.sym, lookupKey);
                }
                if (!lookupKey.hasNext()) {
                    return null;
                }
                lookupKey = lookupKey.rest();
            }
            return null;
        }
    };

    public static Builder builder() {
        return new Builder();
    }

    public static TopLevelIndex of(Iterable<ClassSymbol> syms) {
        Builder builder = SimpleTopLevelIndex.builder();
        for (ClassSymbol sym : syms) {
            builder.insert(sym);
        }
        return builder.build();
    }

    private SimpleTopLevelIndex(Node root) {
        this.root = root;
    }

    @Override
    public Scope scope() {
        return this.scope;
    }

    @Override
    public @Nullable PackageScope lookupPackage(Iterable<String> packagename) {
        Node curr = this.root;
        for (String bit : packagename) {
            if ((curr = curr.lookup(bit)) != null && curr.sym == null) continue;
            return null;
        }
        return new PackageIndex(curr);
    }

    static class PackageIndex
    implements PackageScope {
        private final Node node;
        private final Supplier<ImmutableList<ClassSymbol>> classes = Suppliers.memoize((Supplier)new Supplier<ImmutableList<ClassSymbol>>(){

            public ImmutableList<ClassSymbol> get() {
                ImmutableList.Builder result = ImmutableList.builder();
                for (Node child : node.children.values()) {
                    if (child.sym == null) continue;
                    result.add((Object)child.sym);
                }
                return result.build();
            }
        });

        public PackageIndex(Node node) {
            this.node = node;
        }

        @Override
        public @Nullable LookupResult lookup(LookupKey lookupKey) {
            Node result = this.node.lookup(lookupKey.first().value());
            if (result != null && result.sym != null) {
                return new LookupResult(result.sym, lookupKey);
            }
            return null;
        }

        @Override
        public Iterable<ClassSymbol> classes() {
            return (Iterable)this.classes.get();
        }
    }

    public static class Builder {
        final Node root = new Node(null);

        public TopLevelIndex build() {
            return new SimpleTopLevelIndex(this.root);
        }

        public void insert(ClassSymbol sym) {
            String simpleName;
            String binaryName = sym.binaryName();
            int start = 0;
            int end = binaryName.indexOf(47);
            Node curr = this.root;
            while (end != -1) {
                simpleName = binaryName.substring(start, end);
                if ((curr = curr.insert(simpleName, null)) == null) {
                    return;
                }
                start = end + 1;
                end = binaryName.indexOf(47, start);
            }
            simpleName = binaryName.substring(start);
            if ((curr = curr.insert(simpleName, sym)) == null || !Objects.equals(curr.sym, sym)) {
                return;
            }
        }
    }

    public static class Node {
        private final @Nullable ClassSymbol sym;
        private final Map<String, Node> children = new HashMap<String, Node>();

        public @Nullable Node lookup(String bit) {
            return this.children.get(bit);
        }

        Node(@Nullable ClassSymbol sym) {
            this.sym = sym;
        }

        private @Nullable Node insert(String name, @Nullable ClassSymbol sym) {
            Node child = this.children.get(name);
            if (child != null) {
                if (child.sym != null) {
                    return null;
                }
            } else {
                child = new Node(sym);
                this.children.put(name, child);
            }
            return child;
        }
    }
}

