/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.sym;

import com.google.errorprone.annotations.Immutable;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.Symbol;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@Immutable
public class MethodSymbol
implements Symbol {
    private final int idx;
    private final ClassSymbol owner;
    private final String name;

    public MethodSymbol(int idx, ClassSymbol owner, String name) {
        this.idx = idx;
        this.owner = owner;
        this.name = name;
    }

    public ClassSymbol owner() {
        return this.owner;
    }

    public String name() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.owner);
    }

    @Override
    public Symbol.Kind symKind() {
        return Symbol.Kind.METHOD;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof MethodSymbol)) {
            return false;
        }
        MethodSymbol other = (MethodSymbol)obj;
        return this.name().equals(other.name()) && this.owner().equals(other.owner()) && this.idx == other.idx;
    }

    public String toString() {
        return this.owner + "#" + this.name;
    }
}

