/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.bytecode.sig;

import com.google.common.collect.ImmutableList;
import com.google.turbine.model.TurbineConstantTypeKind;
import org.jspecify.annotations.Nullable;

public final class Sig {
    public static final TySig VOID = new TySig(){

        @Override
        public TySig.TySigKind kind() {
            return TySig.TySigKind.VOID_TY_SIG;
        }
    };

    private Sig() {
    }

    public static class MethodSig {
        private final ImmutableList<TyParamSig> tyParams;
        private final ImmutableList<TySig> params;
        private final TySig returnType;
        private final ImmutableList<TySig> exceptions;

        public MethodSig(ImmutableList<TyParamSig> tyParams, ImmutableList<TySig> params, TySig returnType, ImmutableList<TySig> exceptions) {
            this.tyParams = tyParams;
            this.params = params;
            this.returnType = returnType;
            this.exceptions = exceptions;
        }

        public ImmutableList<TyParamSig> tyParams() {
            return this.tyParams;
        }

        public TySig returnType() {
            return this.returnType;
        }

        public ImmutableList<TySig> params() {
            return this.params;
        }

        public ImmutableList<TySig> exceptions() {
            return this.exceptions;
        }
    }

    public static class BaseTySig
    extends TySig {
        private final TurbineConstantTypeKind type;

        @Override
        public TySig.TySigKind kind() {
            return TySig.TySigKind.BASE_TY_SIG;
        }

        public BaseTySig(TurbineConstantTypeKind type) {
            this.type = type;
        }

        public TurbineConstantTypeKind type() {
            return this.type;
        }
    }

    public static abstract class TySig {
        public abstract TySigKind kind();

        public static enum TySigKind {
            VOID_TY_SIG,
            BASE_TY_SIG,
            CLASS_TY_SIG,
            ARRAY_TY_SIG,
            TY_VAR_SIG,
            WILD_TY_SIG;

        }
    }

    public static class TyVarSig
    extends TySig {
        public final String name;

        public TyVarSig(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        @Override
        public TySig.TySigKind kind() {
            return TySig.TySigKind.TY_VAR_SIG;
        }
    }

    public static class ArrayTySig
    extends TySig {
        private final TySig elementType;

        public ArrayTySig(TySig elementType) {
            this.elementType = elementType;
        }

        public TySig elementType() {
            return this.elementType;
        }

        @Override
        public TySig.TySigKind kind() {
            return TySig.TySigKind.ARRAY_TY_SIG;
        }
    }

    public static class WildTyArgSig
    extends WildTySig {
        @Override
        public WildTySig.BoundKind boundKind() {
            return WildTySig.BoundKind.NONE;
        }
    }

    public static class LowerBoundTySig
    extends WildTySig {
        private final TySig bound;

        public LowerBoundTySig(TySig bound) {
            this.bound = bound;
        }

        public TySig bound() {
            return this.bound;
        }

        @Override
        public WildTySig.BoundKind boundKind() {
            return WildTySig.BoundKind.LOWER;
        }
    }

    public static class UpperBoundTySig
    extends WildTySig {
        private final TySig bound;

        public UpperBoundTySig(TySig bound) {
            this.bound = bound;
        }

        public TySig bound() {
            return this.bound;
        }

        @Override
        public WildTySig.BoundKind boundKind() {
            return WildTySig.BoundKind.UPPER;
        }
    }

    public static abstract class WildTySig
    extends TySig {
        public abstract BoundKind boundKind();

        @Override
        public TySig.TySigKind kind() {
            return TySig.TySigKind.WILD_TY_SIG;
        }

        public static enum BoundKind {
            NONE,
            LOWER,
            UPPER;

        }
    }

    public static class SimpleClassTySig {
        private final String simpleName;
        private final ImmutableList<TySig> tyArgs;

        public SimpleClassTySig(String simpleName, ImmutableList<TySig> tyArgs) {
            this.tyArgs = tyArgs;
            this.simpleName = simpleName;
        }

        public ImmutableList<TySig> tyArgs() {
            return this.tyArgs;
        }

        public String simpleName() {
            return this.simpleName;
        }
    }

    public static class ClassTySig
    extends TySig {
        private final String pkg;
        private final ImmutableList<SimpleClassTySig> classes;

        public ClassTySig(String pkg, ImmutableList<SimpleClassTySig> classes) {
            this.pkg = pkg;
            this.classes = classes;
        }

        public String pkg() {
            return this.pkg;
        }

        public ImmutableList<SimpleClassTySig> classes() {
            return this.classes;
        }

        @Override
        public TySig.TySigKind kind() {
            return TySig.TySigKind.CLASS_TY_SIG;
        }
    }

    public static class TyParamSig {
        private final String name;
        private final @Nullable TySig classBound;
        private final ImmutableList<TySig> interfaceBounds;

        public TyParamSig(String name, @Nullable TySig classBound, ImmutableList<TySig> interfaceBounds) {
            this.name = name;
            this.classBound = classBound;
            this.interfaceBounds = interfaceBounds;
        }

        public @Nullable TySig classBound() {
            return this.classBound;
        }

        public ImmutableList<TySig> interfaceBounds() {
            return this.interfaceBounds;
        }

        public String name() {
            return this.name;
        }
    }

    public static class ClassSig {
        private final ImmutableList<TyParamSig> tyParams;
        private final ClassTySig superClass;
        private final ImmutableList<ClassTySig> interfaces;

        public ClassSig(ImmutableList<TyParamSig> tyParams, ClassTySig superClass, ImmutableList<ClassTySig> interfaces) {
            this.tyParams = tyParams;
            this.superClass = superClass;
            this.interfaces = interfaces;
        }

        public ImmutableList<TyParamSig> tyParams() {
            return this.tyParams;
        }

        public ClassTySig superClass() {
            return this.superClass;
        }

        public ImmutableList<ClassTySig> interfaces() {
            return this.interfaces;
        }
    }
}

