/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.parse;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.model.TurbineConstantTypeKind;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.parse.ConstExpressionParser;
import com.google.turbine.parse.IteratorLexer;
import com.google.turbine.parse.Lexer;
import com.google.turbine.parse.SavedToken;
import com.google.turbine.parse.StreamLexer;
import com.google.turbine.parse.Token;
import com.google.turbine.parse.UnicodeEscapePreprocessor;
import com.google.turbine.parse.VariableInitializerParser;
import com.google.turbine.tree.Tree;
import com.google.turbine.tree.TurbineModifier;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public class Parser {
    private static final String CTOR_NAME = "<init>";
    private final Lexer lexer;
    private Token token;
    private int position;
    private static final ImmutableSet<TurbineModifier> ENUM_CONSTANT_MODIFIERS = ImmutableSet.of((Object)((Object)TurbineModifier.PUBLIC), (Object)((Object)TurbineModifier.STATIC), (Object)((Object)TurbineModifier.ACC_ENUM), (Object)((Object)TurbineModifier.FINAL));

    public static Tree.CompUnit parse(String source) {
        return Parser.parse(new SourceFile(null, source));
    }

    public static Tree.CompUnit parse(SourceFile source) {
        return new Parser(new StreamLexer(new UnicodeEscapePreprocessor(source))).compilationUnit();
    }

    private Parser(Lexer lexer) {
        this.lexer = lexer;
        this.token = lexer.next();
    }

    public Tree.CompUnit compilationUnit() {
        Optional<Tree.PkgDecl> pkg = Optional.empty();
        Optional<Tree.ModDecl> mod = Optional.empty();
        EnumSet<TurbineModifier> access = EnumSet.noneOf(TurbineModifier.class);
        ImmutableList.Builder imports = ImmutableList.builder();
        ImmutableList.Builder decls = ImmutableList.builder();
        ImmutableList.Builder annos = ImmutableList.builder();
        block18: while (true) {
            switch (this.token) {
                case PACKAGE: {
                    this.next();
                    pkg = Optional.of(this.packageDeclaration((ImmutableList<Tree.Anno>)annos.build()));
                    annos = ImmutableList.builder();
                    continue block18;
                }
                case IMPORT: {
                    this.next();
                    Tree.ImportDecl i = this.importDeclaration();
                    if (i == null) continue block18;
                    imports.add((Object)i);
                    continue block18;
                }
                case PUBLIC: {
                    this.next();
                    access.add(TurbineModifier.PUBLIC);
                    continue block18;
                }
                case PROTECTED: {
                    this.next();
                    access.add(TurbineModifier.PROTECTED);
                    continue block18;
                }
                case PRIVATE: {
                    this.next();
                    access.add(TurbineModifier.PRIVATE);
                    continue block18;
                }
                case STATIC: {
                    this.next();
                    access.add(TurbineModifier.STATIC);
                    continue block18;
                }
                case ABSTRACT: {
                    this.next();
                    access.add(TurbineModifier.ABSTRACT);
                    continue block18;
                }
                case FINAL: {
                    this.next();
                    access.add(TurbineModifier.FINAL);
                    continue block18;
                }
                case STRICTFP: {
                    this.next();
                    access.add(TurbineModifier.STRICTFP);
                    continue block18;
                }
                case AT: {
                    int pos = this.position;
                    this.next();
                    if (this.token == Token.INTERFACE) {
                        decls.add((Object)this.annotationDeclaration(access, (ImmutableList<Tree.Anno>)annos.build()));
                        access = EnumSet.noneOf(TurbineModifier.class);
                        annos = ImmutableList.builder();
                        continue block18;
                    }
                    annos.add((Object)this.annotation(pos));
                    continue block18;
                }
                case CLASS: {
                    decls.add((Object)this.classDeclaration(access, (ImmutableList<Tree.Anno>)annos.build()));
                    access = EnumSet.noneOf(TurbineModifier.class);
                    annos = ImmutableList.builder();
                    continue block18;
                }
                case INTERFACE: {
                    decls.add((Object)this.interfaceDeclaration(access, (ImmutableList<Tree.Anno>)annos.build()));
                    access = EnumSet.noneOf(TurbineModifier.class);
                    annos = ImmutableList.builder();
                    continue block18;
                }
                case ENUM: {
                    decls.add((Object)this.enumDeclaration(access, (ImmutableList<Tree.Anno>)annos.build()));
                    access = EnumSet.noneOf(TurbineModifier.class);
                    annos = ImmutableList.builder();
                    continue block18;
                }
                case EOF: {
                    return new Tree.CompUnit(this.position, pkg, mod, (ImmutableList<Tree.ImportDecl>)imports.build(), (ImmutableList<Tree.TyDecl>)decls.build(), this.lexer.source());
                }
                case SEMI: {
                    this.next();
                    continue block18;
                }
                case IDENT: {
                    Tree.Ident ident = this.ident();
                    if (ident.value().equals("record")) {
                        this.next();
                        decls.add((Object)this.recordDeclaration(access, (ImmutableList<Tree.Anno>)annos.build()));
                        access = EnumSet.noneOf(TurbineModifier.class);
                        annos = ImmutableList.builder();
                        continue block18;
                    }
                    if (ident.value().equals("sealed")) {
                        this.next();
                        access.add(TurbineModifier.SEALED);
                        continue block18;
                    }
                    if (ident.value().equals("non")) {
                        int start = this.position;
                        this.next();
                        this.eatNonSealed(start);
                        this.next();
                        access.add(TurbineModifier.NON_SEALED);
                        continue block18;
                    }
                    if (!access.isEmpty() || !ident.value().equals("module") && !ident.value().equals("open")) break block18;
                    boolean open = false;
                    if (ident.value().equals("open")) {
                        this.next();
                        if (this.token != Token.IDENT) {
                            throw this.error(this.token);
                        }
                        ident = this.ident();
                        open = true;
                    }
                    if (!ident.value().equals("module")) {
                        throw this.error(this.token);
                    }
                    this.next();
                    mod = Optional.of(this.moduleDeclaration(open, (ImmutableList<Tree.Anno>)annos.build()));
                    annos = ImmutableList.builder();
                    continue block18;
                }
            }
            break;
        }
        throw this.error(this.token);
    }

    private void eatNonSealed(int start) {
        this.eat(Token.MINUS);
        if (this.token != Token.IDENT) {
            throw this.error(this.token);
        }
        if (!this.ident().value().equals("sealed")) {
            throw this.error(this.token);
        }
        if (this.position != start + "non-".length()) {
            throw this.error(this.token);
        }
    }

    private void next() {
        this.token = this.lexer.next();
        this.position = this.lexer.position();
    }

    private Tree.TyDecl recordDeclaration(EnumSet<TurbineModifier> access, ImmutableList<Tree.Anno> annos) {
        String javadoc = this.lexer.javadoc();
        int pos = this.position;
        Tree.Ident name = this.eatIdent();
        ImmutableList<Tree.TyParam> typarams = this.token == Token.LT ? this.typarams() : ImmutableList.of();
        ImmutableList.Builder formals = ImmutableList.builder();
        if (this.token == Token.LPAREN) {
            this.next();
            this.formalParams((ImmutableList.Builder<Tree.VarDecl>)formals, EnumSet.noneOf(TurbineModifier.class));
            this.eat(Token.RPAREN);
        }
        ImmutableList.Builder interfaces = ImmutableList.builder();
        if (this.token == Token.IMPLEMENTS) {
            this.next();
            do {
                interfaces.add((Object)this.classty());
            } while (this.maybe(Token.COMMA));
        }
        this.eat(Token.LBRACE);
        ImmutableList<Tree> members = this.classMembers();
        this.eat(Token.RBRACE);
        return new Tree.TyDecl(pos, access, annos, name, typarams, Optional.empty(), (ImmutableList<Tree.ClassTy>)interfaces.build(), (ImmutableList<Tree.ClassTy>)ImmutableList.of(), members, (ImmutableList<Tree.VarDecl>)formals.build(), TurbineTyKind.RECORD, javadoc);
    }

    private Tree.TyDecl interfaceDeclaration(EnumSet<TurbineModifier> access, ImmutableList<Tree.Anno> annos) {
        String javadoc = this.lexer.javadoc();
        this.eat(Token.INTERFACE);
        int pos = this.position;
        Tree.Ident name = this.eatIdent();
        ImmutableList<Tree.TyParam> typarams = this.token == Token.LT ? this.typarams() : ImmutableList.of();
        ImmutableList.Builder interfaces = ImmutableList.builder();
        if (this.token == Token.EXTENDS) {
            this.next();
            do {
                interfaces.add((Object)this.classty());
            } while (this.maybe(Token.COMMA));
        }
        ImmutableList.Builder permits = ImmutableList.builder();
        if (this.token == Token.IDENT && this.ident().value().equals("permits")) {
            this.eat(Token.IDENT);
            do {
                permits.add((Object)this.classty());
            } while (this.maybe(Token.COMMA));
        }
        this.eat(Token.LBRACE);
        ImmutableList<Tree> members = this.classMembers();
        this.eat(Token.RBRACE);
        return new Tree.TyDecl(pos, access, annos, name, typarams, Optional.empty(), (ImmutableList<Tree.ClassTy>)interfaces.build(), (ImmutableList<Tree.ClassTy>)permits.build(), members, (ImmutableList<Tree.VarDecl>)ImmutableList.of(), TurbineTyKind.INTERFACE, javadoc);
    }

    private Tree.TyDecl annotationDeclaration(EnumSet<TurbineModifier> access, ImmutableList<Tree.Anno> annos) {
        String javadoc = this.lexer.javadoc();
        this.eat(Token.INTERFACE);
        int pos = this.position;
        Tree.Ident name = this.eatIdent();
        this.eat(Token.LBRACE);
        ImmutableList<Tree> members = this.classMembers();
        this.eat(Token.RBRACE);
        return new Tree.TyDecl(pos, access, annos, name, (ImmutableList<Tree.TyParam>)ImmutableList.of(), Optional.empty(), (ImmutableList<Tree.ClassTy>)ImmutableList.of(), (ImmutableList<Tree.ClassTy>)ImmutableList.of(), members, (ImmutableList<Tree.VarDecl>)ImmutableList.of(), TurbineTyKind.ANNOTATION, javadoc);
    }

    private Tree.TyDecl enumDeclaration(EnumSet<TurbineModifier> access, ImmutableList<Tree.Anno> annos) {
        String javadoc = this.lexer.javadoc();
        this.eat(Token.ENUM);
        int pos = this.position;
        Tree.Ident name = this.eatIdent();
        ImmutableList.Builder interfaces = ImmutableList.builder();
        if (this.token == Token.IMPLEMENTS) {
            this.next();
            do {
                interfaces.add((Object)this.classty());
            } while (this.maybe(Token.COMMA));
        }
        this.eat(Token.LBRACE);
        ImmutableList members = ImmutableList.builder().addAll(this.enumMembers(name)).addAll(this.classMembers()).build();
        this.eat(Token.RBRACE);
        return new Tree.TyDecl(pos, access, annos, name, (ImmutableList<Tree.TyParam>)ImmutableList.of(), Optional.empty(), (ImmutableList<Tree.ClassTy>)interfaces.build(), (ImmutableList<Tree.ClassTy>)ImmutableList.of(), (ImmutableList<Tree>)members, (ImmutableList<Tree.VarDecl>)ImmutableList.of(), TurbineTyKind.ENUM, javadoc);
    }

    private String moduleName() {
        return Parser.flatname('.', this.qualIdent());
    }

    private String packageName() {
        return Parser.flatname('/', this.qualIdent());
    }

    private Tree.ModDecl moduleDeclaration(boolean open, ImmutableList<Tree.Anno> annos) {
        int pos = this.position;
        String moduleName = this.moduleName();
        this.eat(Token.LBRACE);
        ImmutableList.Builder directives = ImmutableList.builder();
        block18: while (true) {
            switch (this.token) {
                case IDENT: {
                    String ident = this.lexer.stringValue();
                    this.next();
                    switch (ident) {
                        case "requires": {
                            directives.add((Object)this.moduleRequires());
                            break;
                        }
                        case "exports": {
                            directives.add((Object)this.moduleExports());
                            break;
                        }
                        case "opens": {
                            directives.add((Object)this.moduleOpens());
                            break;
                        }
                        case "uses": {
                            directives.add((Object)this.moduleUses());
                            break;
                        }
                        case "provides": {
                            directives.add((Object)this.moduleProvides());
                            break;
                        }
                    }
                    continue block18;
                }
                case RBRACE: {
                    break block18;
                }
                default: {
                    throw this.error(this.token);
                }
            }
            break;
        }
        this.eat(Token.RBRACE);
        return new Tree.ModDecl(pos, annos, open, moduleName, (ImmutableList<Tree.ModDirective>)directives.build());
    }

    private static String flatname(char join, ImmutableList<Tree.Ident> idents) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Tree.Ident ident : idents) {
            if (!first) {
                sb.append(join);
            }
            sb.append(ident.value());
            first = false;
        }
        return sb.toString();
    }

    private Tree.ModRequires moduleRequires() {
        int pos = this.position;
        EnumSet<TurbineModifier> access = EnumSet.noneOf(TurbineModifier.class);
        if (this.token == Token.IDENT && this.lexer.stringValue().equals("transitive")) {
            this.next();
            access.add(TurbineModifier.TRANSITIVE);
        } else if (this.token == Token.STATIC) {
            this.next();
            access.add(TurbineModifier.STATIC);
        }
        String moduleName = this.moduleName();
        this.eat(Token.SEMI);
        return new Tree.ModRequires(pos, (ImmutableSet<TurbineModifier>)ImmutableSet.copyOf(access), moduleName);
    }

    private Tree.ModExports moduleExports() {
        int pos = this.position;
        String packageName = this.packageName();
        ImmutableList.Builder moduleNames = ImmutableList.builder();
        if (this.lexer.stringValue().equals("to")) {
            this.next();
            do {
                moduleNames.add((Object)this.moduleName());
            } while (this.maybe(Token.COMMA));
        }
        this.eat(Token.SEMI);
        return new Tree.ModExports(pos, packageName, (ImmutableList<String>)moduleNames.build());
    }

    private Tree.ModOpens moduleOpens() {
        int pos = this.position;
        String packageName = this.packageName();
        ImmutableList.Builder moduleNames = ImmutableList.builder();
        if (this.lexer.stringValue().equals("to")) {
            this.next();
            do {
                String moduleName = this.moduleName();
                moduleNames.add((Object)moduleName);
            } while (this.maybe(Token.COMMA));
        }
        this.eat(Token.SEMI);
        return new Tree.ModOpens(pos, packageName, (ImmutableList<String>)moduleNames.build());
    }

    private Tree.ModUses moduleUses() {
        int pos = this.position;
        ImmutableList<Tree.Ident> uses = this.qualIdent();
        this.eat(Token.SEMI);
        return new Tree.ModUses(pos, uses);
    }

    private Tree.ModProvides moduleProvides() {
        int pos = this.position;
        ImmutableList<Tree.Ident> typeName = this.qualIdent();
        if (!this.eatIdent().value().equals("with")) {
            throw this.error(this.token);
        }
        ImmutableList.Builder implNames = ImmutableList.builder();
        do {
            ImmutableList<Tree.Ident> implName = this.qualIdent();
            implNames.add(implName);
        } while (this.maybe(Token.COMMA));
        this.eat(Token.SEMI);
        return new Tree.ModProvides(pos, typeName, (ImmutableList<ImmutableList<Tree.Ident>>)implNames.build());
    }

    private ImmutableList<Tree> enumMembers(Tree.Ident enumName) {
        ImmutableList.Builder result = ImmutableList.builder();
        ImmutableList.Builder annos = ImmutableList.builder();
        block6: while (true) {
            switch (this.token) {
                case IDENT: {
                    String javadoc = this.lexer.javadoc();
                    Tree.Ident name = this.eatIdent();
                    if (this.token == Token.LPAREN) {
                        this.dropParens();
                    }
                    if (this.token == Token.LBRACE) {
                        this.dropBlocks();
                    }
                    this.maybe(Token.COMMA);
                    result.add((Object)new Tree.VarDecl(this.position, (Set<TurbineModifier>)ENUM_CONSTANT_MODIFIERS, (ImmutableList<Tree.Anno>)annos.build(), new Tree.ClassTy(this.position, Optional.empty(), enumName, (ImmutableList<Tree.Type>)ImmutableList.of(), (ImmutableList<Tree.Anno>)ImmutableList.of()), name, Optional.empty(), javadoc));
                    annos = ImmutableList.builder();
                    continue block6;
                }
                case SEMI: {
                    this.next();
                    annos = ImmutableList.builder();
                    break block6;
                }
                case RBRACE: {
                    annos = ImmutableList.builder();
                    break block6;
                }
                case AT: {
                    int pos = this.position;
                    this.next();
                    annos.add((Object)this.annotation(pos));
                    continue block6;
                }
                default: {
                    throw this.error(this.token);
                }
            }
            break;
        }
        return result.build();
    }

    private Tree.TyDecl classDeclaration(EnumSet<TurbineModifier> access, ImmutableList<Tree.Anno> annos) {
        String javadoc = this.lexer.javadoc();
        this.eat(Token.CLASS);
        int pos = this.position;
        Tree.Ident name = this.eatIdent();
        ImmutableList<Tree.TyParam> tyParams = ImmutableList.of();
        if (this.token == Token.LT) {
            tyParams = this.typarams();
        }
        Tree.ClassTy xtnds = null;
        if (this.token == Token.EXTENDS) {
            this.next();
            xtnds = this.classty();
        }
        ImmutableList.Builder interfaces = ImmutableList.builder();
        if (this.token == Token.IMPLEMENTS) {
            this.next();
            do {
                interfaces.add((Object)this.classty());
            } while (this.maybe(Token.COMMA));
        }
        ImmutableList.Builder permits = ImmutableList.builder();
        if (this.token == Token.IDENT && this.ident().value().equals("permits")) {
            this.eat(Token.IDENT);
            do {
                permits.add((Object)this.classty());
            } while (this.maybe(Token.COMMA));
        }
        switch (this.token) {
            case LBRACE: {
                this.next();
                break;
            }
            case EXTENDS: {
                throw this.error(TurbineError.ErrorKind.EXTENDS_AFTER_IMPLEMENTS, new Object[0]);
            }
            default: {
                throw this.error(TurbineError.ErrorKind.EXPECTED_TOKEN, new Object[]{Token.LBRACE});
            }
        }
        ImmutableList<Tree> members = this.classMembers();
        this.eat(Token.RBRACE);
        return new Tree.TyDecl(pos, access, annos, name, tyParams, Optional.ofNullable(xtnds), (ImmutableList<Tree.ClassTy>)interfaces.build(), (ImmutableList<Tree.ClassTy>)permits.build(), members, (ImmutableList<Tree.VarDecl>)ImmutableList.of(), TurbineTyKind.CLASS, javadoc);
    }

    private ImmutableList<Tree> classMembers() {
        ImmutableList.Builder acc = ImmutableList.builder();
        EnumSet<TurbineModifier> access = EnumSet.noneOf(TurbineModifier.class);
        ImmutableList.Builder annos = ImmutableList.builder();
        block23: while (true) {
            switch (this.token) {
                case PUBLIC: {
                    this.next();
                    access.add(TurbineModifier.PUBLIC);
                    continue block23;
                }
                case PROTECTED: {
                    this.next();
                    access.add(TurbineModifier.PROTECTED);
                    continue block23;
                }
                case PRIVATE: {
                    this.next();
                    access.add(TurbineModifier.PRIVATE);
                    continue block23;
                }
                case STATIC: {
                    this.next();
                    access.add(TurbineModifier.STATIC);
                    continue block23;
                }
                case ABSTRACT: {
                    this.next();
                    access.add(TurbineModifier.ABSTRACT);
                    continue block23;
                }
                case FINAL: {
                    this.next();
                    access.add(TurbineModifier.FINAL);
                    continue block23;
                }
                case NATIVE: {
                    this.next();
                    access.add(TurbineModifier.NATIVE);
                    continue block23;
                }
                case SYNCHRONIZED: {
                    this.next();
                    access.add(TurbineModifier.SYNCHRONIZED);
                    continue block23;
                }
                case TRANSIENT: {
                    this.next();
                    access.add(TurbineModifier.TRANSIENT);
                    continue block23;
                }
                case VOLATILE: {
                    this.next();
                    access.add(TurbineModifier.VOLATILE);
                    continue block23;
                }
                case STRICTFP: {
                    this.next();
                    access.add(TurbineModifier.STRICTFP);
                    continue block23;
                }
                case DEFAULT: {
                    this.next();
                    access.add(TurbineModifier.DEFAULT);
                    continue block23;
                }
                case AT: {
                    int pos = this.position;
                    this.next();
                    if (this.token == Token.INTERFACE) {
                        acc.add((Object)this.annotationDeclaration(access, (ImmutableList<Tree.Anno>)annos.build()));
                        access = EnumSet.noneOf(TurbineModifier.class);
                        annos = ImmutableList.builder();
                        continue block23;
                    }
                    annos.add((Object)this.annotation(pos));
                    continue block23;
                }
                case IDENT: {
                    Tree.Ident ident = this.ident();
                    if (ident.value().equals("sealed")) {
                        this.next();
                        access.add(TurbineModifier.SEALED);
                        continue block23;
                    }
                    if (ident.value().equals("non")) {
                        int pos = this.position;
                        this.next();
                        if (this.token != Token.MINUS) {
                            acc.addAll(this.member(access, (ImmutableList<Tree.Anno>)annos.build(), (ImmutableList<Tree.TyParam>)ImmutableList.of(), pos, ident));
                            access = EnumSet.noneOf(TurbineModifier.class);
                            annos = ImmutableList.builder();
                            continue block23;
                        }
                        this.eatNonSealed(pos);
                        this.next();
                        access.add(TurbineModifier.NON_SEALED);
                        continue block23;
                    }
                    if (ident.value().equals("record")) {
                        this.eat(Token.IDENT);
                        acc.add((Object)this.recordDeclaration(access, (ImmutableList<Tree.Anno>)annos.build()));
                        access = EnumSet.noneOf(TurbineModifier.class);
                        annos = ImmutableList.builder();
                        continue block23;
                    }
                }
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case CHAR: 
                case DOUBLE: 
                case FLOAT: 
                case VOID: 
                case LT: {
                    acc.addAll(this.classMember(access, (ImmutableList<Tree.Anno>)annos.build()));
                    access = EnumSet.noneOf(TurbineModifier.class);
                    annos = ImmutableList.builder();
                    continue block23;
                }
                case LBRACE: {
                    this.dropBlocks();
                    access = EnumSet.noneOf(TurbineModifier.class);
                    annos = ImmutableList.builder();
                    continue block23;
                }
                case CLASS: {
                    acc.add((Object)this.classDeclaration(access, (ImmutableList<Tree.Anno>)annos.build()));
                    access = EnumSet.noneOf(TurbineModifier.class);
                    annos = ImmutableList.builder();
                    continue block23;
                }
                case INTERFACE: {
                    acc.add((Object)this.interfaceDeclaration(access, (ImmutableList<Tree.Anno>)annos.build()));
                    access = EnumSet.noneOf(TurbineModifier.class);
                    annos = ImmutableList.builder();
                    continue block23;
                }
                case ENUM: {
                    acc.add((Object)this.enumDeclaration(access, (ImmutableList<Tree.Anno>)annos.build()));
                    access = EnumSet.noneOf(TurbineModifier.class);
                    annos = ImmutableList.builder();
                    continue block23;
                }
                case RBRACE: {
                    return acc.build();
                }
                case SEMI: {
                    this.next();
                    continue block23;
                }
            }
            break;
        }
        throw this.error(this.token);
    }

    private ImmutableList<Tree> classMember(EnumSet<TurbineModifier> access, ImmutableList<Tree.Anno> annos) {
        ImmutableList<Tree.TyParam> typaram = ImmutableList.of();
        if (this.token == Token.LT) {
            typaram = this.typarams();
        }
        if (this.token == Token.AT) {
            annos = ImmutableList.builder().addAll(annos).addAll(this.maybeAnnos()).build();
        }
        switch (this.token) {
            case VOID: {
                Tree.VoidTy result = new Tree.VoidTy(this.position);
                this.next();
                int pos = this.position;
                Tree.Ident name = this.eatIdent();
                return this.memberRest(pos, access, (ImmutableList<Tree.Anno>)annos, typaram, result, name);
            }
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: {
                Tree.Type result = this.referenceType((ImmutableList<Tree.Anno>)ImmutableList.of());
                int pos = this.position;
                Tree.Ident name = this.eatIdent();
                return this.memberRest(pos, access, (ImmutableList<Tree.Anno>)annos, typaram, result, name);
            }
            case IDENT: {
                int pos = this.position;
                Tree.Ident ident = this.eatIdent();
                return this.member(access, (ImmutableList<Tree.Anno>)annos, typaram, pos, ident);
            }
        }
        throw this.error(this.token);
    }

    private ImmutableList<Tree> member(EnumSet<TurbineModifier> access, ImmutableList<Tree.Anno> annos, ImmutableList<Tree.TyParam> typaram, int pos, Tree.Ident ident) {
        Tree.Type result;
        switch (this.token) {
            case LPAREN: {
                Tree.Ident name = ident;
                return ImmutableList.of((Object)this.methodRest(pos, access, annos, typaram, null, name));
            }
            case LBRACE: {
                this.dropBlocks();
                Tree.Ident name = new Tree.Ident(this.position, CTOR_NAME);
                String javadoc = this.lexer.javadoc();
                access.add(TurbineModifier.COMPACT_CTOR);
                return ImmutableList.of((Object)new Tree.MethDecl(pos, access, annos, typaram, Optional.empty(), name, (ImmutableList<Tree.VarDecl>)ImmutableList.of(), (ImmutableList<Tree.ClassTy>)ImmutableList.of(), Optional.empty(), javadoc));
            }
            case IDENT: {
                Tree.ClassTy result2 = new Tree.ClassTy(this.position, Optional.empty(), ident, (ImmutableList<Tree.Type>)ImmutableList.of(), (ImmutableList<Tree.Anno>)ImmutableList.of());
                pos = this.position;
                Tree.Ident name = this.eatIdent();
                return this.memberRest(pos, access, annos, typaram, result2, name);
            }
            case AT: 
            case LBRACK: {
                result = new Tree.ClassTy(this.position, Optional.empty(), ident, (ImmutableList<Tree.Type>)ImmutableList.of(), (ImmutableList<Tree.Anno>)ImmutableList.of());
                break;
            }
            case LT: {
                result = new Tree.ClassTy(this.position, Optional.empty(), ident, this.tyargs(), (ImmutableList<Tree.Anno>)ImmutableList.of());
                break;
            }
            case DOT: {
                result = new Tree.ClassTy(this.position, Optional.empty(), ident, (ImmutableList<Tree.Type>)ImmutableList.of(), (ImmutableList<Tree.Anno>)ImmutableList.of());
                break;
            }
            default: {
                throw this.error(this.token);
            }
        }
        if (result == null) {
            throw this.error(this.token);
        }
        if (this.token == Token.DOT) {
            this.next();
            if (!((Tree)result).kind().equals((Object)Tree.Kind.CLASS_TY)) {
                throw this.error(this.token);
            }
            result = this.classty((Tree.ClassTy)result);
        }
        result = this.maybeDims(result);
        pos = this.position;
        Tree.Ident name = this.eatIdent();
        switch (this.token) {
            case LPAREN: {
                return ImmutableList.of((Object)this.methodRest(pos, access, annos, typaram, result, name));
            }
            case SEMI: 
            case LBRACK: 
            case ASSIGN: 
            case COMMA: {
                if (!typaram.isEmpty()) {
                    throw this.error(TurbineError.ErrorKind.UNEXPECTED_TYPE_PARAMETER, typaram);
                }
                return this.fieldRest(pos, access, annos, result, name);
            }
        }
        throw this.error(this.token);
    }

    private ImmutableList<Tree.Anno> maybeAnnos() {
        if (this.token != Token.AT) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        while (this.token == Token.AT) {
            int pos = this.position;
            this.next();
            builder.add((Object)this.annotation(pos));
        }
        return builder.build();
    }

    private ImmutableList<Tree> memberRest(int pos, EnumSet<TurbineModifier> access, ImmutableList<Tree.Anno> annos, ImmutableList<Tree.TyParam> typaram, Tree.Type result, Tree.Ident name) {
        switch (this.token) {
            case AT: 
            case SEMI: 
            case LBRACK: 
            case ASSIGN: 
            case COMMA: {
                if (!typaram.isEmpty()) {
                    throw this.error(TurbineError.ErrorKind.UNEXPECTED_TYPE_PARAMETER, typaram);
                }
                return this.fieldRest(pos, access, annos, result, name);
            }
            case LPAREN: {
                return ImmutableList.of((Object)this.methodRest(pos, access, annos, typaram, result, name));
            }
        }
        throw this.error(this.token);
    }

    private ImmutableList<Tree> fieldRest(int pos, EnumSet<TurbineModifier> access, ImmutableList<Tree.Anno> annos, Tree.Type baseTy, Tree.Ident name) {
        String javadoc = this.lexer.javadoc();
        ImmutableList.Builder result = ImmutableList.builder();
        VariableInitializerParser initializerParser = new VariableInitializerParser(this.token, this.lexer);
        List<List<SavedToken>> bits = initializerParser.parseInitializers();
        this.token = initializerParser.token;
        boolean first = true;
        int expressionStart = pos;
        for (List<SavedToken> bit : bits) {
            IteratorLexer lexer = new IteratorLexer(this.lexer.source(), bit.iterator());
            Parser parser = new Parser(lexer);
            if (first) {
                first = false;
            } else {
                name = parser.eatIdent();
            }
            Tree.Type ty = baseTy;
            ty = parser.extraDims(ty);
            ConstExpressionParser constExpressionParser = new ConstExpressionParser(lexer, lexer.next(), lexer.position());
            expressionStart = lexer.position();
            Tree.Expression init = constExpressionParser.expression();
            if (init != null && init.kind() == Tree.Kind.ARRAY_INIT) {
                init = null;
            }
            result.add((Object)new Tree.VarDecl(pos, access, annos, ty, name, Optional.ofNullable(init), javadoc));
        }
        if (this.token != Token.SEMI) {
            throw TurbineError.format(this.lexer.source(), expressionStart, TurbineError.ErrorKind.UNTERMINATED_EXPRESSION, new Object[0]);
        }
        this.eat(Token.SEMI);
        return result.build();
    }

    private Tree methodRest(int pos, EnumSet<TurbineModifier> access, ImmutableList<Tree.Anno> annos, ImmutableList<Tree.TyParam> typaram, Tree.Type result, Tree.Ident name) {
        String javadoc = this.lexer.javadoc();
        this.eat(Token.LPAREN);
        ImmutableList.Builder formals = ImmutableList.builder();
        this.formalParams((ImmutableList.Builder<Tree.VarDecl>)formals, access);
        this.eat(Token.RPAREN);
        result = this.extraDims(result);
        ImmutableList.Builder exceptions = ImmutableList.builder();
        if (this.token == Token.THROWS) {
            this.next();
            exceptions.addAll(this.exceptions());
        }
        Tree.Expression defaultValue = null;
        switch (this.token) {
            case SEMI: {
                this.next();
                break;
            }
            case LBRACE: {
                this.dropBlocks();
                break;
            }
            case DEFAULT: {
                ConstExpressionParser cparser = new ConstExpressionParser(this.lexer, this.lexer.next(), this.lexer.position());
                Tree expr = cparser.expression();
                this.token = cparser.token;
                if (expr == null && this.token == Token.AT) {
                    int annoPos = this.position;
                    this.next();
                    expr = this.annotation(annoPos);
                }
                if (expr == null) {
                    throw this.error(this.token);
                }
                defaultValue = expr;
                this.eat(Token.SEMI);
                break;
            }
            default: {
                throw this.error(this.token);
            }
        }
        if (result == null) {
            name = new Tree.Ident(this.position, CTOR_NAME);
        }
        return new Tree.MethDecl(pos, access, annos, typaram, Optional.ofNullable(result), name, (ImmutableList<Tree.VarDecl>)formals.build(), (ImmutableList<Tree.ClassTy>)exceptions.build(), Optional.ofNullable(defaultValue), javadoc);
    }

    private Tree.Type extraDims(Tree.Type ty) {
        return this.maybeDims(ty);
    }

    private ImmutableList<Tree.ClassTy> exceptions() {
        ImmutableList.Builder result = ImmutableList.builder();
        result.add((Object)this.classty());
        while (this.maybe(Token.COMMA)) {
            result.add((Object)this.classty());
        }
        return result.build();
    }

    private void formalParams(ImmutableList.Builder<Tree.VarDecl> builder, EnumSet<TurbineModifier> access) {
        while (this.token != Token.RPAREN) {
            Tree.VarDecl formal = this.formalParam();
            builder.add((Object)formal);
            if (formal.mods().contains((Object)TurbineModifier.VARARGS)) {
                access.add(TurbineModifier.VARARGS);
            }
            if (this.token != Token.COMMA) break;
            this.next();
        }
    }

    private Tree.VarDecl formalParam() {
        ImmutableList.Builder annos = ImmutableList.builder();
        EnumSet<TurbineModifier> access = this.modifiersAndAnnotations((ImmutableList.Builder<Tree.Anno>)annos);
        Tree.Type ty = this.referenceTypeWithoutDims((ImmutableList<Tree.Anno>)ImmutableList.of());
        ty = this.paramDims(access, ty);
        Tree.Ident name = this.identOrThis();
        while (this.token == Token.DOT) {
            this.eat(Token.DOT);
            name = this.identOrThis();
        }
        ty = this.extraDims(ty);
        return new Tree.VarDecl(this.position, access, (ImmutableList<Tree.Anno>)annos.build(), ty, name, Optional.empty(), null);
    }

    private Tree.Type paramDims(EnumSet<TurbineModifier> access, Tree.Type ty) {
        ImmutableList<Tree.Anno> typeAnnos = this.maybeAnnos();
        switch (this.token) {
            case LBRACK: {
                this.next();
                this.eat(Token.RBRACK);
                return new Tree.ArrTy(this.position, typeAnnos, this.paramDims(access, ty));
            }
            case ELLIPSIS: {
                this.next();
                access.add(TurbineModifier.VARARGS);
                return new Tree.ArrTy(this.position, typeAnnos, ty);
            }
        }
        if (!typeAnnos.isEmpty()) {
            throw this.error(this.token);
        }
        return ty;
    }

    private Tree.Ident identOrThis() {
        switch (this.token) {
            case IDENT: {
                return this.eatIdent();
            }
            case THIS: {
                int position = this.lexer.position();
                this.eat(Token.THIS);
                return new Tree.Ident(position, "this");
            }
        }
        throw this.error(this.token);
    }

    private void dropParens() {
        this.eat(Token.LPAREN);
        int depth = 1;
        while (depth > 0) {
            switch (this.token) {
                case RPAREN: {
                    --depth;
                    break;
                }
                case LPAREN: {
                    ++depth;
                    break;
                }
                case EOF: {
                    throw this.error(TurbineError.ErrorKind.UNEXPECTED_EOF, new Object[0]);
                }
            }
            this.next();
        }
    }

    private void dropBlocks() {
        this.eat(Token.LBRACE);
        int depth = 1;
        while (depth > 0) {
            switch (this.token) {
                case RBRACE: {
                    --depth;
                    break;
                }
                case LBRACE: {
                    ++depth;
                    break;
                }
                case EOF: {
                    throw this.error(TurbineError.ErrorKind.UNEXPECTED_EOF, new Object[0]);
                }
            }
            this.next();
        }
    }

    private ImmutableList<Tree.TyParam> typarams() {
        ImmutableList.Builder acc = ImmutableList.builder();
        this.eat(Token.LT);
        block4: while (true) {
            ImmutableList<Tree.Anno> annotations = this.maybeAnnos();
            int pos = this.position;
            Tree.Ident name = this.eatIdent();
            ImmutableList<Tree> bounds = ImmutableList.of();
            if (this.token == Token.EXTENDS) {
                this.next();
                bounds = this.tybounds();
            }
            acc.add((Object)new Tree.TyParam(pos, name, bounds, annotations));
            switch (this.token) {
                case COMMA: {
                    this.eat(Token.COMMA);
                    continue block4;
                }
                case GT: {
                    this.next();
                    break block4;
                }
                default: {
                    throw this.error(this.token);
                }
            }
            break;
        }
        return acc.build();
    }

    private ImmutableList<Tree> tybounds() {
        ImmutableList.Builder acc = ImmutableList.builder();
        do {
            acc.add((Object)this.classty());
        } while (this.maybe(Token.AND));
        return acc.build();
    }

    private Tree.ClassTy classty() {
        return this.classty(null);
    }

    private Tree.ClassTy classty(Tree.ClassTy ty) {
        return this.classty(ty, null);
    }

    private Tree.ClassTy classty(Tree.ClassTy ty, @Nullable ImmutableList<Tree.Anno> typeAnnos) {
        int pos = this.position;
        do {
            if (typeAnnos == null) {
                typeAnnos = this.maybeAnnos();
            }
            Tree.Ident name = this.eatIdent();
            ImmutableList<Tree.Type> tyargs = ImmutableList.of();
            if (this.token == Token.LT) {
                tyargs = this.tyargs();
            }
            ty = new Tree.ClassTy(pos, Optional.ofNullable(ty), name, tyargs, typeAnnos);
            typeAnnos = null;
        } while (this.maybe(Token.DOT));
        return ty;
    }

    private ImmutableList<Tree.Type> tyargs() {
        ImmutableList.Builder acc = ImmutableList.builder();
        this.eat(Token.LT);
        block15: do {
            ImmutableList<Tree.Anno> typeAnnos = this.maybeAnnos();
            block0 : switch (this.token) {
                case COND: {
                    this.next();
                    switch (this.token) {
                        case EXTENDS: {
                            this.next();
                            Tree.Type upper = this.referenceType(this.maybeAnnos());
                            acc.add((Object)new Tree.WildTy(this.position, typeAnnos, Optional.of(upper), Optional.empty()));
                            break block0;
                        }
                        case SUPER: {
                            this.next();
                            Tree.Type lower = this.referenceType(this.maybeAnnos());
                            acc.add((Object)new Tree.WildTy(this.position, typeAnnos, Optional.empty(), Optional.of(lower)));
                            break block0;
                        }
                        case COMMA: {
                            acc.add((Object)new Tree.WildTy(this.position, typeAnnos, Optional.empty(), Optional.empty()));
                            break block0;
                        }
                        case GT: 
                        case GTGT: 
                        case GTGTGT: {
                            acc.add((Object)new Tree.WildTy(this.position, typeAnnos, Optional.empty(), Optional.empty()));
                            break block15;
                        }
                        default: {
                            throw this.error(this.token);
                        }
                    }
                }
                case IDENT: 
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case CHAR: 
                case DOUBLE: 
                case FLOAT: {
                    acc.add((Object)this.referenceType(typeAnnos));
                    break;
                }
                default: {
                    throw this.error(this.token);
                }
            }
        } while (this.maybe(Token.COMMA));
        switch (this.token) {
            case GT: {
                this.next();
                break;
            }
            case GTGT: {
                this.token = Token.GT;
                break;
            }
            case GTGTGT: {
                this.token = Token.GTGT;
                break;
            }
            default: {
                throw this.error(this.token);
            }
        }
        return acc.build();
    }

    private Tree.Type referenceTypeWithoutDims(ImmutableList<Tree.Anno> typeAnnos) {
        switch (this.token) {
            case IDENT: {
                return this.classty(null, typeAnnos);
            }
            case BOOLEAN: {
                this.next();
                return new Tree.PrimTy(this.position, typeAnnos, TurbineConstantTypeKind.BOOLEAN);
            }
            case BYTE: {
                this.next();
                return new Tree.PrimTy(this.position, typeAnnos, TurbineConstantTypeKind.BYTE);
            }
            case SHORT: {
                this.next();
                return new Tree.PrimTy(this.position, typeAnnos, TurbineConstantTypeKind.SHORT);
            }
            case INT: {
                this.next();
                return new Tree.PrimTy(this.position, typeAnnos, TurbineConstantTypeKind.INT);
            }
            case LONG: {
                this.next();
                return new Tree.PrimTy(this.position, typeAnnos, TurbineConstantTypeKind.LONG);
            }
            case CHAR: {
                this.next();
                return new Tree.PrimTy(this.position, typeAnnos, TurbineConstantTypeKind.CHAR);
            }
            case DOUBLE: {
                this.next();
                return new Tree.PrimTy(this.position, typeAnnos, TurbineConstantTypeKind.DOUBLE);
            }
            case FLOAT: {
                this.next();
                return new Tree.PrimTy(this.position, typeAnnos, TurbineConstantTypeKind.FLOAT);
            }
        }
        throw this.error(this.token);
    }

    private Tree.Type referenceType(ImmutableList<Tree.Anno> typeAnnos) {
        Tree.Type ty = this.referenceTypeWithoutDims(typeAnnos);
        return this.maybeDims(ty);
    }

    private Tree.Type maybeDims(Tree.Type ty) {
        ImmutableList<Tree.Anno> typeAnnos = this.maybeAnnos();
        if (this.maybe(Token.LBRACK)) {
            this.eat(Token.RBRACK);
            return new Tree.ArrTy(this.position, typeAnnos, this.maybeDims(ty));
        }
        if (!typeAnnos.isEmpty()) {
            throw this.error(this.token);
        }
        return ty;
    }

    private EnumSet<TurbineModifier> modifiersAndAnnotations(ImmutableList.Builder<Tree.Anno> annos) {
        EnumSet<TurbineModifier> access = EnumSet.noneOf(TurbineModifier.class);
        block14: while (true) {
            switch (this.token) {
                case PUBLIC: {
                    this.next();
                    access.add(TurbineModifier.PUBLIC);
                    continue block14;
                }
                case PROTECTED: {
                    this.next();
                    access.add(TurbineModifier.PROTECTED);
                    continue block14;
                }
                case PRIVATE: {
                    this.next();
                    access.add(TurbineModifier.PRIVATE);
                    continue block14;
                }
                case STATIC: {
                    this.next();
                    access.add(TurbineModifier.STATIC);
                    continue block14;
                }
                case ABSTRACT: {
                    this.next();
                    access.add(TurbineModifier.ABSTRACT);
                    continue block14;
                }
                case FINAL: {
                    this.next();
                    access.add(TurbineModifier.FINAL);
                    continue block14;
                }
                case NATIVE: {
                    this.next();
                    access.add(TurbineModifier.NATIVE);
                    continue block14;
                }
                case SYNCHRONIZED: {
                    this.next();
                    access.add(TurbineModifier.SYNCHRONIZED);
                    continue block14;
                }
                case TRANSIENT: {
                    this.next();
                    access.add(TurbineModifier.TRANSIENT);
                    continue block14;
                }
                case VOLATILE: {
                    this.next();
                    access.add(TurbineModifier.VOLATILE);
                    continue block14;
                }
                case STRICTFP: {
                    this.next();
                    access.add(TurbineModifier.STRICTFP);
                    continue block14;
                }
                case AT: {
                    int pos = this.position;
                    this.next();
                    annos.add((Object)this.annotation(pos));
                    continue block14;
                }
            }
            break;
        }
        return access;
    }

    private Tree.ImportDecl importDeclaration() {
        boolean stat = this.maybe(Token.STATIC);
        int pos = this.position;
        ImmutableList.Builder type = ImmutableList.builder();
        type.add((Object)this.eatIdent());
        boolean wild = false;
        block4: while (this.maybe(Token.DOT)) {
            switch (this.token) {
                case IDENT: {
                    type.add((Object)this.eatIdent());
                    continue block4;
                }
                case MULT: {
                    this.eat(Token.MULT);
                    wild = true;
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        this.eat(Token.SEMI);
        return new Tree.ImportDecl(pos, (ImmutableList<Tree.Ident>)type.build(), stat, wild);
    }

    private Tree.PkgDecl packageDeclaration(ImmutableList<Tree.Anno> annos) {
        Tree.PkgDecl result = new Tree.PkgDecl(this.position, this.qualIdent(), annos);
        this.eat(Token.SEMI);
        return result;
    }

    private ImmutableList<Tree.Ident> qualIdent() {
        ImmutableList.Builder name = ImmutableList.builder();
        name.add((Object)this.eatIdent());
        while (this.maybe(Token.DOT)) {
            name.add((Object)this.eatIdent());
        }
        return name.build();
    }

    private Tree.Anno annotation(int pos) {
        ImmutableList<Tree.Ident> name = this.qualIdent();
        ImmutableList.Builder args = ImmutableList.builder();
        if (this.token == Token.LPAREN) {
            this.eat(Token.LPAREN);
            while (this.token != Token.RPAREN) {
                ConstExpressionParser cparser = new ConstExpressionParser(this.lexer, this.token, this.position);
                Tree.Expression arg = cparser.expression();
                if (arg == null) {
                    throw this.error(TurbineError.ErrorKind.INVALID_ANNOTATION_ARGUMENT, new Object[0]);
                }
                args.add((Object)arg);
                this.token = cparser.token;
                if (this.maybe(Token.COMMA)) continue;
                break;
            }
            this.eat(Token.RPAREN);
        }
        return new Tree.Anno(pos, name, (ImmutableList<Tree.Expression>)args.build());
    }

    private Tree.Ident ident() {
        int position = this.lexer.position();
        String value = this.lexer.stringValue();
        return new Tree.Ident(position, value);
    }

    private Tree.Ident eatIdent() {
        Tree.Ident ident = this.ident();
        this.eat(Token.IDENT);
        return ident;
    }

    private void eat(Token kind) {
        if (this.token != kind) {
            throw this.error(TurbineError.ErrorKind.EXPECTED_TOKEN, new Object[]{kind});
        }
        this.next();
    }

    @CanIgnoreReturnValue
    private boolean maybe(Token kind) {
        if (this.token == kind) {
            this.next();
            return true;
        }
        return false;
    }

    TurbineError error(Token token) {
        switch (token) {
            case IDENT: {
                return this.error(TurbineError.ErrorKind.UNEXPECTED_IDENTIFIER, this.lexer.stringValue());
            }
            case EOF: {
                return this.error(TurbineError.ErrorKind.UNEXPECTED_EOF, new Object[0]);
            }
        }
        return this.error(TurbineError.ErrorKind.UNEXPECTED_TOKEN, new Object[]{token});
    }

    private TurbineError error(TurbineError.ErrorKind kind, Object ... args) {
        return TurbineError.format(this.lexer.source(), Math.min(this.lexer.position(), this.lexer.source().source().length() - 1), kind, args);
    }
}

