/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.zip;

import com.google.common.primitives.UnsignedInts;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public final class Zip {
    static final int ZIP64_ENDSIG = 101075792;
    static final int ZIP64_LOCSIG = 117853008;
    static final int LOCHDR = 30;
    static final int CENHDR = 46;
    static final int ENDHDR = 22;
    static final int ZIP64_LOCHDR = 20;
    static final int ZIP64_ENDHDR = 56;
    static final int ENDTOT = 10;
    static final int ENDSIZ = 12;
    static final int ENDOFF = 16;
    static final int ENDCOM = 20;
    static final int CENHOW = 10;
    static final int CENLEN = 24;
    static final int CENSIZ = 20;
    static final int CENNAM = 28;
    static final int CENEXT = 30;
    static final int CENCOM = 32;
    static final int CENOFF = 42;
    static final int LOCEXT = 28;
    static final int ZIP64_ENDSIZ = 40;
    static final int ZIP64_MAGICCOUNT = 65535;
    static final long ZIP64_MAGICVAL = 0xFFFFFFFFL;

    static void checkSignature(Path path, MappedByteBuffer buf, int index, int i, int j, String name) {
        if (!Zip.isSignature(buf, index, i, j)) {
            throw new AssertionError((Object)String.format("%s: bad %s (expected: 0x%02x%02x%02x%02x, actual: 0x%08x)", path, name, i, j, 75, 80, buf.getInt(index)));
        }
    }

    static boolean isSignature(MappedByteBuffer buf, int index, int i, int j) {
        return buf.get(index) == 80 && buf.get(index + 1) == 75 && buf.get(index + 2) == i && buf.get(index + 3) == j;
    }

    private Zip() {
    }

    public static class Entry {
        private final Path path;
        private final FileChannel chan;
        private final String name;
        private final ByteBuffer cd;
        private final int cdindex;
        static final int EXTRA_FIELD_SLACK = 128;

        public Entry(Path path, FileChannel chan, String name, ByteBuffer cd, int cdindex) {
            this.path = path;
            this.chan = chan;
            this.name = name;
            this.cd = cd;
            this.cdindex = cdindex;
        }

        public String name() {
            return this.name;
        }

        public byte[] data() {
            long offset = UnsignedInts.toLong((int)this.cd.getInt(this.cdindex + 42));
            if (offset == 0xFFFFFFFFL) {
                throw new AssertionError((Object)String.format("%s: %s requires missing zip64 support, please file a bug", this.path, this.name));
            }
            char nameLength = this.cd.getChar(this.cdindex + 28);
            char extLength = this.cd.getChar(this.cdindex + 30);
            char compression = this.cd.getChar(this.cdindex + 10);
            switch (compression) {
                case '\b': {
                    return this.getBytes(offset, nameLength, extLength, UnsignedInts.toLong((int)this.cd.getInt(this.cdindex + 20)), true);
                }
                case '\u0000': {
                    return this.getBytes(offset, nameLength, extLength, UnsignedInts.toLong((int)this.cd.getInt(this.cdindex + 24)), false);
                }
            }
            throw new AssertionError((Object)String.format("unsupported compression mode: 0x%x", compression));
        }

        private byte[] getBytes(long offset, int nameLength, int cenExtLength, long size, boolean deflate) {
            if (size > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("unsupported zip entry size: " + size);
            }
            try {
                MappedByteBuffer fc = this.chan.map(FileChannel.MapMode.READ_ONLY, offset, Math.min((long)(30 + nameLength + cenExtLength) + size + 128L, this.chan.size() - offset));
                fc.order(ByteOrder.LITTLE_ENDIAN);
                Zip.checkSignature(this.path, fc, 0, 3, 4, "LOCSIG");
                char locExtLength = fc.getChar(28);
                if (locExtLength > cenExtLength + 128) {
                    fc = this.chan.map(FileChannel.MapMode.READ_ONLY, offset + 30L + (long)nameLength + (long)locExtLength, size);
                    fc.order(ByteOrder.LITTLE_ENDIAN);
                } else {
                    fc.position(30 + nameLength + locExtLength);
                    fc.limit((int)((long)(30 + nameLength + locExtLength) + size));
                }
                byte[] bytes = new byte[(int)size];
                fc.get(bytes);
                if (deflate) {
                    bytes = new InflaterInputStream(new ByteArrayInputStream(bytes), new Inflater(true)).readAllBytes();
                }
                return bytes;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    public static class ZipIterable
    implements Iterable<Entry>,
    Closeable {
        private final Path path;
        private final FileChannel chan;
        private final MappedByteBuffer cd;

        public ZipIterable(Path path) throws IOException {
            this.path = path;
            this.chan = FileChannel.open(path, StandardOpenOption.READ);
            long size = this.chan.size();
            if (size < 22L) {
                throw new ZipException("invalid zip archive");
            }
            long eocdOffset = size - 22L;
            MappedByteBuffer eocd = this.chan.map(FileChannel.MapMode.READ_ONLY, eocdOffset, 22L);
            eocd.order(ByteOrder.LITTLE_ENDIAN);
            int index = 0;
            int commentSize = 0;
            if (!Zip.isSignature(eocd, 0, 5, 6)) {
                long start = Math.max(0L, size - 22L - 65535L);
                eocd = this.chan.map(FileChannel.MapMode.READ_ONLY, start, size - start);
                eocd.order(ByteOrder.LITTLE_ENDIAN);
                index = (int)(size - start - 22L);
                while (index > 0) {
                    eocd.position(--index);
                    if (!Zip.isSignature(eocd, index, 5, 6)) continue;
                    commentSize = (int)(size - start - 22L) - index;
                    eocdOffset = start + (long)index;
                    break;
                }
            }
            Zip.checkSignature(path, eocd, index, 5, 6, "ENDSIG");
            char totalEntries = eocd.getChar(index + 10);
            long cdsize = UnsignedInts.toLong((int)eocd.getInt(index + 12));
            long cdoffset = UnsignedInts.toLong((int)eocd.getInt(index + 16));
            int actualCommentSize = eocd.getChar(index + 20);
            if (commentSize != actualCommentSize) {
                throw new ZipException(String.format("zip file comment length was %d, expected %d", commentSize, actualCommentSize));
            }
            if (totalEntries == '\uffff' || cdsize == 0xFFFFFFFFL || cdoffset == 0xFFFFFFFFL) {
                long zip64eocdOffset = size - 22L - 20L - 56L;
                long zip64cdsize = ZipIterable.zip64cdsize(this.chan, zip64eocdOffset);
                if (zip64cdsize != -1L) {
                    eocdOffset = zip64eocdOffset;
                    cdsize = zip64cdsize;
                } else {
                    MappedByteBuffer zip64loc = this.chan.map(FileChannel.MapMode.READ_ONLY, size - 22L - 20L, 20L);
                    zip64loc.order(ByteOrder.LITTLE_ENDIAN);
                    if (zip64loc.getInt(0) == 117853008 && (zip64cdsize = ZipIterable.zip64cdsize(this.chan, zip64eocdOffset = zip64loc.getLong(8))) != -1L) {
                        eocdOffset = zip64eocdOffset;
                        cdsize = zip64cdsize;
                    }
                }
            }
            this.cd = this.chan.map(FileChannel.MapMode.READ_ONLY, eocdOffset - cdsize, cdsize);
            this.cd.order(ByteOrder.LITTLE_ENDIAN);
        }

        static long zip64cdsize(FileChannel chan, long eocdOffset) throws IOException {
            MappedByteBuffer zip64eocd = chan.map(FileChannel.MapMode.READ_ONLY, eocdOffset, 56L);
            zip64eocd.order(ByteOrder.LITTLE_ENDIAN);
            if (zip64eocd.getInt(0) == 101075792) {
                return zip64eocd.getLong(40);
            }
            return -1L;
        }

        @Override
        public Iterator<Entry> iterator() {
            return new ZipIterator(this.path, this.chan, this.cd);
        }

        @Override
        public void close() throws IOException {
            this.chan.close();
        }
    }

    static class ZipIterator
    implements Iterator<Entry> {
        private final FileChannel chan;
        private final Path path;
        private int cdindex = 0;
        private final MappedByteBuffer cd;
        private final CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();

        ZipIterator(Path path, FileChannel chan, MappedByteBuffer cd) {
            this.path = path;
            this.chan = chan;
            this.cd = cd;
        }

        @Override
        public boolean hasNext() {
            return this.cdindex < this.cd.limit();
        }

        @Override
        public Entry next() {
            Zip.checkSignature(this.path, this.cd, this.cdindex, 1, 2, "CENSIG");
            char nameLength = this.cd.getChar(this.cdindex + 28);
            char extLength = this.cd.getChar(this.cdindex + 30);
            char commentLength = this.cd.getChar(this.cdindex + 32);
            Entry entry = new Entry(this.path, this.chan, this.string(this.cd, this.cdindex + 46, nameLength), this.cd, this.cdindex);
            this.cdindex += 46 + nameLength + extLength + commentLength;
            return entry;
        }

        public String string(ByteBuffer buf, int offset, int length) {
            buf = buf.duplicate();
            buf.position(offset);
            buf.limit(offset + length);
            this.decoder.reset();
            try {
                return this.decoder.decode(buf).toString();
            }
            catch (CharacterCodingException e) {
                throw new IOError(e);
            }
        }
    }
}

