/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.matchers.AutoValue_ChildMultiMatcher_MatchResult;
import com.google.errorprone.matchers.AutoValue_ChildMultiMatcher_Matchable;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.MultiMatcher;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.List;

public abstract class ChildMultiMatcher<T extends Tree, N extends Tree>
implements MultiMatcher<T, N> {
    protected final Matcher<N> nodeMatcher;
    private final ListMatcher<N> listMatcher;

    public ChildMultiMatcher(MatchType matchType, Matcher<N> nodeMatcher) {
        this.nodeMatcher = nodeMatcher;
        this.listMatcher = ListMatcher.create(matchType);
    }

    @Override
    public boolean matches(T tree, VisitorState state) {
        return this.multiMatchResult(tree, state).matches();
    }

    @Override
    public MultiMatcher.MultiMatchResult<N> multiMatchResult(T tree, VisitorState state) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Tree subnode : this.getChildNodes(tree, state)) {
            TreePath newPath = new TreePath(state.getPath(), subnode);
            result.add(Matchable.create(subnode, state.withPath(newPath)));
        }
        MatchResult<N> matchResult = this.listMatcher.matches((List<Matchable<N>>)result.build(), this.nodeMatcher);
        return MultiMatcher.MultiMatchResult.create(matchResult.matches(), matchResult.matchingNodes());
    }

    @ForOverride
    protected abstract Iterable<? extends N> getChildNodes(T var1, VisitorState var2);

    private static abstract class ListMatcher<N extends Tree> {
        private ListMatcher() {
        }

        abstract MatchResult<N> matches(List<Matchable<N>> var1, Matcher<N> var2);

        public static <N extends Tree> ListMatcher<N> create(MatchType matchType) {
            return switch (matchType) {
                default -> throw new IncompatibleClassChangeError();
                case MatchType.ALL -> new AllMatcher();
                case MatchType.AT_LEAST_ONE -> new AtLeastOneMatcher();
                case MatchType.LAST -> new LastMatcher();
            };
        }
    }

    public static enum MatchType {
        ALL,
        AT_LEAST_ONE,
        LAST;

    }

    @AutoValue
    static abstract class Matchable<T extends Tree> {
        Matchable() {
        }

        public abstract T tree();

        public abstract VisitorState state();

        public static <T extends Tree> Matchable<T> create(T tree, VisitorState state) {
            return new AutoValue_ChildMultiMatcher_Matchable<T>(tree, state);
        }
    }

    @AutoValue
    static abstract class MatchResult<T extends Tree> {
        MatchResult() {
        }

        public abstract ImmutableList<T> matchingNodes();

        public abstract boolean matches();

        public static <T extends Tree> MatchResult<T> none() {
            return MatchResult.create(ImmutableList.of(), false);
        }

        public static <T extends Tree> MatchResult<T> match(T matchingNode) {
            return MatchResult.create(ImmutableList.of(matchingNode), true);
        }

        public static <T extends Tree> MatchResult<T> match(ImmutableList<T> matchingNodes) {
            return MatchResult.create(matchingNodes, true);
        }

        private static <T extends Tree> MatchResult<T> create(List<T> matchingNode, boolean matches) {
            return new AutoValue_ChildMultiMatcher_MatchResult(ImmutableList.copyOf(matchingNode), matches);
        }
    }

    private static class LastMatcher<N extends Tree>
    extends ListMatcher<N> {
        private LastMatcher() {
        }

        @Override
        public MatchResult<N> matches(List<Matchable<N>> matchables, Matcher<N> nodeMatcher) {
            if (matchables.isEmpty()) {
                return MatchResult.none();
            }
            Matchable last = (Matchable)Iterables.getLast(matchables);
            return nodeMatcher.matches(last.tree(), last.state()) ? MatchResult.match(last.tree()) : MatchResult.none();
        }
    }

    private static class AtLeastOneMatcher<N extends Tree>
    extends ListMatcher<N> {
        private AtLeastOneMatcher() {
        }

        @Override
        public MatchResult<N> matches(List<Matchable<N>> matchables, Matcher<N> nodeMatcher) {
            ImmutableList.Builder matchingTrees = ImmutableList.builder();
            for (Matchable<N> matchable : matchables) {
                if (!nodeMatcher.matches(matchable.tree(), matchable.state())) continue;
                matchingTrees.add(matchable.tree());
            }
            ImmutableList allTheTrees = matchingTrees.build();
            return allTheTrees.isEmpty() ? MatchResult.none() : MatchResult.match(allTheTrees);
        }
    }

    private static class AllMatcher<N extends Tree>
    extends ListMatcher<N> {
        private AllMatcher() {
        }

        @Override
        public MatchResult<N> matches(List<Matchable<N>> matchables, Matcher<N> nodeMatcher) {
            ImmutableList.Builder matchingTrees = ImmutableList.builder();
            for (Matchable<N> matchable : matchables) {
                if (!nodeMatcher.matches(matchable.tree(), matchable.state())) {
                    return MatchResult.none();
                }
                matchingTrees.add(matchable.tree());
            }
            return MatchResult.match(matchingTrees.build());
        }
    }
}

