/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.scanner;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneError;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.SuppressionInfo;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Suppressible;
import com.google.errorprone.scanner.Scanner;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BindingPatternTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExportsTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.OpensTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ProvidesTree;
import com.sun.source.tree.RequiresTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.UsesTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.tree.YieldTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ErrorProneScanner
extends Scanner {
    private final Supplier<? extends Set<? extends Name>> customSuppressionAnnotations;
    private final Map<String, BugPattern.SeverityLevel> severities;
    private final ImmutableSet<BugChecker> bugCheckers;
    private final List<BugChecker.AnnotatedTypeTreeMatcher> annotatedTypeMatchers = new ArrayList<BugChecker.AnnotatedTypeTreeMatcher>();
    private final List<BugChecker.AnnotationTreeMatcher> annotationMatchers = new ArrayList<BugChecker.AnnotationTreeMatcher>();
    private final List<BugChecker.ArrayAccessTreeMatcher> arrayAccessMatchers = new ArrayList<BugChecker.ArrayAccessTreeMatcher>();
    private final List<BugChecker.ArrayTypeTreeMatcher> arrayTypeMatchers = new ArrayList<BugChecker.ArrayTypeTreeMatcher>();
    private final List<BugChecker.AssertTreeMatcher> assertMatchers = new ArrayList<BugChecker.AssertTreeMatcher>();
    private final List<BugChecker.AssignmentTreeMatcher> assignmentMatchers = new ArrayList<BugChecker.AssignmentTreeMatcher>();
    private final List<BugChecker.BinaryTreeMatcher> binaryMatchers = new ArrayList<BugChecker.BinaryTreeMatcher>();
    private final List<BugChecker.BindingPatternTreeMatcher> bindingPatternMatchers = new ArrayList<BugChecker.BindingPatternTreeMatcher>();
    private final List<BugChecker.BlockTreeMatcher> blockMatchers = new ArrayList<BugChecker.BlockTreeMatcher>();
    private final List<BugChecker.BreakTreeMatcher> breakMatchers = new ArrayList<BugChecker.BreakTreeMatcher>();
    private final List<BugChecker.CaseTreeMatcher> caseMatchers = new ArrayList<BugChecker.CaseTreeMatcher>();
    private final List<BugChecker.CatchTreeMatcher> catchMatchers = new ArrayList<BugChecker.CatchTreeMatcher>();
    private final List<BugChecker.ClassTreeMatcher> classMatchers = new ArrayList<BugChecker.ClassTreeMatcher>();
    private final List<BugChecker.CompilationUnitTreeMatcher> compilationUnitMatchers = new ArrayList<BugChecker.CompilationUnitTreeMatcher>();
    private final List<BugChecker.CompoundAssignmentTreeMatcher> compoundAssignmentMatchers = new ArrayList<BugChecker.CompoundAssignmentTreeMatcher>();
    private final List<BugChecker.ConditionalExpressionTreeMatcher> conditionalExpressionMatchers = new ArrayList<BugChecker.ConditionalExpressionTreeMatcher>();
    private final List<BugChecker.ContinueTreeMatcher> continueMatchers = new ArrayList<BugChecker.ContinueTreeMatcher>();
    private final List<BugChecker.DoWhileLoopTreeMatcher> doWhileLoopMatchers = new ArrayList<BugChecker.DoWhileLoopTreeMatcher>();
    private final List<BugChecker.EmptyStatementTreeMatcher> emptyStatementMatchers = new ArrayList<BugChecker.EmptyStatementTreeMatcher>();
    private final List<BugChecker.EnhancedForLoopTreeMatcher> enhancedForLoopMatchers = new ArrayList<BugChecker.EnhancedForLoopTreeMatcher>();
    private final List<BugChecker.ExportsTreeMatcher> exportsMatchers = new ArrayList<BugChecker.ExportsTreeMatcher>();
    private final List<BugChecker.ExpressionStatementTreeMatcher> expressionStatementMatchers = new ArrayList<BugChecker.ExpressionStatementTreeMatcher>();
    private final List<BugChecker.ForLoopTreeMatcher> forLoopMatchers = new ArrayList<BugChecker.ForLoopTreeMatcher>();
    private final List<BugChecker.IdentifierTreeMatcher> identifierMatchers = new ArrayList<BugChecker.IdentifierTreeMatcher>();
    private final List<BugChecker.IfTreeMatcher> ifMatchers = new ArrayList<BugChecker.IfTreeMatcher>();
    private final List<BugChecker.ImportTreeMatcher> importMatchers = new ArrayList<BugChecker.ImportTreeMatcher>();
    private final List<BugChecker.InstanceOfTreeMatcher> instanceOfMatchers = new ArrayList<BugChecker.InstanceOfTreeMatcher>();
    private final List<BugChecker.IntersectionTypeTreeMatcher> intersectionTypeMatchers = new ArrayList<BugChecker.IntersectionTypeTreeMatcher>();
    private final List<BugChecker.LabeledStatementTreeMatcher> labeledStatementMatchers = new ArrayList<BugChecker.LabeledStatementTreeMatcher>();
    private final List<BugChecker.LambdaExpressionTreeMatcher> lambdaExpressionMatchers = new ArrayList<BugChecker.LambdaExpressionTreeMatcher>();
    private final List<BugChecker.LiteralTreeMatcher> literalMatchers = new ArrayList<BugChecker.LiteralTreeMatcher>();
    private final List<BugChecker.MemberReferenceTreeMatcher> memberReferenceMatchers = new ArrayList<BugChecker.MemberReferenceTreeMatcher>();
    private final List<BugChecker.MemberSelectTreeMatcher> memberSelectMatchers = new ArrayList<BugChecker.MemberSelectTreeMatcher>();
    private final List<BugChecker.MethodTreeMatcher> methodMatchers = new ArrayList<BugChecker.MethodTreeMatcher>();
    private final List<BugChecker.MethodInvocationTreeMatcher> methodInvocationMatchers = new ArrayList<BugChecker.MethodInvocationTreeMatcher>();
    private final List<BugChecker.ModifiersTreeMatcher> modifiersMatchers = new ArrayList<BugChecker.ModifiersTreeMatcher>();
    private final List<BugChecker.ModuleTreeMatcher> moduleMatchers = new ArrayList<BugChecker.ModuleTreeMatcher>();
    private final List<BugChecker.NewArrayTreeMatcher> newArrayMatchers = new ArrayList<BugChecker.NewArrayTreeMatcher>();
    private final List<BugChecker.NewClassTreeMatcher> newClassMatchers = new ArrayList<BugChecker.NewClassTreeMatcher>();
    private final List<BugChecker.OpensTreeMatcher> opensMatchers = new ArrayList<BugChecker.OpensTreeMatcher>();
    private final List<BugChecker.PackageTreeMatcher> packageMatchers = new ArrayList<BugChecker.PackageTreeMatcher>();
    private final List<BugChecker.ParameterizedTypeTreeMatcher> parameterizedTypeMatchers = new ArrayList<BugChecker.ParameterizedTypeTreeMatcher>();
    private final List<BugChecker.ParenthesizedTreeMatcher> parenthesizedMatchers = new ArrayList<BugChecker.ParenthesizedTreeMatcher>();
    private final List<BugChecker.PrimitiveTypeTreeMatcher> primitiveTypeMatchers = new ArrayList<BugChecker.PrimitiveTypeTreeMatcher>();
    private final List<BugChecker.ProvidesTreeMatcher> providesMatchers = new ArrayList<BugChecker.ProvidesTreeMatcher>();
    private final List<BugChecker.RequiresTreeMatcher> requiresMatchers = new ArrayList<BugChecker.RequiresTreeMatcher>();
    private final List<BugChecker.ReturnTreeMatcher> returnMatchers = new ArrayList<BugChecker.ReturnTreeMatcher>();
    private final List<BugChecker.SwitchExpressionTreeMatcher> switchExpressionMatchers = new ArrayList<BugChecker.SwitchExpressionTreeMatcher>();
    private final List<BugChecker.SwitchTreeMatcher> switchMatchers = new ArrayList<BugChecker.SwitchTreeMatcher>();
    private final List<BugChecker.SynchronizedTreeMatcher> synchronizedMatchers = new ArrayList<BugChecker.SynchronizedTreeMatcher>();
    private final List<BugChecker.ThrowTreeMatcher> throwMatchers = new ArrayList<BugChecker.ThrowTreeMatcher>();
    private final List<BugChecker.TryTreeMatcher> tryMatchers = new ArrayList<BugChecker.TryTreeMatcher>();
    private final List<BugChecker.TypeCastTreeMatcher> typeCastMatchers = new ArrayList<BugChecker.TypeCastTreeMatcher>();
    private final List<BugChecker.TypeParameterTreeMatcher> typeParameterMatchers = new ArrayList<BugChecker.TypeParameterTreeMatcher>();
    private final List<BugChecker.UnaryTreeMatcher> unaryMatchers = new ArrayList<BugChecker.UnaryTreeMatcher>();
    private final List<BugChecker.UnionTypeTreeMatcher> unionTypeMatchers = new ArrayList<BugChecker.UnionTypeTreeMatcher>();
    private final List<BugChecker.UsesTreeMatcher> usesMatchers = new ArrayList<BugChecker.UsesTreeMatcher>();
    private final List<BugChecker.VariableTreeMatcher> variableMatchers = new ArrayList<BugChecker.VariableTreeMatcher>();
    private final List<BugChecker.WhileLoopTreeMatcher> whileLoopMatchers = new ArrayList<BugChecker.WhileLoopTreeMatcher>();
    private final List<BugChecker.WildcardTreeMatcher> wildcardMatchers = new ArrayList<BugChecker.WildcardTreeMatcher>();
    private final List<BugChecker.YieldTreeMatcher> yieldMatchers = new ArrayList<BugChecker.YieldTreeMatcher>();

    public ErrorProneScanner(BugChecker ... checkers) {
        this(Arrays.asList(checkers));
    }

    public ErrorProneScanner(Iterable<BugChecker> checkers) {
        this(checkers, (Map<String, BugPattern.SeverityLevel>)ErrorProneScanner.defaultSeverities(checkers));
    }

    public ErrorProneScanner(Iterable<BugChecker> checkers, Map<String, BugPattern.SeverityLevel> severities) {
        this.bugCheckers = ImmutableSet.copyOf(checkers);
        this.severities = severities;
        ImmutableSet.Builder annotationClassesBuilder = ImmutableSet.builder();
        for (BugChecker checker : this.bugCheckers) {
            this.registerNodeTypes(checker, (ImmutableSet.Builder<Class<? extends Annotation>>)annotationClassesBuilder);
        }
        ImmutableSet annotationClasses = annotationClassesBuilder.build();
        this.customSuppressionAnnotations = VisitorState.memoize(state -> {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Class annotation : annotationClasses) {
                builder.add((Object)state.getName(annotation.getName()));
            }
            return builder.build();
        });
    }

    private static ImmutableMap<String, BugPattern.SeverityLevel> defaultSeverities(Iterable<BugChecker> checkers) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BugChecker check : checkers) {
            builder.put((Object)check.canonicalName(), (Object)check.defaultSeverity());
        }
        return builder.buildOrThrow();
    }

    @Override
    protected Set<? extends Name> getCustomSuppressionAnnotations(VisitorState state) {
        return this.customSuppressionAnnotations.get(state);
    }

    private void registerNodeTypes(BugChecker checker, ImmutableSet.Builder<Class<? extends Annotation>> customSuppressionAnnotationClasses) {
        customSuppressionAnnotationClasses.addAll(checker.customSuppressionAnnotations());
        if (checker instanceof BugChecker.AnnotatedTypeTreeMatcher) {
            this.annotatedTypeMatchers.add((BugChecker.AnnotatedTypeTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.AnnotationTreeMatcher) {
            this.annotationMatchers.add((BugChecker.AnnotationTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ArrayAccessTreeMatcher) {
            this.arrayAccessMatchers.add((BugChecker.ArrayAccessTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ArrayTypeTreeMatcher) {
            this.arrayTypeMatchers.add((BugChecker.ArrayTypeTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.AssertTreeMatcher) {
            this.assertMatchers.add((BugChecker.AssertTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.AssignmentTreeMatcher) {
            this.assignmentMatchers.add((BugChecker.AssignmentTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.BinaryTreeMatcher) {
            this.binaryMatchers.add((BugChecker.BinaryTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.BindingPatternTreeMatcher) {
            this.bindingPatternMatchers.add((BugChecker.BindingPatternTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.BlockTreeMatcher) {
            this.blockMatchers.add((BugChecker.BlockTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.BreakTreeMatcher) {
            this.breakMatchers.add((BugChecker.BreakTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.CaseTreeMatcher) {
            this.caseMatchers.add((BugChecker.CaseTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.CatchTreeMatcher) {
            this.catchMatchers.add((BugChecker.CatchTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ClassTreeMatcher) {
            this.classMatchers.add((BugChecker.ClassTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.CompilationUnitTreeMatcher) {
            this.compilationUnitMatchers.add((BugChecker.CompilationUnitTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.CompoundAssignmentTreeMatcher) {
            this.compoundAssignmentMatchers.add((BugChecker.CompoundAssignmentTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ConditionalExpressionTreeMatcher) {
            this.conditionalExpressionMatchers.add((BugChecker.ConditionalExpressionTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ContinueTreeMatcher) {
            this.continueMatchers.add((BugChecker.ContinueTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.DoWhileLoopTreeMatcher) {
            this.doWhileLoopMatchers.add((BugChecker.DoWhileLoopTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.EmptyStatementTreeMatcher) {
            this.emptyStatementMatchers.add((BugChecker.EmptyStatementTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.EnhancedForLoopTreeMatcher) {
            this.enhancedForLoopMatchers.add((BugChecker.EnhancedForLoopTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ExportsTreeMatcher) {
            this.exportsMatchers.add((BugChecker.ExportsTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ExpressionStatementTreeMatcher) {
            this.expressionStatementMatchers.add((BugChecker.ExpressionStatementTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ForLoopTreeMatcher) {
            this.forLoopMatchers.add((BugChecker.ForLoopTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.IdentifierTreeMatcher) {
            this.identifierMatchers.add((BugChecker.IdentifierTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.IfTreeMatcher) {
            this.ifMatchers.add((BugChecker.IfTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ImportTreeMatcher) {
            this.importMatchers.add((BugChecker.ImportTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.InstanceOfTreeMatcher) {
            this.instanceOfMatchers.add((BugChecker.InstanceOfTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.IntersectionTypeTreeMatcher) {
            this.intersectionTypeMatchers.add((BugChecker.IntersectionTypeTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.LabeledStatementTreeMatcher) {
            this.labeledStatementMatchers.add((BugChecker.LabeledStatementTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.LambdaExpressionTreeMatcher) {
            this.lambdaExpressionMatchers.add((BugChecker.LambdaExpressionTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.LiteralTreeMatcher) {
            this.literalMatchers.add((BugChecker.LiteralTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.MemberReferenceTreeMatcher) {
            this.memberReferenceMatchers.add((BugChecker.MemberReferenceTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.MemberSelectTreeMatcher) {
            this.memberSelectMatchers.add((BugChecker.MemberSelectTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.MethodTreeMatcher) {
            this.methodMatchers.add((BugChecker.MethodTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.MethodInvocationTreeMatcher) {
            this.methodInvocationMatchers.add((BugChecker.MethodInvocationTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ModifiersTreeMatcher) {
            this.modifiersMatchers.add((BugChecker.ModifiersTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ModuleTreeMatcher) {
            this.moduleMatchers.add((BugChecker.ModuleTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.NewArrayTreeMatcher) {
            this.newArrayMatchers.add((BugChecker.NewArrayTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.NewClassTreeMatcher) {
            this.newClassMatchers.add((BugChecker.NewClassTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.OpensTreeMatcher) {
            this.opensMatchers.add((BugChecker.OpensTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.PackageTreeMatcher) {
            this.packageMatchers.add((BugChecker.PackageTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ParameterizedTypeTreeMatcher) {
            this.parameterizedTypeMatchers.add((BugChecker.ParameterizedTypeTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ParenthesizedTreeMatcher) {
            this.parenthesizedMatchers.add((BugChecker.ParenthesizedTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.PrimitiveTypeTreeMatcher) {
            this.primitiveTypeMatchers.add((BugChecker.PrimitiveTypeTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ProvidesTreeMatcher) {
            this.providesMatchers.add((BugChecker.ProvidesTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.RequiresTreeMatcher) {
            this.requiresMatchers.add((BugChecker.RequiresTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ReturnTreeMatcher) {
            this.returnMatchers.add((BugChecker.ReturnTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.SwitchExpressionTreeMatcher) {
            this.switchExpressionMatchers.add((BugChecker.SwitchExpressionTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.SwitchTreeMatcher) {
            this.switchMatchers.add((BugChecker.SwitchTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.SynchronizedTreeMatcher) {
            this.synchronizedMatchers.add((BugChecker.SynchronizedTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.ThrowTreeMatcher) {
            this.throwMatchers.add((BugChecker.ThrowTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.TryTreeMatcher) {
            this.tryMatchers.add((BugChecker.TryTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.TypeCastTreeMatcher) {
            this.typeCastMatchers.add((BugChecker.TypeCastTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.TypeParameterTreeMatcher) {
            this.typeParameterMatchers.add((BugChecker.TypeParameterTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.UnaryTreeMatcher) {
            this.unaryMatchers.add((BugChecker.UnaryTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.UnionTypeTreeMatcher) {
            this.unionTypeMatchers.add((BugChecker.UnionTypeTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.UsesTreeMatcher) {
            this.usesMatchers.add((BugChecker.UsesTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.VariableTreeMatcher) {
            this.variableMatchers.add((BugChecker.VariableTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.WhileLoopTreeMatcher) {
            this.whileLoopMatchers.add((BugChecker.WhileLoopTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.WildcardTreeMatcher) {
            this.wildcardMatchers.add((BugChecker.WildcardTreeMatcher)((Object)checker));
        }
        if (checker instanceof BugChecker.YieldTreeMatcher) {
            this.yieldMatchers.add((BugChecker.YieldTreeMatcher)((Object)checker));
        }
    }

    private <M extends Suppressible, T extends Tree> VisitorState processMatchers(Iterable<M> matchers, T tree, TreeProcessor<M, T> processingFunction, VisitorState oldState) {
        ErrorProneOptions errorProneOptions = oldState.errorProneOptions();
        VisitorState newState = oldState.withPath(this.getCurrentPath());
        for (Suppressible matcher : matchers) {
            SuppressionInfo.SuppressedState suppressed = this.isSuppressed(matcher, errorProneOptions, newState);
            if (suppressed != SuppressionInfo.SuppressedState.UNSUPPRESSED && !errorProneOptions.isIgnoreSuppressionAnnotations()) continue;
            try {
                AutoCloseable unused = oldState.timingSpan(matcher);
                try {
                    VisitorState stateWithSuppressionInformation = newState.withSuppression(suppressed);
                    this.reportMatch(processingFunction.process(matcher, tree, stateWithSuppressionInformation), stateWithSuppressionInformation);
                }
                finally {
                    if (unused == null) continue;
                    unused.close();
                }
            }
            catch (AssertionError | Exception t) {
                this.handleError(matcher, (Throwable)t);
            }
        }
        return newState;
    }

    @Override
    public Void visitAnnotation(AnnotationTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.annotationMatchers, tree, BugChecker.AnnotationTreeMatcher::matchAnnotation, visitorState);
        return (Void)super.visitAnnotation(tree, state);
    }

    @Override
    public Void visitAnnotatedType(AnnotatedTypeTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.annotatedTypeMatchers, tree, BugChecker.AnnotatedTypeTreeMatcher::matchAnnotatedType, visitorState);
        return (Void)super.visitAnnotatedType(tree, state);
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.arrayAccessMatchers, tree, BugChecker.ArrayAccessTreeMatcher::matchArrayAccess, visitorState);
        return (Void)super.visitArrayAccess(tree, state);
    }

    @Override
    public Void visitArrayType(ArrayTypeTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.arrayTypeMatchers, tree, BugChecker.ArrayTypeTreeMatcher::matchArrayType, visitorState);
        return (Void)super.visitArrayType(tree, state);
    }

    @Override
    public Void visitAssert(AssertTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.assertMatchers, tree, BugChecker.AssertTreeMatcher::matchAssert, visitorState);
        return (Void)super.visitAssert(tree, state);
    }

    @Override
    public Void visitAssignment(AssignmentTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.assignmentMatchers, tree, BugChecker.AssignmentTreeMatcher::matchAssignment, visitorState);
        return (Void)super.visitAssignment(tree, state);
    }

    @Override
    public Void visitBinary(BinaryTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.binaryMatchers, tree, BugChecker.BinaryTreeMatcher::matchBinary, visitorState);
        return (Void)super.visitBinary(tree, state);
    }

    @Override
    public Void visitBindingPattern(BindingPatternTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.bindingPatternMatchers, tree, BugChecker.BindingPatternTreeMatcher::matchBindingPattern, visitorState);
        return (Void)super.visitBindingPattern(tree, state);
    }

    @Override
    public Void visitBlock(BlockTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.blockMatchers, tree, BugChecker.BlockTreeMatcher::matchBlock, visitorState);
        return (Void)super.visitBlock(tree, state);
    }

    @Override
    public Void visitBreak(BreakTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.breakMatchers, tree, BugChecker.BreakTreeMatcher::matchBreak, visitorState);
        return (Void)super.visitBreak(tree, state);
    }

    @Override
    public Void visitCase(CaseTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.caseMatchers, tree, BugChecker.CaseTreeMatcher::matchCase, visitorState);
        return (Void)super.visitCase(tree, state);
    }

    @Override
    public Void visitCatch(CatchTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.catchMatchers, tree, BugChecker.CatchTreeMatcher::matchCatch, visitorState);
        return (Void)super.visitCatch(tree, state);
    }

    @Override
    public Void visitClass(ClassTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.classMatchers, tree, BugChecker.ClassTreeMatcher::matchClass, visitorState);
        return (Void)super.visitClass(tree, state);
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.compilationUnitMatchers, tree, BugChecker.CompilationUnitTreeMatcher::matchCompilationUnit, visitorState);
        return (Void)super.visitCompilationUnit(tree, state);
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.compoundAssignmentMatchers, tree, BugChecker.CompoundAssignmentTreeMatcher::matchCompoundAssignment, visitorState);
        return (Void)super.visitCompoundAssignment(tree, state);
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpressionTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.conditionalExpressionMatchers, tree, BugChecker.ConditionalExpressionTreeMatcher::matchConditionalExpression, visitorState);
        return (Void)super.visitConditionalExpression(tree, state);
    }

    @Override
    public Void visitContinue(ContinueTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.continueMatchers, tree, BugChecker.ContinueTreeMatcher::matchContinue, visitorState);
        return (Void)super.visitContinue(tree, state);
    }

    @Override
    public Void visitDoWhileLoop(DoWhileLoopTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.doWhileLoopMatchers, tree, BugChecker.DoWhileLoopTreeMatcher::matchDoWhileLoop, visitorState);
        return (Void)super.visitDoWhileLoop(tree, state);
    }

    @Override
    public Void visitEmptyStatement(EmptyStatementTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.emptyStatementMatchers, tree, BugChecker.EmptyStatementTreeMatcher::matchEmptyStatement, visitorState);
        return (Void)super.visitEmptyStatement(tree, state);
    }

    @Override
    public Void visitEnhancedForLoop(EnhancedForLoopTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.enhancedForLoopMatchers, tree, BugChecker.EnhancedForLoopTreeMatcher::matchEnhancedForLoop, visitorState);
        return (Void)super.visitEnhancedForLoop(tree, state);
    }

    @Override
    public Void visitExports(ExportsTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.exportsMatchers, tree, BugChecker.ExportsTreeMatcher::matchExports, visitorState);
        return (Void)super.visitExports(tree, state);
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatementTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.expressionStatementMatchers, tree, BugChecker.ExpressionStatementTreeMatcher::matchExpressionStatement, visitorState);
        return (Void)super.visitExpressionStatement(tree, state);
    }

    @Override
    public Void visitForLoop(ForLoopTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.forLoopMatchers, tree, BugChecker.ForLoopTreeMatcher::matchForLoop, visitorState);
        return (Void)super.visitForLoop(tree, state);
    }

    @Override
    public Void visitIdentifier(IdentifierTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.identifierMatchers, tree, BugChecker.IdentifierTreeMatcher::matchIdentifier, visitorState);
        return (Void)super.visitIdentifier(tree, state);
    }

    @Override
    public Void visitIf(IfTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.ifMatchers, tree, BugChecker.IfTreeMatcher::matchIf, visitorState);
        return (Void)super.visitIf(tree, state);
    }

    @Override
    public Void visitImport(ImportTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.importMatchers, tree, BugChecker.ImportTreeMatcher::matchImport, visitorState);
        return (Void)super.visitImport(tree, state);
    }

    @Override
    public Void visitInstanceOf(InstanceOfTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.instanceOfMatchers, tree, BugChecker.InstanceOfTreeMatcher::matchInstanceOf, visitorState);
        return (Void)super.visitInstanceOf(tree, state);
    }

    @Override
    public Void visitIntersectionType(IntersectionTypeTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.intersectionTypeMatchers, tree, BugChecker.IntersectionTypeTreeMatcher::matchIntersectionType, visitorState);
        return (Void)super.visitIntersectionType(tree, state);
    }

    @Override
    public Void visitLabeledStatement(LabeledStatementTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.labeledStatementMatchers, tree, BugChecker.LabeledStatementTreeMatcher::matchLabeledStatement, visitorState);
        return (Void)super.visitLabeledStatement(tree, state);
    }

    @Override
    public Void visitLambdaExpression(LambdaExpressionTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.lambdaExpressionMatchers, tree, BugChecker.LambdaExpressionTreeMatcher::matchLambdaExpression, visitorState);
        return (Void)super.visitLambdaExpression(tree, state);
    }

    @Override
    public Void visitLiteral(LiteralTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.literalMatchers, tree, BugChecker.LiteralTreeMatcher::matchLiteral, visitorState);
        return (Void)super.visitLiteral(tree, state);
    }

    @Override
    public Void visitMemberReference(MemberReferenceTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.memberReferenceMatchers, tree, BugChecker.MemberReferenceTreeMatcher::matchMemberReference, visitorState);
        return (Void)super.visitMemberReference(tree, state);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.memberSelectMatchers, tree, BugChecker.MemberSelectTreeMatcher::matchMemberSelect, visitorState);
        return (Void)super.visitMemberSelect(tree, state);
    }

    @Override
    public Void visitMethod(MethodTree tree, VisitorState visitorState) {
        if (ASTHelpers.isGeneratedConstructor(tree)) {
            return null;
        }
        VisitorState state = this.processMatchers(this.methodMatchers, tree, BugChecker.MethodTreeMatcher::matchMethod, visitorState);
        return (Void)super.visitMethod(tree, state);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.methodInvocationMatchers, tree, BugChecker.MethodInvocationTreeMatcher::matchMethodInvocation, visitorState);
        return (Void)super.visitMethodInvocation(tree, state);
    }

    @Override
    public Void visitModifiers(ModifiersTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.modifiersMatchers, tree, BugChecker.ModifiersTreeMatcher::matchModifiers, visitorState);
        return (Void)super.visitModifiers(tree, state);
    }

    @Override
    public Void visitModule(ModuleTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.moduleMatchers, tree, BugChecker.ModuleTreeMatcher::matchModule, visitorState);
        return (Void)super.visitModule(tree, state);
    }

    @Override
    public Void visitNewArray(NewArrayTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.newArrayMatchers, tree, BugChecker.NewArrayTreeMatcher::matchNewArray, visitorState);
        return (Void)super.visitNewArray(tree, state);
    }

    @Override
    public Void visitNewClass(NewClassTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.newClassMatchers, tree, BugChecker.NewClassTreeMatcher::matchNewClass, visitorState);
        return (Void)super.visitNewClass(tree, state);
    }

    @Override
    public Void visitOpens(OpensTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.opensMatchers, tree, BugChecker.OpensTreeMatcher::matchOpens, visitorState);
        return (Void)super.visitOpens(tree, state);
    }

    @Override
    public Void visitPackage(PackageTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.packageMatchers, tree, BugChecker.PackageTreeMatcher::matchPackage, visitorState);
        return (Void)super.visitPackage(tree, state);
    }

    @Override
    public Void visitParameterizedType(ParameterizedTypeTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.parameterizedTypeMatchers, tree, BugChecker.ParameterizedTypeTreeMatcher::matchParameterizedType, visitorState);
        return (Void)super.visitParameterizedType(tree, state);
    }

    @Override
    public Void visitParenthesized(ParenthesizedTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.parenthesizedMatchers, tree, BugChecker.ParenthesizedTreeMatcher::matchParenthesized, visitorState);
        return (Void)super.visitParenthesized(tree, state);
    }

    @Override
    public Void visitPrimitiveType(PrimitiveTypeTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.primitiveTypeMatchers, tree, BugChecker.PrimitiveTypeTreeMatcher::matchPrimitiveType, visitorState);
        return (Void)super.visitPrimitiveType(tree, state);
    }

    @Override
    public Void visitProvides(ProvidesTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.providesMatchers, tree, BugChecker.ProvidesTreeMatcher::matchProvides, visitorState);
        return (Void)super.visitProvides(tree, state);
    }

    @Override
    public Void visitRequires(RequiresTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.requiresMatchers, tree, BugChecker.RequiresTreeMatcher::matchRequires, visitorState);
        return (Void)super.visitRequires(tree, state);
    }

    @Override
    public Void visitReturn(ReturnTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.returnMatchers, tree, BugChecker.ReturnTreeMatcher::matchReturn, visitorState);
        return (Void)super.visitReturn(tree, state);
    }

    @Override
    public Void visitSwitchExpression(SwitchExpressionTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.switchExpressionMatchers, tree, BugChecker.SwitchExpressionTreeMatcher::matchSwitchExpression, visitorState);
        return (Void)super.visitSwitchExpression(tree, state);
    }

    @Override
    public Void visitSwitch(SwitchTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.switchMatchers, tree, BugChecker.SwitchTreeMatcher::matchSwitch, visitorState);
        return (Void)super.visitSwitch(tree, state);
    }

    @Override
    public Void visitSynchronized(SynchronizedTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.synchronizedMatchers, tree, BugChecker.SynchronizedTreeMatcher::matchSynchronized, visitorState);
        return (Void)super.visitSynchronized(tree, state);
    }

    @Override
    public Void visitThrow(ThrowTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.throwMatchers, tree, BugChecker.ThrowTreeMatcher::matchThrow, visitorState);
        return (Void)super.visitThrow(tree, state);
    }

    @Override
    public Void visitTry(TryTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.tryMatchers, tree, BugChecker.TryTreeMatcher::matchTry, visitorState);
        return (Void)super.visitTry(tree, state);
    }

    @Override
    public Void visitTypeCast(TypeCastTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.typeCastMatchers, tree, BugChecker.TypeCastTreeMatcher::matchTypeCast, visitorState);
        return (Void)super.visitTypeCast(tree, state);
    }

    @Override
    public Void visitTypeParameter(TypeParameterTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.typeParameterMatchers, tree, BugChecker.TypeParameterTreeMatcher::matchTypeParameter, visitorState);
        return (Void)super.visitTypeParameter(tree, state);
    }

    @Override
    public Void visitUnary(UnaryTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.unaryMatchers, tree, BugChecker.UnaryTreeMatcher::matchUnary, visitorState);
        return (Void)super.visitUnary(tree, state);
    }

    @Override
    public Void visitUnionType(UnionTypeTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.unionTypeMatchers, tree, BugChecker.UnionTypeTreeMatcher::matchUnionType, visitorState);
        return (Void)super.visitUnionType(tree, state);
    }

    @Override
    public Void visitUses(UsesTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.usesMatchers, tree, BugChecker.UsesTreeMatcher::matchUses, visitorState);
        return (Void)super.visitUses(tree, state);
    }

    @Override
    public Void visitVariable(VariableTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.variableMatchers, tree, BugChecker.VariableTreeMatcher::matchVariable, visitorState);
        return (Void)super.visitVariable(tree, state);
    }

    @Override
    public Void visitWhileLoop(WhileLoopTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.whileLoopMatchers, tree, BugChecker.WhileLoopTreeMatcher::matchWhileLoop, visitorState);
        return (Void)super.visitWhileLoop(tree, state);
    }

    @Override
    public Void visitWildcard(WildcardTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.wildcardMatchers, tree, BugChecker.WildcardTreeMatcher::matchWildcard, visitorState);
        return (Void)super.visitWildcard(tree, state);
    }

    @Override
    public Void visitYield(YieldTree tree, VisitorState visitorState) {
        VisitorState state = this.processMatchers(this.yieldMatchers, tree, BugChecker.YieldTreeMatcher::matchYield, visitorState);
        return (Void)super.visitYield(tree, state);
    }

    @Override
    protected void handleError(Suppressible s, Throwable t) {
        if (t instanceof ErrorProneError) {
            throw (ErrorProneError)t;
        }
        if (t instanceof Symbol.CompletionFailure) {
            throw (Symbol.CompletionFailure)t;
        }
        TreePath path = this.getCurrentPath();
        throw new ErrorProneError(s.canonicalName(), t, (JCDiagnostic.DiagnosticPosition)((Object)path.getLeaf()), path.getCompilationUnit().getSourceFile());
    }

    @Override
    public Map<String, BugPattern.SeverityLevel> severityMap() {
        return this.severities;
    }

    public ImmutableSet<BugChecker> getBugCheckers() {
        return this.bugCheckers;
    }

    @FunctionalInterface
    private static interface TreeProcessor<M extends Suppressible, T extends Tree> {
        public Description process(M var1, T var2, VisitorState var3);
    }
}

