/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.sun.source.tree.Tree;

public enum OperatorPrecedence {
    POSTFIX(13),
    UNARY(12),
    MULTIPLICATIVE(11),
    ADDITIVE(10),
    SHIFT(9),
    RELATIONAL(8),
    EQUALITY(7),
    AND(6),
    XOR(5),
    OR(4),
    CONDITIONAL_AND(3),
    CONDITIONAL_OR(2),
    TERNARY(1),
    ASSIGNMENT(0);

    private final int precedence;

    private OperatorPrecedence(int precedence) {
        this.precedence = precedence;
    }

    public boolean isHigher(OperatorPrecedence other) {
        return this.precedence > other.precedence;
    }

    public static OperatorPrecedence from(Tree.Kind kind) {
        return switch (kind) {
            case Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT -> POSTFIX;
            case Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT -> UNARY;
            case Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE, Tree.Kind.REMAINDER -> MULTIPLICATIVE;
            case Tree.Kind.PLUS, Tree.Kind.MINUS -> ADDITIVE;
            case Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT, Tree.Kind.LEFT_SHIFT -> SHIFT;
            case Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_EQUAL, Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_EQUAL, Tree.Kind.INSTANCE_OF -> RELATIONAL;
            case Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO -> EQUALITY;
            case Tree.Kind.AND -> AND;
            case Tree.Kind.XOR -> XOR;
            case Tree.Kind.OR -> OR;
            case Tree.Kind.CONDITIONAL_AND -> CONDITIONAL_AND;
            case Tree.Kind.CONDITIONAL_OR -> CONDITIONAL_OR;
            case Tree.Kind.ASSIGNMENT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT -> ASSIGNMENT;
            default -> throw new IllegalArgumentException("Unexpected operator kind: " + kind);
        };
    }
}

