/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.InstructionUtil;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.evaluation.BranchUnit;
import proguard.evaluation.ClassConstantValueFactory;
import proguard.evaluation.ConstantValueFactory;
import proguard.evaluation.InvocationUnit;
import proguard.evaluation.Stack;
import proguard.evaluation.Variables;
import proguard.evaluation.exception.ArrayIndexOutOfBounds;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;

public class Processor
implements InstructionVisitor {
    private final Variables variables;
    private final Stack stack;
    private final ValueFactory valueFactory;
    private final BranchUnit branchUnit;
    private final InvocationUnit invocationUnit;
    private final boolean alwaysCast;
    private final ConstantValueFactory constantValueFactory;
    private final ClassConstantValueFactory classConstantValueFactory;

    public Processor(Variables variables, Stack stack, ValueFactory valueFactory, BranchUnit branchUnit, InvocationUnit invocationUnit, boolean alwaysCast) {
        this.variables = variables;
        this.stack = stack;
        this.valueFactory = valueFactory;
        this.branchUnit = branchUnit;
        this.invocationUnit = invocationUnit;
        this.alwaysCast = alwaysCast;
        this.constantValueFactory = new ConstantValueFactory(valueFactory);
        this.classConstantValueFactory = new ClassConstantValueFactory(valueFactory);
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case 0: {
                break;
            }
            case 1: {
                this.stack.push(this.valueFactory.createReferenceValueNull());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                this.stack.push(this.valueFactory.createIntegerValue(simpleInstruction.constant));
                break;
            }
            case 9: 
            case 10: {
                this.stack.push(this.valueFactory.createLongValue(simpleInstruction.constant));
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.stack.push(this.valueFactory.createFloatValue(simpleInstruction.constant));
                break;
            }
            case 14: 
            case 15: {
                this.stack.push(this.valueFactory.createDoubleValue(simpleInstruction.constant));
                break;
            }
            case 46: 
            case 51: 
            case 52: 
            case 53: {
                IntegerValue arrayIndex = this.stack.ipop();
                ReferenceValue arrayReference = this.stack.apop();
                try {
                    this.stack.push(arrayReference.integerArrayLoad(arrayIndex, this.valueFactory));
                }
                catch (ArrayIndexOutOfBounds e) {
                    this.stack.push(this.valueFactory.createIntegerValue());
                    this.handleArrayException(arrayReference, arrayReference);
                }
                break;
            }
            case 47: {
                IntegerValue arrayIndex = this.stack.ipop();
                ReferenceValue arrayReference = this.stack.apop();
                try {
                    this.stack.push(arrayReference.longArrayLoad(arrayIndex, this.valueFactory));
                }
                catch (ArrayIndexOutOfBounds e) {
                    this.stack.push(this.valueFactory.createLongValue());
                    this.handleArrayException(arrayReference, arrayReference);
                }
                break;
            }
            case 48: {
                IntegerValue arrayIndex = this.stack.ipop();
                ReferenceValue arrayReference = this.stack.apop();
                try {
                    this.stack.push(arrayReference.floatArrayLoad(arrayIndex, this.valueFactory));
                }
                catch (ArrayIndexOutOfBounds e) {
                    this.stack.push(this.valueFactory.createFloatValue());
                    this.handleArrayException(arrayReference, arrayReference);
                }
                break;
            }
            case 49: {
                IntegerValue arrayIndex = this.stack.ipop();
                ReferenceValue arrayReference = this.stack.apop();
                try {
                    this.stack.push(arrayReference.doubleArrayLoad(arrayIndex, this.valueFactory));
                }
                catch (ArrayIndexOutOfBounds e) {
                    this.stack.push(this.valueFactory.createDoubleValue());
                    this.handleArrayException(arrayReference, arrayReference);
                }
                break;
            }
            case 50: {
                IntegerValue arrayIndex = this.stack.ipop();
                ReferenceValue arrayReference = this.stack.apop();
                try {
                    this.stack.push(arrayReference.referenceArrayLoad(arrayIndex, this.valueFactory));
                }
                catch (ArrayIndexOutOfBounds e) {
                    this.stack.push(this.valueFactory.createReferenceValue());
                    this.handleArrayException(arrayReference, arrayReference);
                }
                break;
            }
            case 79: 
            case 84: 
            case 85: 
            case 86: {
                IntegerValue value = this.stack.ipop();
                IntegerValue arrayIndex = this.stack.ipop();
                ReferenceValue arrayReference = this.stack.apop();
                this.arrayStore(arrayReference, arrayIndex, value);
                break;
            }
            case 80: {
                LongValue value = this.stack.lpop();
                IntegerValue arrayIndex = this.stack.ipop();
                ReferenceValue arrayReference = this.stack.apop();
                this.arrayStore(arrayReference, arrayIndex, value);
                break;
            }
            case 81: {
                FloatValue value = this.stack.fpop();
                IntegerValue arrayIndex = this.stack.ipop();
                ReferenceValue arrayReference = this.stack.apop();
                this.arrayStore(arrayReference, arrayIndex, value);
                break;
            }
            case 82: {
                DoubleValue value = this.stack.dpop();
                IntegerValue arrayIndex = this.stack.ipop();
                ReferenceValue arrayReference = this.stack.apop();
                this.arrayStore(arrayReference, arrayIndex, value);
                break;
            }
            case 83: {
                ReferenceValue value = this.stack.apop();
                IntegerValue arrayIndex = this.stack.ipop();
                ReferenceValue arrayReference = this.stack.apop();
                this.arrayStore(arrayReference, arrayIndex, value);
                break;
            }
            case 87: {
                this.stack.pop1();
                break;
            }
            case 88: {
                this.stack.pop2();
                break;
            }
            case 89: {
                this.stack.dup();
                break;
            }
            case 90: {
                this.stack.dup_x1();
                break;
            }
            case 91: {
                this.stack.dup_x2();
                break;
            }
            case 92: {
                this.stack.dup2();
                break;
            }
            case 93: {
                this.stack.dup2_x1();
                break;
            }
            case 94: {
                this.stack.dup2_x2();
                break;
            }
            case 95: {
                this.stack.swap();
                break;
            }
            case 96: {
                this.stack.push(this.stack.ipop().add(this.stack.ipop()));
                break;
            }
            case 97: {
                this.stack.push(this.stack.lpop().add(this.stack.lpop()));
                break;
            }
            case 98: {
                this.stack.push(this.stack.fpop().add(this.stack.fpop()));
                break;
            }
            case 99: {
                this.stack.push(this.stack.dpop().add(this.stack.dpop()));
                break;
            }
            case 100: {
                this.stack.push(this.stack.ipop().subtractFrom(this.stack.ipop()));
                break;
            }
            case 101: {
                this.stack.push(this.stack.lpop().subtractFrom(this.stack.lpop()));
                break;
            }
            case 102: {
                this.stack.push(this.stack.fpop().subtractFrom(this.stack.fpop()));
                break;
            }
            case 103: {
                this.stack.push(this.stack.dpop().subtractFrom(this.stack.dpop()));
                break;
            }
            case 104: {
                this.stack.push(this.stack.ipop().multiply(this.stack.ipop()));
                break;
            }
            case 105: {
                this.stack.push(this.stack.lpop().multiply(this.stack.lpop()));
                break;
            }
            case 106: {
                this.stack.push(this.stack.fpop().multiply(this.stack.fpop()));
                break;
            }
            case 107: {
                this.stack.push(this.stack.dpop().multiply(this.stack.dpop()));
                break;
            }
            case 108: {
                try {
                    this.stack.push(this.stack.ipop().divideOf(this.stack.ipop()));
                }
                catch (ArithmeticException ex) {
                    this.stack.push(this.valueFactory.createIntegerValue());
                }
                break;
            }
            case 109: {
                try {
                    this.stack.push(this.stack.lpop().divideOf(this.stack.lpop()));
                }
                catch (ArithmeticException ex) {
                    this.stack.push(this.valueFactory.createLongValue());
                }
                break;
            }
            case 110: {
                this.stack.push(this.stack.fpop().divideOf(this.stack.fpop()));
                break;
            }
            case 111: {
                this.stack.push(this.stack.dpop().divideOf(this.stack.dpop()));
                break;
            }
            case 112: {
                try {
                    this.stack.push(this.stack.ipop().remainderOf(this.stack.ipop()));
                }
                catch (ArithmeticException ex) {
                    this.stack.push(this.valueFactory.createIntegerValue());
                }
                break;
            }
            case 113: {
                try {
                    this.stack.push(this.stack.lpop().remainderOf(this.stack.lpop()));
                }
                catch (ArithmeticException ex) {
                    this.stack.push(this.valueFactory.createLongValue());
                }
                break;
            }
            case 114: {
                this.stack.push(this.stack.fpop().remainderOf(this.stack.fpop()));
                break;
            }
            case 115: {
                this.stack.push(this.stack.dpop().remainderOf(this.stack.dpop()));
                break;
            }
            case 116: {
                this.stack.push(this.stack.ipop().negate());
                break;
            }
            case 117: {
                this.stack.push(this.stack.lpop().negate());
                break;
            }
            case 118: {
                this.stack.push(this.stack.fpop().negate());
                break;
            }
            case 119: {
                this.stack.push(this.stack.dpop().negate());
                break;
            }
            case 120: {
                this.stack.push(this.stack.ipop().shiftLeftOf(this.stack.ipop()));
                break;
            }
            case 121: {
                this.stack.push(this.stack.ipop().shiftLeftOf(this.stack.lpop()));
                break;
            }
            case 122: {
                this.stack.push(this.stack.ipop().shiftRightOf(this.stack.ipop()));
                break;
            }
            case 123: {
                this.stack.push(this.stack.ipop().shiftRightOf(this.stack.lpop()));
                break;
            }
            case 124: {
                this.stack.push(this.stack.ipop().unsignedShiftRightOf(this.stack.ipop()));
                break;
            }
            case 125: {
                this.stack.push(this.stack.ipop().unsignedShiftRightOf(this.stack.lpop()));
                break;
            }
            case 126: {
                this.stack.push(this.stack.ipop().and(this.stack.ipop()));
                break;
            }
            case 127: {
                this.stack.push(this.stack.lpop().and(this.stack.lpop()));
                break;
            }
            case -128: {
                this.stack.push(this.stack.ipop().or(this.stack.ipop()));
                break;
            }
            case -127: {
                this.stack.push(this.stack.lpop().or(this.stack.lpop()));
                break;
            }
            case -126: {
                this.stack.push(this.stack.ipop().xor(this.stack.ipop()));
                break;
            }
            case -125: {
                this.stack.push(this.stack.lpop().xor(this.stack.lpop()));
                break;
            }
            case -123: {
                this.stack.push(this.stack.ipop().convertToLong());
                break;
            }
            case -122: {
                this.stack.push(this.stack.ipop().convertToFloat());
                break;
            }
            case -121: {
                this.stack.push(this.stack.ipop().convertToDouble());
                break;
            }
            case -120: {
                this.stack.push(this.stack.lpop().convertToInteger());
                break;
            }
            case -119: {
                this.stack.push(this.stack.lpop().convertToFloat());
                break;
            }
            case -118: {
                this.stack.push(this.stack.lpop().convertToDouble());
                break;
            }
            case -117: {
                this.stack.push(this.stack.fpop().convertToInteger());
                break;
            }
            case -116: {
                this.stack.push(this.stack.fpop().convertToLong());
                break;
            }
            case -115: {
                this.stack.push(this.stack.fpop().convertToDouble());
                break;
            }
            case -114: {
                this.stack.push(this.stack.dpop().convertToInteger());
                break;
            }
            case -113: {
                this.stack.push(this.stack.dpop().convertToLong());
                break;
            }
            case -112: {
                this.stack.push(this.stack.dpop().convertToFloat());
                break;
            }
            case -111: {
                this.stack.push(this.stack.ipop().convertToByte());
                break;
            }
            case -110: {
                this.stack.push(this.stack.ipop().convertToCharacter());
                break;
            }
            case -109: {
                this.stack.push(this.stack.ipop().convertToShort());
                break;
            }
            case -108: {
                LongValue longValue1 = this.stack.lpop();
                LongValue longValue2 = this.stack.lpop();
                this.stack.push(longValue2.compare(longValue1));
                break;
            }
            case -107: {
                FloatValue floatValue1 = this.stack.fpop();
                FloatValue floatValue2 = this.stack.fpop();
                this.stack.push(floatValue2.compare(floatValue1));
                break;
            }
            case -106: {
                this.stack.push(this.stack.fpop().compareReverse(this.stack.fpop()));
                break;
            }
            case -105: {
                DoubleValue doubleValue1 = this.stack.dpop();
                DoubleValue doubleValue2 = this.stack.dpop();
                this.stack.push(doubleValue2.compare(doubleValue1));
                break;
            }
            case -104: {
                this.stack.push(this.stack.dpop().compareReverse(this.stack.dpop()));
                break;
            }
            case -84: {
                this.invocationUnit.exitMethod(clazz, method, this.stack.ipop());
                this.branchUnit.returnFromMethod();
                break;
            }
            case -83: {
                this.invocationUnit.exitMethod(clazz, method, this.stack.lpop());
                this.branchUnit.returnFromMethod();
                break;
            }
            case -82: {
                this.invocationUnit.exitMethod(clazz, method, this.stack.fpop());
                this.branchUnit.returnFromMethod();
                break;
            }
            case -81: {
                this.invocationUnit.exitMethod(clazz, method, this.stack.dpop());
                this.branchUnit.returnFromMethod();
                break;
            }
            case -80: {
                this.invocationUnit.exitMethod(clazz, method, this.stack.apop());
                this.branchUnit.returnFromMethod();
                break;
            }
            case -79: {
                this.branchUnit.returnFromMethod();
                break;
            }
            case -68: {
                IntegerValue arrayLength = this.stack.ipop();
                this.stack.push(this.valueFactory.createArrayReferenceValue(String.valueOf(InstructionUtil.internalTypeFromArrayType((byte)simpleInstruction.constant)), null, arrayLength));
                break;
            }
            case -66: {
                ReferenceValue referenceValue = this.stack.apop();
                this.stack.push(referenceValue.arrayLength(this.valueFactory));
                break;
            }
            case -65: {
                ReferenceValue exceptionReferenceValue = this.stack.apop();
                this.stack.clear();
                this.branchUnit.throwException();
                break;
            }
            case -62: 
            case -61: {
                this.stack.apop();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown simple instruction [" + simpleInstruction.opcode + "]");
            }
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        int constantIndex = constantInstruction.constantIndex;
        switch (constantInstruction.opcode) {
            case 18: 
            case 19: 
            case 20: {
                this.stack.push(this.classConstantValueFactory.constantValue(clazz, constantIndex));
                break;
            }
            case -78: 
            case -77: 
            case -76: 
            case -75: 
            case -74: 
            case -73: 
            case -72: 
            case -71: 
            case -70: {
                this.invocationUnit.invokeMember(clazz, method, codeAttribute, offset, constantInstruction, this.stack, this.variables);
                break;
            }
            case -69: {
                this.stack.push(this.constantValueFactory.constantValue(clazz, constantIndex).referenceValue());
                break;
            }
            case -67: {
                ReferenceValue arrayType = this.constantValueFactory.constantValue(clazz, constantIndex).referenceValue();
                this.stack.push(this.valueFactory.createArrayReferenceValue(arrayType.internalType(), arrayType.getReferencedClass(), this.stack.ipop()));
                break;
            }
            case -64: {
                ReferenceValue type = this.constantValueFactory.constantValue(clazz, constantIndex).referenceValue();
                this.stack.push(this.stack.apop().cast(type.getType(), type.getReferencedClass(), this.valueFactory, this.alwaysCast));
                break;
            }
            case -63: {
                int instanceOf;
                ReferenceValue value = this.stack.apop();
                ReferenceValue type = this.constantValueFactory.constantValue(clazz, constantIndex).referenceValue();
                int n = instanceOf = type.mayBeExtension() ? 0 : value.instanceOf(type.getType(), type.getReferencedClass());
                this.stack.push(instanceOf == -1 ? this.valueFactory.createIntegerValue(0) : (instanceOf == 1 ? this.valueFactory.createIntegerValue(1) : this.valueFactory.createIntegerValue()));
                break;
            }
            case -59: {
                int dimensionCount = constantInstruction.constant;
                for (int dimension = 0; dimension < dimensionCount; ++dimension) {
                    IntegerValue integerValue = this.stack.ipop();
                }
                this.stack.push(this.constantValueFactory.constantValue(clazz, constantIndex).referenceValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown constant pool instruction [" + constantInstruction.opcode + "]");
            }
        }
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        int variableIndex = variableInstruction.variableIndex;
        switch (variableInstruction.opcode) {
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.stack.push(this.variables.iload(variableIndex));
                break;
            }
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.stack.push(this.variables.lload(variableIndex));
                break;
            }
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.stack.push(this.variables.fload(variableIndex));
                break;
            }
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.stack.push(this.variables.dload(variableIndex));
                break;
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.stack.push(this.variables.aload(variableIndex));
                break;
            }
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                this.variables.store(variableIndex, this.stack.ipop());
                break;
            }
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                this.variables.store(variableIndex, this.stack.lpop());
                break;
            }
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                this.variables.store(variableIndex, this.stack.fpop());
                break;
            }
            case 57: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.variables.store(variableIndex, this.stack.dpop());
                break;
            }
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.variables.store(variableIndex, this.stack.pop());
                break;
            }
            case -124: {
                this.variables.store(variableIndex, this.variables.iload(variableIndex).add(this.valueFactory.createIntegerValue(variableInstruction.constant)));
                break;
            }
            case -87: {
                InstructionOffsetValue instructionOffsetValue = this.variables.oload(variableIndex);
                this.branchUnit.branch(clazz, codeAttribute, offset, instructionOffsetValue.instructionOffset(instructionOffsetValue.instructionOffsetCount() - 1));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown variable instruction [" + variableInstruction.opcode + "]");
            }
        }
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        int branchTarget = offset + branchInstruction.branchOffset;
        this.branchUnit.branchConditionally(clazz, codeAttribute, offset, offset + branchInstruction.length(offset), 0);
        switch (branchInstruction.opcode) {
            case -103: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, offset, branchTarget, this.stack.ipop().equal(this.valueFactory.createIntegerValue(0)));
                break;
            }
            case -102: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, offset, branchTarget, this.stack.ipop().notEqual(this.valueFactory.createIntegerValue(0)));
                break;
            }
            case -101: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, offset, branchTarget, this.stack.ipop().lessThan(this.valueFactory.createIntegerValue(0)));
                break;
            }
            case -100: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, offset, branchTarget, this.stack.ipop().greaterThanOrEqual(this.valueFactory.createIntegerValue(0)));
                break;
            }
            case -99: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, offset, branchTarget, this.stack.ipop().greaterThan(this.valueFactory.createIntegerValue(0)));
                break;
            }
            case -98: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, offset, branchTarget, this.stack.ipop().lessThanOrEqual(this.valueFactory.createIntegerValue(0)));
                break;
            }
            case -97: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, offset, branchTarget, this.stack.ipop().equal(this.stack.ipop()));
                break;
            }
            case -96: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, offset, branchTarget, this.stack.ipop().notEqual(this.stack.ipop()));
                break;
            }
            case -95: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, offset, branchTarget, this.stack.ipop().greaterThan(this.stack.ipop()));
                break;
            }
            case -94: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, offset, branchTarget, this.stack.ipop().lessThanOrEqual(this.stack.ipop()));
                break;
            }
            case -93: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, offset, branchTarget, this.stack.ipop().lessThan(this.stack.ipop()));
                break;
            }
            case -92: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, offset, branchTarget, this.stack.ipop().greaterThanOrEqual(this.stack.ipop()));
                break;
            }
            case -91: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, offset, branchTarget, this.stack.apop().equal(this.stack.apop()));
                break;
            }
            case -90: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, offset, branchTarget, this.stack.apop().notEqual(this.stack.apop()));
                break;
            }
            case -89: 
            case -56: {
                this.branchUnit.branch(clazz, codeAttribute, offset, branchTarget);
                break;
            }
            case -88: 
            case -55: {
                this.stack.push(new InstructionOffsetValue(offset + branchInstruction.length(offset)));
                this.branchUnit.branch(clazz, codeAttribute, offset, branchTarget);
                break;
            }
            case -58: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, offset, branchTarget, this.stack.apop().isNull());
                break;
            }
            case -57: {
                this.branchUnit.branchConditionally(clazz, codeAttribute, offset, branchTarget, this.stack.apop().isNotNull());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown branch instruction [" + branchInstruction.opcode + "]");
            }
        }
    }

    @Override
    public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, TableSwitchInstruction tableSwitchInstruction) {
        IntegerValue indexValue = this.stack.ipop();
        this.branchUnit.branchConditionally(clazz, codeAttribute, offset, offset + tableSwitchInstruction.defaultOffset, 0);
        for (int index = 0; index < tableSwitchInstruction.jumpOffsets.length; ++index) {
            int conditional = indexValue.equal(this.valueFactory.createIntegerValue(tableSwitchInstruction.lowCase + index));
            this.branchUnit.branchConditionally(clazz, codeAttribute, offset, offset + tableSwitchInstruction.jumpOffsets[index], conditional);
        }
    }

    @Override
    public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, LookUpSwitchInstruction lookUpSwitchInstruction) {
        IntegerValue indexValue = this.stack.ipop();
        this.branchUnit.branchConditionally(clazz, codeAttribute, offset, offset + lookUpSwitchInstruction.defaultOffset, 0);
        for (int index = 0; index < lookUpSwitchInstruction.jumpOffsets.length; ++index) {
            int conditional = indexValue.equal(this.valueFactory.createIntegerValue(lookUpSwitchInstruction.cases[index]));
            this.branchUnit.branchConditionally(clazz, codeAttribute, offset, offset + lookUpSwitchInstruction.jumpOffsets[index], conditional);
        }
    }

    private void arrayStore(ReferenceValue arrayReference, IntegerValue arrayIndex, Value value) {
        Value copy = arrayReference.copyIfMutable();
        if (!(copy instanceof ReferenceValue)) {
            throw new IllegalStateException("copyIfMutable should return a value of the same type");
        }
        if (arrayReference != copy) {
            this.stack.replaceReferences(arrayReference, copy);
            this.variables.replaceReferences(arrayReference, copy);
        }
        try {
            ((ReferenceValue)copy).arrayStore(arrayIndex, value);
        }
        catch (ArrayIndexOutOfBounds e) {
            this.handleArrayException(copy, arrayReference);
        }
    }

    private void handleArrayException(Value toReplace, ReferenceValue currentValue) {
        ReferenceValue unknownArray = this.valueFactory.createArrayReferenceValue(currentValue.getType() == null ? null : currentValue.getType().substring(1), currentValue.getReferencedClass(), this.valueFactory.createIntegerValue());
        this.stack.replaceReferences(toReplace, unknownArray);
        this.variables.replaceReferences(toReplace, unknownArray);
    }
}

