/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.ClassPath;
import com.google.turbine.binder.bound.ModuleInfo;
import com.google.turbine.binder.bytecode.BytecodeBinder;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.lookup.SimpleTopLevelIndex;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.ModuleSymbol;
import com.google.turbine.zip.Zip;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public final class ClassPathBinder {
    public static final String TRANSITIVE_PREFIX = "META-INF/TRANSITIVE/";
    public static final String TRANSITIVE_SUFFIX = ".turbine";

    public static ClassPath bindClasspath(Collection<Path> paths) throws IOException {
        LinkedHashMap<ClassSymbol, Supplier<BytecodeBoundClass>> transitive = new LinkedHashMap<ClassSymbol, Supplier<BytecodeBoundClass>>();
        final HashMap<ClassSymbol, Supplier<BytecodeBoundClass>> map = new HashMap<ClassSymbol, Supplier<BytecodeBoundClass>>();
        HashMap<ModuleSymbol, ModuleInfo> modules = new HashMap<ModuleSymbol, ModuleInfo>();
        final HashMap<String, Supplier<byte[]>> resources = new HashMap<String, Supplier<byte[]>>();
        final Env<ClassSymbol, BytecodeBoundClass> env = new Env<ClassSymbol, BytecodeBoundClass>(){

            @Override
            public @Nullable BytecodeBoundClass get(ClassSymbol sym) {
                Supplier supplier = (Supplier)map.get(sym);
                return supplier == null ? null : (BytecodeBoundClass)supplier.get();
            }
        };
        for (Path path : paths) {
            try {
                ClassPathBinder.bindJar(path, map, modules, env, transitive, resources);
            }
            catch (IOException e) {
                throw new IOException("error reading " + String.valueOf(path), e);
            }
        }
        for (Map.Entry entry : transitive.entrySet()) {
            ClassSymbol symbol = (ClassSymbol)entry.getKey();
            map.putIfAbsent(symbol, (Supplier<BytecodeBoundClass>)((Supplier)entry.getValue()));
        }
        final SimpleEnv moduleEnv = new SimpleEnv(ImmutableMap.copyOf(modules));
        final TopLevelIndex topLevelIndex = SimpleTopLevelIndex.of(map.keySet());
        return new ClassPath(){

            @Override
            public Env<ClassSymbol, BytecodeBoundClass> env() {
                return env;
            }

            @Override
            public Env<ModuleSymbol, ModuleInfo> moduleEnv() {
                return moduleEnv;
            }

            @Override
            public TopLevelIndex index() {
                return topLevelIndex;
            }

            @Override
            public @Nullable Supplier<byte[]> resource(String path) {
                return (Supplier)resources.get(path);
            }
        };
    }

    private static void bindJar(Path path, Map<ClassSymbol, Supplier<BytecodeBoundClass>> env, Map<ModuleSymbol, ModuleInfo> modules, Env<ClassSymbol, BytecodeBoundClass> benv, Map<ClassSymbol, Supplier<BytecodeBoundClass>> transitive, Map<String, Supplier<byte[]>> resources) throws IOException {
        for (Zip.Entry ze : new Zip.ZipIterable(path)) {
            ClassSymbol sym;
            String name = ze.name();
            if (name.startsWith(TRANSITIVE_PREFIX)) {
                if (!name.endsWith(TRANSITIVE_SUFFIX)) continue;
                sym = new ClassSymbol(name.substring(TRANSITIVE_PREFIX.length(), name.length() - TRANSITIVE_SUFFIX.length()));
                transitive.putIfAbsent(sym, BytecodeBoundClass.lazy(sym, ze, benv, path));
                continue;
            }
            if (!name.endsWith(".class")) {
                resources.put(name, ze);
                continue;
            }
            if (name.substring(name.lastIndexOf(47) + 1).equals("module-info.class")) {
                ModuleInfo moduleInfo = BytecodeBinder.bindModuleInfo(path.toString(), (java.util.function.Supplier<byte[]>)((Object)ze));
                modules.put(new ModuleSymbol(moduleInfo.name()), moduleInfo);
                continue;
            }
            sym = new ClassSymbol(name.substring(0, name.length() - ".class".length()));
            env.putIfAbsent(sym, BytecodeBoundClass.lazy(sym, ze, benv, path));
        }
    }

    private ClassPathBinder() {
    }
}

