/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.bridge;

import com.google.caliper.bridge.LogMessage;
import com.google.caliper.bridge.LogMessageVisitor;
import com.google.caliper.util.ShortDuration;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public final class GcLogMessage
extends LogMessage {
    private static final long serialVersionUID = 1L;
    private final Type type;
    private final ShortDuration duration;

    GcLogMessage(Type type, ShortDuration duration) {
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.duration = (ShortDuration)Preconditions.checkNotNull((Object)duration);
    }

    public Type type() {
        return this.type;
    }

    public ShortDuration duration() {
        return this.duration;
    }

    @Override
    public void accept(LogMessageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.duration});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GcLogMessage) {
            GcLogMessage that = (GcLogMessage)obj;
            return this.type == that.type && this.duration.equals(that.duration);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.type).add("duration", (Object)this.duration).toString();
    }

    public static enum Type {
        FULL,
        INCREMENTAL;

    }
}

