/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.util.jsonprinter;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import proguard.evaluation.util.jsonprinter.ErrorRecord;
import proguard.evaluation.util.jsonprinter.InstructionBlockEvaluationRecord;
import proguard.evaluation.util.jsonprinter.InstructionRecord;
import proguard.evaluation.util.jsonprinter.JsonPrinter;
import proguard.evaluation.util.jsonprinter.JsonSerializable;

class CodeAttributeRecord
implements JsonSerializable {
    @NotNull
    private final String clazz;
    @NotNull
    private final String method;
    @NotNull
    private final List<InstructionRecord> instructions;
    @NotNull
    private final List<String> parameters;
    private ErrorRecord error;
    @NotNull
    private final List<InstructionBlockEvaluationRecord> blockEvaluations = new ArrayList<InstructionBlockEvaluationRecord>();

    public CodeAttributeRecord(@NotNull String clazz, @NotNull String method, @NotNull List<String> parameters, @NotNull List<InstructionRecord> instructions) {
        this.clazz = clazz;
        this.method = method;
        this.parameters = parameters;
        this.instructions = instructions;
    }

    @Override
    public StringBuilder toJson(StringBuilder builder) {
        builder.append("{");
        JsonPrinter.toJson("clazz", this.clazz, builder).append(",");
        JsonPrinter.toJson("method", this.method, builder).append(",");
        JsonPrinter.listToJson("instructions", this.instructions, builder).append(",");
        JsonPrinter.stringListToJson("parameters", this.parameters, builder).append(",");
        JsonPrinter.listToJson("blockEvaluations", this.blockEvaluations, builder);
        if (this.error != null) {
            builder.append(",");
            JsonPrinter.serializeJsonSerializable("error", this.error, builder);
        }
        return builder.append("}");
    }

    @NotNull
    public String getClazz() {
        return this.clazz;
    }

    @NotNull
    public String getMethod() {
        return this.method;
    }

    @NotNull
    public List<InstructionRecord> getInstructions() {
        return this.instructions;
    }

    @NotNull
    public List<String> getParameters() {
        return this.parameters;
    }

    public ErrorRecord getError() {
        return this.error;
    }

    @NotNull
    public List<InstructionBlockEvaluationRecord> getBlockEvaluations() {
        return this.blockEvaluations;
    }

    public void setError(ErrorRecord error) {
        this.error = error;
    }
}

