/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.model;

import com.google.caliper.model.Defaults;
import com.google.caliper.model.InstrumentSpec;
import com.google.caliper.model.Measurement;
import com.google.caliper.model.Run;
import com.google.caliper.model.Scenario;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;

public final class Trial {
    public static final Trial DEFAULT = new Trial();
    private UUID id;
    private Run run;
    private InstrumentSpec instrumentSpec;
    private Scenario scenario;
    private List<Measurement> measurements;

    private Trial() {
        this.id = Defaults.UUID;
        this.run = Run.DEFAULT;
        this.instrumentSpec = InstrumentSpec.DEFAULT;
        this.scenario = Scenario.DEFAULT;
        this.measurements = Lists.newArrayList();
    }

    private Trial(Builder builder) {
        this.id = builder.id;
        this.run = builder.run;
        this.instrumentSpec = builder.instrumentSpec;
        this.scenario = builder.scenario;
        this.measurements = Lists.newArrayList((Iterable)builder.measurements);
    }

    public UUID id() {
        return this.id;
    }

    public Run run() {
        return this.run;
    }

    public InstrumentSpec instrumentSpec() {
        return this.instrumentSpec;
    }

    public Scenario scenario() {
        return this.scenario;
    }

    public ImmutableList<Measurement> measurements() {
        return ImmutableList.copyOf(this.measurements);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Trial) {
            Trial that = (Trial)obj;
            return this.id.equals(that.id) && this.run.equals(that.run) && this.instrumentSpec.equals(that.instrumentSpec) && this.scenario.equals(that.scenario) && this.measurements.equals(that.measurements);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.run, this.instrumentSpec, this.scenario, this.measurements});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("run", (Object)this.run).add("instrumentSpec", (Object)this.instrumentSpec).add("scenario", (Object)this.scenario).add("measurements", this.measurements).toString();
    }

    public static final class Builder {
        private final UUID id;
        private Run run;
        private InstrumentSpec instrumentSpec;
        private Scenario scenario;
        private final List<Measurement> measurements = Lists.newArrayList();

        public Builder(UUID id) {
            this.id = (UUID)Preconditions.checkNotNull((Object)id);
        }

        public Builder run(Run.Builder runBuilder) {
            return this.run(runBuilder.build());
        }

        public Builder run(Run run) {
            this.run = (Run)Preconditions.checkNotNull((Object)run);
            return this;
        }

        public Builder instrumentSpec(InstrumentSpec.Builder instrumentSpecBuilder) {
            return this.instrumentSpec(instrumentSpecBuilder.build());
        }

        public Builder instrumentSpec(InstrumentSpec instrumentSpec) {
            this.instrumentSpec = (InstrumentSpec)Preconditions.checkNotNull((Object)instrumentSpec);
            return this;
        }

        public Builder scenario(Scenario.Builder scenarioBuilder) {
            return this.scenario(scenarioBuilder.build());
        }

        public Builder scenario(Scenario scenario) {
            this.scenario = (Scenario)Preconditions.checkNotNull((Object)scenario);
            return this;
        }

        public Builder addMeasurement(Measurement.Builder measurementBuilder) {
            return this.addMeasurement(measurementBuilder.build());
        }

        public Builder addMeasurement(Measurement measurement) {
            this.measurements.add(measurement);
            return this;
        }

        public Builder addAllMeasurements(Iterable<Measurement> measurements) {
            Iterables.addAll(this.measurements, measurements);
            return this;
        }

        public Trial build() {
            Preconditions.checkState((this.run != null ? 1 : 0) != 0);
            Preconditions.checkState((this.instrumentSpec != null ? 1 : 0) != 0);
            Preconditions.checkState((this.scenario != null ? 1 : 0) != 0);
            return new Trial(this);
        }
    }
}

