/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.worker.AllocationStats;

abstract class AllocationRecorder {
    private boolean firstTime = true;

    AllocationRecorder() {
    }

    final void startRecording() {
        if (this.firstTime) {
            this.doStartRecording();
            Object obj = new Object();
            AllocationStats stats = this.stopRecording(1);
            if (stats.getAllocationCount() != 1 || stats.getAllocationSize() < 1L) {
                throw new IllegalStateException(String.format("The allocation recording infrastructure appears to be broken. Expected to find exactly one allocation of a java/lang/Object instead found %s", stats));
            }
            this.firstTime = false;
        }
        this.doStartRecording();
    }

    protected abstract void doStartRecording();

    abstract AllocationStats stopRecording(int var1);
}

