/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.bridge.LogMessageParserModule;
import com.google.caliper.core.Running;
import com.google.caliper.json.GsonModule;
import com.google.caliper.model.Run;
import com.google.caliper.runner.CaliperRunComponent;
import com.google.caliper.runner.ServiceModule;
import com.google.caliper.runner.config.CaliperConfig;
import com.google.caliper.runner.config.CaliperConfigModule;
import com.google.caliper.runner.options.CaliperOptions;
import com.google.caliper.runner.options.OptionsModule;
import com.google.caliper.runner.server.ServerModule;
import com.google.caliper.runner.target.DeviceModule;
import com.google.caliper.runner.target.TargetModule;
import com.google.caliper.runner.worker.WorkerOutputModule;
import com.google.caliper.runner.worker.targetinfo.TargetInfoComponent;
import com.google.caliper.runner.worker.targetinfo.TargetInfoFactory;
import com.google.caliper.runner.worker.targetinfo.TargetInfoFromWorkerFactory;
import com.google.caliper.runner.worker.trial.TrialExecutor;
import com.google.caliper.util.OutputModule;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Singleton;
import org.joda.time.Instant;

@Module(includes={DeviceModule.class, LogMessageParserModule.class, CaliperConfigModule.class, GsonModule.class, OptionsModule.class, OutputModule.class, ServerModule.class, ServiceModule.class, TargetModule.class, WorkerOutputModule.class}, subcomponents={TargetInfoComponent.class, CaliperRunComponent.class})
abstract class CaliperRunnerModule {
    private static final String RUNNER_MAX_PARALLELISM_OPTION = "runner.maxParallelism";

    private CaliperRunnerModule() {
    }

    @Provides
    static Instant provideInstant() {
        return Instant.now();
    }

    @Provides
    static UUID provideUuid() {
        return UUID.randomUUID();
    }

    @Provides
    @Singleton
    static Run provideRun(UUID uuid, CaliperOptions caliperOptions, Instant startTime) {
        return new Run.Builder(uuid).label(caliperOptions.runName()).startTime(startTime).build();
    }

    @Provides
    @Singleton
    static ListeningExecutorService provideListeningExecutorService() {
        return MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    }

    @Binds
    abstract ExecutorService bindExecutorService(ListeningExecutorService var1);

    @Provides
    @Singleton
    @TrialExecutor
    static ListeningExecutorService provideTrialExecutorService(CaliperConfig config) {
        int poolSize = Integer.parseInt((String)config.properties().get((Object)RUNNER_MAX_PARALLELISM_OPTION));
        return MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(poolSize));
    }

    @Binds
    abstract TargetInfoFactory bindTargetInfoFactory(TargetInfoFromWorkerFactory var1);

    @Provides
    @Running.BenchmarkClass
    static String provideBenchmarkClassName(CaliperOptions options) {
        return options.benchmarkClassName();
    }
}

