/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.target;

import com.google.auto.value.AutoValue;
import com.google.caliper.runner.config.VmConfig;
import com.google.caliper.runner.config.VmType;
import com.google.caliper.runner.target.AutoValue_Jvm;
import com.google.caliper.runner.target.Vm;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;

@AutoValue
public abstract class Jvm
extends Vm {
    @VisibleForTesting
    public static final ImmutableSet<String> TRIAL_VM_ARGS = ImmutableSet.of((Object)"-Xbatch", (Object)"-XX:CICompilerCount=1", (Object)"-XX:-TieredCompilation", (Object)"-XX:+UseParallelGC", (Object)"-Dsun.reflect.inflationThreshold=0", (Object)"-XX:+PrintFlagsFinal", (Object[])new String[]{"-XX:+PrintCompilation", "-XX:+PrintGC"});
    private static final Predicate<String> PROPERTIES_TO_RETAIN = new Predicate<String>(){

        public boolean apply(String input) {
            return input.startsWith("java.vm") || input.startsWith("java.runtime") || input.equals("java.version") || input.equals("java.vendor") || input.equals("sun.reflect.noInflation") || input.equals("sun.reflect.inflationThreshold");
        }
    };

    public static Jvm create(VmConfig config, String classpath) {
        return new AutoValue_Jvm(VmType.JVM, config, classpath);
    }

    Jvm() {
    }

    @Override
    public String executable() {
        return (String)this.config().executable().or((Object)"java");
    }

    @Override
    public ImmutableSet<String> trialArgs() {
        return TRIAL_VM_ARGS;
    }

    @Override
    public ImmutableList<String> classpathArgs() {
        return ImmutableList.of((Object)"-cp", (Object)this.classpath());
    }

    @Override
    protected ImmutableList<String> lastArgs() {
        return ImmutableList.of();
    }

    @Override
    public Predicate<String> vmPropertiesToRetain() {
        return PROPERTIES_TO_RETAIN;
    }
}

