/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.target;

import com.google.caliper.runner.config.InvalidConfigurationException;
import com.google.caliper.runner.config.VmConfig;
import com.google.caliper.runner.config.VmType;
import com.google.caliper.runner.options.CaliperOptions;
import com.google.caliper.runner.target.EffectiveClassPath;
import com.google.caliper.runner.target.LocalDevice;
import com.google.caliper.runner.target.Vm;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Map;

final class NonAndroidDeviceHelper
implements LocalDevice.Helper {
    private final CaliperOptions options;
    private static final Predicate<String> JVM_FLAGS_TO_RETAIN = new Predicate<String>(){

        public boolean apply(String flag) {
            return !flag.startsWith("-agentlib:jdwp");
        }
    };
    private volatile String jvmClasspath = null;

    NonAndroidDeviceHelper(CaliperOptions options) {
        this.options = options;
    }

    @Override
    public void setUp() {
    }

    @Override
    public VmType defaultVmType() {
        return VmType.JVM;
    }

    @Override
    public void configureDefaultVm(VmConfig.Builder builder) {
        builder.home(System.getProperty("java.home")).addAllArgs(NonAndroidDeviceHelper.jvmInputArguments());
    }

    private static Collection<String> jvmInputArguments() {
        return Collections2.filter(ManagementFactory.getRuntimeMXBean().getInputArguments(), JVM_FLAGS_TO_RETAIN);
    }

    @Override
    public File getHomeDir(Vm vm, File baseDirectory) {
        return new File(baseDirectory, vm.name());
    }

    @Override
    public String getWorkerClasspath(VmType type) {
        Optional<String> explicitClasspath = this.options.workerClasspath(type.toString());
        if (explicitClasspath.isPresent()) {
            return (String)explicitClasspath.get();
        }
        if (type.equals((Object)VmType.ANDROID)) {
            throw new InvalidConfigurationException("Running an Android VM on a non-Android device requires either --worker-classpath or --worker-classpath-android, specifying a classpath containing files valid for an Android VM (e.g. dex files)");
        }
        if (this.jvmClasspath == null) {
            this.jvmClasspath = this.getJvmClasspath();
        }
        return this.jvmClasspath;
    }

    private String getJvmClasspath() {
        String classpath = EffectiveClassPath.getClassPathForClassLoader(Thread.currentThread().getContextClassLoader());
        return classpath;
    }

    @Override
    public void addToWorkerProcessEnvironment(Map<String, String> env) {
    }
}

