/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.worker;

import com.google.caliper.runner.options.CaliperOptions;
import com.google.caliper.runner.worker.Worker;
import com.google.caliper.runner.worker.WorkerException;
import com.google.caliper.runner.worker.WorkerOutputLogger;
import com.google.caliper.runner.worker.WorkerProcessor;
import com.google.caliper.runner.worker.WorkerScoped;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Service;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.joda.time.Duration;

@WorkerScoped
public final class WorkerRunner<R> {
    private static final Logger logger = Logger.getLogger(WorkerRunner.class.getName());
    private static final Duration WORKER_CLEANUP_DURATION = Duration.standardSeconds((long)2L);
    private final Worker worker;
    private final WorkerProcessor<R> processor;
    private final boolean printWorkerLog;
    private File outputFile = null;
    private boolean doneProcessing = false;
    private boolean done = false;

    @Inject
    WorkerRunner(Worker worker, WorkerProcessor<R> processor, CaliperOptions options) {
        this.worker = worker;
        this.processor = processor;
        this.printWorkerLog = options.printWorkerLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R runWorker() {
        Preconditions.checkState((this.worker.state() == Service.State.NEW ? 1 : 0) != 0, (Object)"You can only invoke the run loop once");
        WorkerOutputLogger workerLogger = this.worker.outputLogger();
        try {
            workerLogger.open();
        }
        catch (IOException e) {
            throw this.processor.newWorkerException(String.format("Failed to open output logger for worker [%s].", this.worker.name()), e);
        }
        this.outputFile = workerLogger.outputFile();
        this.worker.startAsync();
        try {
            workerLogger.printHeader();
            long timeLimitNanos = this.processor.timeLimit().to(TimeUnit.NANOSECONDS);
            Stopwatch stopwatch = Stopwatch.createUnstarted();
            this.worker.awaitRunning();
            this.worker.sendRequest();
            stopwatch.start();
            block20: while (!this.done) {
                Worker.StreamItem item;
                try {
                    item = this.worker.readItem(timeLimitNanos - stopwatch.elapsed(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException e) {
                    if (!this.doneProcessing) {
                        throw this.processor.newWorkerException(this.formatError(this.processor.getInterruptionErrorMessage(this.worker), new Object[0]), e);
                    }
                    logger.log(Level.WARNING, this.formatError("Worker [%s] cancelled before completing normally, but after getting results.", new Object[]{this.worker}));
                    this.done = true;
                    break;
                }
                switch (item.kind()) {
                    case DATA: {
                        this.doneProcessing = this.processor.handleMessage(item.content(), this.worker);
                        if (!this.doneProcessing) continue block20;
                        long cleanupTimeNanos = TimeUnit.MILLISECONDS.toNanos(WORKER_CLEANUP_DURATION.getMillis());
                        timeLimitNanos = stopwatch.elapsed(TimeUnit.NANOSECONDS) + cleanupTimeNanos;
                        continue block20;
                    }
                    case EOF: {
                        if (!this.doneProcessing) {
                            throw this.processor.newWorkerException(this.formatError(this.processor.getPrematureExitErrorMessage(this.worker), new Object[0]), null);
                        }
                        this.done = true;
                        continue block20;
                    }
                    case TIMEOUT: {
                        if (!this.doneProcessing) {
                            throw this.processor.newWorkerException(this.formatError(this.processor.getTimeoutErrorMessage(this.worker), new Object[0]), null);
                        }
                        logger.log(Level.WARNING, this.formatError("Worker [%s] failed to exit cleanly within the allotted time.", new Object[]{this.worker}));
                        this.done = true;
                        continue block20;
                    }
                }
                String string = String.valueOf(item);
                throw new AssertionError((Object)new StringBuilder(17 + String.valueOf(string).length()).append("Impossible item: ").append(string).toString());
            }
            R r = this.processor.getResult();
            return r;
        }
        catch (WorkerException e) {
            throw e;
        }
        catch (Throwable e) {
            logger.severe(this.formatError("Unexpected error while running worker [%s].", new Object[]{this.worker}));
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.worker.stopAsync();
            try {
                workerLogger.ensureFileIsSaved();
            }
            finally {
                workerLogger.close();
            }
        }
    }

    private String formatError(String baseMessageFormat, Object ... args) {
        String baseMessage = String.format(baseMessageFormat, args);
        if (this.printWorkerLog) {
            try {
                this.worker.outputLogger().flush();
                String logContent = Files.asCharSource((File)this.outputFile, (Charset)Charsets.UTF_8).read();
                return new StringBuilder(22 + String.valueOf(baseMessage).length() + String.valueOf(logContent).length()).append(baseMessage).append(" Worker log follows:\n\n").append(logContent).toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String string = String.valueOf(baseMessage);
        String string2 = String.valueOf(String.format(" Inspect %s to see any worker output.", this.outputFile));
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }
}

