/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@BugPattern(severity=BugPattern.SeverityLevel.ERROR, summary="A variable was checkNotNulled multiple times. Did you mean to check something else?")
public final class CheckNotNullMultipleTimes
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<ExpressionTree> CHECK_NOT_NULL = Matchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkNotNull");

    public Description matchMethod(MethodTree tree, final VisitorState state) {
        HashMultiset variables = HashMultiset.create();
        HashMap lastCheck = new HashMap();
        new TreePathScanner<Void, Void>(this, (Multiset)variables, lastCheck){
            final /* synthetic */ Multiset val$variables;
            final /* synthetic */ Map val$lastCheck;
            final /* synthetic */ CheckNotNullMultipleTimes this$0;
            {
                this.val$variables = multiset;
                this.val$lastCheck = map;
                this.this$0 = this$0;
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                Symbol symbol;
                List<? extends ExpressionTree> arguments = tree.getArguments();
                if (!arguments.isEmpty() && arguments.get(0) instanceof IdentifierTree && this.getCurrentPath().getParentPath().getLeaf() instanceof StatementTree && CHECK_NOT_NULL.matches((Tree)tree, state) && (symbol = ASTHelpers.getSymbol((Tree)arguments.get(0))) instanceof Symbol.VarSymbol && ASTHelpers.isConsideredFinal((Symbol)symbol)) {
                    this.val$variables.add((Object)((Symbol.VarSymbol)symbol));
                    this.val$lastCheck.put((Symbol.VarSymbol)symbol, tree);
                }
                return (Void)super.visitMethodInvocation(tree, null);
            }

            @Override
            public Void visitSwitch(SwitchTree tree, Void unused) {
                return null;
            }

            @Override
            public Void visitIf(IfTree tree, Void unused) {
                return null;
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree tree, Void unused) {
                return null;
            }

            @Override
            public Void visitClass(ClassTree tree, Void unused) {
                return null;
            }

            @Override
            public Void visitTry(TryTree tree, Void unused) {
                return (Void)this.scan(tree.getBlock(), null);
            }
        }.scan(state.getPath(), (Void)null);
        for (Multiset.Entry entry : variables.entrySet()) {
            if (entry.getCount() <= 1) continue;
            state.reportMatch(this.buildDescription((Tree)lastCheck.get(entry.getElement())).setMessage(String.format("checkNotNull(%s) was called more than once. Did you mean to check something else?", entry.getElement())).build());
        }
        return Description.NO_MATCH;
    }
}

