/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inlineme;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.inlineme.AutoValue_InlinabilityResult;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;

@AutoValue
abstract class InlinabilityResult {
    InlinabilityResult() {
    }

    abstract @Nullable InlineValidationErrorReason error();

    abstract @Nullable ExpressionTree body();

    abstract @Nullable String additionalErrorInfo();

    final String errorMessage() {
        Preconditions.checkState((this.error() != null ? 1 : 0) != 0);
        Object message = this.error().getErrorMessage();
        if (this.additionalErrorInfo() != null) {
            message = (String)message + " " + this.additionalErrorInfo();
        }
        return message;
    }

    static InlinabilityResult fromError(InlineValidationErrorReason errorReason) {
        return InlinabilityResult.fromError(errorReason, null);
    }

    static InlinabilityResult fromError(InlineValidationErrorReason errorReason, ExpressionTree body) {
        return InlinabilityResult.fromError(errorReason, body, null);
    }

    static InlinabilityResult fromError(InlineValidationErrorReason errorReason, ExpressionTree body, String additionalErrorInfo) {
        return new AutoValue_InlinabilityResult(errorReason, body, additionalErrorInfo);
    }

    static InlinabilityResult inlinable(ExpressionTree body) {
        return new AutoValue_InlinabilityResult(null, body, null);
    }

    boolean isValidForSuggester() {
        return this.isValidForValidator() || this.error() == InlineValidationErrorReason.METHOD_CAN_BE_OVERIDDEN_BUT_CAN_BE_FIXED;
    }

    boolean isValidForValidator() {
        return this.error() == null;
    }

    static InlinabilityResult forMethod(MethodTree tree, VisitorState state) {
        ExpressionTree body;
        if (tree.getBody() == null) {
            return InlinabilityResult.fromError(InlineValidationErrorReason.NO_BODY);
        }
        if (tree.getBody().getStatements().size() != 1) {
            return InlinabilityResult.fromError(InlineValidationErrorReason.NOT_EXACTLY_ONE_STATEMENT);
        }
        Symbol.MethodSymbol methSymbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (methSymbol.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return InlinabilityResult.fromError(InlineValidationErrorReason.API_IS_PRIVATE);
        }
        StatementTree statement = tree.getBody().getStatements().get(0);
        if (state.getSourceForNode((Tree)statement) == null) {
            return InlinabilityResult.fromError(InlineValidationErrorReason.NO_BODY);
        }
        switch (statement.getKind()) {
            case EXPRESSION_STATEMENT: {
                body = ((ExpressionStatementTree)statement).getExpression();
                break;
            }
            case RETURN: {
                body = ((ReturnTree)statement).getExpression();
                if (body != null) break;
                return InlinabilityResult.fromError(InlineValidationErrorReason.EMPTY_VOID);
            }
            default: {
                return InlinabilityResult.fromError(InlineValidationErrorReason.COMPLEX_STATEMENT);
            }
        }
        if (methSymbol.isVarArgs() && InlinabilityResult.usesVarargsParamPoorly(body, methSymbol.params().last(), state)) {
            return InlinabilityResult.fromError(InlineValidationErrorReason.VARARGS_USED_UNSAFELY, body);
        }
        if (body.toString().contains("{") || body.getKind() == Tree.Kind.CONDITIONAL_EXPRESSION) {
            return InlinabilityResult.fromError(InlineValidationErrorReason.COMPLEX_STATEMENT, body);
        }
        Symbol usedMultipleTimes = InlinabilityResult.usesVariablesMultipleTimes(body, methSymbol.params(), state);
        if (usedMultipleTimes != null) {
            return InlinabilityResult.fromError(InlineValidationErrorReason.REUSE_OF_ARGUMENTS, body, usedMultipleTimes.toString());
        }
        Tree privateOrDeprecatedApi = InlinabilityResult.usesPrivateOrDeprecatedApis(body, state, InlinabilityResult.getVisibility(methSymbol));
        if (privateOrDeprecatedApi != null) {
            return InlinabilityResult.fromError(InlineValidationErrorReason.CALLS_DEPRECATED_OR_PRIVATE_APIS, body, state.getSourceForNode(privateOrDeprecatedApi));
        }
        if (InlinabilityResult.hasArgumentInPossiblyNonExecutedPosition(tree, body)) {
            return InlinabilityResult.fromError(InlineValidationErrorReason.BODY_WOULD_EVALUATE_DIFFERENTLY, body);
        }
        if (ASTHelpers.methodCanBeOverridden((Symbol.MethodSymbol)methSymbol)) {
            return InlinabilityResult.fromError(methSymbol.isDefault() ? InlineValidationErrorReason.METHOD_CAN_BE_OVERIDDEN_AND_CANT_BE_FIXED : InlineValidationErrorReason.METHOD_CAN_BE_OVERIDDEN_BUT_CAN_BE_FIXED, body);
        }
        return InlinabilityResult.inlinable(body);
    }

    private static Symbol usesVariablesMultipleTimes(ExpressionTree body, final List<Symbol.VarSymbol> parameterVariables, VisitorState state) {
        final AtomicReference usesVarsTwice = new AtomicReference();
        new TreePathScanner<Void, Void>(){
            final Set<Symbol> usedVariables = new HashSet<Symbol>();

            @Override
            public Void visitIdentifier(IdentifierTree identifierTree, Void aVoid) {
                Symbol usedSymbol = ASTHelpers.getSymbol((Tree)identifierTree);
                if (parameterVariables.contains(usedSymbol) && !this.usedVariables.add(usedSymbol)) {
                    usesVarsTwice.set(usedSymbol);
                }
                return (Void)super.visitIdentifier(identifierTree, null);
            }
        }.scan(new TreePath(state.getPath(), body), (Void)null);
        return (Symbol)usesVarsTwice.get();
    }

    private static boolean usesVarargsParamPoorly(ExpressionTree expressionTree, final Symbol.VarSymbol varargsParam, VisitorState state) {
        final AtomicBoolean usesVarargsPoorly = new AtomicBoolean(false);
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree identifierTree, Void aVoid) {
                if (!ASTHelpers.getSymbol((Tree)identifierTree).equals(varargsParam)) {
                    return (Void)super.visitIdentifier(identifierTree, null);
                }
                Tree parentNode = this.getCurrentPath().getParentPath().getLeaf();
                if (!(parentNode instanceof MethodInvocationTree)) {
                    usesVarargsPoorly.set(true);
                    return null;
                }
                MethodInvocationTree mit = (MethodInvocationTree)parentNode;
                if (!ASTHelpers.getSymbol((MethodInvocationTree)mit).isVarArgs()) {
                    usesVarargsPoorly.set(true);
                    return null;
                }
                List<? extends ExpressionTree> args = mit.getArguments();
                if (args.isEmpty()) {
                    return (Void)super.visitIdentifier(identifierTree, null);
                }
                int indexOfThisTreeUse = args.indexOf(identifierTree);
                if (indexOfThisTreeUse != args.size() - 1) {
                    usesVarargsPoorly.set(true);
                    return null;
                }
                return (Void)super.visitIdentifier(identifierTree, null);
            }
        }.scan(new TreePath(state.getPath(), expressionTree), (Void)null);
        return usesVarargsPoorly.get();
    }

    private static Tree usesPrivateOrDeprecatedApis(ExpressionTree statement, final VisitorState state, final Visibility minVisibility) {
        final AtomicReference usesDeprecatedOrLessVisibleApis = new AtomicReference();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                return (Void)super.scan(node.getBody(), null);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void aVoid) {
                if (this.isDeprecatedOrLessVisible(memberSelectTree, minVisibility)) {
                    return null;
                }
                return (Void)super.visitMemberSelect(memberSelectTree, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree node, Void unused) {
                if (!ASTHelpers.isLocal((Symbol)ASTHelpers.getSymbol((Tree)node)) && !node.getName().contentEquals("this") && this.isDeprecatedOrLessVisible(node, minVisibility)) {
                    return null;
                }
                return (Void)super.visitIdentifier(node, null);
            }

            @Override
            public Void visitNewClass(NewClassTree newClassTree, Void aVoid) {
                if (this.isDeprecatedOrLessVisible(newClassTree, minVisibility)) {
                    return null;
                }
                return (Void)super.visitNewClass(newClassTree, null);
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
                if (this.isDeprecatedOrLessVisible(node, minVisibility)) {
                    return null;
                }
                return (Void)super.visitMethodInvocation(node, null);
            }

            private boolean isDeprecatedOrLessVisible(Tree tree, Visibility minVisibility2) {
                Symbol sym = ASTHelpers.getSymbol((Tree)tree);
                Visibility visibility = InlinabilityResult.getVisibility(sym);
                if (!(sym instanceof Symbol.PackageSymbol) && visibility.compareTo(minVisibility2) < 0) {
                    usesDeprecatedOrLessVisibleApis.set(tree);
                    return true;
                }
                if (ASTHelpers.hasAnnotation((Symbol)sym, (String)"java.lang.Deprecated", (VisitorState)state)) {
                    usesDeprecatedOrLessVisibleApis.set(tree);
                    return true;
                }
                return false;
            }
        }.scan(statement, null);
        return (Tree)usesDeprecatedOrLessVisibleApis.get();
    }

    private static Visibility getVisibility(Symbol symbol) {
        if (symbol.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return Visibility.PRIVATE;
        }
        if (symbol.getModifiers().contains((Object)Modifier.PROTECTED)) {
            return Visibility.PROTECTED;
        }
        if (symbol.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return Visibility.PUBLIC;
        }
        return Visibility.PACKAGE;
    }

    private static boolean hasArgumentInPossiblyNonExecutedPosition(MethodTree meth, ExpressionTree statement) {
        final AtomicBoolean paramReferred = new AtomicBoolean(false);
        final ImmutableSet params = (ImmutableSet)meth.getParameters().stream().map(ASTHelpers::getSymbol).collect(ImmutableSet.toImmutableSet());
        new TreeScanner<Void, Void>(){
            Tree currentContextTree = null;

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree, Void o) {
                Tree lastContext = this.currentContextTree;
                this.currentContextTree = lambdaExpressionTree;
                this.scan(lambdaExpressionTree.getBody(), null);
                this.currentContextTree = lastContext;
                return null;
            }

            @Override
            public Void visitConditionalExpression(ConditionalExpressionTree ceTree, Void o) {
                this.scan(ceTree.getCondition(), null);
                Tree lastContext = this.currentContextTree;
                this.currentContextTree = ceTree;
                this.scan(ceTree.getTrueExpression(), null);
                this.scan(ceTree.getFalseExpression(), null);
                this.currentContextTree = lastContext;
                return null;
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifierTree, Void aVoid) {
                if (this.currentContextTree != null && params.contains((Object)ASTHelpers.getSymbol((Tree)identifierTree))) {
                    paramReferred.set(true);
                }
                return (Void)super.visitIdentifier(identifierTree, null);
            }
        }.scan(statement, null);
        return paramReferred.get();
    }

    static enum InlineValidationErrorReason {
        NO_BODY("InlineMe cannot be applied to abstract methods."),
        NOT_EXACTLY_ONE_STATEMENT("InlineMe cannot inline methods with more than 1 statement."),
        COMPLEX_STATEMENT("InlineMe cannot inline complex statements. Consider using a different refactoring tool"),
        CALLS_DEPRECATED_OR_PRIVATE_APIS("InlineMe cannot be applied when the implementation references deprecated or less visible API elements:"),
        API_IS_PRIVATE("InlineMe cannot be applied to private APIs."),
        BODY_WOULD_EVALUATE_DIFFERENTLY("Inlining this method will result in a change in evaluation timing for one or more arguments to this method."),
        METHOD_CAN_BE_OVERIDDEN_AND_CANT_BE_FIXED("Methods that are inlined should not be overridable, as the implementation of an overriding method may be different than the inlining"),
        METHOD_CAN_BE_OVERIDDEN_BUT_CAN_BE_FIXED("Methods that are inlined should not be overridable, as the implementation of an overriding method may be different than the inlining"),
        VARARGS_USED_UNSAFELY("When using a varargs parameter, it must only be passed in the last position of a method call to another varargs method"),
        EMPTY_VOID("InlineMe cannot yet be applied to no-op void methods"),
        REUSE_OF_ARGUMENTS("Implementations cannot use an argument more than once:");

        private final @Nullable String errorMessage;

        private InlineValidationErrorReason(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        String getErrorMessage() {
            return this.errorMessage;
        }
    }

    private static enum Visibility {
        PRIVATE,
        PACKAGE,
        PROTECTED,
        PUBLIC;

    }
}

