/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.dvcs.branch.DvcsBranchManager;
import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import git4idea.config.GitExecutableDetector;
import git4idea.config.GitVcsSettings;
import git4idea.remoteApi.GitRepositoryFrontendSynchronizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgit4idea/config/GitBackendVcsSettingsListener;", "Lgit4idea/config/GitVcsSettings$GitVcsSettingsListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "showTagsChanged", "", "value", "", "pathToGitChanged", "branchGroupingSettingsChanged", "key", "Lcom/intellij/dvcs/branch/GroupingKey;", "state", "intellij.vcs.git"})
public final class GitBackendVcsSettingsListener
implements GitVcsSettings.GitVcsSettingsListener {
    @NotNull
    private final Project project;

    public GitBackendVcsSettingsListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void showTagsChanged(boolean value) {
        if (!value) {
            ((GitRepositoryFrontendSynchronizer)BackgroundTaskUtil.syncPublisher((Project)this.project, GitRepositoryFrontendSynchronizer.TOPIC)).tagsHidden();
        }
        MessageBus messageBus = this.project.getMessageBus();
        Topic topic = DvcsBranchManager.DVCS_BRANCH_SETTINGS_CHANGED;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DVCS_BRANCH_SETTINGS_CHANGED");
        ((DvcsBranchManager.DvcsBranchManagerListener)messageBus.syncPublisher(topic)).showTagsSettingsChanged(value);
    }

    public void pathToGitChanged() {
        GitExecutableDetector.fireExecutableChanged();
    }

    public void branchGroupingSettingsChanged(@NotNull GroupingKey key, boolean state2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        MessageBus messageBus = this.project.getMessageBus();
        Topic topic = DvcsBranchManager.DVCS_BRANCH_SETTINGS_CHANGED;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DVCS_BRANCH_SETTINGS_CHANGED");
        ((DvcsBranchManager.DvcsBranchManagerListener)messageBus.syncPublisher(topic)).branchGroupingSettingsChanged(key, state2);
    }
}

