/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.ui;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.actions.diff.PresentableGoToChangePopupAction;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDiffPreviewHandler;
import com.intellij.openapi.vcs.changes.ui.TreeHandlerDiffRequestProcessor;
import git4idea.index.GitStageDiffUtilKt;
import git4idea.index.GitStageTracker;
import git4idea.index.HeadInfo;
import git4idea.index.ui.GitStageDiffPreviewHandler;
import git4idea.index.ui.GitStageDiffRequestProcessor;
import git4idea.index.ui.GitStageTree;
import git4idea.index.ui.GitStagingProcessorTracker;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\f\u0010\u0016\u001a\u00020\u0007*\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgit4idea/index/ui/GitStageDiffRequestProcessor;", "Lcom/intellij/openapi/vcs/changes/ui/TreeHandlerDiffRequestProcessor;", "stageTree", "Lgit4idea/index/ui/GitStageTree;", "tracker", "Lgit4idea/index/GitStageTracker;", "isInEditor", "", "<init>", "(Lgit4idea/index/ui/GitStageTree;Lgit4idea/index/GitStageTracker;Z)V", "getStageTree", "()Lgit4idea/index/ui/GitStageTree;", "shouldAddToolbarBottomBorder", "toolbarComponents", "Lcom/intellij/diff/FrameDiffTool$ToolbarComponents;", "forceKeepCurrentFileWhileFocused", "createGoToChangeAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "loadRequestFast", "Lcom/intellij/diff/requests/DiffRequest;", "provider", "Lcom/intellij/diff/chains/DiffRequestProducer;", "isValid", "MyGoToChangePopupAction", "intellij.vcs.git"})
public final class GitStageDiffRequestProcessor
extends TreeHandlerDiffRequestProcessor {
    @NotNull
    private final GitStageTree stageTree;
    private final boolean isInEditor;

    public GitStageDiffRequestProcessor(@NotNull GitStageTree stageTree, @NotNull GitStageTracker tracker, boolean isInEditor) {
        Intrinsics.checkNotNullParameter((Object)((Object)stageTree), (String)"stageTree");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        super("Stage", (ChangesTree)stageTree, (ChangesTreeDiffPreviewHandler)GitStageDiffPreviewHandler.INSTANCE);
        this.stageTree = stageTree;
        this.isInEditor = isInEditor;
        new GitStagingProcessorTracker(tracker, (ChangesTree)this.stageTree, (DiffEditorViewer)this, this.getHandler()).track();
    }

    @NotNull
    public final GitStageTree getStageTree() {
        return this.stageTree;
    }

    protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
        Intrinsics.checkNotNullParameter((Object)toolbarComponents, (String)"toolbarComponents");
        return !this.isInEditor || super.shouldAddToolbarBottomBorder(toolbarComponents);
    }

    public boolean forceKeepCurrentFileWhileFocused() {
        return true;
    }

    @NotNull
    protected AnAction createGoToChangeAction() {
        return (AnAction)new MyGoToChangePopupAction();
    }

    @Nullable
    protected DiffRequest loadRequestFast(@NotNull DiffRequestProducer provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        DiffRequest diffRequest = super.loadRequestFast(provider);
        if (diffRequest == null) {
            return null;
        }
        DiffRequest request = diffRequest;
        if (!this.isValid(request)) {
            return null;
        }
        return request;
    }

    private final boolean isValid(DiffRequest $this$isValid) {
        boolean bl;
        HeadInfo headInfo = (HeadInfo)$this$isValid.getUserData(GitStageDiffUtilKt.getHEAD_INFO());
        if (headInfo != null) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            bl = GitStageDiffUtilKt.isCurrent(headInfo, project);
        } else {
            bl = true;
        }
        return bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014\u00a8\u0006\n"}, d2={"Lgit4idea/index/ui/GitStageDiffRequestProcessor$MyGoToChangePopupAction;", "Lcom/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$Default;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "<init>", "(Lgit4idea/index/ui/GitStageDiffRequestProcessor;)V", "getChanges", "Lcom/intellij/openapi/ListSelection;", "onSelected", "", "change", "intellij.vcs.git"})
    private final class MyGoToChangePopupAction
    extends PresentableGoToChangePopupAction.Default<ChangeViewDiffRequestProcessor.Wrapper> {
        @NotNull
        protected ListSelection<ChangeViewDiffRequestProcessor.Wrapper> getChanges() {
            ListSelection listSelection = GitStageTree.listSelection$default(GitStageDiffRequestProcessor.this.getStageTree(), false, false, 2, null).map(arg_0 -> MyGoToChangePopupAction.getChanges$lambda$0(getChanges.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"map(...)");
            return listSelection;
        }

        protected void onSelected(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            GitStageDiffRequestProcessor.this.setCurrentChange(change);
            GitStageDiffRequestProcessor.this.selectChange(change);
        }

        private static final ChangeViewDiffRequestProcessor.Wrapper getChanges$lambda$0(Function1 $tmp0, Object p0) {
            return (ChangeViewDiffRequestProcessor.Wrapper)$tmp0.invoke(p0);
        }
    }
}

