/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.AlternativeJrePathConverter;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.JavaTestConfigurationWithDiscoverySupport;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import com.theoryinpractice.testng.configuration.AbstractTestNGPatternConfigurationProducer;
import com.theoryinpractice.testng.configuration.TestNGConfigurationEditor;
import com.theoryinpractice.testng.configuration.TestNGConfigurationProducer;
import com.theoryinpractice.testng.configuration.TestNGConfigurationType;
import com.theoryinpractice.testng.configuration.TestNGRunnableState;
import com.theoryinpractice.testng.configuration.testDiscovery.TestNGTestDiscoveryRunnableState;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestNGConsoleProperties;
import com.theoryinpractice.testng.model.TestNGTestObject;
import com.theoryinpractice.testng.model.TestType;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TestNGConfiguration
extends JavaTestConfigurationWithDiscoverySupport {
    @NonNls
    private static final String PATTERNS_EL_NAME = "patterns";
    @NonNls
    private static final String PATTERN_EL_NAME = "pattern";
    @NonNls
    private static final String TEST_CLASS_ATT_NAME = "testClass";
    private static final Logger LOG = Logger.getInstance(TestNGConfiguration.class);
    protected TestData data;
    protected transient Project project;
    public boolean ALTERNATIVE_JRE_PATH_ENABLED;
    public String ALTERNATIVE_JRE_PATH;
    private final RefactoringListeners.Accessor<PsiPackage> myPackage;
    private final RefactoringListeners.Accessor<PsiClass> myClass;

    public TestNGConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory) {
        if (project == null) {
            TestNGConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            TestNGConfiguration.$$$reportNull$$$0(1);
        }
        this(null, project, new TestData(), factory);
    }

    @TestOnly
    public TestNGConfiguration(@Nullable String name, @NotNull Project project) {
        if (project == null) {
            TestNGConfiguration.$$$reportNull$$$0(2);
        }
        this(name, project, new TestData(), (ConfigurationFactory)TestNGConfigurationType.getInstance());
    }

    public TestNGConfiguration(@NotNull Project project) {
        if (project == null) {
            TestNGConfiguration.$$$reportNull$$$0(3);
        }
        this(null, project, new TestData(), (ConfigurationFactory)TestNGConfigurationType.getInstance());
    }

    protected TestNGConfiguration(String s, Project project, TestData data, ConfigurationFactory factory) {
        super(s, new JavaRunConfigurationModule(project, false), factory);
        this.myPackage = new RefactoringListeners.Accessor<PsiPackage>(){

            public void setName(String qualifiedName) {
                boolean generatedName = TestNGConfiguration.this.isGeneratedName();
                TestNGConfiguration.this.data.PACKAGE_NAME = qualifiedName;
                if (generatedName) {
                    TestNGConfiguration.this.setGeneratedName();
                }
            }

            @Nullable
            public PsiPackage getPsiElement() {
                String qualifiedName = TestNGConfiguration.this.data.getPackageName();
                if (qualifiedName == null) {
                    return null;
                }
                try {
                    return (PsiPackage)DumbService.getInstance((Project)TestNGConfiguration.this.getProject()).computeWithAlternativeResolveEnabled(() -> JavaPsiFacade.getInstance((Project)TestNGConfiguration.this.getProject()).findPackage(qualifiedName));
                }
                catch (IndexNotReadyException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }

            public void setPsiElement(PsiPackage psiPackage) {
                this.setName(psiPackage.getQualifiedName());
            }
        };
        this.myClass = new RefactoringListeners.Accessor<PsiClass>(){

            public void setName(String qualifiedName) {
                boolean generatedName = TestNGConfiguration.this.isGeneratedName();
                TestNGConfiguration.this.data.MAIN_CLASS_NAME = qualifiedName;
                if (generatedName) {
                    TestNGConfiguration.this.setGeneratedName();
                }
            }

            @Nullable
            public PsiClass getPsiElement() {
                String qualifiedName = TestNGConfiguration.this.data.getMainClassName();
                if (qualifiedName == null) {
                    return null;
                }
                try {
                    return (PsiClass)DumbService.getInstance((Project)TestNGConfiguration.this.getProject()).computeWithAlternativeResolveEnabled(() -> JavaPsiFacade.getInstance((Project)TestNGConfiguration.this.getProject()).findClass(qualifiedName, GlobalSearchScope.allScope((Project)TestNGConfiguration.this.project)));
                }
                catch (IndexNotReadyException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }

            public void setPsiElement(@NotNull PsiClass psiClass) {
                if (psiClass == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.setName(psiClass.getQualifiedName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/theoryinpractice/testng/configuration/TestNGConfiguration$2", "setPsiElement"));
            }
        };
        this.data = data;
        this.project = project;
    }

    @Nullable
    public RemoteConnectionCreator getRemoteConnectionCreator() {
        return null;
    }

    public TestNGRunnableState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            TestNGConfiguration.$$$reportNull$$$0(4);
        }
        if (env == null) {
            TestNGConfiguration.$$$reportNull$$$0(5);
        }
        TestData data = this.getPersistantData();
        if (data.TEST_OBJECT.equals(TestType.SOURCE.getType()) || data.getChangeList() != null) {
            return new TestNGTestDiscoveryRunnableState(env, this);
        }
        return new TestNGRunnableState(env, this);
    }

    public TestData getPersistantData() {
        return this.data;
    }

    public Collection<Module> getValidModules() {
        return JavaRunConfigurationModule.getModulesForClass((Project)this.getProject(), (String)this.data.getMainClassName());
    }

    public String suggestedName() {
        return TestNGTestObject.fromConfig(this).getGeneratedName();
    }

    public String getActionName() {
        return TestNGTestObject.fromConfig(this).getActionName();
    }

    public void setVMParameters(@Nullable String value) {
        this.data.setVMParameters(value);
    }

    public String getVMParameters() {
        return this.data.getVMParameters();
    }

    public void setProgramParameters(String value) {
        this.data.setProgramParameters(value);
    }

    public String getProgramParameters() {
        return this.data.getProgramParameters();
    }

    public void setWorkingDirectory(String value) {
        this.data.setWorkingDirectory(value);
    }

    public String getWorkingDirectory() {
        return this.data.getWorkingDirectory();
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            TestNGConfiguration.$$$reportNull$$$0(6);
        }
        this.data.setEnvs(envs);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.data.getEnvs();
        if (map == null) {
            TestNGConfiguration.$$$reportNull$$$0(7);
        }
        return map;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.data.PASS_PARENT_ENVS = passParentEnvs;
    }

    public boolean isPassParentEnvs() {
        return this.data.PASS_PARENT_ENVS;
    }

    public boolean isAlternativeJrePathEnabled() {
        return this.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    public void setAlternativeJrePathEnabled(boolean enabled) {
        this.ALTERNATIVE_JRE_PATH_ENABLED = enabled;
    }

    @Nullable
    public String getAlternativeJrePath() {
        return this.ALTERNATIVE_JRE_PATH != null ? new AlternativeJrePathConverter().fromString(this.ALTERNATIVE_JRE_PATH) : null;
    }

    public void setAlternativeJrePath(String path) {
        String collapsedPath = path != null ? new AlternativeJrePathConverter().toString(path) : null;
        boolean changed = !Objects.equals(this.ALTERNATIVE_JRE_PATH, collapsedPath);
        this.ALTERNATIVE_JRE_PATH = collapsedPath;
        ApplicationConfiguration.onAlternativeJreChanged((boolean)changed, (Project)this.getProject());
    }

    public String getRunClass() {
        return !this.data.TEST_OBJECT.equals(TestType.CLASS.getType()) && !this.data.TEST_OBJECT.equals(TestType.METHOD.getType()) ? null : this.data.getMainClassName();
    }

    public String getPackage() {
        return !this.data.TEST_OBJECT.equals(TestType.PACKAGE.getType()) ? null : this.data.getPackageName();
    }

    public void beClassConfiguration(PsiClass psiclass) {
        this.setModule(this.data.setMainClass(psiclass));
        this.data.TEST_OBJECT = TestType.CLASS.getType();
        this.setGeneratedName();
    }

    public boolean isConfiguredByElement(PsiElement element) {
        return TestNGTestObject.fromConfig(this).isConfiguredByElement(element);
    }

    public String getTestType() {
        return this.getPersistantData().TEST_OBJECT;
    }

    public String prepareParameterizedParameter(String paramSetName) {
        return TestNGConfigurationProducer.getInvocationNumber(paramSetName);
    }

    public TestSearchScope getTestSearchScope() {
        return this.getPersistantData().getScope();
    }

    public void setSearchScope(TestSearchScope searchScope) {
        this.getPersistantData().setScope(searchScope);
    }

    public void setPackageConfiguration(Module module, PsiPackage pkg) {
        this.data.setPackage(pkg);
        this.setModule(module);
        this.data.TEST_OBJECT = TestType.PACKAGE.getType();
        this.setGeneratedName();
    }

    public void beMethodConfiguration(Location<PsiMethod> location) {
        this.setModule(this.data.setTestMethod(location));
        this.setGeneratedName();
    }

    @Deprecated
    public void setClassConfiguration(PsiClass psiclass) {
        this.setModule(this.data.setMainClass(psiclass));
        this.data.TEST_OBJECT = TestType.CLASS.getType();
        this.setGeneratedName();
    }

    @Deprecated
    public void setMethodConfiguration(Location<PsiMethod> location) {
        this.setModule(this.data.setTestMethod(location));
        this.setGeneratedName();
    }

    public void bePatternConfiguration(List<PsiClass> classes, PsiMethod method) {
        Object suffix;
        this.data.TEST_OBJECT = TestType.PATTERN.getType();
        if (method != null) {
            this.data.METHOD_NAME = method.getName();
            suffix = "," + this.data.METHOD_NAME;
        } else {
            suffix = "";
        }
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        for (PsiClass pattern : classes) {
            patterns.add(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)pattern) + (String)suffix);
        }
        this.data.setPatterns(patterns);
        Module module = ((AbstractTestNGPatternConfigurationProducer)RunConfigurationProducer.getInstance(AbstractTestNGPatternConfigurationProducer.class)).findModule((ModuleBasedConfiguration)this, ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule(), patterns);
        if (module == null) {
            this.data.setScope(TestSearchScope.WHOLE_PROJECT);
            this.setModule(null);
        } else {
            this.setModule(module);
        }
        this.setGeneratedName();
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), new TestNGConfigurationEditor(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            TestNGConfiguration.$$$reportNull$$$0(8);
        }
        return settingsEditorGroup;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        TestNGTestObject testObject = TestNGTestObject.fromConfig(this);
        testObject.checkConfiguration();
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid((RunConfigurationBase)this);
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this, (Project)this.getProject(), (Module)((JavaRunConfigurationModule)this.getConfigurationModule()).getModule());
        JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this);
    }

    public void readExternal(@NotNull Element element) {
        Element patternsElement;
        if (element == null) {
            TestNGConfiguration.$$$reportNull$$$0(9);
        }
        super.readExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        DefaultJDOMExternalizer.readExternal((Object)this.getPersistantData(), (Element)element);
        EnvironmentVariablesComponent.readExternal((Element)element, this.getPersistantData().getEnvs());
        Map<String, String> properties = this.getPersistantData().TEST_PROPERTIES;
        properties.clear();
        Element propertiesElement = element.getChild("properties");
        if (propertiesElement != null) {
            List children = propertiesElement.getChildren("property");
            for (Element property : children) {
                properties.put(property.getAttributeValue("name"), property.getAttributeValue("value"));
            }
        }
        List<String> listeners = this.getPersistantData().TEST_LISTENERS;
        listeners.clear();
        Element listenersElement = element.getChild("listeners");
        if (listenersElement != null) {
            List children = listenersElement.getChildren("listener");
            for (Element listenerClassName : children) {
                listeners.add(listenerClassName.getAttributeValue("class"));
            }
        }
        if ((patternsElement = element.getChild(PATTERNS_EL_NAME)) != null) {
            LinkedHashSet<String> tests = new LinkedHashSet<String>();
            for (Element patternElement : patternsElement.getChildren(PATTERN_EL_NAME)) {
                tests.add(patternElement.getAttributeValue(TEST_CLASS_ATT_NAME));
            }
            this.getPersistantData().setPatterns(tests);
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            TestNGConfiguration.$$$reportNull$$$0(10);
        }
        super.writeExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
        DefaultJDOMExternalizer.write((Object)((Object)this), (Element)element, (Predicate)JavaParametersUtil.getFilter((CommonJavaRunConfigurationParameters)this));
        DefaultJDOMExternalizer.write((Object)this.getPersistantData(), (Element)element, (Predicate)new DifferenceFilter<TestData>(this.getPersistantData(), new TestData()){

            public boolean test(@NotNull Field field) {
                if (field == null) {
                    3.$$$reportNull$$$0(0);
                }
                return "TEST_OBJECT".equals(field.getName()) || super.test(field);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/theoryinpractice/testng/configuration/TestNGConfiguration$3", "test"));
            }
        });
        EnvironmentVariablesComponent.writeExternal((Element)element, this.getPersistantData().getEnvs());
        Element propertiesElement = element.getChild("properties");
        if (propertiesElement == null) {
            propertiesElement = new Element("properties");
            element.addContent(propertiesElement);
        }
        Map<String, String> properties = this.getPersistantData().TEST_PROPERTIES;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            Element property = new Element("property");
            property.setAttribute("name", entry.getKey());
            property.setAttribute("value", entry.getValue());
            propertiesElement.addContent(property);
        }
        Element listenersElement = element.getChild("listeners");
        if (listenersElement == null) {
            listenersElement = new Element("listeners");
            element.addContent(listenersElement);
        }
        List<String> listeners = this.getPersistantData().TEST_LISTENERS;
        for (String listener : listeners) {
            Element listenerElement = new Element("listener");
            listenerElement.setAttribute("class", listener);
            listenersElement.addContent(listenerElement);
        }
        Set<String> patterns = this.getPersistantData().getPatterns();
        if (!patterns.isEmpty()) {
            Element patternsElement = new Element(PATTERNS_EL_NAME);
            for (String o : patterns) {
                Element patternElement = new Element(PATTERN_EL_NAME);
                patternElement.setAttribute(TEST_CLASS_ATT_NAME, o);
                patternsElement.addContent(patternElement);
            }
            element.addContent(patternsElement);
        }
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (this.data.TEST_OBJECT.equals(TestType.PACKAGE.getType())) {
            if (!(element instanceof PsiPackage)) {
                return null;
            }
            RefactoringElementListener listener = RefactoringListeners.getListener((PsiPackage)((PsiPackage)element), this.myPackage);
            return RunConfigurationExtension.wrapRefactoringElementListener((PsiElement)element, (RunConfigurationBase)this, (RefactoringElementListener)listener);
        }
        if (this.data.TEST_OBJECT.equals(TestType.CLASS.getType())) {
            if (!(element instanceof PsiClass) && !(element instanceof PsiPackage)) {
                return null;
            }
            RefactoringElementListener listener = RefactoringListeners.getClassOrPackageListener((PsiElement)element, this.myClass);
            return RunConfigurationExtension.wrapRefactoringElementListener((PsiElement)element, (RunConfigurationBase)this, (RefactoringElementListener)listener);
        }
        if (this.data.TEST_OBJECT.equals(TestType.METHOD.getType())) {
            if (!(element instanceof PsiMethod)) {
                RefactoringElementListener listener = RefactoringListeners.getClassOrPackageListener((PsiElement)element, this.myClass);
                return RunConfigurationExtension.wrapRefactoringElementListener((PsiElement)element, (RunConfigurationBase)this, (RefactoringElementListener)listener);
            }
            PsiMethod method = (PsiMethod)element;
            if (!method.getName().equals(this.data.getMethodName())) {
                return null;
            }
            if (!method.getContainingClass().equals(this.myClass.getPsiElement())) {
                return null;
            }
            class Listener
            extends RefactoringElementAdapter
            implements UndoRefactoringElementListener {
                Listener() {
                }

                public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        Listener.$$$reportNull$$$0(0);
                    }
                    TestNGConfiguration.this.data.setTestMethod((Location<PsiMethod>)PsiLocation.fromPsiElement((PsiElement)((PsiMethod)newElement)));
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    int methodIdx;
                    if (newElement == null) {
                        Listener.$$$reportNull$$$0(1);
                    }
                    if (oldQualifiedName == null) {
                        Listener.$$$reportNull$$$0(2);
                    }
                    if ((methodIdx = oldQualifiedName.indexOf("#") + 1) <= 0 || methodIdx >= oldQualifiedName.length()) {
                        return;
                    }
                    TestNGConfiguration.this.data.METHOD_NAME = oldQualifiedName.substring(methodIdx);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElement";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldQualifiedName";
                            break;
                        }
                    }
                    objectArray2[1] = "com/theoryinpractice/testng/configuration/TestNGConfiguration$1Listener";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "elementRenamedOrMoved";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "undoElementMovedOrRenamed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
            return RunConfigurationExtension.wrapRefactoringElementListener((PsiElement)element, (RunConfigurationBase)this, (RefactoringElementListener)new Listener());
        }
        return null;
    }

    public boolean collectOutputFromProcessHandler() {
        return false;
    }

    @NotNull
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        if (executor == null) {
            TestNGConfiguration.$$$reportNull$$$0(11);
        }
        return new TestNGConsoleProperties(this, executor);
    }

    public byte getTestFrameworkId() {
        return 1;
    }

    @Nullable
    public Set<String> calculateGroupNames() {
        if (!TestType.GROUP.getType().equals(this.data.TEST_OBJECT)) {
            return null;
        }
        Set<String> groups = StringUtil.split((String)this.data.getGroupName(), (String)",").stream().map(String::trim).filter(StringUtil::isNotEmpty).collect(Collectors.toSet());
        return groups.isEmpty() ? null : groups;
    }

    public void beFromSourcePosition(PsiLocation<PsiMethod> position) {
        this.beMethodConfiguration((Location<PsiMethod>)position);
        this.getPersistantData().TEST_OBJECT = TestType.SOURCE.getType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/theoryinpractice/testng/configuration/TestNGConfiguration";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/theoryinpractice/testng/configuration/TestNGConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

